"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QnaDefSchema = void 0;

var _joi = _interopRequireDefault(require("joi"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const QnaDefSchema = _joi.default.object().keys({
  action: _joi.default.string().required(),
  category: _joi.default.string().required(),
  enabled: _joi.default.bool().required(),
  redirectFlow: _joi.default.string().optional().allow(''),
  redirectNode: _joi.default.string().optional().allow(''),
  questions: _joi.default.array().items(_joi.default.string()).default([]),
  answers: _joi.default.array().items(_joi.default.string()).default([]),
  answer: _joi.default.string().optional()
});

exports.QnaDefSchema = QnaDefSchema;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInZhbGlkYXRpb24udHMiXSwibmFtZXMiOlsiUW5hRGVmU2NoZW1hIiwiSm9pIiwib2JqZWN0Iiwia2V5cyIsImFjdGlvbiIsInN0cmluZyIsInJlcXVpcmVkIiwiY2F0ZWdvcnkiLCJlbmFibGVkIiwiYm9vbCIsInJlZGlyZWN0RmxvdyIsIm9wdGlvbmFsIiwiYWxsb3ciLCJyZWRpcmVjdE5vZGUiLCJxdWVzdGlvbnMiLCJhcnJheSIsIml0ZW1zIiwiZGVmYXVsdCIsImFuc3dlcnMiLCJhbnN3ZXIiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7OztBQUVPLE1BQU1BLFlBQVksR0FBR0MsYUFBSUMsTUFBSixHQUFhQyxJQUFiLENBQWtCO0FBQzVDQyxFQUFBQSxNQUFNLEVBQUVILGFBQUlJLE1BQUosR0FBYUMsUUFBYixFQURvQztBQUU1Q0MsRUFBQUEsUUFBUSxFQUFFTixhQUFJSSxNQUFKLEdBQWFDLFFBQWIsRUFGa0M7QUFHNUNFLEVBQUFBLE9BQU8sRUFBRVAsYUFBSVEsSUFBSixHQUFXSCxRQUFYLEVBSG1DO0FBSTVDSSxFQUFBQSxZQUFZLEVBQUVULGFBQUlJLE1BQUosR0FDWE0sUUFEVyxHQUVYQyxLQUZXLENBRUwsRUFGSyxDQUo4QjtBQU81Q0MsRUFBQUEsWUFBWSxFQUFFWixhQUFJSSxNQUFKLEdBQ1hNLFFBRFcsR0FFWEMsS0FGVyxDQUVMLEVBRkssQ0FQOEI7QUFVNUNFLEVBQUFBLFNBQVMsRUFBRWIsYUFBSWMsS0FBSixHQUNSQyxLQURRLENBQ0ZmLGFBQUlJLE1BQUosRUFERSxFQUVSWSxPQUZRLENBRUEsRUFGQSxDQVZpQztBQWE1Q0MsRUFBQUEsT0FBTyxFQUFFakIsYUFBSWMsS0FBSixHQUNOQyxLQURNLENBQ0FmLGFBQUlJLE1BQUosRUFEQSxFQUVOWSxPQUZNLENBRUUsRUFGRixDQWJtQztBQWdCNUNFLEVBQUFBLE1BQU0sRUFBRWxCLGFBQUlJLE1BQUosR0FBYU0sUUFBYjtBQWhCb0MsQ0FBbEIsQ0FBckIiLCJzb3VyY2VSb290IjoiL3Zhci9saWIvamVua2lucy93b3Jrc3BhY2UvYnVpbGQtbGludXgvbW9kdWxlcy9xbmEvc3JjL2JhY2tlbmQiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgSm9pIGZyb20gJ2pvaSdcblxuZXhwb3J0IGNvbnN0IFFuYURlZlNjaGVtYSA9IEpvaS5vYmplY3QoKS5rZXlzKHtcbiAgYWN0aW9uOiBKb2kuc3RyaW5nKCkucmVxdWlyZWQoKSxcbiAgY2F0ZWdvcnk6IEpvaS5zdHJpbmcoKS5yZXF1aXJlZCgpLFxuICBlbmFibGVkOiBKb2kuYm9vbCgpLnJlcXVpcmVkKCksXG4gIHJlZGlyZWN0RmxvdzogSm9pLnN0cmluZygpXG4gICAgLm9wdGlvbmFsKClcbiAgICAuYWxsb3coJycpLFxuICByZWRpcmVjdE5vZGU6IEpvaS5zdHJpbmcoKVxuICAgIC5vcHRpb25hbCgpXG4gICAgLmFsbG93KCcnKSxcbiAgcXVlc3Rpb25zOiBKb2kuYXJyYXkoKVxuICAgIC5pdGVtcyhKb2kuc3RyaW5nKCkpXG4gICAgLmRlZmF1bHQoW10pLFxuICBhbnN3ZXJzOiBKb2kuYXJyYXkoKVxuICAgIC5pdGVtcyhKb2kuc3RyaW5nKCkpXG4gICAgLmRlZmF1bHQoW10pLFxuICBhbnN3ZXI6IEpvaS5zdHJpbmcoKS5vcHRpb25hbCgpXG59KVxuIl19