"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _api = _interopRequireDefault(require("./api"));

var _setup = require("./setup");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const botScopedStorage = new Map();

const onServerStarted = async bp => {
  await (0, _setup.initModule)(bp, botScopedStorage);
};

const onServerReady = async bp => {
  await (0, _api.default)(bp, botScopedStorage);
};

const onBotMount = async (bp, botId) => {
  await (0, _setup.initBot)(bp, botScopedStorage, botId);
};

const onBotUnmount = async (bp, botId) => {
  botScopedStorage.delete(botId);
};

const onModuleUnmount = async bp => {
  bp.events.removeMiddleware('qna.incoming');
  bp.http.deleteRouterForBot('qna');
};

const onFlowChanged = async (bp, botId, newFlow) => {
  const oldFlow = await bp.ghost.forBot(botId).readFileAsObject('./flows', newFlow.location);
  const qnaStorage = await botScopedStorage.get(botId);
  const questions = await qnaStorage.getQuestions({
    question: '',
    categories: []
  }, {
    limit: 0,
    offset: 0
  }); // Detect nodes that had their name changed

  for (const oldNode of oldFlow.nodes) {
    for (const newNode of newFlow.nodes) {
      // Update all questions that refer to the old node name
      if (oldNode.id === newNode.id && oldNode.name !== newNode.name) {
        const updatedItems = questions.items.filter(q => q.data.redirectFlow === newFlow.name && q.data.redirectNode === oldNode.name).map(q => {
          q.data.redirectNode = newNode.name;
          return q;
        });

        for (const item of updatedItems) {
          await qnaStorage.update(item.data, item.id);
          bp.logger.debug(`References to node "${oldNode.name}" has been updated to "${newNode.name}"`);
        }
      }
    }
  }
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onBotMount,
  onBotUnmount,
  onModuleUnmount,
  onFlowChanged,
  definition: {
    name: 'qna',
    menuIcon: 'question_answer',
    menuText: 'Q&A',
    fullName: 'QNA',
    homepage: 'https://botpress.io'
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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