"use strict";

const base = require('./_base');

function render(data) {
  const events = [];

  if (data.typing) {
    events.push({
      type: 'typing',
      value: data.typing
    });
  }

  return [...events, {
    type: 'custom',
    module: 'extensions',
    component: 'Dropdown',
    message: data.message,
    buttonText: data.buttonText,
    displayInKeyboard: data.displayInKeyboard,
    options: data.options,
    allowCreation: data.allowCreation,
    allowMultiple: data.allowMultiple,
    width: data.width
  }];
}

function renderElement(data, channel) {
  if (channel === 'web' || channel === 'api') {
    return render(data);
  }

  return [];
}

module.exports = {
  id: 'dropdown',
  group: 'Extensions',
  title: 'Dropdown',
  jsonSchema: {
    title: 'Displays a list of options to the user',
    type: 'object',
    required: ['message'],
    properties: {
      message: {
        type: 'string',
        title: 'Message'
      },
      buttonText: {
        type: 'string',
        title: 'The text to display on the button.',
        description: 'When left blank, the selected option is sent when the dropdown is closed',
        default: ''
      },
      options: {
        type: 'array',
        title: 'List of options',
        items: {
          type: 'object',
          required: ['label'],
          properties: {
            label: {
              description: 'The text displayed in the dropdown menu',
              type: 'string',
              title: 'Label'
            },
            value: {
              description: 'The value that the bot will receive (optional)',
              type: 'string',
              title: 'Value'
            }
          }
        }
      },
      width: {
        type: 'number',
        title: 'The width of the component (in pixels)',
        description: 'The default size displays the select and the button on one line. Change it to fit your needs',
        default: 200
      },
      displayInKeyboard: {
        type: 'boolean',
        title: 'Display as keyboard',
        description: 'It will be displayed right on top of the composer (like choices)',
        default: true
      },
      allowCreation: {
        type: 'boolean',
        title: 'Allow creation of new options'
      },
      allowMultiple: {
        type: 'boolean',
        title: 'Allow multiple choices'
      },
      ...base.typingIndicators
    }
  },
  uiSchema: {
    message: {
      'ui:field': 'i18n_field'
    },
    buttonText: {
      'ui:field': 'i18n_field'
    },
    options: {
      'ui:field': 'i18n_array'
    }
  },
  computePreviewText: formData => formData.message && 'Dropdown: ' + formData.message,
  renderElement
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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