#!/bin/sh
# Copyright (C) 2009 Help/Systems LLC, All Rights Reserved


WORKING_DIR=`dirname $0`
RUNJAVA_DIR=`dirname $WORKING_DIR`
logDebug="false"
MAIN_CLASS="com.helpsystems.enterprise.module.webservice.WebServiceWorker"
DEV_MODE="false"
# ------------------------------------------------------------------------
# Function: Log an info message                                         -
# ------------------------------------------------------------------------
logInfo() {
  echo "$1"
}

# ------------------------------------------------------------------------
# Function: Log an error message                                         -
# ------------------------------------------------------------------------
logError() {
  printf "$1\n">&2
}


# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText(){
  logInfo ""
  logInfo "Help for: $0"
  logInfo ""
  logInfo "Web Service $0 allows these actions:"
  logInfo ""
  logInfo "     create, delete, get,"
  logInfo "     find_id_by_name, update_job_queue,"
  logInfo "     hold_job_queue, release_job_queue"
  logInfo ""
  logInfo "All Automate Schedule object names are case sensitive."
  logInfo ""
  logInfo "------------------------ The Web Service Parameters ------------------------"  
  logInfo ""
  logInfo "-serverurl=<server url>    The Automate Schedule server url for the"
  logInfo "                           request - Required"
  logInfo "-password=<password>       The Automate Schedule password - Required"
  logInfo "-username=<username>       The Automate Schedule user name - Required"
  logInfo "-name=<object name>        The object name - Required"
  logInfo "-type=<object type>        The object type"
  logInfo "                           (agents, job_queues) - Required"
  logInfo "-action=<action>           The actions for Job Queue(create, delete, get,"
  logInfo "                           find_id_by_name, update_job_queue," 
  logInfo "                           hold_job_queue, release_job_queue) - Required"
  logInfo "-queuename=<queue name>    The job queue name" 
  logInfo "                           (required for agent based job queues)"
  logInfo "-queueparameter=<queue parameters> The job queue parameters"
  logInfo "                           (required for update action on Job Queue)"
  logInfo "-configfile=<file>         The configuration file."
  logInfo "-filename=<file>           The file containing xml object for create action."
  logInfo "-ssl=<ssl>                 Use 'any' to accept all SSL certificates"
  logInfo "                           (used with https only)."
  logInfo "------------------------ END Web Service Parameters ------------------------"
  logInfo ""
  logInfo "  Example for creating a job queue."
  logInfo "     Example: $0"
  logInfo "                -serverurl=http://localhost:8008"
  logInfo "                -password=admin -username=admin -type=job_queues"
  logInfo "                -action=create -filename=/home/skybot/job_queue.xml"
  logInfo ""
  logInfo "  Example for holding an agent based job queue."
  logInfo "     Example: $0"
  logInfo "                -serverurl=http://localhost:8008"
  logInfo "                -password=admin -username=admin"
  logInfo "                -name=agent_name -type=agents"
  logInfo "                -action=hold_job_queue -queuename=queue_name"
  logInfo ""
  logInfo "  Example for holding a cross-agent job queue."
  logInfo "     Example: $0"
  logInfo "                -serverurl=http://localhost:8008"
  logInfo "                -password=admin -username=admin"
  logInfo "                -name=queue_name -type=job_queues"
  logInfo "                -action=hold_job_queue"
  logInfo ""
  logInfo "---------------- The default configuration file parameters -----------------"  
  logInfo ""
  logInfo "     serverurl=<server url> The Automate Schedule server url for the request"
  logInfo "     password=<password>    The Automate Schedule password"
  logInfo "     username=<username>    The Automate Schedule user name"
  logInfo ""
  logInfo "---------------- END default configuration file parameters -----------------"
  logInfo ""
  logInfo "     Example:"
  logInfo "        serverurl=http://localhost:8008"
  logInfo "        username=admin"
  logInfo "        password=admin"
  logInfo ""
  logInfo "     -h, /h, -? or /?   Show help information"
  logInfo ""
  logInfo ""
}


PATH=$PATH:/usr/ucb

allArgs=$@

if [ $# -eq 0 ]; then
  showHelpText
  exit 1
fi

for i in "${@}"
do
    if [ "$i" = "-h" -o "$i" = "--help" -o "$i" = "-?" -o "$i" = "/h" -o "$i" = "/?" ]; then
        showHelpText
        exit 1
    fi
done

if [ ${RUNJAVA_DIR} = "." ]; then
 RUNJAVA_DIR=".."
fi

${RUNJAVA_DIR}/runjava.sh $MAIN_CLASS -type="agents" -devmode=${DEV_MODE} "$@"
