#!/bin/sh

# Figures out information about the current system.
# Copyright (C) 2017  HelpSystems, LLC

OP_SYS=`uname`
PROCESSOR=''
PS='ps'

if [ "${OP_SYS}" = "Linux" -o "${OP_SYS}" = "HP-UX" ]; then
    PROCESSOR=`uname -m`
elif [ "${OP_SYS}" = "OS400" ]; then
    PROCESSOR=powerpc64
else
    PROCESSOR=`uname -p`
fi

if [ "${OP_SYS}" = "HP-UX" ]; then
    PS='sh UNIX_STD=2003 ps'
    has_slash=`echo $PROCESSOR | grep / | wc -l`
    if [ $has_slash -eq 1 ]; then
        PROCESSOR=`echo $PROCESSOR | cut -f1 -d/`
        PS='sh UNIX95=Y ps'
    fi
fi

if [ "${OP_SYS}" = "AIX" -a "${PROCESSOR}" = "powerpc" ]; then
    BIT_WIDTH=`prtconf -k | cut -f2 -d: | cut -f1 -d- | sed s/\ //g`
    if [ "64" = "${BIT_WIDTH}" ]; then
        PROCESSOR=${PROCESSOR}$BIT_WIDTH
    fi
    PS="/usr/sysv/bin/ps"
fi


if [ "${OP_SYS}" = "SunOS" ]; then
    BIT_WIDTH=`isainfo -b`
    if [ "64" = "${BIT_WIDTH}" ]; then
        if [ "i386" = ${PROCESSOR} ]; then
            PROCESSOR="x86_64"
        else 
            PROCESSOR=${PROCESSOR}$BIT_WIDTH
        fi
    fi
fi

if [ "${OP_SYS}" = "Darwin" -a "${PROCESSOR}" = "i386" ]; then
    # Automate Schedule requires Java 1.6, which is 64-bits
    PROCESSOR="x86_64"
fi

