#!/bin/sh

# Copyright (C) 2017 HelpSystems, LLC, All Rights Reserved
# Sends a command to an active agent that it should shutdown.

PATH=$PATH:/usr/ucb

#if [ `whoami` != "root" ]; then
#    echo This process must be started by root.
#    exit
#fi

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}

# Initialize a verbose parameter
# "verbose=" to turn off verbose mode
# "verbose=-v" to turn on verbose mode
verbose=

NOW=
CONFIG_FILE=agent.xml
COMMAND=stop


while [ $# -ne 0 ]; do
    # is it the command, or the file?
    if [ "$1" = "-h" -o "$1" = "--help" ]; then
        echo ""
        echo "Help for: $0"
        echo ""
        echo "STOP - Instructs an agent to stop.  If jobs are running,"
        echo "       the agent will end when processing finishes, unless the"
        echo "       optional parameter [now] is used.  Using [now] will terminate"
        echo "       all Automate Schedule jobs running on the agent."
        echo ""
        echo "Usage: $0 [-v] [-f config file] [stop|restart] [now]"
        echo "If no config file is provided, then the file agent.xml is used."
        echo ""
        echo "The default command is 'stop', but 'restart' can be specified."
        echo ""
        echo "If jobs are running, the agent will end when processing finishes,"
        echo "unless the optional parameter [now] is used.  Using [now] will"
        echo "terminate all Automate Schedule jobs running on the agent."
        echo ""
        echo "[-v] verbose mode"
        echo ""
        exit
    elif [ "$1" = "-f" ]; then
        if [ -n "$2" ]; then
           CONFIG_FILE=$2
	else
	   echo "Error: A configuration file must follow the -f parameter"
           exit 1
	fi
    elif [ "stop" = $1 ]; then
        COMMAND=stop
    elif [ "restart" = $1 ]; then
        COMMAND=restart
    elif [ "now" = $1 ]; then
        NOW=now
    elif [ "-v" = $1 ] ; then
        verbose=-v
    fi
    shift
done

if [ ! -f ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is not readable by the current user."
    exit 1
fi

PASSPHRASE_FILE=$CONFIG_FILE.passphrase
if [ ! -f ${PASSPHRASE_FILE} ]; then
    echo "The passphrase file $PASSPHRASE_FILE is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${PASSPHRASE_FILE} ]; then
    echo "The passphrase file $PASSPHRASE_FILE is not readable by the current user."
    exit 1
fi

echo "About to stop the Agent with configuration file $CONFIG_FILE ..."
./runjava.sh com.helpsystems.enterprise.peer.AgentControl ${verbose} $CONFIG_FILE $COMMAND $NOW



