#!/bin/sh

# Copyright (C) 2017 HelpSystems, LLC, All Rights Reserved
# Starts a Java process which connects to an agent and instructs it
#   to fire a named/manual event.

PATH=$PATH:/usr/ucb

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}

# Initialize a verbose parameter
# "verbose=" to turn off verbose mode
# "verbose=-v" to turn on verbose mode
verbose=

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText() {
  echo ""
  echo "Help for: $0"
  echo ""
  echo "FIREEVENT - Starts a Java process which connects to an agent and "
  echo "            instructs it to fire a named/manual event that was "
  echo "            previously defined in Automate Schedule."
  echo ""
  echo "Usage: $0 [-v] [-f config_file] eventName [\"even data\"]"
  echo "If no config file is provided, then the file agent.xml is used."
  echo ""
  echo "  The -h or --help option will show command help."
  echo "  Use -v to specify verbose mode."
  echo "  Use -f to specify an Agent configuration file."
  echo ""
  echo " Example: $0 -f myagent.xml myevent \"some_data\""
  echo ""
}

if [ "$1" = "-h" -o "$1" = "--help" ]; then
    showHelpText
    exit
fi

if [ $# -eq 0 ]; then
    echo "Error: An event name must be provided."
    exit 1
fi

COMMAND=fireevent
EVENT_NAME=
EXTRA_DATA=
CONFIG_FILE=agent.xml

while [ $# -ne 0 ]; do
   if [ "$1" = "-f" ]; then
        if [ -n "$2" ]; then
           CONFIG_FILE=$2
           shift
	else
	   echo "Error: A configuration file must follow the -f parameter"
           exit 1
	fi
   elif [ "$1" = "-v" ]; then
        verbose=-v
   elif [ -z "${EVENT_NAME}" ]; then
      EVENT_NAME=$1;
   else
      EXTRA_DATA="${EXTRA_DATA} $1"
   fi
   shift
done

if [ ! -f ${CONFIG_FILE} ]; then
    echo "The config file ${CONFIG_FILE} is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is not readable by the current user."
    exit 1
fi

echo "About to fire an event for Agent with configuration file $CONFIG_FILE ..."
./runjava.sh com.helpsystems.enterprise.peer.AgentControl ${verbose} ${CONFIG_FILE} ${COMMAND} ${EVENT_NAME} ${EXTRA_DATA}



