/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.SchedulerAM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectChangeObserver;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduledTime;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.core.scheduler.SimpleList;
import com.helpsystems.enterprise.core.scheduler.observers.AgentGroupChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.AgentGroupChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.AgentTimeZoneChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.AgentTimeZoneChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.DateListChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.DateListChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.JobChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.JobChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.MemberChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.MemberChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.SuiteChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.SuiteChangeObserver;
import com.helpsystems.enterprise.scheduler.NSTCalculator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SchedulerAMImpl
extends AbstractManager
implements SchedulerAM,
AgentGroupChangeNotifier,
CalendarObjectChangeNotifier,
DateListChangeNotifier,
JobChangeNotifier,
SuiteChangeNotifier,
MemberChangeNotifier,
AgentTimeZoneChangeNotifier {
    private static final Logger logger = Logger.getLogger(SchedulerAMImpl.class);
    private static final ThreadPoolExecutor calendarChangeExecutor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10));
    private static final ThreadPoolExecutor agentTimeZoneChangeExecutor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10));
    private static final ThreadPoolExecutor dateObjectChangeExecutor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10));
    private NSTCalculator nstCalculator;
    private ScheduleJobDM scheduleJobDM;
    private ScheduleInfoDM scheduleInfoDM;
    private JobChangeAM jobChangeAM;
    private ScheduledTimeDM scheduledTimeDM;
    private JobMonitorManagerAM jobMonitorManagerAM;
    private List<AgentGroupChangeObserver> agentGroupChangeObservers = new ArrayList<AgentGroupChangeObserver>();
    private List<AgentTimeZoneChangeObserver> agentTimeZoneChangeObservers = new ArrayList<AgentTimeZoneChangeObserver>();
    private List<CalendarObjectChangeObserver> calendarObjectChangeObservers = new ArrayList<CalendarObjectChangeObserver>();
    private List<DateListChangeObserver> dateListChangeObservers = new ArrayList<DateListChangeObserver>();
    private List<JobChangeObserver> jobChangeObservers = new ArrayList<JobChangeObserver>();
    private List<MemberChangeObserver> memberChangeObservers = new ArrayList<MemberChangeObserver>();
    private List<SuiteChangeObserver> suiteChangeObservers = new ArrayList<SuiteChangeObserver>();

    public SchedulerAMImpl(NSTCalculator nSTCalculator, ScheduleJobDM scheduleJobDM, ScheduledTimeDM scheduledTimeDM, ScheduleInfoDM scheduleInfoDM) {
        ValidationHelper.checkForNull((String)"NST Calculator", (Object)nSTCalculator);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        ValidationHelper.checkForNull((String)"ScheduledTimeDM", (Object)scheduledTimeDM);
        ValidationHelper.checkForNull((String)"ScheduleInfoDM", (Object)scheduleInfoDM);
        this.setName("ENTERPRISE.SchedulerAM");
        this.nstCalculator = nSTCalculator;
        this.scheduleJobDM = scheduleJobDM;
        this.scheduledTimeDM = scheduledTimeDM;
        this.scheduleInfoDM = scheduleInfoDM;
        this.jobChangeAM = new JobChangeAM();
        this.jobMonitorManagerAM = MRHelper.getJobMonitorManagerAM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentGroupChangeObserver(AgentGroupChangeObserver agentGroupChangeObserver) {
        ValidationHelper.checkForNull((String)"Agent Group Change Observer", (Object)agentGroupChangeObserver);
        List<AgentGroupChangeObserver> list = this.agentGroupChangeObservers;
        synchronized (list) {
            this.agentGroupChangeObservers.add(agentGroupChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentTimeZoneChangeObserver(AgentTimeZoneChangeObserver agentTimeZoneChangeObserver) {
        ValidationHelper.checkForNull((String)"Agent Timezone Change Observer", (Object)agentTimeZoneChangeObserver);
        List<AgentTimeZoneChangeObserver> list = this.agentTimeZoneChangeObservers;
        synchronized (list) {
            this.agentTimeZoneChangeObservers.add(agentTimeZoneChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCalendarObjectChangeObserver(CalendarObjectChangeObserver calendarObjectChangeObserver) {
        ValidationHelper.checkForNull((String)"CalendarObject Change Observer", (Object)calendarObjectChangeObserver);
        List<CalendarObjectChangeObserver> list = this.calendarObjectChangeObservers;
        synchronized (list) {
            this.calendarObjectChangeObservers.add(calendarObjectChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDateListChangeObserver(DateListChangeObserver dateListChangeObserver) {
        ValidationHelper.checkForNull((String)"Date List Change Observer", (Object)dateListChangeObserver);
        List<DateListChangeObserver> list = this.dateListChangeObservers;
        synchronized (list) {
            this.dateListChangeObservers.add(dateListChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobChangeObserver(JobChangeObserver jobChangeObserver) {
        ValidationHelper.checkForNull((String)"Job Change Observer", (Object)jobChangeObserver);
        List<JobChangeObserver> list = this.jobChangeObservers;
        synchronized (list) {
            this.jobChangeObservers.add(jobChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberChangeObserver(MemberChangeObserver memberChangeObserver) {
        ValidationHelper.checkForNull((String)"Member Change Observer", (Object)memberChangeObserver);
        List<MemberChangeObserver> list = this.memberChangeObservers;
        synchronized (list) {
            this.memberChangeObservers.add(memberChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuiteChangeObserver(SuiteChangeObserver suiteChangeObserver) {
        ValidationHelper.checkForNull((String)"Suite Change Observer", (Object)suiteChangeObserver);
        List<SuiteChangeObserver> list = this.suiteChangeObservers;
        synchronized (list) {
            this.suiteChangeObservers.add(suiteChangeObserver);
        }
    }

    public void calendarChange(long l) {
        this.notifyCalendarObjectChangeObservers(l);
        calendarChangeExecutor.execute(new CalendarChangeRunner(l));
    }

    public void agentTimeZoneChange(long l, String string, String string2) {
        this.notifyAgentTimeZoneChangeObservers(l, string, string2);
        agentTimeZoneChangeExecutor.execute(new AgentTimeZoneChangeRunner(l));
    }

    public void dateObjectChange(long l) {
        this.notifyDateListChangeObservers(l);
        dateObjectChangeExecutor.execute(new DateObjectChangeRunner(l));
    }

    public void jobChange(long l, long l2, ScheduleInfo.TargetType targetType, long l3, ScheduleInfo.TargetType targetType2) {
        this.notifyJobChangeObservers(l);
        try {
            this.checkMax(l);
            this.validateTypes(targetType, targetType2);
            this.jobChangeAM.jobChange((int)l, l2, targetType, l3, targetType2);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{Long.toString(l)};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_CHANGE_ERROR.newLogEntry(stringArray, 0L, l);
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            throw new RuntimeException(scheduleLogEntry.getMessageText(), exception);
        }
        catch (Error error) {
            try {
                String string = MessageUtil.formatMsg((String)"Unable to process the job change request for job {0}, due to a severe system error.", (Object[])new Object[]{l});
                logger.fatal((Object)string, (Throwable)error);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw error;
        }
    }

    public void memberChange(long l, long l2, ScheduleInfo.TargetType targetType, long l3, ScheduleInfo.TargetType targetType2) {
        this.notifyMemberChangeObservers(l);
    }

    public void suiteChange(long l, ScheduleJobProxy scheduleJobProxy) {
        block9: {
            this.notifySuiteChangeObservers(l);
            try {
                this.checkMax(l);
                if (scheduleJobProxy.isScheduleTypeJob()) {
                    this.nstCalculator.jobChange((int)l);
                    break block9;
                }
                try {
                    this.scheduledTimeDM.delete((int)l);
                }
                catch (Exception exception) {
                    String string = MessageUtil.formatMsg((String)"An error occurred while trying to delete the next scheduled time data associated with job suite {0}. It is possible that none existed. However, if some did, then it is likely that this data is now orphaned. That is, it has no associated schedule type job suite. This data will get cleaned up automatically, when the Scheduler tries to process this job suite.", (Object[])new Object[]{scheduleJobProxy.getName()});
                    logger.error((Object)string, (Throwable)exception);
                }
                if (scheduleJobProxy.isLateStartMonitorSelected()) {
                    this.jobMonitorManagerAM.lateStartNSTRemoved(l);
                }
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{Long.toString(l)};
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.SUITE_CHANGE_ERROR.newLogEntry(stringArray, 0L, l);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                throw new RuntimeException(scheduleLogEntry.getMessageText(), exception);
            }
            catch (Error error) {
                try {
                    String string = MessageUtil.formatMsg((String)"Unable to process the job suite change request for suite {0}, due to a severe system error.", (Object[])new Object[]{l});
                    logger.fatal((Object)string, (Throwable)error);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw error;
            }
        }
    }

    public NSTCalculator getNSTCalculator() {
        return this.nstCalculator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgentGroupChangeObserver(AgentGroupChangeObserver agentGroupChangeObserver) {
        ValidationHelper.checkForNull((String)"Agent Group Change Observer", (Object)agentGroupChangeObserver);
        List<AgentGroupChangeObserver> list = this.agentGroupChangeObservers;
        synchronized (list) {
            this.agentGroupChangeObservers.remove(agentGroupChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgentTimeZoneChangeObserver(AgentTimeZoneChangeObserver agentTimeZoneChangeObserver) {
        ValidationHelper.checkForNull((String)"Agent Timezone Change Observer", (Object)agentTimeZoneChangeObserver);
        List<AgentTimeZoneChangeObserver> list = this.agentTimeZoneChangeObservers;
        synchronized (list) {
            this.agentTimeZoneChangeObservers.remove(agentTimeZoneChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCalendarObjectChangeObserver(CalendarObjectChangeObserver calendarObjectChangeObserver) {
        ValidationHelper.checkForNull((String)"CalendarObject Change Observer", (Object)calendarObjectChangeObserver);
        List<CalendarObjectChangeObserver> list = this.calendarObjectChangeObservers;
        synchronized (list) {
            this.calendarObjectChangeObservers.remove(calendarObjectChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDateListChangeObserver(DateListChangeObserver dateListChangeObserver) {
        ValidationHelper.checkForNull((String)"Date List Change Observer", (Object)dateListChangeObserver);
        List<DateListChangeObserver> list = this.dateListChangeObservers;
        synchronized (list) {
            this.dateListChangeObservers.remove(dateListChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobChangeObserver(JobChangeObserver jobChangeObserver) {
        ValidationHelper.checkForNull((String)"Job Change Observer", (Object)jobChangeObserver);
        List<JobChangeObserver> list = this.jobChangeObservers;
        synchronized (list) {
            this.jobChangeObservers.remove(jobChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberChangeObserver(MemberChangeObserver memberChangeObserver) {
        ValidationHelper.checkForNull((String)"Member Change Observer", (Object)memberChangeObserver);
        List<MemberChangeObserver> list = this.memberChangeObservers;
        synchronized (list) {
            this.memberChangeObservers.remove(memberChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSuiteChangeObserver(SuiteChangeObserver suiteChangeObserver) {
        ValidationHelper.checkForNull((String)"Suite Change Observer", (Object)suiteChangeObserver);
        List<SuiteChangeObserver> list = this.suiteChangeObservers;
        synchronized (list) {
            this.suiteChangeObservers.remove(suiteChangeObserver);
        }
    }

    public void agentGroupChange(long l) {
        ValidationHelper.checkForNull((String)"Agent Group ID", (Object)l);
        this.notifyAgentGroupChangeObservers(l);
        this.jobChangeAM.agentGroupChange(l);
    }

    private void checkMax(long l) {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException("Job number exceeds temporary maximum.");
        }
    }

    private String getJobName(long l) {
        try {
            return this.scheduleJobDM.getScheduleJobProxy(l).getName();
        }
        catch (Exception exception) {
            logger.warn((Object)MessageUtil.formatMsg((String)"Error retrieving Job Name. Defaulting to Job Number - {0}.", (Object[])new Object[]{l}), (Throwable)exception);
            return String.valueOf(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAgentGroupChangeObservers(long l) {
        List<AgentGroupChangeObserver> list = this.agentGroupChangeObservers;
        synchronized (list) {
            for (AgentGroupChangeObserver agentGroupChangeObserver : this.agentGroupChangeObservers) {
                agentGroupChangeObserver.agentGroupChanged(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAgentTimeZoneChangeObservers(long l, String string, String string2) {
        List<AgentTimeZoneChangeObserver> list = this.agentTimeZoneChangeObservers;
        synchronized (list) {
            for (AgentTimeZoneChangeObserver agentTimeZoneChangeObserver : this.agentTimeZoneChangeObservers) {
                agentTimeZoneChangeObserver.agentTimeZoneChanged(l, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCalendarObjectChangeObservers(long l) {
        List<CalendarObjectChangeObserver> list = this.calendarObjectChangeObservers;
        synchronized (list) {
            for (CalendarObjectChangeObserver calendarObjectChangeObserver : this.calendarObjectChangeObservers) {
                calendarObjectChangeObserver.calendarObjectChanged(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDateListChangeObservers(long l) {
        List<DateListChangeObserver> list = this.dateListChangeObservers;
        synchronized (list) {
            for (DateListChangeObserver dateListChangeObserver : this.dateListChangeObservers) {
                dateListChangeObserver.dateListChanged(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyJobChangeObservers(long l) {
        try {
            List<JobChangeObserver> list = this.jobChangeObservers;
            synchronized (list) {
                for (JobChangeObserver jobChangeObserver : this.jobChangeObservers) {
                    jobChangeObserver.jobChanged(l);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while notifying observers of change to job {0}.", (Object[])new Object[]{this.getJobName(l)}), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMemberChangeObservers(long l) {
        try {
            List<MemberChangeObserver> list = this.memberChangeObservers;
            synchronized (list) {
                for (MemberChangeObserver memberChangeObserver : this.memberChangeObservers) {
                    memberChangeObserver.memberChanged(l);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while notifying observers of change to member {0}.", (Object[])new Object[]{this.getJobName(l)}), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuiteChangeObservers(long l) {
        try {
            List<SuiteChangeObserver> list = this.suiteChangeObservers;
            synchronized (list) {
                for (SuiteChangeObserver suiteChangeObserver : this.suiteChangeObservers) {
                    suiteChangeObserver.suiteChanged(l);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while notifying observers of change to suite {0}.", (Object[])new Object[]{this.getJobName(l)}), (Throwable)exception);
        }
    }

    private void validateTypes(ScheduleInfo.TargetType targetType, ScheduleInfo.TargetType targetType2) {
        ValidationHelper.checkForNull((String)"New Target Type", (Object)targetType);
        if (targetType != ScheduleInfo.TargetType.AGENT && targetType != ScheduleInfo.TargetType.AGENT_GROUP) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Invalid new target type - {0}.", (Object[])new Object[]{targetType}));
        }
        if (targetType2 != null && targetType2 != ScheduleInfo.TargetType.AGENT && targetType2 != ScheduleInfo.TargetType.AGENT_GROUP) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Invalid old target type - {0}.", (Object[])new Object[]{targetType2}));
        }
    }

    static {
        calendarChangeExecutor.allowCoreThreadTimeOut(true);
        agentTimeZoneChangeExecutor.allowCoreThreadTimeOut(true);
        dateObjectChangeExecutor.allowCoreThreadTimeOut(true);
    }

    class DateObjectChangeRunner
    implements Runnable {
        private long dateObjectID;

        public DateObjectChangeRunner(long l) {
            this.dateObjectID = l;
        }

        @Override
        public void run() {
            this.changedDateObject();
        }

        private void changedDateObject() {
            SimpleList simpleList;
            try {
                simpleList = SchedulerAMImpl.this.scheduleJobDM.getList_JobsThatReferToDateObject(this.dateObjectID);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = MessageUtil.formatMsg((String)"Date List {0} has changed and a request was made to recalculate the next scheduled time for all jobs that reference it. However, an error occurred while trying to get a list of those jobs. Nothing was changed.", (Object[])new Object[]{this.dateObjectID});
                logger.error((Object)string, (Throwable)resourceUnavailableException);
                return;
            }
            try {
                while (simpleList.next()) {
                    long l;
                    block7: {
                        l = 0L;
                        try {
                            l = ((ScheduleJobProxy)simpleList.get()).getSkybotJobNumber();
                        }
                        catch (BadDataException badDataException) {
                            logger.debug((Object)"Data exception loading job.", (Throwable)badDataException);
                            Object object = badDataException.getLoadedObject();
                            if (object == null || !(object instanceof ScheduleJobProxy)) break block7;
                            ScheduleJobProxy scheduleJobProxy = (ScheduleJobProxy)object;
                            l = scheduleJobProxy.getSkybotJobNumber();
                        }
                    }
                    if (l == 0L) continue;
                    SchedulerAMImpl.this.checkMax(l);
                    SchedulerAMImpl.this.nstCalculator.calcNST((int)l);
                }
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = MessageUtil.formatMsg((String)"Date List {0} has changed and a request was made to recalculate the next scheduled time for all jobs that reference it. However, an error occurred while trying to perform the recalculations.", (Object[])new Object[]{this.dateObjectID});
                logger.error((Object)string, (Throwable)resourceUnavailableException);
            }
            simpleList.close();
        }
    }

    class AgentTimeZoneChangeRunner
    implements Runnable {
        private long agentId;

        public AgentTimeZoneChangeRunner(long l) {
            this.agentId = l;
        }

        @Override
        public void run() {
            this.changedAgentTimeZone();
        }

        private void changedAgentTimeZone() {
            SimpleList simpleList;
            try {
                simpleList = SchedulerAMImpl.this.scheduledTimeDM.get((int)this.agentId);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = "Error getting ScheduledTime list for agent ID: " + this.agentId;
                logger.error((Object)string, (Throwable)resourceUnavailableException);
                return;
            }
            block12: while (true) {
                try {
                    while (simpleList.next()) {
                        String string;
                        ScheduledTime scheduledTime = null;
                        try {
                            scheduledTime = (ScheduledTime)simpleList.get();
                        }
                        catch (BadDataException badDataException) {
                            String string2 = "Error getting ScheduledTime.";
                            logger.error((Object)string2, (Throwable)badDataException);
                        }
                        ScheduleInfo scheduleInfo = null;
                        int n = 0;
                        try {
                            n = scheduledTime.getJobNumber();
                            scheduleInfo = SchedulerAMImpl.this.scheduleInfoDM.get(n);
                        }
                        catch (BadDataException badDataException) {
                            string = "Error getting ScheduleInfo for Job ID: " + n;
                            logger.error((Object)string, (Throwable)badDataException);
                        }
                        catch (ResourceUnavailableException resourceUnavailableException) {
                            string = "Error getting ScheduleInfo for Job ID: " + n;
                            logger.error((Object)string, (Throwable)resourceUnavailableException);
                        }
                        catch (NoDataException noDataException) {
                            string = "Error getting ScheduleInfo for Job ID: " + n;
                            logger.error((Object)string, (Throwable)noDataException);
                        }
                        if (scheduleInfo == null || scheduleInfo.getTimeZoneType() != ScheduleInfo.TimeZoneType.AGENT) continue;
                        int n2 = scheduledTime.getJobNumber();
                        string = SchedulerAMImpl.this.nstCalculator.constructJobInfo(n2, (int)this.agentId);
                        try {
                            SchedulerAMImpl.this.nstCalculator.calcNST_Maint(n2, (int)this.agentId, scheduleInfo, (JobInfo)string);
                            continue block12;
                        }
                        catch (DataException dataException) {
                            String string3 = MessageUtil.formatMsg((String)"An error occurred while recalculating the next scheduled time for Job {0} on Agent {1}.", (Object[])new Object[]{n2, this.agentId});
                            logger.error((Object)string3, (Throwable)dataException);
                        }
                    }
                    break;
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    String string = MessageUtil.formatMsg((String)"Agent Object {0} has updated and a request was made to recalculate the next scheduled time for all jobs that reference it. However, an error occurred while trying to perform the recalculations.", (Object[])new Object[]{this.agentId});
                    logger.error((Object)string, (Throwable)resourceUnavailableException);
                    break;
                }
            }
            simpleList.close();
        }
    }

    class CalendarChangeRunner
    implements Runnable {
        private long calendarID;

        public CalendarChangeRunner(long l) {
            this.calendarID = l;
        }

        @Override
        public void run() {
            this.changedCalendar();
        }

        private void changedCalendar() {
            SimpleList simpleList;
            try {
                simpleList = SchedulerAMImpl.this.scheduleJobDM.getList_JobsThatReferToCalendar(this.calendarID);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = MessageUtil.formatMsg((String)"Calendar Object {0} has changed and a request was made to recalculate the next scheduled time for all jobs that reference it. However, an error occurred while trying to get a list of those jobs. Nothing was changed.", (Object[])new Object[]{this.calendarID});
                logger.error((Object)string, (Throwable)resourceUnavailableException);
                return;
            }
            try {
                while (simpleList.next()) {
                    long l;
                    block7: {
                        l = 0L;
                        try {
                            l = ((ScheduleJobProxy)simpleList.get()).getSkybotJobNumber();
                        }
                        catch (BadDataException badDataException) {
                            logger.debug((Object)"Data exception loading job.", (Throwable)badDataException);
                            Object object = badDataException.getLoadedObject();
                            if (object == null || !(object instanceof ScheduleJobProxy)) break block7;
                            ScheduleJobProxy scheduleJobProxy = (ScheduleJobProxy)object;
                            l = scheduleJobProxy.getSkybotJobNumber();
                        }
                    }
                    if (l == 0L) continue;
                    SchedulerAMImpl.this.checkMax(l);
                    SchedulerAMImpl.this.nstCalculator.calcNST((int)l);
                }
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = MessageUtil.formatMsg((String)"Calendar Object {0} has changed and a request was made to recalculate the next scheduled time for all jobs that reference it. However, an error occurred while trying to perform the recalculations.", (Object[])new Object[]{this.calendarID});
                logger.error((Object)string, (Throwable)resourceUnavailableException);
            }
            simpleList.close();
        }
    }

    class JobChangeAM {
        JobChangeAM() {
        }

        private void jobChange(int n, long l, ScheduleInfo.TargetType targetType, long l2, ScheduleInfo.TargetType targetType2) throws ResourceUnavailableException {
            ScheduleJobProxy scheduleJobProxy;
            try {
                scheduleJobProxy = SchedulerAMImpl.this.scheduleJobDM.getScheduleJobProxy((long)n);
            }
            catch (NoDataException noDataException) {
                String string = MessageUtil.formatMsg((String)"The scheduler was notified that job {0} changed, so that the next scheduled time could be (re)calculated. However, the job was not found.", (Object[])new Object[]{n});
                logger.debug((Object)string);
                return;
            }
            JobInfo jobInfo = new JobInfo(n, scheduleJobProxy.getName());
            if (!scheduleJobProxy.isScheduleTypeJob()) {
                try {
                    SchedulerAMImpl.this.scheduledTimeDM.delete(n);
                    if (scheduleJobProxy.isLateStartMonitorSelected()) {
                        SchedulerAMImpl.this.jobMonitorManagerAM.lateStartNSTRemoved((long)n);
                    }
                }
                catch (Exception exception) {
                    String string = MessageUtil.formatMsg((String)"An error occurred while trying to delete the next scheduled time data associated with job {0}. It is possible that none existed. However, if some did, then it is likely that this data is now orphaned. That is, it has no associated schedule type job. This data will get cleaned up automatically, when the Scheduler tries to process it.", (Object[])new Object[]{jobInfo.getJobNameWithID()});
                    logger.error((Object)string, (Throwable)exception);
                }
                return;
            }
            if (l2 == 0L) {
                this.jobInsert(n, jobInfo);
            } else {
                this.jobUpdate(n, l, targetType, l2, targetType2, jobInfo, scheduleJobProxy.isLateStartMonitorSelected());
            }
        }

        private void jobInsert(int n, JobInfo jobInfo) throws ResourceUnavailableException {
            if (this.nstRecordCount(n) > 0) {
                String string = MessageUtil.formatMsg((String)"A request was made to calculate the next scheduled time for job {0} (on all agents that it runs on). Unexpectedly, {1} record(s) already exist for this job. These will be deleted before new data is created.", (Object[])new Object[]{jobInfo.getJobNameWithID(), this.nstRecordCount(n)});
                logger.warn((Object)string);
                this.deleteAllNextScheduledTimes(n, jobInfo);
            }
            this.calcNST(n);
        }

        private void jobUpdate(int n, long l, ScheduleInfo.TargetType targetType, long l2, ScheduleInfo.TargetType targetType2, JobInfo jobInfo, boolean bl) throws ResourceUnavailableException {
            if (targetType == targetType2) {
                if (l != l2) {
                    if (targetType == ScheduleInfo.TargetType.AGENT) {
                        this.agentChange(n, l, jobInfo);
                        if (bl) {
                            SchedulerAMImpl.this.jobMonitorManagerAM.lateStartMonitorAgentChanged((long)n, l2, l);
                        }
                    } else {
                        this.deleteAllNextScheduledTimes(n, jobInfo);
                        if (bl) {
                            SchedulerAMImpl.this.jobMonitorManagerAM.lateStartNSTRemoved((long)n);
                        }
                    }
                }
            } else if (targetType2 == ScheduleInfo.TargetType.AGENT) {
                this.deleteAllNextScheduledTimes(n, jobInfo);
                if (bl) {
                    SchedulerAMImpl.this.jobMonitorManagerAM.lateStartNSTRemoved((long)n);
                }
            } else {
                this.deleteAllNextScheduledTimes(n, jobInfo);
                if (bl) {
                    SchedulerAMImpl.this.jobMonitorManagerAM.lateStartNSTRemoved((long)n);
                }
            }
            this.calcNST(n);
            if (targetType == ScheduleInfo.TargetType.AGENT && this.nstRecordCount(n) != 1) {
                String string = MessageUtil.formatMsg((String)"Program error: Expect 1 next scheduled time entry for job {0}. The actual number found was {1}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), this.nstRecordCount(n)});
                logger.error((Object)string);
            }
        }

        private void agentChange(int n, long l, JobInfo jobInfo) throws ResourceUnavailableException {
            int n2 = SchedulerAMImpl.this.scheduledTimeDM.countNSTRecords(n);
            if (n2 == 1) {
                SchedulerAMImpl.this.scheduledTimeDM.updateSystem(n, (int)l);
            } else if (n2 > 1) {
                String string = MessageUtil.formatMsg((String)"Expect 1 (or zero) next scheduled time entry for job {0}. The actual number found was {1}. These will be deleted before new data is created.", (Object[])new Object[]{jobInfo.getJobNameWithID(), this.nstRecordCount(n)});
                logger.warn((Object)string);
                this.deleteAllNextScheduledTimes(n, jobInfo);
            }
        }

        private void calcNST(int n) {
            SchedulerAMImpl.this.nstCalculator.jobChange(n);
        }

        private int deleteAllNextScheduledTimes(int n, JobInfo jobInfo) throws ResourceUnavailableException {
            try {
                return SchedulerAMImpl.this.scheduledTimeDM.delete(n);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = MessageUtil.formatMsg((String)"An error occurred while trying to delete the next scheduled time data associated with job {0}.", (Object[])new Object[]{jobInfo.getJobNameWithID()});
                throw new ResourceUnavailableException(string, (Throwable)resourceUnavailableException);
            }
        }

        private int nstRecordCount(int n) throws ResourceUnavailableException {
            try {
                return SchedulerAMImpl.this.scheduledTimeDM.countNSTRecords(n);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return SchedulerAMImpl.this.scheduledTimeDM.countNSTRecords(n);
            }
        }

        private void agentGroupChange(long l) {
            try {
                AgentGroupType agentGroupType = this.retrieveAgentGroupType(l);
                switch (agentGroupType) {
                    case UTILIZATION_BALANCED: 
                    case PREFERRED_AGENT: {
                        return;
                    }
                    case ALL_AGENTS: {
                        ScheduleJobDM scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.ScheduleJobDM");
                        long[] lArray = scheduleJobDM.getJobIDsForAgentGroup(l);
                        for (int i = 0; i < lArray.length; ++i) {
                            this.processAgentGroupChangeForJob(l, lArray[i]);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group type {0} is not supported by this method.", (Object[])new Object[]{agentGroupType}));
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Error processing changed agent groups.", exception);
            }
        }

        private AgentGroupType retrieveAgentGroupType(long l) throws ResourceUnavailableException {
            try {
                AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
                AgentGroupProxy agentGroupProxy = agentGroupDM.getProxy(l);
                return agentGroupProxy.getAgentGroupType();
            }
            catch (DataException dataException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve the agent group type because no agent group was found whose id is {0}.", (Object[])new Object[]{l}));
            }
        }

        private boolean isScheduleTypeJob(long l) throws ResourceUnavailableException {
            try {
                ScheduleJobProxy scheduleJobProxy = SchedulerAMImpl.this.scheduleJobDM.getScheduleJobProxy(l);
                return scheduleJobProxy.isScheduleTypeJob();
            }
            catch (NoDataException noDataException) {
                return false;
            }
        }

        private void processAgentGroupChangeForJob(long l, long l2) throws ResourceUnavailableException {
            Object object;
            try {
                object = new ArrayList();
                object = SchedulerAMImpl.this.scheduledTimeDM.purgeObsoleteRuntimes(l2, l);
                if (((ArrayList)object).size() > 0) {
                    SchedulerAMImpl.this.jobMonitorManagerAM.lateStartNSTAgentsDroppedFromAgentGroup(l2, (ArrayList)object);
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)("Error purging obsolete runtimes for agent group " + l + " and job " + l2 + "."), throwable);
            }
            try {
                if (this.isScheduleTypeJob(l2)) {
                    object = SchedulerAMImpl.this.scheduledTimeDM.getMissingRuntimeAgents(l2, l);
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        try {
                            SchedulerAMImpl.this.getNSTCalculator().calcNST((int)l2, (int)object[i]);
                            continue;
                        }
                        catch (Throwable throwable) {
                            logger.error((Object)("Error updating missing agent runtimes for agent group " + l + " job " + l2 + " agent " + (long)object[i] + "."), throwable);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)("Error updating missing agent runtimes for agent group " + l + " and job " + l2 + "."), throwable);
            }
        }
    }
}

