/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.MovedNST;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayCount;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_TimedInterval;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduledTime;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.core.scheduler.UpdateCounterException;
import com.helpsystems.enterprise.scheduler.Scheduler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class NSTCalculator {
    private static final Logger logger = Logger.getLogger(NSTCalculator.class);
    private ScheduleInfoDM scheduleInfoDM;
    private ScheduledTimeDM scheduledTimeDM;
    private ScheduleJobDM scheduleJobDM;
    private AgentDM agentDM;
    private AgentGroupDM agentGroupDM;
    private JobMonitorManagerAM jobMonitorManagerAM;
    private Scheduler scheduler;
    private static ThreadLocal<Boolean> suppressScheduleLogEntry = new ThreadLocal();

    public static void setSuppressScheduleLogEntry(boolean bl) {
        suppressScheduleLogEntry.set(bl);
    }

    public NSTCalculator(ScheduleInfoDM scheduleInfoDM, ScheduledTimeDM scheduledTimeDM, ScheduleJobDM scheduleJobDM, AgentDM agentDM, JobMonitorManagerAM jobMonitorManagerAM, AgentGroupDM agentGroupDM) {
        ValidationHelper.checkForNull((String)"ScheduleInfoDM", (Object)scheduleInfoDM);
        ValidationHelper.checkForNull((String)"ScheduledTimeDM", (Object)scheduledTimeDM);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        ValidationHelper.checkForNull((String)"AgentDM", (Object)agentDM);
        ValidationHelper.checkForNull((String)"JobMonitorManagerAM", (Object)jobMonitorManagerAM);
        ValidationHelper.checkForNull((String)"AgentGroupDM", (Object)agentGroupDM);
        this.scheduleInfoDM = scheduleInfoDM;
        this.scheduledTimeDM = scheduledTimeDM;
        this.scheduleJobDM = scheduleJobDM;
        this.agentDM = agentDM;
        this.jobMonitorManagerAM = jobMonitorManagerAM;
        this.agentGroupDM = agentGroupDM;
    }

    public void calcNST(ScheduledTime scheduledTime, JobInfo jobInfo) {
        Object object;
        ScheduleInfo scheduleInfo;
        int n;
        int n2;
        block20: {
            ValidationHelper.checkForNull((String)"Scheduled Time", (Object)scheduledTime);
            ValidationHelper.checkForNull((String)"Job Info", (Object)jobInfo);
            this.restoreOriginalNST(scheduledTime);
            n2 = scheduledTime.getJobNumber();
            n = scheduledTime.getSystem();
            try {
                try {
                    scheduleInfo = this.scheduleInfoDM.get(n2);
                    if (scheduleInfo == null) {
                        this.logError_NotScheduleJob(jobInfo);
                        return;
                    }
                    Calendar calendar = scheduledTime.getConsideredScheduledTime();
                    this.setTimeZoneForDateCalcs(calendar, scheduleInfo, n2, n);
                    object = this.calcNST_Common(calendar, scheduleInfo, jobInfo, n);
                    scheduledTime.setNextScheduledTime((Calendar)object);
                }
                catch (NoDataException noDataException) {
                    this.logError_JobNotFound(jobInfo, (Exception)((Object)noDataException));
                    scheduledTime.setNextScheduledTime(null);
                    try {
                        this.scheduledTimeDM.update(scheduledTime);
                    }
                    catch (Exception exception) {
                        this.logError_NSTClearError(jobInfo, exception);
                    }
                    return;
                }
                catch (BadDataException badDataException) {
                    boolean bl = true;
                    this.logError_BadScheduleInfo(jobInfo, badDataException, bl);
                    scheduleInfo = (ScheduleInfo)badDataException.getLoadedObject();
                    scheduledTime.setNextScheduledTime(null);
                }
                scheduledTime.setUpdateCounter(scheduleInfo.getUpdateCounter());
                try {
                    this.scheduledTimeDM.updateByCounter(scheduledTime);
                }
                catch (NotSavedException notSavedException) {
                    if (notSavedException instanceof UpdateCounterException) {
                        object = MessageUtil.formatMsg((String)"The value of the Scheduled Time data update counter for job {0}, agent {1} was not as expected. Expected {2}, found {3}.", (Object[])new Object[]{n2, n, ((UpdateCounterException)notSavedException).getUpdateCounterExpected(), ((UpdateCounterException)notSavedException).getUpdateCounterFound()});
                        logger.info(object);
                        try {
                            scheduleInfo = this.scheduleInfoDM.get(n2);
                        }
                        catch (NoDataException noDataException) {
                            this.logError_JobNotFound(jobInfo, (Exception)((Object)noDataException));
                            return;
                        }
                        catch (BadDataException badDataException) {
                            boolean bl = false;
                            this.logError_BadScheduleInfo(jobInfo, badDataException, bl);
                            return;
                        }
                        Calendar calendar = scheduledTime.getConsideredScheduledTime();
                        this.setTimeZoneForDateCalcs(calendar, scheduleInfo, n2, n);
                        Calendar calendar2 = this.calcNST_Common(calendar, scheduleInfo, jobInfo, n);
                        scheduledTime.setNextScheduledTime(calendar2);
                        try {
                            this.scheduledTimeDM.update(scheduledTime);
                            break block20;
                        }
                        catch (NotSavedException notSavedException2) {
                            this.logError_TimeDataNotSaved(jobInfo, (Exception)((Object)notSavedException2), scheduledTime);
                            return;
                        }
                    }
                    this.logError_TimeDataNotSaved(jobInfo, (Exception)((Object)notSavedException), scheduledTime);
                    return;
                }
            }
            catch (Exception exception) {
                this.logError_NSTCalcError_NotSetToNull(jobInfo, exception);
                return;
            }
            catch (Error error) {
                this.logError_JVMError(jobInfo, error);
                throw error;
            }
        }
        this.notifyScheduler(scheduledTime.getNextScheduledTime());
        if (scheduleInfo.isLateStartJob()) {
            try {
                this.jobMonitorManagerAM.lateStartNSTAddedOrReplaced((long)n2, (long)n, scheduledTime.getNextScheduledTime());
            }
            catch (Exception exception) {
                object = MessageUtil.formatMsg((String)"An error occurred while trying to notify the Job Monitor Manager of a change to the next scheduled time value for job {0} on agent {1}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
                logger.warn(object, (Throwable)exception);
            }
        }
    }

    public void calcNST(int n) {
        try {
            this.calcNST(n, this.getJobName(n));
        }
        catch (Exception exception) {
            this.logError_NSTCalcError(n, exception);
            return;
        }
        catch (Error error) {
            throw error;
        }
    }

    public void calcNST(int n, int n2) {
        JobInfo jobInfo = this.constructJobInfo(n, n2);
        try {
            ScheduleInfo scheduleInfo;
            try {
                scheduleInfo = this.scheduleInfoDM.get(n);
                if (scheduleInfo == null) {
                    this.logError_NotScheduleJob(jobInfo);
                    return;
                }
            }
            catch (NoDataException noDataException) {
                this.logError_JobNotFound(jobInfo, (Exception)((Object)noDataException));
                return;
            }
            catch (BadDataException badDataException) {
                boolean bl = false;
                this.logError_BadScheduleInfo(jobInfo, badDataException, bl);
                return;
            }
            this.calcNST_Maint(n, n2, scheduleInfo, jobInfo);
        }
        catch (Exception exception) {
            this.logError_NSTCalcError_NotSetToNull(jobInfo, exception);
            return;
        }
        catch (Error error) {
            this.logError_JVMError(jobInfo, error);
            throw error;
        }
    }

    public Calendar[] calcNST(int n, int n2, ScheduleInfo scheduleInfo, Calendar calendar, Calendar calendar2) throws ResourceUnavailableException, DataException {
        Calendar calendar3;
        ValidationHelper.checkForNull((String)"Scheduled Info", (Object)scheduleInfo);
        ValidationHelper.checkForNull((String)"Period Begin", (Object)calendar);
        ValidationHelper.checkForNull((String)"Period End", (Object)calendar2);
        calendar = (Calendar)calendar.clone();
        JobInfo jobInfo = new JobInfo(n, "", n2, "");
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        this.setTimeZoneForDateCalcs(calendar, scheduleInfo, n, n2);
        TimeZone timeZone = calendar.getTimeZone();
        if (scheduleInfo.getScheduleType() == ScheduleJobProxy.ScheduleType.TIMED_INTERVAL || scheduleInfo.getScheduleType() == ScheduleJobProxy.ScheduleType.DAY_COUNT) {
            Calendar calendar4;
            if (this.scheduledTimeDM.isInDatabase(n, n2)) {
                calendar4 = this.getCST(n, n2);
                calendar4 = this.adjustCstIfNotBeforePeriodBegin(calendar4, calendar, scheduleInfo, n, n2);
            } else {
                calendar4 = null;
            }
            if (calendar4 != null) {
                this.setTimeZoneForDateCalcs(calendar4, scheduleInfo, n, n2);
            }
            calendar3 = scheduleInfo.calcNST(calendar4, jobInfo, timeZone);
            while (calendar3 != null && calendar3.before(calendar)) {
                calendar3 = scheduleInfo.calcNST(calendar3, jobInfo, timeZone);
            }
        } else {
            calendar.setTimeInMillis(calendar.getTimeInMillis() - 1L);
            calendar3 = scheduleInfo.calcNST(calendar, jobInfo, timeZone);
        }
        while (calendar3 != null && !calendar3.after(calendar2)) {
            arrayList.add(calendar3);
            calendar3 = this.restoreOriginalNST(calendar3);
            try {
                calendar3 = scheduleInfo.calcNST(calendar3, jobInfo, timeZone);
            }
            catch (Exception exception) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                simpleDateFormat.setTimeZone(calendar3.getTimeZone());
                logger.info((Object)MessageUtil.formatMsg((String)"Unable to determine a next scheduled runtime for job {0} on agent {1}, that occurs after {2}.", (Object[])new Object[]{this.getJobName(n), this.getAgentName(n2), simpleDateFormat.format(calendar3.getTime())}));
                calendar3 = null;
            }
        }
        return arrayList.toArray(new Calendar[arrayList.size()]);
    }

    public Calendar[] calcNST(ScheduleInfo scheduleInfo, Calendar calendar, Calendar calendar2, int n) throws ResourceUnavailableException, DataException {
        ValidationHelper.checkForNull((String)"Scheduled Info", (Object)scheduleInfo);
        ValidationHelper.checkForNull((String)"Period Begin", (Object)calendar);
        ValidationHelper.checkForNull((String)"Period End", (Object)calendar2);
        JobInfo jobInfo = new JobInfo(-99999, "event", n, "");
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        this.setTimeZoneForDateCalcs(calendar, scheduleInfo, jobInfo.getJobID(), n);
        TimeZone timeZone = calendar.getTimeZone();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - 1L);
        Calendar calendar3 = scheduleInfo.calcNST(calendar, jobInfo, timeZone);
        calendar.setTimeInMillis(calendar.getTimeInMillis() + 1L);
        while (calendar3 != null && !calendar3.after(calendar2)) {
            arrayList.add(calendar3);
            calendar3 = this.restoreOriginalNST(calendar3);
            try {
                calendar3 = scheduleInfo.calcNST(calendar3, jobInfo, timeZone);
            }
            catch (Exception exception) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                simpleDateFormat.setTimeZone(calendar3.getTimeZone());
                logger.info((Object)MessageUtil.formatMsg((String)"Unable to determine a next scheduled runtime event ? on agent {0}, that occurs after {1}.", (Object[])new Object[]{this.getAgentName(n), simpleDateFormat.format(calendar3.getTime())}));
                calendar3 = null;
            }
        }
        return arrayList.toArray(new Calendar[arrayList.size()]);
    }

    public void jobChange(int n) {
        try {
            ScheduleJobProxy scheduleJobProxy;
            try {
                scheduleJobProxy = this.scheduleJobDM.getScheduleJobProxy((long)n);
            }
            catch (NoDataException noDataException) {
                String string = MessageUtil.formatMsg((String)"The scheduler was notified that job {0} changed, so that the next scheduled time could be (re)calculated. However, the job was not found.", (Object[])new Object[]{n});
                logger.warn((Object)string);
                return;
            }
            JobInfo jobInfo = new JobInfo(n, scheduleJobProxy.getName());
            if (!scheduleJobProxy.isScheduleTypeJob()) {
                this.deleteNextScheduledTimesIfAny(n, jobInfo);
                return;
            }
            this.calcNST(n, scheduleJobProxy.getName());
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{Integer.toString(n), this.getUnanticipatedErrorMessageText(), this.nestedMsgText(exception)};
            this.writeToScheduleLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE_NOT_SET_TO_NULL_JOB_CHANGE, stringArray, n);
            this.writeToDiagnosticLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE_NOT_SET_TO_NULL_JOB_CHANGE, stringArray, exception);
            return;
        }
        catch (Error error) {
            try {
                String string = MessageUtil.formatMsg((String)"Unable to process the job change request for job {0}, due to a severe system error.", (Object[])new Object[]{n});
                logger.fatal((Object)string, (Throwable)error);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw error;
        }
    }

    private void calcNST(int n, String string) throws Exception {
        JobInfo jobInfo = new JobInfo(n, string);
        jobInfo.setAgentName("ALL AGENTS");
        try {
            ScheduleInfo scheduleInfo;
            try {
                scheduleInfo = this.scheduleInfoDM.get(n);
                if (scheduleInfo == null) {
                    this.logError_NotScheduleJob(jobInfo);
                    return;
                }
            }
            catch (NoDataException noDataException) {
                this.logError_JobNotFound(jobInfo, (Exception)((Object)noDataException));
                return;
            }
            catch (BadDataException badDataException) {
                boolean bl = false;
                this.logError_BadScheduleInfo(jobInfo, badDataException, bl);
                return;
            }
            JobInfo jobInfo2 = new JobInfo(n, string);
            int[] nArray = this.systemsTheJobRunsOn(scheduleInfo);
            int n2 = nArray.length;
            int n3 = 0;
            try {
                for (int n4 : nArray) {
                    jobInfo2.setAgentInfo(n4, this.getAgentName(n4));
                    Calendar calendar = this.calcNST_Maint(n, n4, scheduleInfo, jobInfo2);
                    if (calendar == null) continue;
                    ++n3;
                }
                if (n3 != n2) {
                    if (n2 > 1) {
                        String[] exception = new String[]{Integer.toString(n2), jobInfo.getJobNameWithID(), Integer.toString(n3)};
                        this.writeToScheduleLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE_MULTIPLE_SYSTEMS, exception, n);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{Integer.toString(n2), jobInfo.getJobNameWithID(), Integer.toString(n3), this.nestedMsgText(exception)};
                this.writeToScheduleLog(RosettaMsg.NST_CALC_ERROR_MULTIPLE_SYSTEMS, stringArray, n);
                this.writeToDiagnosticLog(RosettaMsg.NST_CALC_ERROR_MULTIPLE_SYSTEMS, stringArray, exception);
                return;
            }
        }
        catch (Exception exception) {
            this.logError_NSTCalcError_NotSetToNull(jobInfo, exception);
            throw exception;
        }
        catch (Error error) {
            this.logError_JVMError(jobInfo, error);
            throw error;
        }
    }

    private Calendar calcNST_Common(Calendar calendar, ScheduleInfo scheduleInfo, JobInfo jobInfo, int n) throws DataException, ResourceUnavailableException {
        try {
            TimeZone timeZone = null;
            timeZone = calendar != null ? calendar.getTimeZone() : this.getTimeZone(scheduleInfo, jobInfo.getJobID(), n);
            Calendar calendar2 = scheduleInfo.calcNST(calendar, jobInfo, timeZone);
            this.validateMaxYear(calendar2);
            return calendar2;
        }
        catch (IllegalStateException illegalStateException) {
            this.logError_NSTCalcError(jobInfo, this.nestedMsgText(illegalStateException));
            return null;
        }
        catch (RuntimeException runtimeException) {
            this.logError_NSTCalcError(jobInfo, (Exception)runtimeException);
            return null;
        }
    }

    public Calendar calcNST_Maint(int n, int n2, ScheduleInfo scheduleInfo, JobInfo jobInfo) throws ResourceUnavailableException, DataException {
        ScheduledTime scheduledTime;
        boolean bl;
        Calendar calendar;
        Calendar calendar2 = null;
        try {
            Calendar calendar3;
            calendar = Calendar.getInstance();
            try {
                this.setTimeZoneForDateCalcs(calendar, scheduleInfo, n, n2);
            }
            catch (DataException dataException) {
                this.logError_NSTCalcError(jobInfo, (Exception)((Object)dataException));
                throw dataException;
            }
            bl = this.scheduledTimeDM.isInDatabase(n, n2);
            if (scheduleInfo.getScheduleType() == ScheduleJobProxy.ScheduleType.TIMED_INTERVAL || scheduleInfo.getScheduleType() == ScheduleJobProxy.ScheduleType.DAY_COUNT) {
                Calendar calendar4;
                if (bl) {
                    try {
                        calendar4 = this.getCST(n, n2);
                    }
                    catch (Exception exception) {
                        this.logError_NSTCalcError(jobInfo, exception);
                        return null;
                    }
                } else {
                    calendar4 = null;
                }
                if (calendar4 != null) {
                    try {
                        this.setTimeZoneForDateCalcs(calendar4, scheduleInfo, n, n2);
                    }
                    catch (DataException dataException) {
                        this.logError_NSTCalcError(jobInfo, (Exception)((Object)dataException));
                        throw dataException;
                    }
                }
                calendar3 = this.calcNST_Common(calendar4, scheduleInfo, jobInfo, n2);
                while (calendar3 != null && calendar3.before(calendar)) {
                    calendar3 = this.calcNST_Common(calendar3, scheduleInfo, jobInfo, n2);
                }
            } else {
                calendar3 = this.calcNST_Common(calendar, scheduleInfo, jobInfo, n2);
            }
            scheduledTime = new ScheduledTime();
            scheduledTime.setJobNumber(n);
            scheduledTime.setSystem(n2);
            scheduledTime.setNextScheduledTime(calendar3);
            scheduledTime.setMaintainedAtDateTime(calendar);
            scheduledTime.setUpdateCounter(scheduleInfo.getUpdateCounter());
            try {
                if (bl) {
                    calendar2 = this.getOldNST(n, n2, jobInfo);
                    this.scheduledTimeDM.updateNST(scheduledTime);
                } else {
                    this.scheduledTimeDM.insert(scheduledTime);
                }
            }
            catch (NotSavedException notSavedException) {
                this.logError_TimeDataNotSaved(jobInfo, (Exception)((Object)notSavedException), scheduledTime);
                return null;
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            this.logError_NSTCalcError(jobInfo, (Exception)((Object)resourceUnavailableException));
            throw resourceUnavailableException;
        }
        calendar = scheduledTime.getNextScheduledTime();
        this.notifyScheduler(calendar);
        if (scheduleInfo.isLateStartJob()) {
            this.notifyJobMonitorManager(n, n2, calendar, calendar2, bl, jobInfo);
        }
        return calendar;
    }

    private Calendar adjustCstIfNotBeforePeriodBegin(Calendar calendar, Calendar calendar2, ScheduleInfo scheduleInfo, int n, int n2) throws ResourceUnavailableException, DataException {
        if (calendar == null || calendar.before(calendar2)) {
            return calendar;
        }
        switch (scheduleInfo.getScheduleType()) {
            case TIMED_INTERVAL: {
                int n3 = ((ScheduleInfo_TimedInterval)scheduleInfo).getMinutes();
                long l = (long)n3 * 60000L;
                long l2 = calendar.getTimeInMillis() - calendar2.getTimeInMillis();
                int n4 = (int)(l2 / l) + 1;
                calendar.add(12, n4 * n3 * -1);
                logger.trace((Object)MessageUtil.formatMsg((String)"Backing up the forecast CST of timed interval job id {0} {1} minutes.", (Object[])new Object[]{n, n4 * n3}));
                return calendar;
            }
            case DAY_COUNT: {
                ScheduleInfo_DayCount scheduleInfo_DayCount = (ScheduleInfo_DayCount)scheduleInfo;
                int n5 = scheduleInfo_DayCount.getDayCountInterval();
                this.setTimeZoneForDateCalcs(calendar, scheduleInfo, n, n2);
                while (!calendar.before(calendar2)) {
                    try {
                        calendar = scheduleInfo.getCalendarObject().addDays(-n5, scheduleInfo_DayCount.getDayType(), calendar);
                    }
                    catch (CalendarObjectRangeException calendarObjectRangeException) {
                        String string = MessageUtil.formatMsg((String)"Unable to position to before the forecast window begin date/time, using Calendar {0}, for job id {1}.", (Object[])new Object[]{scheduleInfo.getCalendarObject().getName(), n});
                        throw new IllegalStateException(string, calendarObjectRangeException);
                    }
                    catch (InvalidDateTimeException invalidDateTimeException) {
                        calendar = invalidDateTimeException.getMovedInvalidDateTime();
                    }
                }
                logger.trace((Object)MessageUtil.formatMsg((String)"Backing up the forecast CST of daily interval job id {0}.", (Object[])new Object[]{n}));
                return calendar;
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Schedule Type {0} is not supported by this method.", (Object[])new Object[]{scheduleInfo.getScheduleType()}));
    }

    public JobInfo constructJobInfo(int n, int n2) {
        return new JobInfo(n, this.getJobName(n), n2, this.getAgentName(n2));
    }

    private int deleteNextScheduledTimesIfAny(int n, JobInfo jobInfo) {
        try {
            return this.scheduledTimeDM.delete(n);
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"An error occurred while trying to delete the next scheduled time data associated with job {0}. It is possible that none existed. However, if some did, then it is likely that this data is now orphaned. That is, it has no associated schedule type job.", (Object[])new Object[]{jobInfo.getJobNameWithID()});
            logger.error((Object)string, (Throwable)exception);
            return 0;
        }
    }

    private String getAgentName(long l) {
        if (l == 0L) {
            return "";
        }
        try {
            return this.agentDM.get(l).getName();
        }
        catch (Exception exception) {
            logger.warn((Object)"Error retrieving Agent Name - defaulting to Agent ID.", (Throwable)exception);
            return String.valueOf(l);
        }
    }

    private Calendar getCST(int n, int n2) {
        try {
            return this.scheduledTimeDM.get(n, n2).getConsideredScheduledTime();
        }
        catch (Exception exception) {
            String string = "An error occurred while trying to retrieve the considered scheduled time value.";
            throw new RuntimeException(string, exception);
        }
    }

    private String getJobName(long l) {
        try {
            return this.scheduleJobDM.getScheduleJobProxy(l).getName();
        }
        catch (Exception exception) {
            logger.warn((Object)MessageUtil.formatMsg((String)"Error retrieving Job Name. Defaulting to Job Number - {0}.", (Object[])new Object[]{l}), (Throwable)exception);
            return String.valueOf(l);
        }
    }

    private Calendar getOldNST(int n, int n2, JobInfo jobInfo) {
        try {
            return this.scheduledTimeDM.get(n, n2).getNextScheduledTime();
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"An error occurred while trying to retrieve the next scheduled time value for job {0} on agent {1}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
            logger.error((Object)string, (Throwable)exception);
            return null;
        }
    }

    private void notifyJobMonitorManager(int n, int n2, Calendar calendar, Calendar calendar2, boolean bl, JobInfo jobInfo) {
        try {
            if (bl) {
                if (calendar2 == null) {
                    if (calendar != null) {
                        this.jobMonitorManagerAM.lateStartNSTAddedOrReplaced((long)n, (long)n2, calendar);
                    }
                } else if (calendar == null) {
                    this.jobMonitorManagerAM.lateStartNSTUnknown((long)n, (long)n2, calendar2);
                } else if (calendar2.compareTo(calendar) != 0) {
                    this.jobMonitorManagerAM.lateStartNSTUpdated((long)n, (long)n2, calendar2, calendar);
                }
            } else if (calendar != null) {
                this.jobMonitorManagerAM.lateStartNSTAddedOrReplaced((long)n, (long)n2, calendar);
            }
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"An error occurred while trying to notify the Job Monitor Manager of a change to the next scheduled time value for job {0} on agent {1}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
            logger.error((Object)string, (Throwable)exception);
        }
    }

    private void notifyScheduler(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        if (this.scheduler == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The scheduler is not available to notify of NST change.");
            }
            return;
        }
        try {
            this.scheduler.notifyOfPossibleEarliestNST(calendar);
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to notify the scheduler of a possible earliest Next Scheduled Time.", (Throwable)exception);
        }
    }

    private void restoreOriginalNST(ScheduledTime scheduledTime) {
        Calendar calendar = scheduledTime.getConsideredScheduledTime();
        if (calendar instanceof MovedNST) {
            Calendar calendar2 = ((MovedNST)calendar).getOriginalNST();
            scheduledTime.setConsideredScheduledTime(calendar2);
        }
    }

    private Calendar restoreOriginalNST(Calendar calendar) {
        if (calendar instanceof MovedNST) {
            return ((MovedNST)calendar).getOriginalNST();
        }
        return calendar;
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }

    private void setTimeZoneForDateCalcs(Calendar calendar, ScheduleInfo scheduleInfo, int n, int n2) throws DataException, ResourceUnavailableException {
        TimeZone timeZone = this.getTimeZone(scheduleInfo, n, n2);
        calendar.setTimeZone(timeZone);
    }

    private TimeZone getTimeZone(ScheduleInfo scheduleInfo, int n, int n2) throws DataException, ResourceUnavailableException {
        ScheduleInfo.TimeZoneType timeZoneType = scheduleInfo.getTimeZoneType();
        TimeZone timeZone = null;
        switch (timeZoneType) {
            case SERVER: {
                timeZone = this.serverTimeZone();
                break;
            }
            case AGENT: {
                timeZone = this.timeZoneOfSystem(n2);
                break;
            }
            case JOB: {
                String string = scheduleInfo.getJobTimezone();
                timeZone = this.timezone(string, n);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Unrecognized Timezone Type - {0}", (Object[])new Object[]{timeZoneType}));
            }
        }
        return timeZone;
    }

    private int[] systemsTheJobRunsOn(ScheduleInfo scheduleInfo) throws ResourceUnavailableException {
        ScheduleInfo.TargetType targetType = scheduleInfo.getTargetType();
        if (targetType != null) {
            switch (targetType) {
                case AGENT: {
                    return new int[]{scheduleInfo.getTargetID()};
                }
                case AGENT_GROUP: {
                    switch (scheduleInfo.getAgentGroupType()) {
                        case ALL_AGENTS: {
                            long[] lArray = this.agentGroupDM.getAgentsIDsInGroup((long)scheduleInfo.getTargetID(), null);
                            int[] nArray = new int[lArray.length];
                            for (int i = 0; i < nArray.length; ++i) {
                                nArray[i] = (int)lArray[i];
                            }
                            return nArray;
                        }
                        case UTILIZATION_BALANCED: 
                        case PREFERRED_AGENT: {
                            return new int[]{0};
                        }
                    }
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group Type {0} is not supported by this method.", (Object[])new Object[]{scheduleInfo.getAgentGroupType()}));
                }
            }
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Unrecognized Target Type - {0}", (Object[])new Object[]{targetType}));
        }
        return new int[]{0};
    }

    private TimeZone timeZoneOfSystem(int n) throws DataException, ResourceUnavailableException {
        Agent agent = this.agentDM.get((long)n);
        return TimeZone.getTimeZone(agent.getTimeZone());
    }

    private TimeZone timezone(String string, int n) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
                String string2 = timeZone.getID();
                this.logError_UnrecognizedTimeZoneID(string, string2, n);
            }
        }
        catch (Exception exception) {
            timeZone = TimeZone.getDefault();
            String string3 = timeZone.getID();
            String string4 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead, for the calculation of the next scheduled time.", (Object[])new Object[]{string, this.getJobName(n), string3});
            logger.error((Object)string4, (Throwable)exception);
        }
        return timeZone;
    }

    private void validateMaxYear(Calendar calendar) {
        if (calendar != null && calendar.get(1) > 9998) {
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTimeZone(TimeZone.getTimeZone("GMT"));
            if (calendar2.get(1) > 9999) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
                simpleDateFormat.setTimeZone(calendar.getTimeZone());
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyyy-MM-dd HH:mm z");
                simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("GMT"));
                String string = MessageUtil.formatMsg((String)"{0} ({1}) exceeds the maximum allowed year value of 9999 GMT.", (Object[])new Object[]{simpleDateFormat.format(calendar.getTime()), simpleDateFormat2.format(calendar2.getTime())});
                throw new IllegalStateException(string);
            }
        }
    }

    private void logError_BadScheduleInfo(JobInfo jobInfo, BadDataException badDataException, boolean bl) {
        String string = bl ? "The next scheduled runtime was cleared." : "No change was made to the next scheduled runtime(s).";
        String string2 = badDataException.getMessage();
        Exception[] exceptionArray = ((ExceptionErrorList)badDataException.getErrorList()).getExceptions();
        for (Exception exception : exceptionArray) {
            string2 = string2 + " " + exception.getMessage();
        }
        Object[] objectArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string, string2};
        this.writeToScheduleLog(RosettaMsg.NST_CALC_BAD_SCHEDULE_INFO, (String[])objectArray, jobInfo);
        this.writeToDiagnosticLog(RosettaMsg.NST_CALC_BAD_SCHEDULE_INFO, (String[])objectArray, (Exception)((Object)badDataException));
    }

    private void logError_JobNotFound(JobInfo jobInfo, Exception exception) {
        String string = MessageUtil.formatMsg((String)"A request was made to calculate the next scheduled time for job {0} on agent {1}, but the job was not found.", (Object[])new Object[]{jobInfo.getJobIDAsString(), jobInfo.getAgentNameWithID()});
        logger.warn((Object)string, (Throwable)exception);
    }

    private void logError_JVMError(JobInfo jobInfo, Error error) {
        try {
            String string = MessageUtil.formatMsg((String)"Unable to determine the next scheduled runtime for job {0} on agent {1}, due to a severe system error.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
            logger.fatal((Object)string, (Throwable)error);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logError_NotScheduleJob(JobInfo jobInfo) {
        String string = MessageUtil.formatMsg((String)"A request was made to calculate the next scheduled time for job {0} on agent {1}, but it is not a scheduled type job.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
        logger.warn((Object)string);
    }

    private void logError_NSTCalcError(int n, Exception exception) {
        String[] stringArray = new String[]{Integer.toString(n), this.nestedMsgText(exception)};
        this.writeToScheduleLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE, stringArray, n);
    }

    private void logError_NSTCalcError(JobInfo jobInfo, String string) {
        String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string};
        this.writeToScheduleLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE, stringArray, jobInfo);
    }

    private void logError_NSTCalcError(JobInfo jobInfo, Exception exception) {
        String string = exception instanceof NullPointerException ? "NullPointerException. See diagnostic log for details." : this.nestedMsgText(exception);
        String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string};
        this.writeToScheduleLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE, stringArray, jobInfo);
        this.writeToDiagnosticLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE, stringArray, exception);
    }

    private void logError_NSTCalcError_NotSetToNull(JobInfo jobInfo, Exception exception) {
        String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), this.getUnanticipatedErrorMessageText(), this.nestedMsgText(exception)};
        this.writeToScheduleLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE_NOT_SET_TO_NULL, stringArray, jobInfo);
        this.writeToDiagnosticLog(RosettaMsg.NST_CALC_UNABLE_TO_DETERMINE_NOT_SET_TO_NULL, stringArray, exception);
    }

    private void logError_NSTClearError(JobInfo jobInfo, Exception exception) {
        String string = MessageUtil.formatMsg((String)"Unable to clear the next scheduled runtime for job {0}, agent {1} in the database.", (Object[])new Object[]{jobInfo.getJobIDAsString(), jobInfo.getAgentNameWithID()});
        logger.error((Object)string, (Throwable)exception);
    }

    private void logError_TimeDataNotSaved(JobInfo jobInfo, Exception exception, ScheduledTime scheduledTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        simpleDateFormat.setTimeZone(scheduledTime.getNextScheduledTime().getTimeZone());
        String[] stringArray = new String[]{simpleDateFormat.format(scheduledTime.getNextScheduledTime().getTime()), jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()};
        this.writeToScheduleLog(RosettaMsg.NST_CALC_TIME_DATA_NOT_SAVED, stringArray, jobInfo);
        this.writeToDiagnosticLog(RosettaMsg.NST_CALC_TIME_DATA_NOT_SAVED, stringArray, exception);
    }

    private void logError_UnrecognizedTimeZoneID(String string, String string2, int n) {
        Object[] objectArray = new String[]{string, this.getJobName(n), string2};
        this.writeToScheduleLog(RosettaMsg.NST_CALC_UNRECOGNIZED_TIME_ZONE_ID, (String[])objectArray, n);
        String string3 = RosettaMsg.getMsgText((RosettaMsg)RosettaMsg.NST_CALC_UNRECOGNIZED_TIME_ZONE_ID, (Object[])objectArray);
        logger.error((Object)string3);
    }

    private String getUnanticipatedErrorMessageText() {
        return "This was an unanticipated error and no attempt was made to change or clear the next scheduled runtime, in the database! In other words, the next scheduled runtime value will be the same as the last time the job was scheduled to run.";
    }

    private String nestedMsgText(Exception exception) {
        String string = exception.getMessage();
        for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
            string = string + " " + throwable.getMessage();
        }
        return string;
    }

    private void writeToDiagnosticLog(RosettaMsg rosettaMsg, String[] stringArray, Exception exception) {
        String string = RosettaMsg.getMsgText((RosettaMsg)rosettaMsg, (Object[])stringArray);
        string = string.split("Cause:")[0];
        logger.error((Object)string, (Throwable)exception);
    }

    private void writeToScheduleLog(RosettaMsg rosettaMsg, String[] stringArray, JobInfo jobInfo) {
        if (!this.isSuppressScheduleLogEntry()) {
            ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, (long)jobInfo.getAgentID(), (long)jobInfo.getJobID());
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        }
    }

    private void writeToScheduleLog(RosettaMsg rosettaMsg, String[] stringArray, int n) {
        if (!this.isSuppressScheduleLogEntry()) {
            ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, 0L, (long)n);
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    private boolean isSuppressScheduleLogEntry() {
        Boolean bl = suppressScheduleLogEntry.get();
        return bl != null && bl == Boolean.TRUE;
    }
}

