/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.network;

import com.helpsystems.common.core.network.NodeProxy;
import com.helpsystems.common.core.network.ProductProxy;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.util.ArrayList;
import java.util.List;

public class RuntimeNodeProxy
extends NodeProxy {
    private static final long serialVersionUID = 1951512160730518040L;
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(RuntimeNodeProxy.class);
    public static final int UNKNOWN = 0;
    public static final int ONLINE = 1;
    public static final int OFFLINE = 2;
    public static final int DOWNLEVEL = 5;
    private String address;
    private int state;
    private int timezone;
    private String hwIdentifier;
    private String systemName;
    private String systemDesc;
    private List<ProductProxy> productList;

    public int getState() {
        return this.state;
    }

    public String getStateAsString() {
        return RuntimeNodeProxy.getStateAsString(this.state);
    }

    public static String getStateAsString(int n) {
        switch (n) {
            case 1: {
                return rbh.getStdMsg("online");
            }
            case 2: {
                return rbh.getStdMsg("offline");
            }
            case 5: {
                return rbh.getStdMsg("downlevel");
            }
        }
        return rbh.getStdMsg("unknown");
    }

    public void setState(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                this.state = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("The state is not valid.");
            }
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public String getHardwareIdentifier() {
        return this.hwIdentifier;
    }

    public void setHardwareIdentifier(String string) {
        this.hwIdentifier = string;
    }

    public int getTimeZone() {
        return this.timezone;
    }

    public void setTimeZone(int n) {
        this.timezone = n;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String string) {
        this.systemName = string;
    }

    public String getSystemDescription() {
        return this.systemDesc;
    }

    public void setSystemDescription(String string) {
        this.systemDesc = string;
    }

    public void clearProducts() {
        if (this.productList != null) {
            this.productList.clear();
        }
    }

    public ProductProxy[] getProducts() {
        if (this.productList == null) {
            return new ProductProxy[0];
        }
        ProductProxy[] productProxyArray = new ProductProxy[this.productList.size()];
        this.productList.toArray(productProxyArray);
        return productProxyArray;
    }

    public void addProduct(ProductProxy productProxy) {
        if (this.productList == null) {
            this.productList = new ArrayList<ProductProxy>();
        }
        this.productList.add(productProxy);
    }
}

