/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.access;

import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerNotFoundException;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.DestinationCache;
import com.helpsystems.common.tl.access.TLManagerFactory;
import com.helpsystems.common.tl.busobj.DataManagerEntry;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.common.tl.event.PeerEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class TLManagerRegistryPlugin
implements ManagerRegistryPlugin {
    private static final Logger logger = Logger.getLogger(TLManagerRegistryPlugin.class);
    private Hashtable<String, IAbstractManager> resolvedManagers;
    private Peer localPeer;
    private DestinationCache destinationCache;
    private HashMap<PeerID, DataManagerEntry[]> managerListingCache;

    public TLManagerRegistryPlugin(Peer peer) {
        ValidationHelper.checkForNull((String)"Local peer", (Object)peer);
        this.localPeer = peer;
        this.destinationCache = new DestinationCache();
        this.resolvedManagers = new Hashtable();
        this.managerListingCache = new HashMap();
        peer.addListener(new PeerEventListener(){

            @Override
            protected void peerConnected(PeerID peerID, PeerID peerID2) {
                TLManagerRegistryPlugin.this.reset();
            }

            @Override
            protected void peerDisconnected(PeerID peerID, PeerID peerID2) {
                TLManagerRegistryPlugin.this.reset();
            }
        });
    }

    public IAbstractManager lookupManager(BasicIdentifier basicIdentifier, String string, ClassLoader classLoader) throws ManagerNotFoundException {
        ValidationHelper.checkForNull((String)"Identifier", (Object)basicIdentifier);
        ValidationHelper.checkForNull((String)"Prefix", (Object)string);
        try {
            IAbstractManager iAbstractManager = this.lookupOrFetch(basicIdentifier, string, classLoader);
            return iAbstractManager;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            ManagerNotFoundException managerNotFoundException = new ManagerNotFoundException(basicIdentifier + ":" + string);
            managerNotFoundException.initCause((Throwable)resourceUnavailableException);
            throw managerNotFoundException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAbstractManager lookupOrFetch(BasicIdentifier basicIdentifier, String string, ClassLoader classLoader) throws ResourceUnavailableException {
        String string2;
        PeerID peerID;
        if (basicIdentifier instanceof PeerID) {
            peerID = (PeerID)basicIdentifier;
            string2 = "PeerID_ " + peerID.getHardwareHash() + ":" + peerID.getInstanceIdentifier() + "_" + string;
        } else {
            string2 = basicIdentifier + string;
        }
        peerID = this.resolvedManagers.get(string2);
        if (peerID != null) {
            return peerID;
        }
        DestinationCache.CacheValue cacheValue = null;
        Object object = this.destinationCache;
        synchronized (object) {
            cacheValue = this.destinationCache.lookupIdentifier(this.localPeer, basicIdentifier);
        }
        object = cacheValue.getLibraryName();
        PeerID peerID2 = cacheValue.getPeerID();
        DataManagerEntry[] dataManagerEntryArray = null;
        dataManagerEntryArray = this.managerListingCache.get(peerID2);
        if (dataManagerEntryArray != null && (peerID = this.findTheManager(peerID2, (String)object, dataManagerEntryArray, string, classLoader)) != null) {
            return peerID;
        }
        IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)TLManagerFactory.createProxy(IPeerInfoManager.class, this.localPeer, peerID2, "PEER.PeerInfoManager");
        try {
            dataManagerEntryArray = iPeerInfoManager.listManagers();
            this.managerListingCache.put(peerID2, dataManagerEntryArray);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to get a data manager listing from " + peerID2.getPeerDescriptor(), (Throwable)exception);
        }
        peerID = this.findTheManager(peerID2, (String)object, dataManagerEntryArray, string, classLoader);
        if (peerID != null) {
            this.resolvedManagers.put(string2, (IAbstractManager)peerID);
            return peerID;
        }
        throw new ResourceUnavailableException("Unable to find a data manager starting with '" + string + "' on peer " + peerID2, null);
    }

    private IAbstractManager findTheManager(PeerID peerID, String string, DataManagerEntry[] dataManagerEntryArray, String string2, ClassLoader classLoader) throws ResourceUnavailableException {
        Object object;
        String string3;
        IAbstractManager iAbstractManager = null;
        String string4 = string2.toUpperCase();
        ArrayList<DataManagerEntry> arrayList = new ArrayList<DataManagerEntry>();
        for (int i = 0; i < dataManagerEntryArray.length; ++i) {
            if (!dataManagerEntryArray[i].getName().toUpperCase().startsWith(string4)) continue;
            arrayList.add(dataManagerEntryArray[i]);
        }
        Object object2 = null;
        if (arrayList.size() == 1) {
            object2 = (DataManagerEntry)((Object)arrayList.get(0));
        } else if (arrayList.size() > 1) {
            string3 = string == null || string.length() == 0 ? null : "." + string.toUpperCase();
            object = null;
            for (DataManagerEntry dataManagerEntry : arrayList) {
                String string5 = dataManagerEntry.getName().toUpperCase();
                if (string5.equals(string4)) {
                    object = dataManagerEntry;
                }
                if (string3 != null) {
                    if (!string5.endsWith(string3)) continue;
                    object2 = dataManagerEntry;
                    break;
                }
                if (!string5.equals(string4)) continue;
                object2 = dataManagerEntry;
                break;
            }
            if (object2 == null && object != null) {
                object2 = object;
            }
        }
        if (object2 == null) {
            return null;
        }
        string3 = object2.getInterfaceName();
        object = null;
        if (classLoader != null) {
            try {
                object = classLoader.loadClass(string3);
            }
            catch (Exception exception) {
                logger.debug((Object)("The classloader " + classLoader + " was not able to load the class/interface " + string3 + ". Trying the System cloassloader instead."), (Throwable)exception);
            }
        }
        if (object == null) {
            try {
                object = Class.forName(string3);
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Unable to load interface " + string3 + " for communicating with the data manager " + object2.getName() + " on the remote peer " + peerID, (Throwable)exception);
            }
        }
        iAbstractManager = TLManagerFactory.createProxy(object, this.localPeer, peerID, object2.getName());
        return iAbstractManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.resolvedManagers.clear();
        DestinationCache destinationCache = this.destinationCache;
        synchronized (destinationCache) {
            this.destinationCache.clear();
        }
        this.managerListingCache.clear();
    }
}

