/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.access;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.RoutableBasicIdentifier;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.TLManagerFactory;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.common.tl.ex.RemoteManagerNotFoundException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

class DestinationCache {
    private static final Logger logger = Logger.getLogger(DestinationCache.class);
    private Map<BasicIdentifier, CacheValue> cache = new HashMap<BasicIdentifier, CacheValue>();

    DestinationCache() {
    }

    void clear() {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheValue lookupIdentifier(Peer peer, BasicIdentifier basicIdentifier) throws ResourceUnavailableException {
        if (basicIdentifier == null) {
            throw new NullPointerException("The identifier passed in is null.");
        }
        CacheValue cacheValue = null;
        Map<BasicIdentifier, CacheValue> map = this.cache;
        synchronized (map) {
            cacheValue = this.cache.get(basicIdentifier);
            if (cacheValue != null) {
                return cacheValue;
            }
            if (basicIdentifier instanceof ProductIID && (cacheValue = this.checkHostProduct(peer, (ProductIID)basicIdentifier)) != null) {
                return cacheValue;
            }
            if (cacheValue == null) {
                cacheValue = this.resolveIdentifier(peer, basicIdentifier);
            }
            if (cacheValue == null) {
                throw new RemoteManagerNotFoundException(null, basicIdentifier.toString(), 3);
            }
            this.cache.put(basicIdentifier, cacheValue);
        }
        return cacheValue;
    }

    private CacheValue checkHostProduct(Peer peer, ProductIID productIID) throws ResourceUnavailableException {
        if (productIID == ProductIID.HOST_PIID || productIID == ProductIID.PRODUCT_MASTER_PIID || productIID == ProductIID.DATA_REPLICATION_PIID || productIID == ProductIID.HOST_PRODUCT_INSTANCE_PIID) {
            PeerID[] peerIDArray = peer.getGatewaysFromRoutingTable();
            if (peerIDArray.length != 1) {
                throw new RemoteManagerNotFoundException(null, "Unable to determine which Host to use. " + peerIDArray.length + " hosts found.", null);
            }
            String string = "";
            if (productIID == ProductIID.PRODUCT_MASTER_PIID) {
                string = "_PM";
            } else if (productIID == ProductIID.DATA_REPLICATION_PIID) {
                string = "_DR";
            } else if (productIID == ProductIID.HOST_PRODUCT_INSTANCE_PIID) {
                string = "_HPI";
            }
            return new CacheValue(peerIDArray[0], string);
        }
        return null;
    }

    private CacheValue resolveIdentifier(Peer peer, BasicIdentifier basicIdentifier) throws ResourceUnavailableException {
        Object object;
        PeerID[] peerIDArray;
        Object object2;
        if (basicIdentifier instanceof RoutableBasicIdentifier && ((PeerID[])(object2 = peer.searchRoutingTableFor((peerIDArray = (PeerID[])basicIdentifier).getHardwareHash(), peerIDArray.getInstanceIdentifier()))).length > 0) {
            return new CacheValue(object2[0], null);
        }
        peerIDArray = peer.getGatewaysFromRoutingTable();
        if (peerIDArray.length == 0) {
            throw new RemoteManagerNotFoundException(null, "The local peer does not have any hosts in its routing table.", null);
        }
        object2 = null;
        PeerID peerID = null;
        for (int i = 0; i < peerIDArray.length; ++i) {
            object = peerIDArray[i];
            try {
                object2 = (IPeerInfoManager)TLManagerFactory.createProxy(IPeerInfoManager.class, peer, (PeerID)object, "PEER.PeerInfoManager", -1);
                peerID = object2.resolveIdentifier(basicIdentifier);
                if (peerID == null) continue;
                break;
            }
            catch (Exception exception) {
                logger.debug((Object)("Error when asking host " + ((PeerID)object).getPeerDescriptor().findPrintableAddress() + " for info about " + basicIdentifier), (Throwable)exception);
            }
        }
        if (peerID != null) {
            Serializable serializable = peerID.getInstanceIdentifier();
            object = null;
            if (serializable != null) {
                object = serializable.toString();
            }
            return new CacheValue(peerID, (String)object);
        }
        return null;
    }

    class CacheValue {
        PeerID descriptor;
        String libraryName;

        CacheValue(PeerID peerID, String string) {
            this.descriptor = peerID;
            this.libraryName = string;
        }

        public PeerID getPeerID() {
            return this.descriptor;
        }

        public String getLibraryName() {
            return this.libraryName;
        }
    }
}

