/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.access;

import com.helpsystems.common.core.util.ValidationHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class ChameleonThrowable
extends Throwable
implements Serializable {
    private String classname;
    private byte[] buf;

    public ChameleonThrowable(Throwable throwable) {
        super(ChameleonThrowable.getMessageFromThrowable(throwable));
        this.setStackTrace(throwable.getStackTrace());
        this.classname = throwable.getClass().getName();
        if (throwable.getCause() != null) {
            this.initCause(new ChameleonThrowable(throwable.getCause()));
        }
        this.serializeThrowable(throwable);
    }

    @Override
    public String toString() {
        String string = "Deserialized " + this.classname;
        String string2 = this.getLocalizedMessage();
        return string2 != null ? string + ": " + string2 : string;
    }

    private void serializeThrowable(Throwable throwable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(throwable);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            this.buf = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Throwable deserializeThrowable() {
        if (this.buf == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Throwable throwable = (Throwable)objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
            return throwable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        Throwable throwable = this.deserializeThrowable();
        if (throwable == null) {
            throwable = this;
        }
        return throwable;
    }

    private static String getMessageFromThrowable(Throwable throwable) {
        ValidationHelper.checkForNull((String)"Throwable", (Object)throwable);
        return throwable.getLocalizedMessage();
    }
}

