/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.common.tl.processor.impl.DataManagerCommand;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class TestNode
extends HeavyweightPeer {
    private static final Logger logger = Logger.getLogger(TestNode.class);

    public TestNode(PeerDescriptor peerDescriptor) throws PeerStartupException {
        super(peerDescriptor, (Serializable)((Object)"MyNodeLib"), new HeavyweightPeerConfig());
    }

    @Override
    protected void checkCredentials(ConnectRequest connectRequest) {
        logger.info((Object)("Accepting connect from " + connectRequest.getPeerID()));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("Need 3 args: listen-port host-address host-port");
            System.exit(-1);
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 1) {
            System.out.println("Invalid listen-port number.");
            System.exit(-1);
        }
        PeerDescriptor peerDescriptor = PeerDescriptor.createLocalPeerDescriptor(n, 2);
        TestNode testNode = null;
        try {
            testNode = new TestNode(peerDescriptor);
            testNode.startup();
        }
        catch (Exception exception) {
            logger.error((Object)"Can't start the node.", (Throwable)exception);
            System.exit(-1);
        }
        n = 0;
        try {
            n = Integer.parseInt(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 1) {
            System.out.println("Invalid host-port number.");
            System.exit(-1);
        }
        PeerDescriptor peerDescriptor2 = new PeerDescriptor(stringArray[1], n, 1, null);
        try {
            TestNode.doStuff(testNode, peerDescriptor2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void doStuff(TestNode testNode, PeerDescriptor peerDescriptor) throws Exception {
        PeerID peerID = testNode.connectToPeer(peerDescriptor, (Serializable)((Object)"asabekone"));
        Envelope envelope = new Envelope();
        envelope.setPayload(new DataManagerCommand("LoopbackDM", "fictionalMethod", new Class[0], new Object[0]));
        envelope.setDestination(testNode.getRemotePeerID());
        testNode.sendEnvelope(envelope);
        logger.info((Object)"Loopback Envelope successfully sent!");
        envelope = new Envelope();
        envelope.setPayload(new DataManagerCommand("FictionalDM", "fictionalMethod", new Class[0], new Object[0]));
        envelope.setDestination(peerID);
        testNode.sendEnvelopeAndWait(envelope);
        logger.info((Object)"Envelope successfully sent!");
    }
}

