/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.util.HSJvmProperties;
import com.helpsystems.common.tl.DisconnectRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.log4j.Logger;

class SocketProtocol {
    private static final byte UNCOMPRESSED_HEADER_MARKER = 10;
    private static final byte COMPRESSED_HEADER_MARKER = 20;
    private static final byte TRAILER_MARKER = 99;
    private static final Logger logger = Logger.getLogger(SocketProtocol.class);
    private Socket socket;
    private HashMap<Long, List<ReceivedObject>> threadMap;
    private String who;
    private Thread threadVolunteer;
    private OutputStream out;
    private PushbackInputStream in;
    private ByteBuffer bbHeader;
    private ByteBuffer bbOne;
    private String address;
    private int socketPort;
    private int localPort;
    private InetAddress inetAddress;
    private InetAddress localInetAddress;
    private boolean closeRequested;
    private AtomicLong threadCounter;

    SocketProtocol(Socket socket) throws IOException {
        this.socket = socket;
        this.inetAddress = this.socket.getInetAddress();
        this.address = this.inetAddress.getHostAddress();
        this.socketPort = this.socket.getPort();
        this.localPort = this.socket.getLocalPort();
        this.localInetAddress = this.socket.getLocalAddress();
        this.who = socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
        this.threadMap = new HashMap();
        this.in = new PushbackInputStream(socket.getInputStream(), 5000);
        this.out = socket.getOutputStream();
        this.bbHeader = ByteBuffer.allocate(20);
        this.bbOne = ByteBuffer.allocate(1);
        this.threadCounter = new AtomicLong(1L);
    }

    public synchronized void close() {
        this.close(true);
    }

    public synchronized void closeHard() {
        this.close(false);
    }

    private synchronized void close(boolean bl) {
        if (this.isClosed()) {
            return;
        }
        this.closeRequested = true;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("SocketProtocol.close(boolean) invoked.  Notity Peer: " + bl));
        }
        if (bl) {
            try {
                this.sendObject((Serializable)((Object)new DisconnectRequest()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.closeAndNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeAndNotify() {
        block9: {
            if (this.socket == null) {
                return;
            }
            try {
                if (logger.isTraceEnabled()) {
                    if (this.closeRequested) {
                        logger.trace((Object)("Closing the socket: " + this.who));
                    } else {
                        logger.trace((Object)("Unexpected socket closed: " + this.who));
                    }
                }
                this.socket.close();
            }
            catch (Exception exception) {
                if (!logger.isTraceEnabled()) break block9;
                logger.trace((Object)("Error closing the socket: " + this.who), (Throwable)exception);
            }
        }
        HashMap<Long, List<ReceivedObject>> hashMap = this.threadMap;
        synchronized (hashMap) {
            this.threadMap.notifyAll();
        }
        this.socket = null;
    }

    private void checkIfClosed() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("The socket has already been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBacklog() {
        int n = 0;
        HashMap<Long, List<ReceivedObject>> hashMap = this.threadMap;
        synchronized (hashMap) {
            for (List<ReceivedObject> list : this.threadMap.values()) {
                n += list.size();
            }
        }
        return n;
    }

    public String getIdentification() {
        return this.who;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public InetAddress getSocketInetAddress() {
        return this.inetAddress;
    }

    public String getSocketAddress() {
        return this.address;
    }

    public int getSocketPort() {
        return this.socketPort;
    }

    public InetAddress getLocalInetAddress() {
        return this.localInetAddress;
    }

    static boolean isHeaderByte(int n) {
        switch (n) {
            case 10: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    private long getThreadID() {
        long l = 0L;
        while (l == 0L) {
            l = this.threadCounter.incrementAndGet();
        }
        return l;
    }

    public boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    public synchronized void replyToObject(Serializable serializable, long l) throws IOException {
        this.internalSendObject(serializable, 0L, l);
    }

    public Serializable sendAndReceiveObject(Serializable serializable, int n) throws IOException {
        long l = this.getThreadID();
        this.internalSendObject(serializable, l, 0L);
        return this.receiveObject((int)n, (long)l).object;
    }

    public void sendObject(Serializable serializable) throws IOException {
        this.internalSendObject(serializable, 0L, 0L);
    }

    private void internalSendObject(Serializable serializable, long l, long l2) throws IOException {
        Serializable serializable2;
        byte[] byArray;
        Object object;
        Object object2;
        this.checkIfClosed();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        try {
            object2 = new ByteArrayOutputStream();
            object = new ObjectOutputStream((OutputStream)object2);
            ((ObjectOutputStream)object).writeObject(serializable);
            ((ObjectOutputStream)object).flush();
            byArray = ((ByteArrayOutputStream)object2).toByteArray();
            n = byArray.length;
            if (byArray.length > 5000) {
                byArray = this.deflate(byArray);
                bl = true;
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Unable to prepare data for peer " + this.who);
            iOException.initCause(exception);
            throw iOException;
        }
        object2 = ByteBuffer.allocate(byArray.length + 100);
        if (!bl) {
            ((ByteBuffer)object2).put((byte)10);
        } else {
            ((ByteBuffer)object2).put((byte)20);
        }
        ((ByteBuffer)object2).putInt(byArray.length);
        ((ByteBuffer)object2).putLong(l);
        ((ByteBuffer)object2).putLong(l2);
        ((ByteBuffer)object2).put(byArray);
        ((ByteBuffer)object2).put((byte)99);
        n2 = ((Buffer)object2).position();
        ((ByteBuffer)object2).flip();
        if (HSJvmProperties.isRMITraceEnabled() && logger.isTraceEnabled()) {
            object = new ReceivedObject();
            ((ReceivedObject)object).object = serializable;
            ((ReceivedObject)object).sourceThreadID = l;
            ((ReceivedObject)object).destThreadID = l2;
            serializable2 = new StringBuffer();
            ((StringBuffer)serializable2).append(">>> Sending ");
            ((StringBuffer)serializable2).append(byArray.length);
            ((StringBuffer)serializable2).append(" bytes");
            if (bl) {
                ((StringBuffer)serializable2).append(" (was ");
                ((StringBuffer)serializable2).append(n);
                ((StringBuffer)serializable2).append(")");
            }
            ((StringBuffer)serializable2).append(" to ");
            ((StringBuffer)serializable2).append(this.who);
            ((StringBuffer)serializable2).append(": ");
            ((StringBuffer)serializable2).append(object);
            logger.trace((Object)((StringBuffer)serializable2).toString());
        }
        try {
            this.writeBytes((ByteBuffer)object2, n2);
        }
        catch (IOException iOException) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("The socket to " + this.who + " failed a write."));
            }
            this.closeAndNotify();
            serializable2 = new SocketException("Socket write failed, peer " + this.who);
            ((Throwable)serializable2).initCause(iOException);
            throw serializable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBytes(ByteBuffer byteBuffer, int n) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(byteBuffer.array(), 0, n);
            this.out.flush();
        }
    }

    public ReceivedObject receiveObject() throws IOException {
        return this.receiveObject(-1, 0L);
    }

    public ReceivedObject receiveObject(int n) throws IOException {
        return this.receiveObject(n, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceivedObject receiveObject(int n, long l) throws IOException {
        ReceivedObject receivedObject = null;
        long l2 = System.currentTimeMillis();
        while (true) {
            this.checkIfClosed();
            HashMap<Long, List<ReceivedObject>> hashMap = this.threadMap;
            synchronized (hashMap) {
                receivedObject = this.getWaitingObject(l);
                if (receivedObject != null) {
                    Serializable serializable = receivedObject.object;
                    if (serializable == null) {
                        return receivedObject;
                    }
                    return receivedObject;
                }
                if (this.threadVolunteer == null) {
                    this.threadVolunteer = Thread.currentThread();
                }
            }
            if (this.threadVolunteer == Thread.currentThread()) {
                try {
                    this.internalReceiveObject(n);
                }
                finally {
                    hashMap = this.threadMap;
                    synchronized (hashMap) {
                        this.threadVolunteer = null;
                        this.threadMap.notifyAll();
                    }
                }
            }
            this.checkTimeout(l2, n, "Timeout while waiting for response from peer ");
            hashMap = this.threadMap;
            synchronized (hashMap) {
                try {
                    this.threadMap.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalReceiveObject(int n) throws IOException {
        Object object;
        if (Thread.currentThread() != this.threadVolunteer) {
            throw new IllegalStateException("Current thread [" + Thread.currentThread() + "] is not registered to read the socket. " + "Registered thread is [" + this.threadVolunteer + "]");
        }
        long l = System.currentTimeMillis();
        int n2 = -1;
        int n3 = n;
        boolean bl = false;
        long l2 = -1L;
        long l3 = -1L;
        ByteBuffer byteBuffer = null;
        int n4 = -1;
        try {
            int n5 = 0;
            int n6 = 0;
            if (n3 < 1) {
                while (n5 == 0) {
                    object = this.in;
                    synchronized (object) {
                        n5 = this.in.read();
                    }
                    if (n5 == -1) {
                        throw new SocketException("Socket looks like it's closed.");
                    }
                    if (n5 != 0 || ++n6 <= 100) continue;
                    this.close();
                    throw new SocketException("Close socket, unusable data.");
                }
            } else {
                while (n5 == 0 && !this.socket.isClosed()) {
                    this.bbOne.clear();
                    this.readWithTimeout(this.bbOne, l, n3);
                    this.bbOne.flip();
                    n5 = this.bbOne.get(0);
                    if (n5 != 0) continue;
                    this.checkTimeout(l, n3, "Timeout while waiting for data from peer ");
                }
            }
            if (!SocketProtocol.isHeaderByte(n5)) {
                throw new IOException("Bad start of packet code: " + n5);
            }
            switch (n5) {
                case 20: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                default: {
                    throw new IOException("Bad start of packet code: " + n5);
                }
            }
            this.bbHeader.clear();
            this.readWithTimeout(this.bbHeader, l, n3);
            this.bbHeader.flip();
            n4 = this.bbHeader.getInt();
            l2 = this.bbHeader.getLong();
            l3 = this.bbHeader.getLong();
            if (n3 < 1) {
                n3 = 300000;
                l = System.currentTimeMillis();
            }
            byteBuffer = ByteBuffer.allocate(n4);
            this.readWithTimeout(byteBuffer, l, n3);
            n2 = 0;
            while (n2 == 0 && !this.socket.isClosed()) {
                this.bbOne.clear();
                this.readWithTimeout(this.bbOne, l, n3);
                this.bbOne.flip();
                n2 = this.bbOne.get(0);
                if (n2 != 0) continue;
                this.checkTimeout(l, n3, "Timeout while waiting for end of data");
            }
        }
        catch (SocketException socketException) {
            this.closeAndNotify();
            throw socketException;
        }
        catch (WebBrowserException webBrowserException) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("The socket to " + this.who + " appears to be a web browser"));
            }
            throw webBrowserException;
        }
        catch (IOException iOException) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("The socket to " + this.who + " failed a read."));
            }
            this.closeAndNotify();
            SocketException socketException = new SocketException("Socket read failed, peer " + this.who);
            socketException.initCause(iOException);
            throw socketException;
        }
        if (n2 != 99) {
            throw new IOException("Bad end of packet code: " + n2);
        }
        InputStream inputStream = new ByteArrayInputStream(byteBuffer.array());
        if (bl) {
            inputStream = new InflaterInputStream(inputStream);
        }
        ReceivedObject receivedObject = new ReceivedObject();
        try {
            object = new ObjectInputStream(inputStream);
            receivedObject.object = (Serializable)((ObjectInputStream)object).readObject();
        }
        catch (Throwable throwable) {
            receivedObject.object = throwable;
        }
        receivedObject.sourceThreadID = l2;
        receivedObject.destThreadID = l3;
        object = this.threadMap;
        synchronized (object) {
            this.addWaitingObject(l3, receivedObject);
        }
        if (HSJvmProperties.isRMITraceEnabled() && logger.isTraceEnabled()) {
            logger.trace((Object)("<<< Received " + n4 + " bytes from " + this.who + ": " + receivedObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readWithTimeout(ByteBuffer byteBuffer, long l, int n) throws IOException {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.position();
        PushbackInputStream pushbackInputStream = this.in;
        synchronized (pushbackInputStream) {
            while (true) {
                if (this.socket.isClosed()) {
                    this.closeAndNotify();
                    throw new SocketException("Socket closed");
                }
                int n3 = this.in.read(byArray, n2, byArray.length - n2);
                if (n3 == -1) {
                    this.closeAndNotify();
                    throw new SocketException("Socket appears to be closed");
                }
                if ((n2 += n3) >= byArray.length) {
                    byteBuffer.position(n2);
                    return;
                }
                this.checkTimeout(l, n, "Timeout while reading data from from peer ");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unread(int n) throws IOException {
        PushbackInputStream pushbackInputStream = this.in;
        synchronized (pushbackInputStream) {
            this.in.unread(n);
        }
    }

    private ReceivedObject getWaitingObject(long l) {
        Long l2 = new Long(l);
        List<ReceivedObject> list = this.threadMap.get(l2);
        ReceivedObject receivedObject = null;
        if (list == null || list.size() == 0) {
            return null;
        }
        receivedObject = list.remove(0);
        if (list.isEmpty() && l != 0L) {
            this.threadMap.remove(l2);
        }
        return receivedObject;
    }

    private void addWaitingObject(long l, ReceivedObject receivedObject) {
        Long l2 = new Long(l);
        List<ReceivedObject> list = this.threadMap.get(l2);
        if (list == null) {
            list = new ArrayList<ReceivedObject>();
            this.threadMap.put(l2, list);
        }
        list.add(receivedObject);
    }

    private byte[] deflate(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(2));
        deflaterOutputStream.write(byArray);
        deflaterOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void checkTimeout(long l, int n, String string) throws IOException {
        if (n < 1) {
            return;
        }
        long l2 = System.currentTimeMillis() - l;
        if (n > 0 && l2 >= 300000L) {
            throw new IOException(string + this.who);
        }
    }

    class WebBrowserException
    extends IOException {
        WebBrowserException() {
        }
    }

    class ReceivedObject {
        Serializable object;
        long sourceThreadID;
        long destThreadID;

        ReceivedObject() {
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SourceThread= ");
            stringBuffer.append(this.sourceThreadID);
            String string = Long.toString(this.sourceThreadID);
            for (n = string.length(); n < 21; ++n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("   DestThread= ");
            stringBuffer.append(this.destThreadID);
            string = Long.toString(this.destThreadID);
            for (n = string.length(); n < 21; ++n) {
                stringBuffer.append(' ');
            }
            if (this.object != null) {
                String string2 = null;
                stringBuffer.append(this.object.getClass().getName());
                stringBuffer.append(": ");
                if (string2 != null) {
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(this.object);
                }
            }
            return stringBuffer.toString();
        }
    }
}

