/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.DebugMarker;
import com.helpsystems.common.tl.DisconnectRequest;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.IPeer;
import com.helpsystems.common.tl.LoopbackPeerRunner;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.PeerRunner;
import com.helpsystems.common.tl.SocketProtocol;
import com.helpsystems.common.tl.ex.EnvelopeException;
import com.helpsystems.common.tl.ex.InvalidCredentialsException;
import com.helpsystems.common.tl.ex.PeerAlreadyConnectedException;
import com.helpsystems.common.tl.ex.PeerConnectException;
import com.helpsystems.common.tl.ex.PeerDisconnectedException;
import com.helpsystems.common.tl.processor.impl.PingCommand;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class PeerProtocolRunner
extends PeerRunner
implements IPeer {
    private static final int WAITING_FOR_THEIR_CONNECT_REQUEST = 1;
    private static final int WAITING_FOR_OUR_CONNECT_RESPONSE = 2;
    private static final int TRUSTED_CONNECTION = 3;
    private static final int CONNECTION_CLOSED = -1;
    private static final int CLOSE_OUR_CONNECTION = -2;
    private static final int CONNECTION_TIMED_OUT = -3;
    private static final Logger logger = Logger.getLogger(PeerProtocolRunner.class);
    private SocketProtocol protocol;
    private Thread socketThread;
    private int readFailure;
    private int writeFailure;
    private int state;
    private SocketProtocol.ReceivedObject ro;
    private Serializable response;
    private Serializable credentials;
    private Object connectResult;
    private Object connectLockObject;
    private ThreadLocal threadMarker;
    private boolean addOurselfToRoutingTable;

    PeerProtocolRunner(Peer peer, SocketProtocol socketProtocol, Serializable serializable, long l) {
        super(peer, socketProtocol.getIdentification(), l);
        this.initPeerProtocolRunner(peer, socketProtocol, serializable);
    }

    PeerProtocolRunner(Peer peer, SocketProtocol socketProtocol, Serializable serializable) {
        super(peer, socketProtocol.getIdentification());
        this.initPeerProtocolRunner(peer, socketProtocol, serializable);
    }

    private void initPeerProtocolRunner(Peer peer, SocketProtocol socketProtocol, Serializable serializable) {
        ValidationHelper.checkForNull((String)"Protocol", (Object)socketProtocol);
        ValidationHelper.checkForNull((String)"Credentials", (Object)serializable);
        this.protocol = socketProtocol;
        this.credentials = serializable;
        this.connectLockObject = new Object();
        this.threadMarker = new PeerRunner.ThreadMarker(this);
    }

    private void changeState(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Waiting for initial CR from " + this.who;
                break;
            }
            case 2: {
                string = "Waiting for CR response from " + this.who;
                break;
            }
            case 3: {
                string = "Connected to " + this.getPeerID();
                break;
            }
            case -2: {
                string = "Disconnecting from " + this.getPeerID();
                break;
            }
            case -1: {
                string = "Finished with " + this.getPeerID();
                break;
            }
            case -3: {
                string = "Connection timed out to " + this.getPeerID();
                break;
            }
            default: {
                string = "Unknown state with " + this.who;
            }
        }
        this.socketThread.setName(string);
        this.state = n == -3 ? -1 : n;
    }

    @Override
    public void close() {
        this.close(-2);
    }

    private void close(int n) {
        this.changeState(n);
        if (n == -3) {
            this.protocol.closeHard();
        } else {
            this.protocol.close();
        }
        super.close();
    }

    InetAddress getInetAddress() {
        return this.protocol.getSocketInetAddress();
    }

    @Override
    public int getBacklog() {
        return this.protocol.getBacklog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateResponse() {
        this.response = null;
        if (this.state == -2) {
            this.response = new DisconnectRequest();
            return;
        }
        if (this.ro == null) {
            return;
        }
        Serializable serializable = this.ro.object;
        if (serializable == null) {
            return;
        }
        if (serializable instanceof DisconnectRequest) {
            this.changeState(-1);
            return;
        }
        if (this.state == 1) {
            if (serializable instanceof ConnectRequest) {
                ConnectRequest connectRequest = (ConnectRequest)((Object)serializable);
                this.handleConnect(connectRequest);
                this.changeState(2);
            } else {
                String string = "Expected ConnectRequest, received " + serializable.getClass().getName() + ": " + serializable;
                logger.trace((Object)string);
                this.response = new PeerConnectException(string);
                this.changeState(-2);
            }
            return;
        }
        if (this.state == 2) {
            if (this.connectResult == null) {
                this.connectResult = serializable;
            }
            if (this.connectResult instanceof PeerID) {
                this.changeState(3);
                if (this.addOurselfToRoutingTable) {
                    this.parentPeer.addPeerToRoutingTable(this);
                    this.addOurselfToRoutingTable = false;
                }
            } else {
                this.changeState(-2);
            }
            Object object = this.connectLockObject;
            synchronized (object) {
                this.connectLockObject.notifyAll();
            }
            return;
        }
        if (this.state == 3 && serializable instanceof Envelope) {
            block21: {
                Envelope envelope = (Envelope)((Object)serializable);
                try {
                    int n = this.handleEnvelope(envelope);
                    if (n == 1) {
                        this.response = "ok";
                        break block21;
                    }
                    if (n == 2) {
                        this.response = null;
                        break block21;
                    }
                    logger.debug((Object)("Unknown return code from 'handleEnvelope' " + n));
                    throw new EnvelopeException("Unknown handling of envelope " + envelope.getArbitraryID() + " on peer " + this.ourPeerID, envelope);
                }
                catch (EnvelopeException envelopeException) {
                    this.response = envelopeException;
                }
            }
            return;
        }
        if (serializable instanceof Throwable) {
            logger.trace((Object)("The remote peer " + this.who + " was unable to " + " accept an object."), (Throwable)serializable);
            this.response = null;
            return;
        }
        logger.trace((Object)("Don't know what kind of response to generate for " + serializable.getClass().getName() + ": " + serializable));
        this.response = new RuntimeException("The remote peer did not recognize the request: " + serializable.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnect(ConnectRequest connectRequest) {
        Object object;
        Object object2;
        if (connectRequest == null) {
            this.response = new PeerConnectException("The connect request was null.");
            return;
        }
        PeerID peerID = connectRequest.getPeerID();
        if (peerID == null) {
            this.response = new PeerConnectException("The peer ID in the request is missing.");
            return;
        }
        IPeer iPeer = this.parentPeer.getPeerFromRoutingTable(peerID);
        if (iPeer != null) {
            if (iPeer instanceof LoopbackPeerRunner || iPeer == this) {
                String string = null;
                string = iPeer instanceof LoopbackPeerRunner ? "Cannot replace an existing loopback route." : "A connection already exists.";
                this.response = new PeerAlreadyConnectedException(peerID, string);
                this.connectResult = this.response;
                Object object3 = this.connectLockObject;
                synchronized (object3) {
                    this.connectLockObject.notifyAll();
                }
                return;
            }
            object2 = new PeerSocketTester(iPeer);
            ((Thread)object2).start();
            try {
                object = object2;
                synchronized (object) {
                    object2.wait(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!((PeerSocketTester)object2).isSocketAlive()) {
                this.parentPeer.disconnectFromPeer(peerID);
            } else {
                this.response = new PeerAlreadyConnectedException(peerID, "A connection already exists.");
                this.connectResult = this.response;
                object = this.connectLockObject;
                synchronized (object) {
                    this.connectLockObject.notifyAll();
                }
                return;
            }
        }
        if ((object2 = peerID.getPeerDescriptor()) == null || !((PeerDescriptor)object2).isValid()) {
            this.response = new PeerConnectException("The peer descriptor in the request is missing or invalid.");
            return;
        }
        ((PeerDescriptor)object2).removeLoopbackAddresses();
        object = peerID.getHardwareKey();
        if (object == null || ((String)object).trim().length() == 0) {
            this.response = new PeerConnectException("The system info in the request is missing.");
            return;
        }
        boolean bl = false;
        if (peerID.equals(connectRequest.getCredentials())) {
            bl = true;
        } else {
            try {
                this.parentPeer.checkCredentials(connectRequest);
                bl = true;
            }
            catch (PeerConnectException peerConnectException) {
                this.response = peerConnectException;
                this.changeState(-2);
            }
            catch (Throwable throwable) {
                this.response = new PeerConnectException("The peer " + this.ourPeerID.getPeerDescriptor() + " encountered an error when processing the connect request", throwable);
                this.changeState(-2);
            }
        }
        if (bl) {
            this.setPeerID(peerID);
            logger.trace((Object)("This peer has accepted a trusted connection with peer " + this.who));
            this.getPeerID().getPeerDescriptor().setPreferredInetAddress(connectRequest.getOriginInetAddress());
            this.addOurselfToRoutingTable = true;
            this.response = this.ourPeerID;
        }
    }

    private void receiveObject() {
        block5: {
            this.ro = null;
            try {
                this.ro = this.state == 1 ? this.protocol.receiveObject(300000) : this.protocol.receiveObject();
                this.readFailure = 0;
            }
            catch (SocketException socketException) {
                if (this.state > -1) {
                    logger.debug((Object)("Read failed, socket no longer usable for peer " + this.who), (Throwable)socketException);
                }
                this.changeState(-1);
                return;
            }
            catch (Throwable throwable) {
                logger.debug((Object)("Error reading object from " + this.who), throwable);
                if (this.state == 1 || this.state == 2) {
                    this.changeState(-2);
                }
                ++this.readFailure;
                if (this.readFailure != 5) break block5;
                this.changeState(-2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = "Running on " + this.ourPeerID;
        Thread thread = Thread.currentThread();
        thread.setName(string);
        thread.setPriority(7);
        PeerRunner.MarkerInfo markerInfo = (PeerRunner.MarkerInfo)this.threadMarker.get();
        DebugMarker debugMarker = null;
        if (!markerInfo.markedRun) {
            debugMarker = this.buildMarker(string);
            try {
                markerInfo.markedRun = true;
                if (debugMarker != null) {
                    debugMarker.run(this);
                    return;
                }
            }
            finally {
                markerInfo.markedRun = false;
            }
        }
        try {
            this.socketThread = Thread.currentThread();
            this.socketThread.setName("Negotiating connection with peer " + this.who);
            this.socketThread.setPriority(5);
            this.changeState(1);
            try {
                CommonVersionedObject commonVersionedObject = new ConnectRequest(this.parentPeer.getRemotePeerID(), this.credentials);
                commonVersionedObject.setOriginInetAddress(this.protocol.getLocalInetAddress());
                this.response = commonVersionedObject;
                this.sendResponse();
            }
            catch (Throwable throwable) {
                this.connectResult = new PeerConnectException("Unable to send our credentials to the remote peer " + this.who, throwable);
                this.changeState(-2);
                this.changeState(-1);
                try {
                    this.protocol.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                PeerID peerID = this.getPeerID();
                boolean bl = this.connectResult instanceof PeerAlreadyConnectedException;
                if (peerID != null && !bl) {
                    this.parentPeer.removePeerFromRoutingTable(peerID);
                }
                super.close();
                logger.trace((Object)("Socket thread ended: " + this.who));
                this.threadMarker.remove();
                return;
            }
            while (!this.protocol.isClosed() && this.state > -1) {
                this.receiveObject();
                if (this.state == -1) {
                    return;
                }
                this.generateResponse();
                if (this.state == -1) {
                    return;
                }
                this.sendResponse();
                if (this.state != -2) continue;
                this.changeState(-1);
            }
        }
        catch (Throwable throwable) {
            if (this.state > -1) {
                logger.warn((Object)("Severe problem while communicating with peer " + this.who), throwable);
            }
        }
        finally {
            this.changeState(-1);
            try {
                this.protocol.close();
            }
            catch (Throwable throwable) {}
            PeerID peerID = this.getPeerID();
            boolean bl = this.connectResult instanceof PeerAlreadyConnectedException;
            if (peerID != null && !bl) {
                this.parentPeer.removePeerFromRoutingTable(peerID);
            }
            super.close();
            logger.trace((Object)("Socket thread ended: " + this.who));
            this.threadMarker.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testWaitingThreads(PeerID peerID) {
        Object object;
        ArrayList<PeerRunner.LockObject> arrayList = new ArrayList<PeerRunner.LockObject>();
        Object object2 = this.waitTable;
        synchronized (object2) {
            object = this.waitTable.keySet().toArray();
            boolean bl = false;
            if (peerID == null || peerID.getPeerDescriptor().getType() == 1) {
                bl = true;
            }
            for (int i = 0; i < ((Object[])object).length; ++i) {
                Object object3 = object[i];
                Object v = this.waitTable.get(object3);
                if (!(v instanceof PeerRunner.LockObject)) continue;
                PeerDisconnectedException peerDisconnectedException = null;
                PeerRunner.LockObject lockObject = (PeerRunner.LockObject)v;
                PeerID peerID2 = lockObject.getDestination();
                if (bl || peerID != null && peerID.equals(peerID2)) {
                    try {
                        this.pingPeer(peerID2);
                    }
                    catch (EnvelopeException envelopeException) {
                        peerDisconnectedException = new PeerDisconnectedException("Peer " + peerID2 + " is no longer reachable.", null, envelopeException);
                    }
                }
                if (peerDisconnectedException == null) continue;
                this.waitTable.put(object3, peerDisconnectedException);
                arrayList.add(lockObject);
            }
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            Object object4 = object = (PeerRunner.LockObject)object2.next();
            synchronized (object4) {
                object.notifyAll();
            }
        }
    }

    void pingPeer(PeerID peerID) throws EnvelopeException {
        Envelope envelope = new Envelope();
        PingCommand pingCommand = new PingCommand(System.currentTimeMillis());
        pingCommand.setSource(this.ourPeerID);
        envelope.setPayload(pingCommand);
        envelope.setSource(this.ourPeerID);
        envelope.setDestination(peerID);
        this.sendEnvelopeAndWait(envelope, 0);
    }

    @Override
    protected int forwardEnvelope(Envelope envelope) {
        long l = 0L;
        if (this.ro != null) {
            l = this.ro.sourceThreadID;
        }
        Thread thread = new Thread(new ForwardingRunner(envelope, l));
        thread.start();
        return 2;
    }

    @Override
    protected Serializable sendAndReceiveEnvelope(Envelope envelope) throws EnvelopeException {
        try {
            Serializable serializable = this.protocol.sendAndReceiveObject((Serializable)((Object)envelope), 15000);
            this.writeFailure = 0;
            return serializable;
        }
        catch (SocketException socketException) {
            if (this.state > -1) {
                logger.debug((Object)("Socket no longer usable for peer " + this.who), (Throwable)socketException);
            }
            int n = this.state;
            this.changeState(-1);
            if (n > -1) {
                throw new EnvelopeException("Remote peer no longer available.", envelope, socketException);
            }
            return "ok";
        }
        catch (IOException iOException) {
            logger.debug((Object)("Error replying to object from " + this.who), (Throwable)iOException);
            ++this.writeFailure;
            if (this.writeFailure == 5) {
                this.changeState(-2);
                this.close();
            }
            throw new EnvelopeException("Communication error with the remote peer", envelope, iOException);
        }
    }

    @Override
    public Envelope sendEnvelopeAndWait(Envelope envelope, int n) throws EnvelopeException {
        Thread thread = Thread.currentThread();
        if (n != 0 && thread == this.socketThread) {
            throw new IllegalStateException("The socket thread cannot be used, deadlock will occur.");
        }
        return super.sendEnvelopeAndWait(envelope, n);
    }

    private void sendResponse() {
        long l = 0L;
        if (this.ro != null) {
            l = this.ro.sourceThreadID;
        }
        this.sendResponse(this.response, l);
    }

    private void sendResponse(Serializable serializable, long l) {
        block5: {
            if (serializable == null) {
                return;
            }
            try {
                this.protocol.replyToObject(serializable, l);
                this.writeFailure = 0;
            }
            catch (SocketException socketException) {
                if (this.state > -1) {
                    logger.debug((Object)("Read failed, socket no longer usable for peer " + this.who), (Throwable)socketException);
                }
                this.changeState(-1);
            }
            catch (IOException iOException) {
                logger.debug((Object)("Error replying to object from " + this.who), (Throwable)iOException);
                ++this.writeFailure;
                if (this.writeFailure != 5) break block5;
                this.changeState(-2);
            }
        }
    }

    PeerID waitForConnection(long l) throws PeerConnectException, InvalidCredentialsException {
        Object object = this.connectLockObject;
        synchronized (object) {
            if (this.connectResult == null) {
                try {
                    this.connectLockObject.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.connectResult == null) {
                this.close(-3);
                throw new PeerConnectException("Timeout while waiting for a connection to peer " + this.who);
            }
            if (this.connectResult instanceof PeerID) {
                return (PeerID)this.connectResult;
            }
            if (this.connectResult instanceof InvalidCredentialsException) {
                Exception exception = (Exception)this.connectResult;
                throw new InvalidCredentialsException(exception.getMessage(), exception);
            }
            if (this.connectResult instanceof PeerConnectException) {
                PeerConnectException peerConnectException = (PeerConnectException)this.connectResult;
                throw peerConnectException;
            }
            if (this.connectResult instanceof Throwable) {
                throw new PeerConnectException("Problem connecting to peer " + this.who, (Throwable)this.connectResult);
            }
            throw new PeerConnectException("Unknown connect response " + this.connectResult.getClass() + ": " + this.connectResult);
        }
    }

    private class ForwardingRunner
    implements Runnable {
        long theirThreadID;
        Envelope envelope;

        ForwardingRunner(Envelope envelope, long l) {
            this.envelope = envelope;
            this.theirThreadID = l;
        }

        @Override
        public void run() {
            Object object = null;
            Thread thread = Thread.currentThread();
            thread.setName("Forwarding envelope " + this.envelope.getArbitraryID() + " from " + this.envelope.getSource() + " to " + this.envelope.getDestination());
            try {
                PeerProtocolRunner.this.parentPeer.forwardEnvelope(this.envelope);
                object = "ok";
            }
            catch (EnvelopeException envelopeException) {
                object = envelopeException;
            }
            catch (Throwable throwable) {
                object = new EnvelopeException("The peer " + PeerProtocolRunner.this.ourPeerID + " was unable to accept envelope " + this.envelope.getArbitraryID(), this.envelope, throwable);
                logger.debug((Object)"Error accepting envelope: ", (Throwable)((EnvelopeException)PeerProtocolRunner.this.response));
            }
            PeerProtocolRunner.this.sendResponse((Serializable)object, this.theirThreadID);
        }
    }

    class PeerSocketTester
    extends Thread {
        boolean isAlive;
        IPeer peer;

        PeerSocketTester(IPeer iPeer) {
            this.peer = iPeer;
        }

        boolean isSocketAlive() {
            return this.isAlive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Envelope envelope = new Envelope();
                envelope.setDestination(this.peer.getPeerID());
                envelope.setSource(PeerProtocolRunner.this.parentPeer.getRemotePeerID());
                PingCommand pingCommand = new PingCommand(0L);
                pingCommand.setSource(this.peer.getPeerID());
                envelope.setPayload(pingCommand);
                this.peer.sendEnvelopeAndWait(envelope, 0);
                this.isAlive = true;
                PeerSocketTester peerSocketTester = this;
                synchronized (peerSocketTester) {
                    this.notifyAll();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

