/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.service.Service;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.service.ServiceException;
import com.helpsystems.common.core.service.ServiceStarter;
import com.helpsystems.common.core.util.DurableQueue;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.TargetVersionInfo;
import com.helpsystems.common.core.util.ThreadSession;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.util.VersionedObjectOutputStream;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimpleConfig;
import com.helpsystems.common.tl.event.PeerConnectEvent;
import com.helpsystems.common.tl.event.PeerStartupCompletedEvent;
import com.helpsystems.common.tl.ex.EnvelopeException;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.common.tl.ex.SocketStartupException;
import com.helpsystems.common.tl.ex.UndeliverableEnvelopeException;
import com.helpsystems.common.tl.module.GenericJarModule;
import com.helpsystems.common.tl.module.Module;
import com.helpsystems.common.tl.module.ModuleDescriptor;
import com.helpsystems.common.tl.module.ModuleException;
import com.helpsystems.common.tl.module.ModuleInfo;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.impl.NoEnvelopeProcessorResponse;
import com.helpsystems.common.tl.processor.impl.ThrowableCommandResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.Document;

public abstract class HeavyweightPeer
extends Peer {
    private static final Logger logger = Logger.getLogger(HeavyweightPeer.class);
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(HeavyweightPeer.class);
    protected Vector<Module> moduleList;
    protected HeavyweightPeerConfig config;
    protected String configPath;
    protected Hashtable<String, Service> serviceTable;
    private HashMap<PeerID, DurableQueue> backlogTable;
    private Map<PeerID, TargetVersionInfo> versionCache;
    private List<DurableQueue> queuesBeingProcessed;
    protected EncryptUtil encryptUtil;
    private TargetVersionInfo versionInfo;

    public HeavyweightPeer(PeerDescriptor peerDescriptor, Serializable serializable, HeavyweightPeerConfig heavyweightPeerConfig) throws PeerStartupException {
        super(peerDescriptor, serializable);
        if (heavyweightPeerConfig == null) {
            throw new NullPointerException("The configuration passed in is null.");
        }
        this.backlogTable = new HashMap();
        this.versionCache = new HashMap<PeerID, TargetVersionInfo>();
        this.queuesBeingProcessed = new ArrayList<DurableQueue>();
        this.moduleList = new Vector();
        this.config = heavyweightPeerConfig;
        this.versionInfo = new TargetVersionInfo();
        CommonVersionedObject.staticFillInVersion((TargetVersionInfo)this.versionInfo);
        this.initLog4j();
        this.addListener(new SimpleEventListener(){

            public void serviceEvent(GenericEvent genericEvent) {
                if (genericEvent instanceof PeerConnectEvent) {
                    PeerID peerID = ((PeerConnectEvent)genericEvent).getPeerID();
                    HeavyweightPeer.this.processBacklog(peerID);
                }
            }
        });
    }

    protected void addModule(Module module) {
        this.moduleList.add(module);
    }

    public void addService(ServiceDescriptor serviceDescriptor) {
        this.config.addServiceDescriptor(serviceDescriptor);
    }

    @Override
    protected Processable deserializeEnvelope(Envelope envelope) throws ClassNotFoundException, IOException {
        byte[] byArray = envelope.getPayloadBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        MyObjectInputStream myObjectInputStream = new MyObjectInputStream(byteArrayInputStream);
        Processable processable = (Processable)myObjectInputStream.readObject();
        envelope.setDeserializedPayload(processable);
        myObjectInputStream.close();
        return processable;
    }

    protected String findModuleJar(String string) {
        if (string == null) {
            throw new NullPointerException("The module name passed in was null.");
        }
        final String string2 = string.toLowerCase() + "-module";
        try {
            File[] fileArray;
            File file = new File(".");
            String string3 = System.getProperty("helpsystems.module.dir");
            if (string3 != null && string3.length() > 0) {
                file = new File(file.getAbsolutePath() + File.separator + string3);
            }
            if ((fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.startsWith(string2) && string.endsWith(".jar");
                }
            })) == null || fileArray.length == 0) {
                return null;
            }
            if (fileArray.length == 1) {
                return fileArray[0].getAbsolutePath();
            }
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    String string = file.getName();
                    String string2 = file2.getName();
                    return string.compareTo(string2);
                }
            });
            File file2 = fileArray[fileArray.length - 1];
            return file2.getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Module findModuleUsingDescriptor(ModuleDescriptor moduleDescriptor) {
        Module[] moduleArray = this.listModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            if (moduleArray[i].getDescriptor() != moduleDescriptor) continue;
            Module module = moduleArray[i];
            moduleArray[i] = null;
            return module;
        }
        return null;
    }

    protected void firePeerStartupEvent() {
        PeerStartupCompletedEvent peerStartupCompletedEvent = new PeerStartupCompletedEvent();
        this.addEvent(peerStartupCompletedEvent);
    }

    public HeavyweightPeerConfig getConfig() {
        return this.config;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public Service getService(String string) {
        return this.serviceTable.get(string);
    }

    public TargetVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @Override
    protected String getHtmlSection(String string) {
        if ("modules".equals(string)) {
            return this.getModuleHTML();
        }
        if ("services".equals(string)) {
            return this.getServicesHTML();
        }
        if ("config".equals(string)) {
            return this.getConfigHTML();
        }
        return super.getHtmlSection(string);
    }

    private String getModuleHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Loaded modules:</h2>\n");
        Module[] moduleArray = this.listModules();
        if (moduleArray.length == 0) {
            stringBuffer.append("None.");
        } else {
            stringBuffer.append("<table border=\"1\" bordercolor=\"gray\" cellspacing=\"0\"><tr>\n");
            stringBuffer.append("<td><b>Product</b></td>\n");
            stringBuffer.append("<td><b>Library</b></td>\n");
            stringBuffer.append("<td><b>Version</b></td>\n");
            stringBuffer.append("<td><b>Build</b></td>\n");
            stringBuffer.append("<td><b>File</b></td></tr>\n");
            for (int i = 0; i < moduleArray.length; ++i) {
                Object object;
                Module module = moduleArray[i];
                moduleArray[i] = null;
                ModuleDescriptor moduleDescriptor = module.getDescriptor();
                ModuleInfo moduleInfo = null;
                if (module instanceof GenericJarModule) {
                    object = (GenericJarModule)module;
                    moduleInfo = ((GenericJarModule)object).getInfo();
                } else {
                    moduleInfo = new ModuleInfo(moduleDescriptor.getProductName(), new File("NA"), moduleDescriptor.getSpecificVersion());
                }
                stringBuffer.append("<tr><td>\n");
                stringBuffer.append(moduleDescriptor.getProductName());
                stringBuffer.append("</td><td>\n");
                stringBuffer.append(this.nullToBlank(moduleDescriptor.getLibraryName()));
                stringBuffer.append("</td><td>\n");
                stringBuffer.append(moduleInfo.getVersion());
                stringBuffer.append("</td><td>\n");
                stringBuffer.append(moduleInfo.getBuildDate() + " @ " + moduleInfo.getBuildTime());
                stringBuffer.append("</td><td>\n");
                object = moduleInfo.getFile();
                String string = "unknown";
                if (object != null) {
                    string = ((File)object).getName();
                }
                stringBuffer.append(string);
                stringBuffer.append("</td></tr>\n");
            }
            stringBuffer.append("</table>");
        }
        return stringBuffer.toString();
    }

    private String getServicesHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Services:</h2>");
        ServiceDescriptor[] serviceDescriptorArray = this.listServices();
        if (serviceDescriptorArray.length == 0) {
            stringBuffer.append("None.");
        }
        for (int i = 0; i < serviceDescriptorArray.length; ++i) {
            ServiceDescriptor serviceDescriptor = serviceDescriptorArray[i];
            String string = serviceDescriptor.getName();
            Service service = this.getService(string);
            String string2 = "Unable to use";
            if (service != null) {
                string2 = Service.getStatusString((int)service.getStatus());
                string2 = string2 + " : " + service.toString();
            }
            stringBuffer.append(string + ": " + string2 + "<br>");
        }
        return stringBuffer.toString();
    }

    protected String getConfigHTML() {
        String string = null;
        try {
            string = XMLUtil.documentToString((Document)XMLReflector.writeObject((XMLSerializable)this.config));
            string = string.replaceAll("<", "&lt;").replaceAll(">", "&gt;<br>");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            return "Not available.";
        }
        return "<h2>Configuration:</h2>\n<pre>" + string + "</pre>";
    }

    public boolean isServiceRunning(String string) {
        if (string == null) {
            throw new NullPointerException("The service name passed in is null.");
        }
        ServiceDescriptor[] serviceDescriptorArray = this.listServices();
        if (serviceDescriptorArray == null || serviceDescriptorArray.length == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < serviceDescriptorArray.length; ++i) {
            Service service;
            String string2 = serviceDescriptorArray[i].getName();
            if (string2 == null || (service = this.getService(string2)) == null) continue;
            if (string.equals(string2)) {
                return service.getStatus() == 1;
            }
            if (!string.equalsIgnoreCase(string2)) continue;
            bl = true;
        }
        if (bl) {
            logger.debug((Object)("Could not find a service called " + string + " however, there is a Service with the same " + "name but the cases mismatch."));
        }
        return false;
    }

    protected void initLog4j() {
        Properties properties = this.config.getLog4jProperties();
        if (properties == null || properties.size() == 0) {
            return;
        }
        Logger.getRootLogger().removeAllAppenders();
        PropertyConfigurator.configure((Properties)properties);
        logger.info((Object)rbh.getText("loggingConfigured"));
    }

    public void jarFileUpdated(String string) throws IOException, ModuleException {
        GenericJarModule genericJarModule = new GenericJarModule(string);
        String string2 = genericJarModule.getName();
        ModuleDescriptor[] moduleDescriptorArray = this.getConfig().getModuleDescriptorsForProduct(string2);
        for (int i = 0; i < moduleDescriptorArray.length; ++i) {
            String string3 = moduleDescriptorArray[i].getSpecificVersion();
            if (string3 != null && string3.length() != 0) continue;
            if (genericJarModule == null) {
                genericJarModule = new GenericJarModule(string);
            }
            this.useModule(genericJarModule, moduleDescriptorArray[i]);
            genericJarModule = null;
        }
    }

    public Module[] listModules() {
        Module[] moduleArray = new Module[this.moduleList.size()];
        this.moduleList.toArray(moduleArray);
        return moduleArray;
    }

    public ServiceDescriptor[] listServices() {
        return this.config.getServiceDescriptors();
    }

    protected void loadAllDefinedModules() throws PeerStartupException {
        ModuleDescriptor[] moduleDescriptorArray;
        ModuleDescriptor[] moduleDescriptorArray2 = this.getConfig().getModuleDescriptorsForProduct("transport");
        if (moduleDescriptorArray2.length == 0) {
            moduleDescriptorArray = new ModuleDescriptor();
            moduleDescriptorArray.setProductName("transport");
            this.config.addModuleDescriptor((ModuleDescriptor)moduleDescriptorArray);
        }
        moduleDescriptorArray = this.getConfig().getModuleDescriptors();
        for (int i = 0; i < moduleDescriptorArray.length; ++i) {
            ModuleDescriptor moduleDescriptor = moduleDescriptorArray[i];
            try {
                this.loadAndUse(moduleDescriptor);
                continue;
            }
            catch (Exception exception) {
                logger.warn((Object)rbh.getMsg("badModule", (Object)moduleDescriptor.getProductName(), (Object)moduleDescriptor.getLibraryName()), (Throwable)exception);
            }
        }
        Module[] moduleArray = this.listModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            String string = moduleArray[i].getName();
            moduleArray[i] = null;
            if (!"transport".equalsIgnoreCase(string)) continue;
            return;
        }
        String string = rbh.getText("noTLModule");
        logger.fatal((Object)string);
        throw new PeerStartupException(string);
    }

    private void loadBacklogQueues() {
        if (this.config instanceof SimpleConfig) {
            return;
        }
        String string = this.config.getBacklogDirectory();
        if (string == null) {
            logger.debug((Object)"Warning: The configuration file is missing the Backlog Queue Directory.");
            logger.debug((Object)"Backlog events will not be processed.");
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            boolean bl = file.mkdir();
            if (!bl) {
                logger.debug((Object)("Unable to create backlog-queue directory " + file.getAbsolutePath()));
            }
            return;
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".q");
            }
        });
        if (fileArray.length == 0) {
            logger.trace((Object)"No message backlog queues present.");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                DurableQueue durableQueue = new DurableQueue(fileArray[i].getAbsolutePath());
                Envelope envelope = (Envelope)((Object)durableQueue.peek());
                if (envelope == null) {
                    this.nukeQueue(durableQueue);
                    continue;
                }
                logger.trace((Object)("Found backlogged messages for peer " + envelope.getSource()));
                this.putDataQueue(envelope.getSource(), durableQueue);
                continue;
            }
            catch (IOException iOException) {
                logger.debug((Object)("Error reading data from backlog queue " + fileArray[i].getAbsolutePath() + "\nThe queued up messages will be lost."));
            }
        }
        Thread thread = new Thread(new WandererThread());
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDataQueue(PeerID peerID, DurableQueue durableQueue) {
        HashMap<PeerID, DurableQueue> hashMap = this.backlogTable;
        synchronized (hashMap) {
            this.backlogTable.put(peerID, durableQueue);
        }
    }

    protected void loadAndUse(ModuleDescriptor moduleDescriptor) throws IOException, ModuleException {
        File file;
        String string = null;
        String string2 = moduleDescriptor.getProductName();
        String string3 = moduleDescriptor.getSpecificVersion();
        if (string3 == null || string3.length() == 0) {
            string = this.findModuleJar(string2);
            if (string == null) {
                throw new FileNotFoundException(rbh.getMsg("moduleFileMissing", (Object)string2));
            }
        } else {
            string = string2 + "-module" + string3 + ".jar";
        }
        if (!(file = new File(string)).exists() || file.isDirectory() || !file.canRead()) {
            throw new FileNotFoundException(rbh.getMsg("fileNotFound", (Object)string2, (Object)file.getAbsolutePath()));
        }
        GenericJarModule genericJarModule = new GenericJarModule(string);
        this.useModule(genericJarModule, moduleDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nukeQueue(DurableQueue durableQueue) {
        HashMap<PeerID, DurableQueue> hashMap = this.backlogTable;
        synchronized (hashMap) {
            DurableQueue durableQueue2 = durableQueue;
            synchronized (durableQueue2) {
                try {
                    durableQueue.clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    durableQueue.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                File file = new File(durableQueue.getFilename());
                boolean bl = file.delete();
                if (!bl) {
                    logger.debug((Object)("Unable to delete backlog queue file " + file.getAbsolutePath()));
                }
                Iterator<DurableQueue> iterator = this.backlogTable.values().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != durableQueue) continue;
                    iterator.remove();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBacklog(PeerID peerID) {
        DurableQueue durableQueue = null;
        HashMap<PeerID, DurableQueue> hashMap = this.backlogTable;
        synchronized (hashMap) {
            durableQueue = this.backlogTable.get(peerID);
            if (durableQueue == null || durableQueue.isEmpty()) {
                return;
            }
            List<DurableQueue> list = this.queuesBeingProcessed;
            synchronized (list) {
                if (!this.queuesBeingProcessed.contains(durableQueue)) {
                    this.queuesBeingProcessed.add(durableQueue);
                    Thread thread = new Thread(new BacklogProcessorThread(durableQueue));
                    thread.setDaemon(true);
                    thread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEnvelope(Envelope envelope) {
        Object object;
        Processable processable = null;
        try {
            processable = envelope.getPayloadState() == 16 ? this.deserializeEnvelope(envelope) : envelope.getPayload();
        }
        catch (Throwable throwable) {
            logger.trace((Object)rbh.getMsg("szFailed", (Object)envelope.getPayloadClassname()), throwable);
            this.sendExceptionResponse(envelope, throwable);
            return;
        }
        Module[] moduleArray = this.listModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            object = moduleArray[i];
            moduleArray[i] = null;
            if (!object.canHandle(envelope, processable)) continue;
            try {
                ThreadSession.getOrCreateSession().setLocale(envelope.getSenderLocale());
                object.processEnvelope(envelope, processable);
            }
            catch (Throwable throwable) {
                logger.debug((Object)("Module " + object + " couldn't handle an envelope containing " + envelope.getPayloadClassname()), throwable);
                this.sendExceptionResponse(envelope, throwable);
            }
            finally {
                ThreadSession.endSession();
            }
            return;
        }
        logger.debug((Object)("There is no module present that can handle a " + envelope.getPayloadClassname()));
        NoEnvelopeProcessorResponse noEnvelopeProcessorResponse = new NoEnvelopeProcessorResponse(rbh.getMsg("noModuleForPayload", (Object)envelope.getPayloadClassname()));
        noEnvelopeProcessorResponse.setSource(this.getRemotePeerID());
        object = new Envelope();
        ((Envelope)((Object)object)).setDestination(envelope.getSource());
        ((Envelope)((Object)object)).setResponseToEnvelopeID(envelope.getArbitraryID());
        try {
            ((Envelope)((Object)object)).setPayload(noEnvelopeProcessorResponse);
            this.sendEnvelope((Envelope)((Object)object));
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to send an exception response to " + envelope.getSource()), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeModule(ModuleDescriptor moduleDescriptor) {
        Vector<Module> vector = this.moduleList;
        synchronized (vector) {
            Iterator<Module> iterator = this.moduleList.iterator();
            while (iterator.hasNext()) {
                Module module = iterator.next();
                if (moduleDescriptor != module.getDescriptor()) continue;
                iterator.remove();
                try {
                    module.shutdown();
                    return true;
                }
                catch (ModuleException moduleException) {
                    logger.debug((Object)("Module " + module.getName() + " threw exception in shutdown."), (Throwable)moduleException);
                }
            }
        }
        return false;
    }

    public void removeService(String string) {
        this.config.removeService(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws IOException {
        if (this.configPath == null) {
            throw new NullPointerException("The configuration path is null.");
        }
        HeavyweightPeerConfig heavyweightPeerConfig = this.config;
        synchronized (heavyweightPeerConfig) {
            try {
                XMLUtil.writeXML((Document)XMLReflector.writeObject((XMLSerializable)this.config), (String)this.configPath);
            }
            catch (TransformerException transformerException) {
                IOException iOException = new IOException("Unable to convert the configuration into XML");
                iOException.initCause(transformerException);
                throw iOException;
            }
        }
    }

    public void setConfigPath(String string) {
        this.configPath = string;
    }

    public void startup() throws PeerStartupException {
        this.loadBacklogQueues();
        try {
            this.startServices();
        }
        catch (ServiceException serviceException) {
            throw new PeerStartupException("One of the required services failed to load.", serviceException);
        }
        this.loadAllDefinedModules();
    }

    @Override
    public void shutdown() {
        Module[] moduleArray = this.listModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            ModuleDescriptor moduleDescriptor = moduleArray[i].getDescriptor();
            moduleArray[i] = null;
            this.removeModule(moduleDescriptor);
        }
        ServiceDescriptor[] serviceDescriptorArray = this.listServices();
        for (int i = 0; i < serviceDescriptorArray.length; ++i) {
            String string = serviceDescriptorArray[i].getName();
            try {
                this.stopService(string);
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug((Object)("Error shutting down Service " + string), (Throwable)serviceException);
            }
        }
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndGuaranteeDelivery(Envelope envelope) throws EnvelopeException {
        if (envelope == null) {
            throw new NullPointerException("The envelope passed in is null.");
        }
        PeerID peerID = envelope.getDestination();
        if (peerID == null) {
            throw new NullPointerException("The envelope doesn't have a destination - it's null.");
        }
        DurableQueue durableQueue = null;
        HashMap<PeerID, DurableQueue> hashMap = this.backlogTable;
        synchronized (hashMap) {
            durableQueue = this.backlogTable.get(peerID);
            if (durableQueue != null && !durableQueue.isEmpty()) {
                try {
                    durableQueue.push((Serializable)((Object)envelope));
                }
                catch (IOException iOException) {
                    throw new UndeliverableEnvelopeException("Unable to enqueue an envelope onto a durable queue.", envelope, iOException);
                }
                return;
            }
        }
        try {
            this.sendEnvelope(envelope);
        }
        catch (EnvelopeException envelopeException) {
            HashMap<PeerID, DurableQueue> hashMap2 = this.backlogTable;
            synchronized (hashMap2) {
                durableQueue = this.backlogTable.get(peerID);
                if (durableQueue != null) {
                    try {
                        durableQueue.push((Serializable)((Object)envelope));
                    }
                    catch (IOException iOException) {
                        throw new UndeliverableEnvelopeException("Unable to enqueue an envelope onto a durable queue.", envelope, iOException);
                    }
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.config.getBacklogDirectory());
                stringBuffer.append('/');
                stringBuffer.append(peerID.toString().replace(' ', '_').replace(':', '_'));
                stringBuffer.append('_');
                stringBuffer.append(System.currentTimeMillis());
                stringBuffer.append(".q");
                String string = stringBuffer.toString();
                try {
                    durableQueue = new DurableQueue(string);
                    durableQueue.push((Serializable)((Object)envelope));
                    this.backlogTable.put(peerID, durableQueue);
                }
                catch (IOException iOException) {
                    throw new UndeliverableEnvelopeException("Unable to create a durable queue using filename " + string, envelope, iOException);
                }
            }
        }
    }

    @Override
    public void sendEnvelope(Envelope envelope) throws EnvelopeException {
        ValidationHelper.checkForNull((String)"Envelope", (Object)((Object)envelope));
        PeerID peerID = envelope.getDestination();
        ValidationHelper.checkForNull((String)"Destination address", (Object)peerID);
        if ((envelope.getPayloadState() & 0x10) == 0) {
            try {
                this.serializeEnvelopePayload(envelope);
            }
            catch (IOException iOException) {
                ThrowableCommandResponse throwableCommandResponse = new ThrowableCommandResponse(iOException);
                envelope.setPayload(throwableCommandResponse);
                try {
                    this.serializeEnvelopePayload(envelope);
                    this.sendEnvelope(envelope);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw new UndeliverableEnvelopeException("Unable to serialize the envelope's payload", envelope, iOException);
            }
        }
        super.sendEnvelope(envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeEnvelopePayload(Envelope envelope) throws IOException {
        Processable processable = envelope.deserializedPayload;
        if (processable == null) {
            return;
        }
        PeerID peerID = envelope.getDestination();
        TargetVersionInfo targetVersionInfo = null;
        Object object = this.versionCache;
        synchronized (object) {
            targetVersionInfo = this.versionCache.get(peerID);
        }
        object = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        objectOutputStream = targetVersionInfo != null ? new VersionedObjectOutputStream((OutputStream)object, targetVersionInfo) : new ObjectOutputStream((OutputStream)object);
        objectOutputStream.writeObject(processable);
        objectOutputStream.close();
        ((ByteArrayOutputStream)object).close();
        envelope.setPayloadBytes(((ByteArrayOutputStream)object).toByteArray(), processable.getClass().getName());
    }

    public Service startService(String string) throws ServiceException {
        Service service;
        logger.debug((Object)("Starting service: " + string));
        ServiceDescriptor serviceDescriptor = this.config.getServiceDescriptor(string);
        String string2 = serviceDescriptor.getStarterClassname();
        ServiceStarter serviceStarter = null;
        try {
            service = Class.forName(string2);
            serviceStarter = (ServiceStarter)service.newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Unable to load the ServiceStarter " + string2, (Throwable)exception);
        }
        serviceStarter.useEncryption(this.encryptUtil);
        service = serviceStarter.startService(serviceDescriptor);
        this.serviceTable.put(serviceDescriptor.getName(), service);
        return service;
    }

    protected void startServices() throws ServiceException {
        this.serviceTable = new Hashtable();
        ServiceDescriptor[] serviceDescriptorArray = this.config.getServiceDescriptors();
        for (int i = 0; i < serviceDescriptorArray.length; ++i) {
            if (!serviceDescriptorArray[i].getAutoStartup()) continue;
            this.startService(serviceDescriptorArray[i].getName());
        }
    }

    public void stopService(String string) throws ServiceException {
        if (string == null) {
            logger.debug((Object)"Unable to stop service.  Service name is null.");
            return;
        }
        Service service = this.getService(string);
        if (service == null) {
            logger.debug((Object)("Service named " + string + " was not started."));
            return;
        }
        ServiceDescriptor serviceDescriptor = this.config.getServiceDescriptor(string);
        String string2 = serviceDescriptor.getStarterClassname();
        ServiceStarter serviceStarter = null;
        try {
            Class<?> clazz = Class.forName(string2);
            serviceStarter = (ServiceStarter)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Unable to load the ServiceStarter " + string2, (Throwable)exception);
        }
        serviceStarter.stopService(service);
        this.serviceTable.remove(serviceDescriptor.getName());
    }

    @Override
    public void switchListenPort(int n) throws SocketStartupException {
        if (this.config != null && this.config.getListenPort() == n) {
            return;
        }
        super.switchListenPort(n);
        if (this.config == null) {
            return;
        }
        this.config.setListenPort(n);
        try {
            this.saveConfig();
        }
        catch (IOException iOException) {
            logger.warn((Object)"Unable to update the config file with the new listen port number.", (Throwable)iOException);
        }
    }

    public void useEncryption(EncryptUtil encryptUtil) {
        this.encryptUtil = encryptUtil;
    }

    protected void useModule(Module module, ModuleDescriptor moduleDescriptor) throws ModuleException {
        this.removeModule(moduleDescriptor);
        try {
            module.startup(this, moduleDescriptor);
        }
        catch (ModuleException moduleException) {
            throw moduleException;
        }
        catch (Throwable throwable) {
            throw new ModuleException(rbh.getMsg("moduleStartupFailed", (Object)module.getName()), throwable);
        }
        this.addModule(module);
    }

    class BacklogProcessorThread
    implements Runnable {
        private DurableQueue queue;

        BacklogProcessorThread(DurableQueue durableQueue) {
            this.queue = durableQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            try {
                object = Thread.currentThread();
                ((Thread)object).setName("BacklogProcessorThread");
                ((Thread)object).setPriority(3);
                int n = 0;
                PeerID peerID = null;
                while (!this.queue.isEmpty()) {
                    Envelope envelope;
                    block19: {
                        envelope = null;
                        try {
                            envelope = (Envelope)((Object)this.queue.peek());
                            n = 0;
                            if (peerID != null) break block19;
                            peerID = envelope.getDestination();
                            ((Thread)object).setName("BacklogProcessorThread for " + peerID);
                        }
                        catch (IOException iOException) {
                            if (++n <= 10) break block19;
                            logger.debug((Object)("The queue '" + this.queue.getFilename() + "' contains errors." + "\nThe queued up messages will be lost."), (Throwable)iOException);
                            HeavyweightPeer.this.nukeQueue(this.queue);
                            return;
                        }
                    }
                    try {
                        HeavyweightPeer.this.sendEnvelope(envelope);
                        this.queue.pop();
                    }
                    catch (EnvelopeException envelopeException) {
                        List list = HeavyweightPeer.this.queuesBeingProcessed;
                        synchronized (list) {
                            HeavyweightPeer.this.queuesBeingProcessed.remove(this.queue);
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            logger.debug((Object)"An envelope was successfully 'peeked' from the backlog queue, but couldn't be 'popped'.", (Throwable)iOException);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                object = HeavyweightPeer.this.queuesBeingProcessed;
                synchronized (object) {
                    HeavyweightPeer.this.queuesBeingProcessed.remove(this.queue);
                }
            }
        }
    }

    class WandererThread
    implements Runnable {
        WandererThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            thread.setName("WandererThread");
            thread.setPriority(3);
            block7: while (true) {
                try {
                    while (true) {
                        Iterator iterator = null;
                        Cloneable cloneable = HeavyweightPeer.this.backlogTable;
                        synchronized (cloneable) {
                            iterator = HeavyweightPeer.this.backlogTable.keySet().iterator();
                        }
                        while (iterator.hasNext()) {
                            cloneable = (PeerID)iterator.next();
                            HeavyweightPeer.this.processBacklog((PeerID)cloneable);
                        }
                        try {
                            Thread.sleep(60000L);
                            continue block7;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    logger.warn((Object)"Wanderer Thread ended in error.", throwable);
                    return;
                }
            }
        }
    }

    class MyObjectInputStream
    extends ObjectInputStream {
        public MyObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = super.resolveClass(objectStreamClass);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Module[] moduleArray = HeavyweightPeer.this.listModules();
                for (int i = 0; i < moduleArray.length; ++i) {
                    try {
                        clazz = moduleArray[i].loadClass(objectStreamClass.getName());
                        if (clazz == null) continue;
                        moduleArray[i] = null;
                        return clazz;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new ClassNotFoundException("None of the loaded modules contains class " + objectStreamClass.getName());
            }
        }
    }
}

