/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.enterprise.module.windows.Advapi32;
import com.helpsystems.enterprise.module.windows.HandleInputStream;
import com.helpsystems.enterprise.module.windows.HandleOutputStream;
import com.helpsystems.enterprise.module.windows.Kernel32Ext;
import com.helpsystems.enterprise.module.windows.ProcessCreationException;
import com.helpsystems.enterprise.module.windows.ProcessInformation;
import com.helpsystems.enterprise.module.windows.SID_IDENTIFIER_AUTHORITY;
import com.helpsystems.enterprise.module.windows.SecurityAttributes;
import com.helpsystems.enterprise.module.windows.StartupInfo;
import com.helpsystems.enterprise.module.windows.User32Ext;
import com.helpsystems.enterprise.module.windows.Userenv;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;

public class WindowsNativeProcess
extends Process {
    public static final String DFT_STATION = "hsAgentz01";
    public static final String DFT_DESKTOP = "agentProcesses";
    private String username;
    private String domainname;
    private String command;
    private String workingDir;
    private String envString;
    private WString w_username;
    private WString w_domainname;
    private WString w_password;
    private WinNT.HANDLEByReference pToken = null;
    private WinNT.HANDLE g_hChildStd_IN_Rd;
    private WinNT.HANDLE g_hChildStd_IN_Wr;
    private WinNT.HANDLE g_hChildStd_OUT_Rd;
    private WinNT.HANDLE g_hChildStd_OUT_Wr;
    private ProcessInformation proceInfo;
    private HandleInputStream standardOut;
    private HandleOutputStream standardIn;

    public WindowsNativeProcess(String string, String string2, String string3, String string4, String string5, Properties properties) throws ProcessCreationException {
        this.username = string;
        if (string != null && string.length() > 0) {
            this.w_username = new WString(string);
        }
        if (string3 != null) {
            this.w_password = new WString(string3);
        }
        this.domainname = string2;
        if (string2 != null) {
            this.w_domainname = new WString(string2);
        }
        this.workingDir = string5;
        this.command = string4;
        this.buildEnv(properties);
        this.startProcess();
    }

    public int getProcessID() {
        if (this.proceInfo == null) {
            return -1;
        }
        return this.proceInfo.dwProcessId;
    }

    @Override
    public void destroy() {
        if (this.standardOut != null) {
            this.standardOut.close();
        }
        if (this.standardIn != null) {
            this.standardIn.close();
        }
        if (this.pToken != null) {
            Kernel32Ext.INSTANCE.CloseHandle(this.pToken.getValue());
        }
    }

    @Override
    public boolean isAlive() {
        int n = this.fetchExitCode();
        return n == 259;
    }

    @Override
    public int exitValue() {
        int n = this.fetchExitCode();
        if (n == 259) {
            throw new IllegalThreadStateException();
        }
        return n;
    }

    private int fetchExitCode() {
        if (this.proceInfo == null) {
            return -1;
        }
        IntByReference intByReference = new IntByReference();
        if (Kernel32Ext.INSTANCE.GetExitCodeProcess(this.proceInfo.hProcess, intByReference)) {
            return intByReference.getValue();
        }
        throw new RuntimeException(this.getLastExitMessage("Unable to retrieve process's exit value."));
    }

    @Override
    public InputStream getErrorStream() {
        return this.getInputStream();
    }

    @Override
    public InputStream getInputStream() {
        if (this.standardOut == null) {
            this.standardOut = new HandleInputStream(this.g_hChildStd_OUT_Rd, this.g_hChildStd_OUT_Wr);
        }
        return this.standardOut;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.standardIn == null) {
            this.standardIn = new HandleOutputStream(this.g_hChildStd_IN_Wr, this.g_hChildStd_IN_Rd);
        }
        return this.standardIn;
    }

    @Override
    public int waitFor() throws InterruptedException {
        while (true) {
            int n = 259;
            try {
                n = this.fetchExitCode();
                if (n != 259) {
                    return n;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                n = 259;
            }
            Thread.sleep(250L);
        }
    }

    private void buildEnv(Properties properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                string2 = "";
            }
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
            stringBuilder.append('\u0000');
        }
        this.envString = stringBuilder.toString();
    }

    private void createPipes() throws ProcessCreationException {
        WinNT.HANDLEByReference hANDLEByReference;
        WinNT.HANDLEByReference hANDLEByReference2;
        SecurityAttributes securityAttributes = new SecurityAttributes();
        securityAttributes.bInheritHandle = true;
        Advapi32.SECURITY_DESCRIPTOR sECURITY_DESCRIPTOR = this.getSECURITY_DESCRIPTOR();
        securityAttributes.lpSecurityDescriptor = sECURITY_DESCRIPTOR == null ? Pointer.NULL : sECURITY_DESCRIPTOR.getPointer();
        securityAttributes.write();
        WinNT.HANDLEByReference hANDLEByReference3 = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference hANDLEByReference4 = new WinNT.HANDLEByReference();
        if (!Kernel32Ext.INSTANCE.CreatePipe(hANDLEByReference3, hANDLEByReference4, securityAttributes.getPointer(), 0)) {
            this.ErrorExit("Unable to setup Standard In");
        }
        this.g_hChildStd_IN_Rd = hANDLEByReference3.getValue();
        this.g_hChildStd_IN_Wr = hANDLEByReference4.getValue();
        if (!Kernel32Ext.INSTANCE.SetHandleInformation(this.g_hChildStd_IN_Wr, 1, 0)) {
            this.ErrorExit("Unable to configure Standard In");
        }
        if (!Kernel32Ext.INSTANCE.CreatePipe(hANDLEByReference2 = new WinNT.HANDLEByReference(), hANDLEByReference = new WinNT.HANDLEByReference(), securityAttributes.getPointer(), 0)) {
            this.ErrorExit("Unable to setup Standard Out");
        }
        this.g_hChildStd_OUT_Rd = hANDLEByReference2.getValue();
        this.g_hChildStd_OUT_Wr = hANDLEByReference.getValue();
        if (!Kernel32Ext.INSTANCE.SetHandleInformation(this.g_hChildStd_OUT_Rd, 1, 0)) {
            this.ErrorExit("Unable to configure Standard Out");
        }
    }

    private void startProcess() throws ProcessCreationException {
        SecurityAttributes securityAttributes = new SecurityAttributes();
        securityAttributes.bInheritHandle = true;
        Advapi32.SECURITY_DESCRIPTOR sECURITY_DESCRIPTOR = this.getSECURITY_DESCRIPTOR();
        securityAttributes.lpSecurityDescriptor = sECURITY_DESCRIPTOR == null ? Pointer.NULL : sECURITY_DESCRIPTOR.getPointer();
        securityAttributes.write();
        WString wString = null;
        if (this.envString != null) {
            wString = new WString(this.envString);
        }
        StartupInfo startupInfo = new StartupInfo();
        startupInfo.lpTitle = null;
        startupInfo.dwFlags = 256;
        startupInfo.lpDesktop = new WString("hsAgentz01\\agentProcesses");
        this.proceInfo = new ProcessInformation();
        boolean bl = false;
        String string = null;
        if (this.username != null && this.username.length() > 0) {
            PointerByReference pointerByReference;
            WinNT.HANDLE hANDLE;
            WinNT.HANDLE hANDLE2;
            string = this.domainname == null || this.domainname.length() == 0 ? "local user " + this.username : this.domainname + "\\" + this.username;
            WinNT.HANDLE hANDLE3 = User32Ext.INSTANCE.GetProcessWindowStation();
            if (hANDLE3 == null) {
                this.ErrorExit("Could not set the new Windows Station.");
            }
            if ((hANDLE2 = User32Ext.INSTANCE.OpenWindowStation(new WString(DFT_STATION), false, 393216)) == null) {
                hANDLE2 = User32Ext.INSTANCE.CreateWindowStation(new WString(DFT_STATION), 0, 983935, securityAttributes.getPointer());
                if (hANDLE2 != null) {
                    this.AllowAccess(hANDLE2, "new Windows Station");
                } else {
                    this.ErrorExit("Could not initialize our WindowStation.");
                }
            } else {
                this.AllowAccess(hANDLE2, "existing Windows Station");
            }
            if (!User32Ext.INSTANCE.SetProcessWindowStation(hANDLE2)) {
                this.ErrorExit("Could not set the new Windows Station.");
            }
            if ((hANDLE = User32Ext.INSTANCE.OpenDesktop(new WString(DFT_DESKTOP), 0, true, 0x10000000)) == null) {
                hANDLE = User32Ext.INSTANCE.CreateDesktop(new WString(DFT_DESKTOP), Pointer.NULL, Pointer.NULL, 0, 0x10000000, securityAttributes.getPointer());
                if (hANDLE != null) {
                    this.AllowAccess(hANDLE, "Desktop");
                } else {
                    this.ErrorExit("Could not open the desktop.");
                }
            } else {
                this.AllowAccess(hANDLE, "Desktop");
            }
            if (!User32Ext.INSTANCE.SetProcessWindowStation(hANDLE3)) {
                this.ErrorExit("Could not set the original Windows Station back.");
            }
            this.pToken = new WinNT.HANDLEByReference();
            bl = Advapi32.INSTANCE.LogonUser(this.w_username, this.w_domainname, this.w_password, 2, 0, this.pToken);
            if (!bl) {
                this.ErrorExit("Unable to logon as user " + string);
            }
            User32Ext.PROFILEINFO pROFILEINFO = new User32Ext.PROFILEINFO();
            pROFILEINFO.lpUserName = new WString(string);
            pROFILEINFO.write();
            if (!Userenv.INSTANCE.LoadUserProfile(this.pToken.getValue(), pROFILEINFO)) {
                this.ErrorExit("Unable to load the user profile " + string);
            }
            pROFILEINFO.read();
            this.createPipes();
            startupInfo.hStdError = this.g_hChildStd_OUT_Wr;
            startupInfo.hStdOutput = this.g_hChildStd_OUT_Wr;
            startupInfo.hStdInput = this.g_hChildStd_IN_Rd;
            startupInfo.write();
            if (!Advapi32.INSTANCE.ImpersonateLoggedOnUser(this.pToken.getValue())) {
                this.ErrorExit("Could not impersonate the logged on user.");
            }
            if (!Userenv.INSTANCE.CreateEnvironmentBlock(pointerByReference = new PointerByReference(), this.pToken.getValue(), false)) {
                this.ErrorExit("Could not get the users Environment.");
            }
            bl = Advapi32.INSTANCE.CreateProcessAsUser(this.pToken.getValue(), null, this.command, null, null, true, 134219296, pointerByReference.getValue(), this.workingDir, startupInfo.getPointer(), this.proceInfo.getPointer());
            if (!Userenv.INSTANCE.DestroyEnvironmentBlock(pointerByReference.getValue())) {
                this.ErrorExit("Could not cleanup the users Environment.");
            }
        } else {
            this.createPipes();
            startupInfo.hStdError = this.g_hChildStd_OUT_Wr;
            startupInfo.hStdOutput = this.g_hChildStd_OUT_Wr;
            startupInfo.hStdInput = this.g_hChildStd_IN_Rd;
            startupInfo.write();
            string = System.getProperty("user.name");
            bl = Kernel32Ext.INSTANCE.CreateProcess(null, this.command, null, null, true, 1024, wString, this.workingDir, startupInfo.getPointer(), this.proceInfo.getPointer());
        }
        if (bl) {
            this.proceInfo.read();
        } else {
            this.ErrorExit("Unable to start the process " + this.command + " for " + string);
        }
    }

    private void ErrorExit(String string) throws ProcessCreationException {
        throw new ProcessCreationException(this.getLastExitMessage(string));
    }

    private String getLastExitMessage(String string) {
        int n = Kernel32.INSTANCE.GetLastError();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(", Error Code: ");
        stringBuffer.append(n);
        stringBuffer.append(" - ");
        stringBuffer.append(this.getFormattedMessage(n));
        return stringBuffer.toString();
    }

    private String getFormattedMessage(int n) {
        String[] stringArray = new String[1];
        String string = null;
        int n2 = Kernel32Ext.INSTANCE.FormatMessage(4352, Pointer.NULL, n, 0, stringArray, 80, Pointer.NULL);
        string = n2 == 0 ? " Format message failed - " + Kernel32.INSTANCE.GetLastError() : stringArray[0];
        if (stringArray[0] != null) {
            stringArray[0] = null;
        }
        return string;
    }

    private Advapi32.SECURITY_DESCRIPTOR getSECURITY_DESCRIPTOR() throws ProcessCreationException {
        Advapi32.SECURITY_DESCRIPTOR sECURITY_DESCRIPTOR = new Advapi32.SECURITY_DESCRIPTOR();
        sECURITY_DESCRIPTOR.Dacl = null;
        sECURITY_DESCRIPTOR.write();
        int n = 1;
        if (!Advapi32.INSTANCE.InitializeSecurityDescriptor(sECURITY_DESCRIPTOR.getPointer(), n)) {
            this.ErrorExit("Could not get a new security descriptor.");
        }
        sECURITY_DESCRIPTOR.read();
        if (!Advapi32.INSTANCE.SetSecurityDescriptorDacl(sECURITY_DESCRIPTOR, true, null, false)) {
            this.ErrorExit("Could not set the security descriptor.");
        }
        return sECURITY_DESCRIPTOR;
    }

    private void AllowAccess(WinNT.HANDLE hANDLE, String string) throws ProcessCreationException {
        int n;
        SID_IDENTIFIER_AUTHORITY sID_IDENTIFIER_AUTHORITY = SID_IDENTIFIER_AUTHORITY.getWorldUsers();
        Advapi32.SECURITY_DESCRIPTOR sECURITY_DESCRIPTOR = this.getSECURITY_DESCRIPTOR();
        PointerByReference pointerByReference = new PointerByReference();
        WinBase.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES = new WinBase.SECURITY_ATTRIBUTES();
        sECURITY_ATTRIBUTES.bInheritHandle = true;
        sECURITY_ATTRIBUTES.lpSecurityDescriptor = Pointer.NULL;
        sECURITY_ATTRIBUTES.dwLength = new WinDef.DWORD((long)sECURITY_ATTRIBUTES.size());
        int n2 = n = 7;
        if (!Advapi32.INSTANCE.AllocateAndInitializeSid(sID_IDENTIFIER_AUTHORITY.getPointer(), 1, sID_IDENTIFIER_AUTHORITY, 0, 0, 0, 0, 0, 0, 0, pointerByReference.getPointer())) {
            this.ErrorExit("Could not get an SID for group.");
        }
        if (!Advapi32.INSTANCE.SetSecurityDescriptorDacl(sECURITY_DESCRIPTOR, true, null, false)) {
            this.ErrorExit("Could not set the security DACL " + string);
        }
        sECURITY_ATTRIBUTES.lpSecurityDescriptor = sECURITY_DESCRIPTOR.getPointer();
        if (Advapi32.INSTANCE.SetSecurityInfo(hANDLE, n2, -1073741824, null, null, null, null) != 0) {
            this.ErrorExit("Could not set the user object security " + string);
        }
        if (sID_IDENTIFIER_AUTHORITY != null) {
            Advapi32.INSTANCE.FreeSid(pointerByReference.getValue());
        }
    }
}

