/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.module.windows.WMICProcessInfo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class WMIC_Reader {
    private static final Logger logger = Logger.getLogger(WMIC_Reader.class);
    private static final boolean VERBOSE = false;
    private static boolean IS_LOGGING_OFF = false;
    private static boolean NOT_NOTIFIED = true;
    private static final String TAB = "\t";
    private static final String WMIC_COMMAND = "wmic.exe";
    private static final String WMIC_PROCESS = "PROCESS get Processid,Commandline /FORMAT:textvaluelist.xsl";

    public static void main(String[] stringArray) {
        IS_LOGGING_OFF = true;
        int n = 2000;
        int n2 = 20;
        for (int i = 1; i <= n2; ++i) {
            WMIC_Reader.startTestThread("Thread#" + i, n);
        }
    }

    private static void startTestThread(final String string, final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    WMIC_Reader.runTestLoop(string, n);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private static void runTestLoop(String string, int n) throws ResourceUnavailableException {
        long l = System.currentTimeMillis();
        for (int i = 1; i <= n; ++i) {
            WMIC_Reader.runTest(string, i);
        }
        long l2 = System.currentTimeMillis();
        System.out.println("** " + string + " RunTime: " + (l2 - l));
    }

    private static void runTest(String string, int n) throws ResourceUnavailableException {
        WMICProcessInfo[] wMICProcessInfoArray = WMIC_Reader.getProcessList();
        String string2 = "";
        if (n > 0) {
            string2 = "(" + string + " Run: " + n + ") ";
        }
        if (wMICProcessInfoArray == null) {
            System.out.println("piList is null!");
        } else {
            System.out.println(string2 + wMICProcessInfoArray.length + " process entries were returned.");
            for (int i = 0; i < wMICProcessInfoArray.length; ++i) {
            }
        }
    }

    public static synchronized WMICProcessInfo[] getProcessList() throws ResourceUnavailableException {
        WMICProcessInfo[] wMICProcessInfoArray;
        int n;
        File file;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        block15: {
            WMICProcessInfo[] wMICProcessInfoArray2;
            PrintWriter printWriter;
            Process process;
            block14: {
                fileInputStream = null;
                inputStreamReader = null;
                bufferedReader = null;
                process = null;
                printWriter = null;
                wMICProcessInfoArray2 = null;
                file = null;
                file = File.createTempFile("SkybotAgent_", ".wmic");
                if (IS_LOGGING_OFF && NOT_NOTIFIED) {
                    NOT_NOTIFIED = false;
                    System.out.println("Creating temporary WMIC file: " + file.getAbsolutePath());
                }
                if (!file.exists() || file.delete()) break block14;
                if (IS_LOGGING_OFF) {
                    System.out.println("Unable to delete pre-existing temporary WMIC file: " + file.getAbsolutePath());
                }
                logger.error((Object)("Unable to delete pre-existing temporary WMIC file: " + file.getAbsolutePath()));
                WMICProcessInfo[] wMICProcessInfoArray3 = new WMICProcessInfo[]{};
                WMIC_Reader.close(bufferedReader);
                WMIC_Reader.close(inputStreamReader);
                WMIC_Reader.close(fileInputStream);
                if (file.exists() && !file.delete()) {
                    file.deleteOnExit();
                }
                return wMICProcessInfoArray3;
            }
            String[] stringArray = new String[]{WMIC_COMMAND};
            process = Runtime.getRuntime().exec(stringArray);
            String string = "/OUTPUT:\"" + file.getAbsolutePath() + "\" " + WMIC_PROCESS;
            logger.trace((Object)("WMIC Sub-Command: " + string));
            printWriter = new PrintWriter(process.getOutputStream());
            printWriter.println(string);
            printWriter.flush();
            printWriter.println("exit");
            printWriter.flush();
            printWriter.close();
            n = process.waitFor();
            if (n != 0 || !file.exists()) break block15;
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "utf-16");
            bufferedReader = new BufferedReader(inputStreamReader);
            WMICProcessInfo[] wMICProcessInfoArray4 = wMICProcessInfoArray2 = WMIC_Reader.processWMICInput(bufferedReader);
            WMIC_Reader.close(bufferedReader);
            WMIC_Reader.close(inputStreamReader);
            WMIC_Reader.close(fileInputStream);
            if (file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
            return wMICProcessInfoArray4;
        }
        try {
            if (IS_LOGGING_OFF) {
                System.out.println("The WMIC output file was not created. RC:" + n);
            }
            logger.info((Object)("The WMIC output file was not created. RC:" + n));
            wMICProcessInfoArray = new WMICProcessInfo[]{};
        }
        catch (Throwable throwable) {
            try {
                if (throwable instanceof ResourceUnavailableException) {
                    throw (ResourceUnavailableException)throwable;
                }
                throw new ResourceUnavailableException("Unable to generate a Windows process listing.", throwable);
            }
            catch (Throwable throwable2) {
                WMIC_Reader.close(bufferedReader);
                WMIC_Reader.close(inputStreamReader);
                WMIC_Reader.close(fileInputStream);
                if (file.exists() && !file.delete()) {
                    file.deleteOnExit();
                }
                throw throwable2;
            }
        }
        WMIC_Reader.close(bufferedReader);
        WMIC_Reader.close(inputStreamReader);
        WMIC_Reader.close(fileInputStream);
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
        return wMICProcessInfoArray;
    }

    private static WMICProcessInfo[] processWMICInput(BufferedReader bufferedReader) throws ResourceUnavailableException {
        try {
            String string = "";
            String string2 = "CommandLine=";
            String string3 = "ProcessId=";
            WMICProcessInfo wMICProcessInfo = null;
            TreeMap<Integer, WMICProcessInfo> treeMap = new TreeMap<Integer, WMICProcessInfo>();
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                if (string.startsWith(string2)) {
                    wMICProcessInfo = new WMICProcessInfo();
                    wMICProcessInfo.commandLine = string.substring(string2.length());
                    continue;
                }
                if (!string.startsWith(string3)) continue;
                wMICProcessInfo.pid = string.substring(string3.length());
                if (wMICProcessInfo.commandLine != null && WMIC_COMMAND.equals(wMICProcessInfo.commandLine.trim())) {
                    wMICProcessInfo = null;
                    continue;
                }
                treeMap.put(Integer.valueOf(wMICProcessInfo.pid), wMICProcessInfo);
                wMICProcessInfo = null;
            }
            WMICProcessInfo[] wMICProcessInfoArray = new WMICProcessInfo[]{};
            return treeMap.values().toArray(wMICProcessInfoArray);
        }
        catch (IOException iOException) {
            throw new ResourceUnavailableException("Unable to parse Windows Process entry", (Throwable)iOException);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

