/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.sap;

import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.enterprise.core.busobj.sap.SAPEvent;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutableJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSelectParameters;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSelection;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSimple;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobTimeType;
import com.helpsystems.enterprise.core.busobj.sap.SAPProfileTypeSelection;
import com.helpsystems.enterprise.core.busobj.sap.SAPRecipientStatusSetting;
import com.helpsystems.enterprise.core.busobj.sap.SAPReturnMessage;
import com.helpsystems.enterprise.core.busobj.sap.SAPSpecialConfirmJobSelection;
import com.helpsystems.enterprise.core.busobj.sap.SAPSpoolListRecipientType;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantAction;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantActionList;
import com.helpsystems.enterprise.core.busobj.sap.SAPXBPVersion;
import com.helpsystems.enterprise.module.sap.SAPConnection;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class SAPFunctionUtility {
    private static final Logger logger = Logger.getLogger(SAPFunctionUtility.class);
    private static final int RECIPIENT_COPY = 0;
    private static final int RECIPIENT_EXPRESS = 1;
    private static final int RECIPIENT_BLIND_COPY = 2;
    private static final int RECIPIENT_NO_FORWARDING = 3;
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public static JCoFunction getFunctionOutputDeviceSearch(SAPConnection sAPConnection, String string, String string2, String string3) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_OUTPUT_DEVICE_SEARCH");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_OUTPUT_DEVICE_SEARCH not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string3);
        jCoFunction.getImportParameterList().setValue("OUTPUT_DEVICE_SHORT", string);
        jCoFunction.getImportParameterList().setValue("OUTPUT_DEVICE_LONG", string2);
        if (sAPConnection.getXBPVersion().equals(SAPXBPVersion.XBP_30)) {
            jCoFunction.getImportParameterList().setValue("RETURN_LONG_NAMES", "X");
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionSpecialConfirmJob(SAPConnection sAPConnection, SAPSpecialConfirmJobSelection sAPSpecialConfirmJobSelection, HashMap<String, SAPInterceptedJob> hashMap) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_SPECIAL_CONFIRM_JOB");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_SPECIAL_CONFIRM_JOB not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        jCoFunction.getImportParameterList().setValue("CONFIRMATION", sAPSpecialConfirmJobSelection.parameter());
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBS");
        Collection<SAPInterceptedJob> collection = hashMap.values();
        for (SAPInterceptedJob sAPInterceptedJob : collection) {
            jCoTable.appendRow();
            jCoTable.setValue("JOBNAME", sAPInterceptedJob.getJobName());
            jCoTable.setValue("JOBCOUNT", sAPInterceptedJob.getJobCount());
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionSXMIVersionsGet(SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("SXMI_VERSIONS_GET");
        if (jCoFunction == null) {
            throw new RuntimeException("SXMI_VERSIONS_GET not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("INTERFACE", "XBP");
        return jCoFunction;
    }

    public static JCoFunction getFunctionXMILogon(SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XMI_LOGON");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XMI_LOGON not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTCOMPANY", "HelpSystems, LLC.");
        jCoFunction.getImportParameterList().setValue("EXTPRODUCT", "Automate Schedule");
        jCoFunction.getImportParameterList().setValue("INTERFACE", "XBP");
        jCoFunction.getImportParameterList().setValue("VERSION", sAPConnection.getXBPVersion().persistanceCode());
        return jCoFunction;
    }

    public static JCoFunction getFunctionXMILogoff(SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XMI_LOGOFF");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XMI_LOGOFF not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("INTERFACE", "XBP");
        return jCoFunction;
    }

    public static JCoFunction getFunctionXMISetAuditLevel(SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XMI_SET_AUDITLEVEL");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XMI_SET_AUDITLEVEL not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("AUDITLEVEL", (Object)sAPConnection.getXMIAuditLevel().persistanceCode());
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobOpen(SAPConnection sAPConnection, SAPExecutableJob sAPExecutableJob, String string) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_OPEN");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_OPEN not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPExecutableJob.getJobName());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
        jCoFunction.getImportParameterList().setValue("JOBCLASS", sAPExecutableJob.getSapJobClass().persistanceCode());
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobClose(SAPConnection sAPConnection, SAPExecutableJob sAPExecutableJob, String string) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_CLOSE");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_CLOSE not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPExecutableJob.getJobName());
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPExecutableJob.getJobCount());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
        jCoFunction.getImportParameterList().setValue("TARGET_SERVER", sAPExecutableJob.getSapExecTarget());
        if (sAPExecutableJob.hasSapSpoolListRecipient()) {
            JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("RECIPIENT");
            jCoStructure.setValue("RECIPIENT", sAPExecutableJob.getSapSpoolListRecipient());
            logger.debug((Object)("BAPI_XBP_JOB_CLOSE RECIPIENT parm RECIPIENT set to " + sAPExecutableJob.getSapSpoolListRecipient()));
            jCoStructure.setValue("REC_TYPE", sAPExecutableJob.getSapSpoolListRecipientType());
            logger.debug((Object)("BAPI_XBP_JOB_CLOSE RECIPIENT parm REC_TYPE set to " + sAPExecutableJob.getSapSpoolListRecipientType()));
            if (sAPExecutableJob.getSapSpoolListRecipientType().equals(SAPSpoolListRecipientType.EXTERNAL_ADDRESS) && !sAPExecutableJob.getDeliverStatusSetting().equals(SAPRecipientStatusSetting.DEFAULT)) {
                jCoStructure.setValue("DELIVER", sAPExecutableJob.getDeliverStatusSetting());
                logger.debug((Object)("BAPI_XBP_JOB_CLOSE RECIPIENT parm DELIVER set to " + sAPExecutableJob.getDeliverStatusSetting()));
            }
            String string2 = sAPExecutableJob.getSapRecipientAttributes();
            String[] stringArray = string2.split(":");
            String string3 = SAPFunctionUtility.getSAPRecipientSetting(stringArray[0]);
            String string4 = SAPFunctionUtility.getSAPRecipientSetting(stringArray[1]);
            String string5 = SAPFunctionUtility.getSAPRecipientSetting(stringArray[2]);
            String string6 = SAPFunctionUtility.getSAPRecipientSetting(stringArray[3]);
            jCoStructure.setValue("COPY", string3);
            logger.debug((Object)("BAPI_XBP_JOB_CLOSE RECIPIENT parm COPY set to " + string3));
            jCoStructure.setValue("EXPRESS", string4);
            logger.debug((Object)("BAPI_XBP_JOB_CLOSE RECIPIENT parm EXPRESS set to " + string4));
            jCoStructure.setValue("BLIND_COPY", string5);
            logger.debug((Object)("BAPI_XBP_JOB_CLOSE RECIPIENT parm BLIND_COPY set to " + string5));
            jCoStructure.setValue("NO_FORWARDING", string6);
            logger.debug((Object)("BAPI_XBP_JOB_CLOSE RECIPIENT parm NO_FORWARDING set to " + string6));
        }
        return jCoFunction;
    }

    private static String getSAPRecipientSetting(String string) {
        String string2 = "";
        int n = Integer.parseInt(string);
        if (n == 1) {
            string2 = "X";
        }
        return string2;
    }

    public static JCoFunction getFunctionJobCount(SAPConnection sAPConnection, String string) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_COUNT");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_COUNT not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", string);
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobSelect(SAPConnection sAPConnection, SAPJobSelection sAPJobSelection, SAPJobSelectParameters sAPJobSelectParameters) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_SELECT");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_SELECT not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        logger.trace((Object)("EXTERNAL_USER_NAME set to " + sAPConnection.getExternalUserName()));
        SAPFunctionUtility.addJobSelectParameters(jCoFunction, sAPJobSelectParameters);
        jCoFunction.getImportParameterList().setValue("SELECTION", sAPJobSelection.getStringValue());
        logger.trace((Object)("SELECTION set to " + sAPJobSelection.getStringValue()));
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobStart(SAPExecutableJob sAPExecutableJob, String string, SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction;
        String string2 = "BAPI_XBP_JOB_START_ASAP";
        if (sAPExecutableJob.isStartImmediately()) {
            string2 = "BAPI_XBP_JOB_START_IMMEDIATELY";
        }
        if ((jCoFunction = sAPConnection.getFunction(string2)) == null) {
            throw new RuntimeException(string2 + " not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPExecutableJob.getJobName());
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPExecutableJob.getJobCount());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
        jCoFunction.getImportParameterList().setValue("TARGET_SERVER", sAPExecutableJob.getSapExecTarget());
        return jCoFunction;
    }

    public static JCoFunction getFunctionEventRaise(SAPConnection sAPConnection, SAPEvent sAPEvent, String string) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_EVENT_RAISE");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_EVENT_RAISE not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EVENTID", sAPEvent.getName());
        jCoFunction.getImportParameterList().setValue("EVENTPARM", sAPEvent.getEventParameters());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
        return jCoFunction;
    }

    public static JCoFunction getFunctionGetInterceptedJobs(SAPConnection sAPConnection, SAPJobSelection sAPJobSelection, boolean bl) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_GET_INTERCEPTED_JOBS");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_GET_INTERCEPTED_JOBS not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        jCoFunction.getImportParameterList().setValue("SELECTION", sAPJobSelection.getStringValue());
        if (bl) {
            jCoFunction.getImportParameterList().setValue("MORE_INFO", "X");
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionChainInterrupt(String string, SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("RSPC_API_CHAIN_INTERRUPT");
        if (jCoFunction == null) {
            throw new RuntimeException("RSPC_API_CHAIN_INTERRUPT not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("I_CHAIN", string);
        return jCoFunction;
    }

    public static JCoFunction getFunctionChainStart(SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("RSPC_API_CHAIN_START");
        if (jCoFunction == null) {
            throw new RuntimeException("RSPC_API_CHAIN_START not found in SAP.");
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionChainGetStatus(SAPConnection sAPConnection, String string, String string2) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("RSPC_API_CHAIN_GET_STATUS");
        if (jCoFunction == null) {
            throw new RuntimeException("RSPC_API_CHAIN_GET_STATUS not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("I_CHAIN", string);
        jCoFunction.getImportParameterList().setValue("I_LOGID", string2);
        return jCoFunction;
    }

    public static JCoFunction getFunctionChainGetLog(SAPConnection sAPConnection, String string, String string2) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("RSPC_API_CHAIN_GET_LOG");
        if (jCoFunction == null) {
            throw new RuntimeException("RSPC_API_CHAIN_GET_LOG not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("I_CHAIN", string);
        jCoFunction.getImportParameterList().setValue("I_LOGID", string2);
        return jCoFunction;
    }

    public static JCoFunction getFunctionGetChains(SAPConnection sAPConnection, String string, boolean bl) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("RSPC_API_GET_CHAINS");
        if (jCoFunction == null) {
            throw new RuntimeException("RSPC_API_GET_CHAINS not found in SAP.");
        }
        if (bl) {
            jCoFunction.getImportParameterList().setValue("I_SEL_TXTLG", string);
        } else {
            jCoFunction.getImportParameterList().setValue("I_SEL_CHAIN", string);
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionChainGetStartCond(SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("RSPC_API_CHAIN_GET_STARTCOND");
        if (jCoFunction == null) {
            throw new RuntimeException("RSPC_API_CHAIN_GET_STARTCOND not found in SAP.");
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionChainGetProcesses(SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("RSPC_API_CHAIN_GET_PROCESSES");
        if (jCoFunction == null) {
            throw new RuntimeException("RSPC_API_CHAIN_GET_PROCESSES not found in SAP.");
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionRSPCAPIProcessGetLog(SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("RSPC_API_PROCESS_GET_LOG");
        if (jCoFunction == null) {
            throw new RuntimeException("RSPC_API_PROCESS_GET_LOG not found in SAP.");
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobAbort(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_ABORT");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_ABORT not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPJobProxy.getJobName());
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPJobProxy.getJobCount());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobDefinitionGet(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_DEFINITION_GET");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_DEFINITION_GET not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPJobProxy.getJobName());
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPJobProxy.getJobCount());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobRead(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy, boolean bl) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_READ");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_READ not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPJobProxy.getJobName());
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPJobProxy.getJobCount());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        if (bl) {
            jCoFunction.getImportParameterList().setValue("JOB_HEADER_ONLY", "X");
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobReadSingleSpool(SAPConnection sAPConnection, int n, boolean bl, int n2, int n3) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_READ_SINGLE_SPOOL");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_READ_SINGLE_SPOOL not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("SPOOL_REQUEST", n);
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        if (bl) {
            jCoFunction.getImportParameterList().setValue("RAW", "X");
        }
        if (n2 > 0) {
            jCoFunction.getImportParameterList().setValue("FIRST_PAGE", n2);
        }
        if (n3 > 0) {
            jCoFunction.getImportParameterList().setValue("LAST_PAGE", n3);
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobDelete(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_DELETE");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_DELETE not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPJobProxy.getJobName());
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPJobProxy.getJobCount());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        return jCoFunction;
    }

    public static JCoFunction getFunctionChangeCreatedVariant(SAPConnection sAPConnection, SAPVariantActionList sAPVariantActionList) throws Exception {
        JCoFunction jCoFunction = sAPConnection.getFunction("RS_CHANGE_CREATED_VARIANT_RFC");
        if (jCoFunction == null) {
            throw new RuntimeException("RS_CHANGE_CREATED_VARIANT_RFC not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("CURR_REPORT", sAPVariantActionList.getSapProgramName());
        jCoFunction.getImportParameterList().setValue("CURR_VARIANT", sAPVariantActionList.getSapVariant());
        ArrayList<SAPVariantAction> arrayList = sAPVariantActionList.getSAPVariantActions();
        if (arrayList.isEmpty()) {
            throw new Exception("No Variant Actions found.");
        }
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("VARI_CONTENTS");
        for (SAPVariantAction sAPVariantAction : arrayList) {
            jCoTable.appendRow();
            jCoTable.setValue("SELNAME", sAPVariantAction.getParameterName());
            jCoTable.setValue("KIND", sAPVariantAction.getParameterType().persistanceCode());
            jCoTable.setValue("SIGN", sAPVariantAction.getParameterSign().persistanceCode());
            jCoTable.setValue("OPTION", sAPVariantAction.getParameterOption().persistanceCode());
            jCoTable.setValue("LOW", sAPVariantAction.getParameterLowValue());
            jCoTable.setValue("HIGH", sAPVariantAction.getParameterHighValue());
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionCMProfileCreate(SAPConnection sAPConnection, String string, String string2) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_CM_PROFILE_CREATE");
        jCoFunction.getImportParameterList().setValue("I_EXTERNAL_USER_NAME", string);
        jCoFunction.getImportParameterList().setValue("I_PROFILE_XML", string2);
        return jCoFunction;
    }

    public static JCoFunction getFunctionCMProfilesGet(SAPConnection sAPConnection, String string, SAPProfileTypeSelection sAPProfileTypeSelection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_CM_PROFILES_GET");
        jCoFunction.getImportParameterList().setValue("I_EXTERNAL_USER_NAME", string);
        jCoFunction.getImportParameterList().setValue("I_PROFILETYPE", sAPProfileTypeSelection.getStringValue());
        return jCoFunction;
    }

    public static JCoFunction getFunctionCMCriteriaGet(SAPConnection sAPConnection, String string, int n, SAPProfileTypeSelection sAPProfileTypeSelection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_CM_CRITERIA_GET");
        jCoFunction.getImportParameterList().setValue("I_EXTERNAL_USER_NAME", string);
        jCoFunction.getImportParameterList().setValue("I_PROFILEID", n);
        jCoFunction.getImportParameterList().setValue("I_PROFILETYPE", sAPProfileTypeSelection.getStringValue());
        return jCoFunction;
    }

    public static JCoFunction getFunctionCMCriteriaSet(SAPConnection sAPConnection, String string, int n, SAPProfileTypeSelection sAPProfileTypeSelection, String string2) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_CM_CRITERIA_SET");
        jCoFunction.getImportParameterList().setValue("I_EXTERNAL_USER_NAME", string);
        jCoFunction.getImportParameterList().setValue("I_PROFILEID", n);
        jCoFunction.getImportParameterList().setValue("I_PROFILETYPE", sAPProfileTypeSelection.getStringValue());
        jCoFunction.getImportParameterList().setValue("I_CRITERIA_XML", string2);
        return jCoFunction;
    }

    public static JCoFunction getFunctionConfirmJob(SAPConnection sAPConnection, SAPJobSimple sAPJobSimple) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_CONFIRM_JOB");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_CONFIRM_JOB not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBS");
        jCoTable.appendRow();
        jCoTable.setValue("JOBNAME", sAPJobSimple.getJobName());
        jCoTable.setValue("JOBCOUNT", sAPJobSimple.getJobCount());
        return jCoFunction;
    }

    public static JCoFunction getFunctionConfirmJob(SAPConnection sAPConnection, Collection<SAPJobSimple> collection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_CONFIRM_JOB");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_CONFIRM_JOB not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBS");
        for (SAPJobSimple sAPJobSimple : collection) {
            jCoTable.appendRow();
            jCoTable.setValue("JOBNAME", sAPJobSimple.getJobName());
            jCoTable.setValue("JOBCOUNT", sAPJobSimple.getJobCount());
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobStatusGet(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_STATUS_GET");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_STATUS_GET not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPJobProxy.getJobName());
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPJobProxy.getJobCount());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobListStatusGet(SAPConnection sAPConnection, Collection<SAPJobProxy> collection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOBLIST_STATUS_GET");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOBLIST_STATUS_GET not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        try {
            jCoFunction.getImportParameterList().setValue("READ_ONLY_STATUS", "X");
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to set a Value for the function BAPI_XBP_JOBLIST_STATUS_GET on SAP System " + sAPConnection.getSapSystemDefinitionName()), (Throwable)exception);
            logger.debug((Object)("The optional READ_ONLY_STATUS setting for the function BAPI_XBP_JOBLIST_STATUS_GET will not be used on SAP System " + sAPConnection.getSapSystemDefinitionName() + ".  See SAP Note 1736859 for details."));
        }
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBLIST");
        for (SAPJobProxy sAPJobProxy : collection) {
            jCoTable.appendRow();
            jCoTable.setValue("JOBNAME", sAPJobProxy.getJobName());
            jCoTable.setValue("JOBCOUNT", sAPJobProxy.getJobCount());
        }
        return jCoFunction;
    }

    public static JCoFunction getFunctionJobJoblogRead(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy, String string) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_JOBLOG_READ");
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPJobProxy.getJobName());
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPJobProxy.getJobCount());
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
        jCoFunction.getImportParameterList().setValue("PROT_NEW", "X");
        return jCoFunction;
    }

    public static void setSAPJobTime(SAPJobTimeType sAPJobTimeType, SAPJobProxy sAPJobProxy, Date date, Date date2, TimeZone timeZone) {
        Timestamp timestamp = SAPFunctionUtility.getConvertedToTimestamp(date, date2, timeZone);
        if (timestamp == null) {
            return;
        }
        switch (sAPJobTimeType) {
            case PLANNED_START: {
                sAPJobProxy.setPlannedStartMS(timestamp.getTime());
                break;
            }
            case JOB_START: {
                sAPJobProxy.setJobStartTimeMS(timestamp.getTime());
                break;
            }
            case JOB_END: {
                sAPJobProxy.setJobEndTimeMS(timestamp.getTime());
            }
        }
    }

    private static Timestamp getConvertedToTimestamp(Date date, Date date2, TimeZone timeZone) {
        if (date == null || date2 == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2.getTime());
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        calendar.setTimeZone(timeZone);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        return timestamp;
    }

    private static void addJobSelectParameters(JCoFunction jCoFunction, SAPJobSelectParameters sAPJobSelectParameters) {
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("JOB_SELECT_PARAM");
        SAPJobSelectParameters.JobSelectField jobSelectField = SAPJobSelectParameters.JobSelectField.JOBNAME;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.JOBCOUNT;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.USERNAME;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.PRELIM;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.SCHEDUL;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.READY;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.RUNNING;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.FINISHED;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.ABORTED;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.FROM_DATE;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
        jobSelectField = SAPJobSelectParameters.JobSelectField.EVENTID;
        SAPFunctionUtility.setFieldValue(jCoStructure, sAPJobSelectParameters, jobSelectField);
    }

    private static void setFieldValue(JCoStructure jCoStructure, SAPJobSelectParameters sAPJobSelectParameters, SAPJobSelectParameters.JobSelectField jobSelectField) {
        switch (jobSelectField.getParameterType()) {
            case STRING: {
                String string = (String)sAPJobSelectParameters.getField(jobSelectField);
                if (string == null) break;
                jCoStructure.setValue(jobSelectField.name(), string);
                logger.trace((Object)("JOB_SELECT_PARAM " + jobSelectField + " set to " + string));
                break;
            }
            case BOOLEAN: {
                boolean bl = (Boolean)sAPJobSelectParameters.getField(jobSelectField);
                jCoStructure.setValue(jobSelectField.name(), (Object)bl);
                logger.trace((Object)("JOB_SELECT_PARAM " + jobSelectField + " set to " + bl));
                break;
            }
            case DATS: {
                String string = (String)sAPJobSelectParameters.getField(jobSelectField);
                if (string == null) break;
                jCoStructure.setValue(jobSelectField.name(), string);
                logger.trace((Object)("JOB_SELECT_PARAM " + jobSelectField + " set to " + string));
                break;
            }
        }
    }

    public static String getCreateCMProfileXML(SAPProfileTypeSelection sAPProfileTypeSelection, int n, String string) {
        String string2 = "<?xml version=\"1.0\"?><!DOCTYPE profile SYSTEM\"criteria_profile.dtd\"><profile type=\"" + sAPProfileTypeSelection.getStringValue() + "\" " + "id=\"" + n + "\" " + "description=\"" + string + "\">" + "<root/>" + "</profile>";
        return string2;
    }

    public static JCoFunction getFunctionEventHistoryRecords(SAPConnection sAPConnection, long l) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_BTC_EVTHISTORY_GET");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_BTC_EVTHISTORY_GET not found in SAP version.  Your SAP Version must be version 3.0 or higher.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        BigDecimal bigDecimal = DateTranslator.getBigDecimalFromDate((long)l);
        logger.debug((Object)("From Date: " + new Date(l) + " Raw: " + bigDecimal + " Passed: " + l));
        jCoFunction.getImportParameterList().setValue("FROM_TIMESTAMP_UTC", bigDecimal);
        jCoFunction.getImportParameterList().setValue("SELECT_STATE", "N");
        jCoFunction.getImportParameterList().setValue("ACTION", "C");
        return jCoFunction;
    }

    public static String getStartString(boolean bl) {
        String string = "ASAP";
        if (bl) {
            string = "IMMEDIATELY";
        }
        return string;
    }

    public static SAPReturnMessage getSAPReturnMessage(JCoFunction jCoFunction) {
        JCoStructure jCoStructure = jCoFunction.getExportParameterList().getStructure("RETURN");
        boolean bl = !SAPFunctionUtility.isBapiReturnCodeOK((JCoRecord)jCoStructure);
        String string = jCoStructure.getString("TYPE");
        String string2 = jCoStructure.getString("ID");
        int n = jCoStructure.getInt("NUMBER");
        String string3 = jCoStructure.getString("MESSAGE");
        return new SAPReturnMessage(string, string2, n, string3, bl);
    }

    public static SAPReturnMessage getSAPException(JCoFunction jCoFunction) {
        JCoStructure jCoStructure = jCoFunction.getExportParameterList().getStructure("RETURN");
        boolean bl = !SAPFunctionUtility.isBapiReturnCodeOK((JCoRecord)jCoStructure);
        String string = jCoStructure.getString("TYPE");
        String string2 = jCoStructure.getString("ID");
        int n = jCoStructure.getInt("NUMBER");
        String string3 = jCoStructure.getString("MESSAGE");
        return new SAPReturnMessage(string, string2, n, string3, bl);
    }

    private static boolean isBapiReturnCodeOK(JCoRecord jCoRecord) {
        try {
            if (jCoRecord instanceof JCoStructure) {
                return jCoRecord.getString("TYPE").equals("") || jCoRecord.getString("TYPE").equals("S");
            }
            if (jCoRecord instanceof JCoTable) {
                JCoTable jCoTable = (JCoTable)jCoRecord;
                int n = jCoTable.getNumRows();
                if (n == 0) {
                    return true;
                }
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    jCoTable.setRow(i);
                    if (jCoTable.getString("TYPE").equals("") && !jCoTable.getString("TYPE").equals("S")) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getDateTimeString(long l) {
        String string = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        String string2 = "";
        String string3 = "";
        string2 = numberFormatter.format(calendar.get(12));
        string3 = numberFormatter.format(calendar.get(13));
        string = calendar.get(1) + "." + (calendar.get(2) + 1) + "." + calendar.get(5) + " at " + calendar.get(11) + ":" + string2 + ":" + string3;
        return string;
    }

    public static void logExceptionDetails(JCoFunction jCoFunction, boolean bl) {
        if (jCoFunction == null) {
            if (bl) {
                logger.error((Object)"bapiFunction is null.  No information available.");
            } else {
                logger.debug((Object)"bapiFunction is null.  No information available.");
            }
            return;
        }
        AbapException[] abapExceptionArray = jCoFunction.getExceptionList();
        if (abapExceptionArray != null) {
            for (int i = 0; i < abapExceptionArray.length; ++i) {
                if (bl) {
                    logger.error((Object)("AbapException[" + i + "] = " + abapExceptionArray[i]));
                } else {
                    logger.debug((Object)("AbapException[" + i + "] = " + abapExceptionArray[i]));
                }
                AbapException abapException = abapExceptionArray[i];
                String string = abapException.getKey();
                String string2 = abapException.getMessage();
                String string3 = abapException.getMessageNumber();
                if (bl) {
                    logger.error((Object)("AbapException: Key(" + string + ") MessageNumber(" + string3 + ") Message(" + string2 + ")"));
                } else {
                    logger.debug((Object)("AbapException: Key(" + string + ") MessageNumber(" + string3 + ") Message(" + string2 + ")"));
                }
                String[] stringArray = abapException.getMessageParameters();
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (bl) {
                        logger.error((Object)("messageParameter[" + j + "] = " + stringArray[j]));
                        continue;
                    }
                    logger.debug((Object)("messageParameter[" + j + "] = " + stringArray[j]));
                }
            }
        }
    }

    static {
        numberFormatter.setMinimumIntegerDigits(2);
    }
}

