/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.sap;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStep;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStepSet;
import com.helpsystems.enterprise.core.busobj.sap.SAPAllPrintParameters;
import com.helpsystems.enterprise.core.busobj.sap.SAPChildJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPCommand;
import com.helpsystems.enterprise.core.busobj.sap.SAPCommandResults;
import com.helpsystems.enterprise.core.busobj.sap.SAPEvent;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutable;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutableJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutableProcessChain;
import com.helpsystems.enterprise.core.busobj.sap.SAPField;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobStatus;
import com.helpsystems.enterprise.core.busobj.sap.SAPProcess;
import com.helpsystems.enterprise.core.busobj.sap.SAPProcessChain;
import com.helpsystems.enterprise.core.busobj.sap.SAPProcessStatus;
import com.helpsystems.enterprise.core.busobj.sap.SAPReturnMessage;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystem;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemEnvironment;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantAction;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantActionList;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.dm.sap.SAPCommandHelperAM;
import com.helpsystems.enterprise.core.dm.sap.SAPPrintParametersDM;
import com.helpsystems.enterprise.module.sap.SAPConnection;
import com.helpsystems.enterprise.module.sap.SAPConnectionProvider;
import com.helpsystems.enterprise.module.sap.SAPFunctionUtility;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class SAPCommandHelperAMImpl
extends SAPConnectionProvider
implements SAPCommandHelperAM {
    private static final Logger logger = Logger.getLogger(SAPCommandHelperAMImpl.class);
    private static HashMap<Long, SAPXMIAuditLevel> xmiAuditLevelHM = new HashMap();
    private ArrayList<Long> requestsToTerminateAL = new ArrayList();
    private SAPPrintParametersDM sapPrintParametersDM;
    private AgentPeer peer;

    public SAPCommandHelperAMImpl(AgentPeer agentPeer) {
        this.setName("ENTERPRISE.SAPCommandHelperAM");
        this.peer = agentPeer;
    }

    public AgentPeer getPeer() {
        return this.peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAPCommandResults runSAPCommand(SAPExecutable sAPExecutable, PrintWriter printWriter) {
        SAPConnection sAPConnection;
        Thread.currentThread().setName("Automate Schedule Event " + sAPExecutable.getSkybotEventID() + " for Agent " + sAPExecutable.getAgentNameAndPort());
        SAPCommandResults sAPCommandResults = new SAPCommandResults();
        String string = "Starting process to run SAP Command: " + sAPExecutable.getSapCommand().getSAPCommandName();
        logger.debug((Object)string);
        this.writeToProcessMonitorLog(printWriter, string);
        try {
            sAPConnection = this.getSAPConnection(sAPExecutable);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            sAPCommandResults.addLogEntry(resourceUnavailableException.getMessage());
            sAPCommandResults.setTerminationReason(resourceUnavailableException.getMessage());
            sAPCommandResults.setSuccessful(false, false, SAPCommandResults.SAPCommandExitCode.FAILURE);
            return sAPCommandResults;
        }
        try {
            this.startSAPXMISession(sAPConnection);
            this.executeSAPCommand(sAPConnection, sAPExecutable, sAPCommandResults, printWriter);
        }
        catch (Exception exception) {
            string = "Error executing SAP Command.";
            logger.error((Object)string, (Throwable)exception);
            sAPCommandResults.addLogEntry(string + "  " + exception.getMessage());
            sAPCommandResults.setTerminationReason(exception.getMessage());
            sAPCommandResults.setSuccessful(false, false, SAPCommandResults.SAPCommandExitCode.FAILURE);
            SAPCommandResults sAPCommandResults2 = sAPCommandResults;
            return sAPCommandResults2;
        }
        finally {
            this.requestsToTerminateAL.remove(sAPExecutable.getSkybotEventID());
            this.endSAPXMISession(sAPConnection);
        }
        logger.trace((Object)("*** After completing runSAPCommand " + sAPExecutable.getSapCommand().getSAPCommandName() + " for Automate Schedule event " + sAPExecutable.getSkybotEventID() + " requestsToTerminateAL.size() = " + this.requestsToTerminateAL.size()));
        return sAPCommandResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToProcessMonitorLog(PrintWriter printWriter, String string) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(string);
            printWriter.flush();
            printWriter.notifyAll();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeSAPCommand(SAPConnection sAPConnection, SAPExecutable sAPExecutable, SAPCommandResults sAPCommandResults, PrintWriter printWriter) throws Exception {
        EnterpriseProxy enterpriseProxy;
        String string = "About to Run SAP Command: " + sAPExecutable.getSapCommand().getSAPCommandName();
        String string2 = sAPExecutable.getSapSystemEnvironment().getSapUserName();
        SAPCommand sAPCommand = sAPExecutable.getSapCommand();
        this.validateSAPCommand(sAPCommand);
        if (sAPCommand instanceof SAPExecutableJob) {
            enterpriseProxy = (SAPExecutableJob)sAPCommand;
            switch (((SAPExecutableJob)enterpriseProxy).getExecutableSAPJobType()) {
                case NORMAL: {
                    this.runStartSAPJobProcess(sAPConnection, sAPExecutable, (SAPExecutableJob)enterpriseProxy, string2, sAPCommandResults, printWriter);
                    break;
                }
                case SINGLE_INTERCEPTED: 
                case MULTIPLE_INTERCEPTED: {
                    void var10_16;
                    int n = ((SAPExecutableJob)enterpriseProxy).getInterceptedJobsToRelease().size();
                    String object22 = "Found " + n + " intercepted ";
                    if (n == 1) {
                        String string3 = object22 + "job";
                    } else {
                        String string4 = object22 + "jobs";
                        sAPCommandResults.setMultipleInterceptedJobs(true);
                    }
                    String string5 = (String)var10_16 + " in theSAPExecutableJob.";
                    logger.debug((Object)string5);
                    sAPCommandResults.setReleasingInterceptedJobs(true);
                    this.runStartInterceptedJobsProcess(sAPConnection, (SAPExecutableJob)enterpriseProxy, string2, sAPCommandResults, printWriter);
                    break;
                }
                default: {
                    throw new InvalidParameterException("Invalid Executable SAP Job Type of " + (Object)((Object)((SAPExecutableJob)enterpriseProxy).getExecutableSAPJobType()));
                }
            }
            if (!sAPCommandResults.isSuccessful()) {
                return;
            }
            if (((SAPExecutableJob)enterpriseProxy).isWaitOnCompletion()) {
                this.monitorSAPJob((SAPJobProxy)enterpriseProxy, string2, sAPExecutable.getSkybotEventID(), sAPConnection, sAPCommandResults, printWriter);
                if (((SAPJobProxy)enterpriseProxy).isWithChildJobs()) {
                    this.loadChildJobs((SAPExecutableJob)enterpriseProxy, string2, sAPConnection);
                    ArrayList<SAPChildJob> arrayList = ((SAPExecutableJob)enterpriseProxy).getChildJobs();
                    string = ((SAPJobProxy)enterpriseProxy).getNameAndCount() + " produced " + arrayList.size() + " child jobs.";
                    logger.debug((Object)string);
                    this.writeToProcessMonitorLog(printWriter, string);
                    this.loadStatusOfChildJobs((SAPExecutableJob)enterpriseProxy, string2, sAPConnection);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        SAPJobProxy sAPJobProxy = arrayList.get(i);
                        String string6 = "Child " + (i + 1) + ": " + sAPJobProxy.getNameAndCount() + " Status: " + sAPJobProxy.getJobStatus();
                        this.writeToProcessMonitorLog(printWriter, string6);
                    }
                    if (((SAPExecutableJob)enterpriseProxy).isWaitForChildJobs()) {
                        string = "*** About to monitor " + arrayList.size() + " child job(s) from SAP job " + ((SAPJobProxy)enterpriseProxy).getNameAndCount();
                        logger.debug((Object)string);
                        this.writeToProcessMonitorLog(printWriter, string);
                        for (SAPJobProxy sAPJobProxy : arrayList) {
                            this.monitorSAPJob(sAPJobProxy, string2, sAPExecutable.getSkybotEventID(), sAPConnection, sAPCommandResults, printWriter);
                        }
                    }
                }
            } else {
                string = sAPCommandResults.isMultipleInterceptedJobs() ? "The released Intercepted Jobs will not be monitored on SAP System " + sAPExecutable.getSAPSystemName() : "The SAP Job " + ((SAPJobProxy)enterpriseProxy).getNameAndCount() + " is not set to wait on completion and " + "will not be monitored on SAP System " + sAPExecutable.getSAPSystemName();
                logger.debug((Object)string);
                this.writeToProcessMonitorLog(printWriter, string);
            }
        }
        if (sAPCommand instanceof SAPEvent) {
            enterpriseProxy = (SAPEvent)sAPCommand;
            String string3 = "SAP Event: " + enterpriseProxy.getName();
            if (((SAPEvent)enterpriseProxy).hasParameters()) {
                string3 = string3 + " with parameters '" + ((SAPEvent)enterpriseProxy).getEventParameters() + "'";
            }
            string = "About to Raise " + string3;
            logger.debug((Object)string);
            this.writeToProcessMonitorLog(printWriter, string);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionEventRaise(sAPConnection, (SAPEvent)enterpriseProxy, string2);
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string7 = "SAP Error " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + sAPReturnMessage.getMessageText();
                logger.error((Object)string7);
                this.writeToProcessMonitorLog(printWriter, string7);
                String string8 = "Error raising " + string3;
                string8 = string8 + " on SAP System " + sAPConnection.getSapSystemDefinitionName() + ".";
                sAPCommandResults.addLogEntry(string8);
                this.writeToProcessMonitorLog(printWriter, string8);
                sAPCommandResults.setSuccessful(false, string7, SAPCommandResults.SAPCommandExitCode.FAILURE);
                return;
            }
            string = "Successfully Raised " + string3 + " on SAP System " + sAPConnection.getSapSystemDefinitionName() + ".";
            logger.debug((Object)string);
            this.writeToProcessMonitorLog(printWriter, string);
        }
        if (sAPCommand instanceof SAPVariantActionList) {
            enterpriseProxy = (SAPVariantActionList)sAPCommand;
            string = "About to process SAP Variant Action: " + enterpriseProxy.getName();
            logger.debug((Object)string);
            this.writeToProcessMonitorLog(printWriter, string);
            for (SAPVariantAction sAPVariantAction : ((SAPVariantActionList)enterpriseProxy).getSAPVariantActions()) {
                string = "Adding variant change for: TYPE(" + sAPVariantAction.getParameterType() + ") NAME(" + sAPVariantAction.getParameterName() + ") SIGN(" + sAPVariantAction.getParameterSign().persistanceCode() + ") OPTION(" + sAPVariantAction.getParameterOption().persistanceCode() + ") LOW(" + sAPVariantAction.getParameterLowValue() + ") HIGH(" + sAPVariantAction.getParameterHighValue() + ")";
                logger.debug((Object)string);
                this.writeToProcessMonitorLog(printWriter, string);
            }
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionChangeCreatedVariant(sAPConnection, (SAPVariantActionList)enterpriseProxy);
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string9 = "SAP Error " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + ((SAPVariantActionList)enterpriseProxy).getSapVariant() + " was not changed. " + sAPReturnMessage.getMessageText();
                logger.error((Object)string9);
                string = "Error changing SAP Variant " + ((SAPVariantActionList)enterpriseProxy).getSapVariant() + " for ABAP Program " + ((SAPVariantActionList)enterpriseProxy).getSapProgramName();
                this.writeToProcessMonitorLog(printWriter, string);
                sAPCommandResults.setSuccessful(false, string9, SAPCommandResults.SAPCommandExitCode.FAILURE);
                return;
            }
            string = "Successfully processed SAP Variant Action " + enterpriseProxy.getName() + " on SAP System " + sAPConnection.getSapSystemDefinitionName() + ".";
            logger.debug((Object)string);
            this.writeToProcessMonitorLog(printWriter, string);
        }
        if (sAPCommand instanceof SAPExecutableProcessChain) {
            enterpriseProxy = (SAPExecutableProcessChain)sAPCommand;
            string = "About to process SAP Process Chain: " + enterpriseProxy.getName();
            logger.debug((Object)string);
            this.writeToProcessMonitorLog(printWriter, string);
            this.startProcessChainProcess(sAPConnection, (SAPExecutableProcessChain)enterpriseProxy, printWriter);
            this.monitorProcessChainProcess(sAPConnection, (SAPExecutableProcessChain)enterpriseProxy, sAPExecutable.getSkybotEventID(), sAPCommandResults, printWriter);
            string = "Successfully processed SAP Process Chain: '" + ((SAPExecutableProcessChain)enterpriseProxy).getNameAndLogID() + "' on SAP System " + sAPConnection.getSapSystemDefinitionName() + ".";
            logger.debug((Object)string);
            this.writeToProcessMonitorLog(printWriter, string);
        }
    }

    private void runStartSAPJobProcess(SAPConnection sAPConnection, SAPExecutable sAPExecutable, SAPExecutableJob sAPExecutableJob, String string, SAPCommandResults sAPCommandResults, PrintWriter printWriter) throws JCoException {
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobOpen(sAPConnection, sAPExecutableJob, string);
        sAPConnection.executeMiddleFunction(jCoFunction);
        String string2 = sAPExecutable.getSAPSystemName();
        String string3 = jCoFunction.getExportParameterList().getString("JOBCOUNT");
        sAPExecutableJob.setJobCount(string3);
        String string4 = "SAP Job " + sAPExecutableJob.getNameAndCount() + " opened on SAP System " + string2;
        logger.debug((Object)string4);
        this.writeToProcessMonitorLog(printWriter, string4);
        try {
            SAPABAPStepSet sAPABAPStepSet = sAPExecutableJob.getAbapStepSet();
            if (sAPABAPStepSet.getStepList().isEmpty()) {
                throw new JCoException(126, "The job definition has no steps defined.");
            }
            this.addABAPSteps(sAPConnection, sAPExecutableJob, sAPABAPStepSet, printWriter, string);
            jCoFunction = SAPFunctionUtility.getFunctionJobClose(sAPConnection, sAPExecutableJob, string);
            sAPConnection.executeMiddleFunction(jCoFunction);
            string4 = "Closed SAP Job " + sAPExecutableJob.getNameAndCount() + " on SAP System " + string2;
            if (sAPExecutableJob.hasSAPExecTarget()) {
                string4 = string4 + " with target server " + sAPExecutableJob.getSapExecTarget();
            }
            logger.debug((Object)string4);
            this.writeToProcessMonitorLog(printWriter, string4);
            jCoFunction = SAPFunctionUtility.getFunctionJobStatusGet(sAPConnection, sAPExecutableJob);
            sAPConnection.executeMiddleFunction(jCoFunction);
            String string5 = jCoFunction.getExportParameterList().getString("STATUS");
            SAPJobStatus sAPJobStatus = SAPJobStatus.persistanceCodeToEnum(string5);
            string4 = "SAP Job " + sAPExecutableJob.getNameAndCount() + " status = " + sAPJobStatus;
            logger.debug((Object)string4);
            this.writeToProcessMonitorLog(printWriter, string4);
            jCoFunction = SAPFunctionUtility.getFunctionJobStart(sAPExecutableJob, string, sAPConnection);
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                string4 = "Error starting SAP Job " + sAPExecutableJob.getNameAndCount() + ".  " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + sAPReturnMessage.getMessageText();
                logger.error((Object)string4);
                this.writeToProcessMonitorLog(printWriter, string4);
                throw new JCoException(105, string4);
            }
            string4 = "Successfully started SAP Job " + sAPExecutableJob.getNameAndCount() + " " + SAPFunctionUtility.getStartString(sAPExecutableJob.isStartImmediately()) + " on SAP System " + string2;
            if (sAPExecutableJob.getSapExecTarget().length() > 0) {
                string4 = string4 + " with target server " + sAPExecutableJob.getSapExecTarget();
            }
            logger.debug((Object)string4);
            this.writeToProcessMonitorLog(printWriter, string4);
        }
        catch (JCoException jCoException) {
            string4 = "SAP Job " + sAPExecutableJob.getNameAndCount() + " failed to start.  " + jCoException.getMessage();
            logger.error((Object)string4);
            this.writeToProcessMonitorLog(printWriter, string4);
            string4 = "SAP Job " + sAPExecutableJob.getNameAndCount() + " will be deleted.";
            logger.debug((Object)string4);
            this.writeToProcessMonitorLog(printWriter, string4);
            this.deleteSAPJob(sAPConnection, sAPExecutableJob, sAPCommandResults);
            throw jCoException;
        }
        catch (JCoRuntimeException jCoRuntimeException) {
            string4 = "SAP Job " + sAPExecutableJob.getNameAndCount() + " failed to start.  " + jCoRuntimeException.getMessage();
            logger.error((Object)string4);
            this.writeToProcessMonitorLog(printWriter, string4);
            if (jCoRuntimeException.getGroup() == 127 && jCoRuntimeException.getMessage().contains("Field RECIPIENT")) {
                string4 = "SAP System " + sAPExecutable.getSAPSystemName() + " does not support Spool List Recipient." + "  See SAP Notes 0000723902 and 0000967787.";
                logger.error((Object)string4);
                this.writeToProcessMonitorLog(printWriter, string4);
            }
            string4 = "SAP Job " + sAPExecutableJob.getNameAndCount() + " will be deleted.";
            this.writeToProcessMonitorLog(printWriter, string4);
            this.deleteSAPJob(sAPConnection, sAPExecutableJob, sAPCommandResults);
            throw jCoRuntimeException;
        }
    }

    private void runStartInterceptedJobsProcess(SAPConnection sAPConnection, SAPExecutableJob sAPExecutableJob, String string, SAPCommandResults sAPCommandResults, PrintWriter printWriter) throws Exception {
        ArrayList<SAPInterceptedJob> arrayList = sAPExecutableJob.getInterceptedJobsToRelease();
        Iterator<SAPInterceptedJob> iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            SAPInterceptedJob sAPInterceptedJob = iterator.next();
            SAPExecutableJob sAPExecutableJob2 = new SAPExecutableJob(sAPInterceptedJob);
            this.runStartInterceptedJobProcess(sAPConnection, sAPExecutableJob2, string, sAPCommandResults, printWriter);
            if (!sAPCommandResults.isSuccessful()) continue;
            bl = true;
            sAPCommandResults.addStartedInterceptedJobID(sAPInterceptedJob.getOID());
        }
        if (bl) {
            sAPCommandResults.setSuccessful(true, true, SAPCommandResults.SAPCommandExitCode.SUCCESS);
        }
    }

    private void runStartInterceptedJobProcess(SAPConnection sAPConnection, SAPExecutableJob sAPExecutableJob, String string, SAPCommandResults sAPCommandResults, PrintWriter printWriter) throws Exception {
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobStart(sAPExecutableJob, string, sAPConnection);
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string2 = "SAP Error " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + sAPExecutableJob.getNameAndCount() + " was not started. ";
                jCoFunction = SAPFunctionUtility.getFunctionJobStatusGet(sAPConnection, sAPExecutableJob);
                sAPConnection.executeMiddleFunction(jCoFunction);
                String string3 = jCoFunction.getExportParameterList().getString("STATUS");
                SAPJobStatus sAPJobStatus = SAPJobStatus.persistanceCodeToEnum(string3);
                string2 = sAPJobStatus.isTerminal() ? string2 + " The job was previously released or canceled." : string2 + sAPReturnMessage.getMessageText();
                logger.error((Object)string2);
                String string4 = "Error starting SAP Intercepted Job " + sAPExecutableJob.getNameAndCount();
                this.writeToProcessMonitorLog(printWriter, string4);
                this.writeToProcessMonitorLog(printWriter, string2);
                sAPCommandResults.setSuccessful(false, string2, SAPCommandResults.SAPCommandExitCode.FAILURE);
                return;
            }
            String string5 = "Successfully started SAP Job " + sAPExecutableJob.getNameAndCount() + " " + SAPFunctionUtility.getStartString(sAPExecutableJob.isStartImmediately()) + " on SAP System " + sAPConnection.getSapSystemDefinitionName();
            logger.debug((Object)string5);
            this.writeToProcessMonitorLog(printWriter, string5);
        }
        catch (JCoException jCoException) {
            String string6 = "Error starting intercepted SAP Job " + sAPExecutableJob.getNameAndCount() + ".  " + jCoException.getMessage();
            logger.error((Object)string6);
            throw new Exception(string6, jCoException);
        }
    }

    private void startProcessChainProcess(SAPConnection sAPConnection, SAPExecutableProcessChain sAPExecutableProcessChain, PrintWriter printWriter) throws Exception {
        JCoFunction jCoFunction = null;
        jCoFunction = SAPFunctionUtility.getFunctionChainStart(sAPConnection);
        String string = sAPExecutableProcessChain.getName();
        jCoFunction.getImportParameterList().setValue("I_CHAIN", string);
        logger.debug((Object)("Import Parm I_CHAIN set to '" + string + "'"));
        try {
            sAPConnection.execute(jCoFunction);
        }
        catch (JCoException jCoException) {
            String string2 = "Error starting SAP Process Chain " + string;
            if (jCoException.getMessageNumber().equals("031")) {
                string2 = string2 + ".  Process Chain may not exist.";
            } else if (jCoException.getMessageNumber().equals("022")) {
                string2 = string2 + ".  Process Chain may be in error.";
            } else if (jCoException.getMessageNumber().equals("090")) {
                string2 = string2 + ".  Process Chain may already be active.";
            }
            logger.error((Object)string2, (Throwable)jCoException);
            throw new Exception(string2, jCoException);
        }
        String string3 = jCoFunction.getExportParameterList().getString("E_LOGID");
        sAPExecutableProcessChain.setLogID(string3);
        String string4 = "Successfully started Process Chain: " + sAPExecutableProcessChain.getNameAndLogID();
        logger.debug((Object)string4);
        this.writeToProcessMonitorLog(printWriter, string4);
    }

    private void monitorProcessChainProcess(SAPConnection sAPConnection, SAPExecutableProcessChain sAPExecutableProcessChain, long l, SAPCommandResults sAPCommandResults, PrintWriter printWriter) throws Exception {
        String string = sAPExecutableProcessChain.getNameAndLogID();
        String string2 = "Monitoring SAP Process Chain " + string;
        logger.debug((Object)string2);
        this.writeToProcessMonitorLog(printWriter, string2);
        this.loadSAPProcessChainProcesses(sAPConnection, sAPExecutableProcessChain);
        JCoFunction jCoFunction = null;
        boolean bl = false;
        jCoFunction = SAPFunctionUtility.getFunctionChainGetStatus(sAPConnection, sAPExecutableProcessChain.getName(), sAPExecutableProcessChain.getLogID());
        String string3 = "Unknown";
        SAPProcessStatus sAPProcessStatus = null;
        boolean bl2 = false;
        while (!bl) {
            SAPProcessStatus sAPProcessStatus2 = sAPProcessStatus;
            sAPConnection.executeMiddleFunction(jCoFunction);
            string3 = jCoFunction.getExportParameterList().getString("E_STATUS");
            sAPProcessStatus = SAPProcessStatus.persistanceCodeToEnum(string3);
            sAPExecutableProcessChain.setStatus(sAPProcessStatus);
            if (sAPProcessStatus2 != sAPProcessStatus) {
                string2 = "SAP Process Chain: '" + string + "' Status = " + sAPProcessStatus;
                logger.debug((Object)string2);
                this.writeToProcessMonitorLog(printWriter, string2);
            }
            if (sAPProcessStatus.isTerminal()) {
                bl = true;
                continue;
            }
            if (bl) continue;
            if (this.requestsToTerminateAL.contains(l) && !bl2) {
                string2 = "SAP Process Chain: '" + sAPExecutableProcessChain.getNameAndLogID() + "' will be terminated.";
                logger.debug((Object)string2);
                this.writeToProcessMonitorLog(printWriter, string2);
                bl2 = true;
                this.terminateSAPProcessChain(sAPExecutableProcessChain, sAPConnection);
                Thread.sleep(2000L);
                sAPConnection.executeMiddleFunction(jCoFunction);
                string3 = jCoFunction.getExportParameterList().getString("E_STATUS");
                sAPProcessStatus = SAPProcessStatus.persistanceCodeToEnum(string3);
                sAPExecutableProcessChain.setStatus(sAPProcessStatus);
                bl = true;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        string2 = "SAP Process Chain: '" + sAPExecutableProcessChain.getNameAndLogID() + "' completed with status " + sAPProcessStatus;
        logger.debug((Object)string2);
        this.writeToProcessMonitorLog(printWriter, string2);
        if (bl2) {
            sAPCommandResults.setSuccessful(false, "The SAP Process Chain: '" + sAPExecutableProcessChain.getNameAndLogID() + "' was canceled upon request from Automate Schedule.", SAPCommandResults.SAPCommandExitCode.FAILURE);
        } else {
            if (sAPExecutableProcessChain.getStatus().equals(SAPProcessStatus.CANCELLED)) {
                sAPCommandResults.setSuccessful(false, "The SAP Process Chain: '" + sAPExecutableProcessChain.getNameAndLogID() + "' was canceled on the SAP system.", SAPCommandResults.SAPCommandExitCode.FAILURE);
            }
            if (sAPProcessStatus.equals(SAPProcessStatus.UNKNOWN)) {
                sAPCommandResults.setSuccessful(false, "The status of SAP Process Chain: '" + sAPExecutableProcessChain.getNameAndLogID() + "' is unknown.", SAPCommandResults.SAPCommandExitCode.FAILURE);
            }
        }
        this.listProcessChainLogDetails(sAPConnection, sAPExecutableProcessChain, sAPCommandResults);
    }

    private void listProcessChainLogDetails(SAPConnection sAPConnection, SAPExecutableProcessChain sAPExecutableProcessChain, SAPCommandResults sAPCommandResults) throws Exception {
        Object object;
        Object object2;
        String string = sAPExecutableProcessChain.getName();
        String string2 = sAPExecutableProcessChain.getLogID();
        this.loadSAPProcessChainProcesses(sAPConnection, sAPExecutableProcessChain);
        if (sAPExecutableProcessChain.hasSAPProcesses()) {
            logger.debug((Object)(sAPExecutableProcessChain.getNameAndLogID() + " contains " + sAPExecutableProcessChain.getSapProcessHM().size() + " processes."));
            this.loadSAPJobNamesAndCounts(sAPConnection, sAPExecutableProcessChain);
            object2 = "";
            Iterator<String> iterator = sAPExecutableProcessChain.getSapProcessHM().keySet().iterator();
            while (iterator.hasNext()) {
                object = sAPExecutableProcessChain.getSapProcessHM().get(iterator.next());
                object2 = " SAP Job:" + ((SAPProcess)object).getJobName() + "(" + ((SAPProcess)object).getJobCount() + ") Job Status: " + ((SAPProcess)object).getSapJobStatus() + " Process Variant: " + ((SAPProcess)object).getVariant() + " Status: " + ((SAPProcess)object).getSapProcessStatus();
                logger.debug(object2);
            }
        }
        object = SAPFunctionUtility.getFunctionChainGetLog(sAPConnection, string, string2);
        sAPConnection.execute((JCoFunction)object);
        object2 = object.getTableParameterList().getTable("E_T_LOG");
        int n = object2.getNumRows();
        String string3 = "Process Chain log details:";
        logger.debug((Object)string3);
        sAPCommandResults.addLogEntry(string3);
        sAPCommandResults.addLogEntry("--------------------------");
        for (int i = 0; i < n; ++i) {
            object2.setRow(i);
            String string4 = object2.getString("MSGTY");
            if (!string4.equals("S") && !string4.equals("E")) continue;
            String string5 = object2.getString("MSGV1");
            String string6 = object2.getString("MSGV2");
            String string7 = object2.getString("MSGV4");
            string3 = string5 + " " + string6 + " " + string7;
            logger.debug((Object)string3);
            sAPCommandResults.addLogEntry(string3);
            if (!string4.equals("E")) continue;
            sAPCommandResults.setSuccessful(false, string3, SAPCommandResults.SAPCommandExitCode.FAILURE);
        }
        sAPCommandResults.addLogEntry("--------------------------");
        if (!sAPCommandResults.isSuccessful()) {
            throw new Exception(sAPCommandResults.getTerminationReason());
        }
    }

    private void loadSAPJobNamesAndCounts(SAPConnection sAPConnection, SAPExecutableProcessChain sAPExecutableProcessChain) throws JCoException {
        Iterator<String> iterator = sAPExecutableProcessChain.getSapProcessHM().keySet().iterator();
        while (iterator.hasNext()) {
            SAPProcess sAPProcess = sAPExecutableProcessChain.getSapProcessHM().get(iterator.next());
            if (!sAPProcess.hasJobNameAndCount() || !sAPProcess.getSapJobStatus().isTerminal()) {
                this.loadSAPProcessLog(sAPConnection, sAPExecutableProcessChain.getLogID(), sAPProcess);
            }
            if (!sAPProcess.hasJobNameAndCount() || sAPProcess.getSapJobStatus().isTerminal()) continue;
            this.loadSAPProcessJobStatus(sAPConnection, sAPProcess);
        }
    }

    private void loadSAPProcessJobStatus(SAPConnection sAPConnection, SAPProcess sAPProcess) throws JCoException {
        SAPJobProxy sAPJobProxy = new SAPJobProxy(sAPProcess.getJobName(), sAPProcess.getJobCount());
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobStatusGet(sAPConnection, sAPJobProxy);
        sAPConnection.executeMiddleFunction(jCoFunction);
        SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
        if (sAPReturnMessage.isError()) {
            String string = "Unable to obtain status of SAP job " + sAPJobProxy.getNameAndCount() + ".  " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + sAPReturnMessage.getMessageText();
            logger.warn((Object)string);
            if (sAPReturnMessage.getReturnID().equals("XM") && sAPReturnMessage.getReturnNumber() == 49) {
                String string2 = "SAP job " + sAPJobProxy.getNameAndCount() + " was deleted on the SAP system before it could start.";
                logger.warn((Object)string2);
            }
            return;
        }
        String string = jCoFunction.getExportParameterList().getString("STATUS");
        SAPJobStatus sAPJobStatus = SAPJobStatus.persistanceCodeToEnum(string);
        sAPProcess.setSapJobStatus(sAPJobStatus);
    }

    private void validateSAPCommand(SAPCommand sAPCommand) throws Exception {
        if (sAPCommand instanceof SAPExecutableJob || sAPCommand instanceof SAPEvent || sAPCommand instanceof SAPVariantActionList || sAPCommand instanceof SAPProcessChain) {
            return;
        }
        throw new Exception("Unknown SAPCommand " + sAPCommand.getSAPCommandName());
    }

    private void loadStatusOfChildJobs(SAPExecutableJob sAPExecutableJob, String string, SAPConnection sAPConnection) throws JCoException {
        ArrayList<SAPJobProxy> arrayList = new ArrayList<SAPJobProxy>();
        ArrayList<SAPChildJob> arrayList2 = sAPExecutableJob.getChildJobs();
        ListIterator<SAPChildJob> listIterator = arrayList2.listIterator();
        while (listIterator.hasNext()) {
            SAPJobProxy sAPJobProxy = listIterator.next();
            arrayList.add(sAPJobProxy);
        }
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobListStatusGet(sAPConnection, arrayList);
        sAPConnection.executeMiddleFunction(jCoFunction);
        SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
        if (sAPReturnMessage.isError()) {
            logger.error((Object)("Error executing " + jCoFunction.getName() + ". SAP error: " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + sAPReturnMessage.getMessageText()));
        }
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBLIST");
        int n = jCoTable.getNumRows();
        logger.debug((Object)(jCoFunction.getName() + " returned " + n + " jobs"));
        for (int i = 0; i < n; ++i) {
            jCoTable.setRow(i);
            String string2 = jCoTable.getString("JOBNAME");
            String string3 = jCoTable.getString("JOBCOUNT");
            String string4 = jCoTable.getString("STATUS");
            String string5 = jCoTable.getString("HAS_CHILD");
            logger.debug((Object)("Job[" + i + "]: " + string2 + "(" + string3 + ") Status: " + string4 + " Has_Child: " + string5));
            SAPChildJob sAPChildJob = sAPExecutableJob.getChild(string2, string3);
            if (sAPChildJob == null) continue;
            sAPChildJob.setJobStatus(SAPJobStatus.persistanceCodeToEnum(string4));
        }
    }

    private void deleteSAPJob(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy, SAPCommandResults sAPCommandResults) throws JCoException {
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobDelete(sAPConnection, sAPJobProxy);
        sAPConnection.executeMiddleFunction(jCoFunction);
        SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
        if (sAPReturnMessage.isError()) {
            String string = "SAP Error " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + sAPJobProxy.getNameAndCount() + " was not deleted. " + sAPReturnMessage.getMessageText();
            logger.error((Object)string);
            sAPCommandResults.addLogEntry("Error deleting SAP job " + sAPJobProxy.getNameAndCount());
            sAPCommandResults.addLogEntry(string);
        } else {
            String string = "SAP Job " + sAPJobProxy.getNameAndCount() + " was deleted.";
            logger.debug((Object)string);
            sAPCommandResults.addLogEntry(string);
        }
    }

    private void monitorSAPJob(SAPJobProxy sAPJobProxy, String string, long l, SAPConnection sAPConnection, SAPCommandResults sAPCommandResults, PrintWriter printWriter) throws JCoException {
        String string2 = "Monitoring SAP Job " + sAPJobProxy.getNameAndCount();
        logger.debug((Object)string2);
        this.writeToProcessMonitorLog(printWriter, string2);
        boolean bl = false;
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobStatusGet(sAPConnection, sAPJobProxy);
        String string3 = "Unknown";
        SAPJobStatus sAPJobStatus = null;
        String string4 = "";
        boolean bl2 = false;
        while (!bl) {
            SAPJobStatus sAPJobStatus2 = sAPJobStatus;
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                string2 = "Unable to obtain status of SAP job " + sAPJobProxy.getNameAndCount() + ".  " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + sAPReturnMessage.getMessageText();
                logger.warn((Object)string2);
                this.writeToProcessMonitorLog(printWriter, string2);
                if (sAPReturnMessage.getReturnID().equals("XM") && sAPReturnMessage.getReturnNumber() == 49) {
                    string2 = "SAP job " + sAPJobProxy.getNameAndCount() + " was deleted on the SAP system before it could start.";
                    this.writeToProcessMonitorLog(printWriter, string2);
                    sAPCommandResults.setSuccessful(false, string2, SAPCommandResults.SAPCommandExitCode.FAILURE);
                }
                bl = true;
                return;
            }
            string3 = jCoFunction.getExportParameterList().getString("STATUS");
            sAPJobStatus = SAPJobStatus.persistanceCodeToEnum(string3);
            sAPJobProxy.setJobStatus(sAPJobStatus);
            string4 = jCoFunction.getExportParameterList().getString("HAS_CHILD");
            if (sAPJobProxy.getJobStatus().isTerminal()) {
                bl = true;
            } else if (sAPJobStatus2 != sAPJobProxy.getJobStatus()) {
                string2 = "SAP Job " + sAPJobProxy.getNameAndCount() + " status = " + sAPJobStatus;
                logger.debug((Object)string2);
                this.writeToProcessMonitorLog(printWriter, string2);
                logger.debug((Object)("parentChildStatus = " + string4));
            }
            if (!bl && this.requestsToTerminateAL.contains(l) && !bl2) {
                string2 = "SAP Job " + sAPJobProxy.getNameAndCount() + " will be terminated.";
                logger.debug((Object)string2);
                this.writeToProcessMonitorLog(printWriter, string2);
                bl2 = true;
                try {
                    this.terminateSAPJob(sAPJobProxy, sAPConnection);
                }
                catch (EndJobException endJobException) {
                    if (endJobException.getReason().equals((Object)EndJobException.Reason.JOB_NOT_ACTIVE)) {
                        sAPCommandResults.addLogEntry("SAP Job " + sAPJobProxy.getNameAndCount() + " cannot be terminated in its current status.");
                        sAPCommandResults.addLogEntry("SAP Job " + sAPJobProxy.getNameAndCount() + " will be deleted before it starts.");
                        this.deleteSAPJob(sAPConnection, sAPJobProxy, sAPCommandResults);
                    }
                    sAPCommandResults.setSuccessful(false, "The SAP job " + sAPJobProxy.getNameAndCount() + " was deleted upon request from Automate Schedule.", SAPCommandResults.SAPCommandExitCode.FAILURE);
                    return;
                }
            }
            if (!bl) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.checkForAuditLevelChange(sAPConnection);
        }
        sAPJobProxy.setParentChildStatus(string4);
        string2 = "SAP Job " + sAPJobProxy.getNameAndCount() + " completed with status " + sAPJobStatus;
        logger.debug((Object)string2);
        this.writeToProcessMonitorLog(printWriter, string2);
        if (bl2) {
            sAPCommandResults.setSuccessful(false, "The SAP job " + sAPJobProxy.getNameAndCount() + " was canceled upon request from Automate Schedule.", SAPCommandResults.SAPCommandExitCode.FAILURE);
        } else if (sAPJobProxy.getJobStatus().equals(SAPJobStatus.CANCELLED)) {
            sAPCommandResults.setSuccessful(false, "The SAP job " + sAPJobProxy.getNameAndCount() + " was canceled on the SAP system.", SAPCommandResults.SAPCommandExitCode.FAILURE);
        } else if (sAPJobProxy.getJobStatus().equals(SAPJobStatus.INTERCEPTED)) {
            sAPCommandResults.setSuccessful(false, "The SAP job " + sAPJobProxy.getNameAndCount() + " was intercepted on the SAP system.", SAPCommandResults.SAPCommandExitCode.FAILURE);
        }
    }

    private void checkForAuditLevelChange(SAPConnection sAPConnection) throws JCoException {
        SAPXMIAuditLevel sAPXMIAuditLevel;
        if (xmiAuditLevelHM.containsKey(sAPConnection.getSapSystemDefinitionID()) && !(sAPXMIAuditLevel = xmiAuditLevelHM.get(sAPConnection.getSapSystemDefinitionID())).equals(sAPConnection.getXMIAuditLevel())) {
            sAPConnection.setXMIAuditLevel(sAPXMIAuditLevel);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionXMISetAuditLevel(sAPConnection);
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                logger.warn((Object)("Error setting XMI Audit Level to " + sAPConnection.getXMIAuditLevel() + ".  " + sAPReturnMessage.getReturnMessageIDAndNumber() + " " + sAPReturnMessage.getMessageText()));
            } else {
                logger.debug((Object)("XMI Audit Level Set to " + sAPConnection.getXMIAuditLevel()));
            }
        }
    }

    private void loadChildJobs(SAPExecutableJob sAPExecutableJob, String string, SAPConnection sAPConnection) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_CHILDREN_GET");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_CHILDREN_GET not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPExecutableJob.getJobCount());
        jCoFunction.getImportParameterList().setValue("JOBNAME", sAPExecutableJob.getJobName());
        jCoFunction.getImportParameterList().setValue("SELECTION", "AL");
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
        sAPConnection.executeMiddleFunction(jCoFunction);
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOB_CHILDREN");
        int n = jCoTable.getNumRows();
        logger.debug((Object)("Found " + n + " child jobs " + " for parent job " + sAPExecutableJob.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName()));
        for (int i = 0; i < n; ++i) {
            jCoTable.setRow(i);
            String string2 = jCoTable.getString("JOBNAME");
            String string3 = jCoTable.getString("JOBCOUNT");
            logger.debug((Object)("ChildJob[" + i + "]: " + string2 + "(" + string3 + ")"));
            SAPChildJob sAPChildJob = new SAPChildJob(sAPExecutableJob.getJobName(), string2, string3);
            sAPExecutableJob.addChildJob(sAPChildJob);
        }
    }

    private boolean terminateSAPJob(SAPJobProxy sAPJobProxy, SAPConnection sAPConnection) throws JCoException, EndJobException {
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobAbort(sAPConnection, sAPJobProxy);
        sAPConnection.executeMiddleFunction(jCoFunction);
        SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
        if (sAPReturnMessage.isError()) {
            String string = "Unable to terminate SAP job " + sAPJobProxy.getNameAndCount() + ". " + sAPReturnMessage.getFullReturnMessage();
            logger.debug((Object)string);
            EndJobException.Reason reason = EndJobException.Reason.OTHER;
            if (sAPReturnMessage.getReturnID().equals("XM") && sAPReturnMessage.getReturnNumber() == 55) {
                reason = EndJobException.Reason.JOB_NOT_ACTIVE;
            } else if (sAPReturnMessage.getReturnID().equals("XM") && sAPReturnMessage.getReturnNumber() == 49) {
                reason = EndJobException.Reason.JOB_DOES_NOT_EXIST;
            }
            throw new EndJobException(string, reason);
        }
        logger.info((Object)("Successfully canceled SAP Job " + sAPJobProxy.getNameAndCount()));
        return true;
    }

    private void terminateSAPProcessChain(SAPExecutableProcessChain sAPExecutableProcessChain, SAPConnection sAPConnection) throws JCoException, EndJobException {
        logger.info((Object)("About to terminate Process Chain " + sAPExecutableProcessChain.getNameAndLogID()));
        String string = sAPExecutableProcessChain.getLogID();
        int n = 5;
        int n2 = 0;
        boolean bl = false;
        while (!bl && n2 < n) {
            ++n2;
            this.loadSAPProcessChainProcesses(sAPConnection, sAPExecutableProcessChain);
            this.loadSAPJobNamesAndCounts(sAPConnection, sAPExecutableProcessChain);
            SAPProcess sAPProcess = null;
            Collection<SAPProcess> collection = sAPExecutableProcessChain.getSapProcessHM().values();
            Iterator<SAPProcess> iterator = collection.iterator();
            while (!bl && iterator.hasNext()) {
                sAPProcess = iterator.next();
                if (sAPProcess.getSapProcessStatus().equals("JOB_FINISHED")) continue;
                if (sAPProcess.getProcessType().equals("CHAIN")) {
                    String string2 = sAPProcess.getVariant();
                    String string3 = sAPProcess.getInstance();
                    SAPExecutableProcessChain sAPExecutableProcessChain2 = new SAPExecutableProcessChain();
                    sAPExecutableProcessChain2.setName(string2);
                    sAPExecutableProcessChain2.setLogID(string3);
                    if (sAPExecutableProcessChain2.getLogID().length() > 0) {
                        this.loadSAPProcessChainProcesses(sAPConnection, sAPExecutableProcessChain2);
                        this.loadSAPJobNamesAndCounts(sAPConnection, sAPExecutableProcessChain2);
                        logger.info((Object)("Attempting to cancel local Process Chain " + sAPExecutableProcessChain2.getNameAndLogID()));
                        Collection<SAPProcess> collection2 = sAPExecutableProcessChain2.getSapProcessHM().values();
                        Iterator<SAPProcess> iterator2 = collection2.iterator();
                        while (!bl && iterator2.hasNext()) {
                            SAPProcess sAPProcess2 = iterator2.next();
                            if (sAPProcess2.getSapProcessStatus().equals("JOB_FINISHED") || !(bl = this.terminateSAPJobInProcessChain(sAPConnection, sAPExecutableProcessChain2.getLogID(), sAPProcess2))) continue;
                        }
                    }
                }
                if (bl) continue;
                bl = this.terminateSAPJobInProcessChain(sAPConnection, string, sAPProcess);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!bl) {
            logger.warn((Object)("Failed to cancel Process Chain " + sAPExecutableProcessChain.getNameAndLogID() + " after 5 attempts.  See previous log messages."));
            throw new EndJobException("Failed to cancel Process Chain.", EndJobException.Reason.OTHER);
        }
        sAPExecutableProcessChain.setTerminated(true);
    }

    private boolean terminateSAPJobInProcessChain(SAPConnection sAPConnection, String string, SAPProcess sAPProcess) throws EndJobException {
        boolean bl = false;
        try {
            this.loadSAPProcessLog(sAPConnection, string, sAPProcess);
            SAPJobProxy sAPJobProxy = new SAPJobProxy(sAPProcess.getJobName(), sAPProcess.getJobCount());
            if (sAPJobProxy.getJobName() == null) {
                return false;
            }
            if (sAPJobProxy.getJobCount() == null) {
                return false;
            }
            int n = Integer.parseInt(sAPJobProxy.getJobCount());
            if (n == 0) {
                return false;
            }
            logger.debug((Object)("About to cancel SAP Job " + sAPJobProxy.getNameAndCount()));
            try {
                bl = this.terminateSAPJob(sAPJobProxy, sAPConnection);
            }
            catch (EndJobException endJobException) {
                if (endJobException.getReason().equals((Object)EndJobException.Reason.JOB_NOT_ACTIVE) || endJobException.getReason().equals((Object)EndJobException.Reason.JOB_DOES_NOT_EXIST)) {
                    return false;
                }
                throw endJobException;
            }
        }
        catch (JCoException jCoException) {
            throw new EndJobException("Error canceling SAP Job.", (Exception)((Object)jCoException));
        }
        return bl;
    }

    private void loadSAPProcessLog(SAPConnection sAPConnection, String string, SAPProcess sAPProcess) throws JCoException {
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionRSPCAPIProcessGetLog(sAPConnection);
        jCoFunction.getImportParameterList().setValue("I_LOGID", string);
        jCoFunction.getImportParameterList().setValue("I_TYPE", sAPProcess.getProcessType());
        jCoFunction.getImportParameterList().setValue("I_VARIANT", sAPProcess.getEventPStart());
        jCoFunction.getImportParameterList().setValue("I_INSTANCE", sAPProcess.getInstance());
        jCoFunction.getImportParameterList().setValue("I_JOBCOUNT", sAPProcess.getJobCount());
        sAPConnection.executeMiddleFunction(jCoFunction);
        String string2 = jCoFunction.getExportParameterList().getString("E_JOBNAME");
        String string3 = jCoFunction.getExportParameterList().getString("E_JOBCOUNT");
        String string4 = jCoFunction.getExportParameterList().getString("E_STATUS");
        sAPProcess.setJobName(string2);
        sAPProcess.setJobCount(string3);
        sAPProcess.setSapJobStatus(SAPJobStatus.persistanceCodeToEnum(string4));
    }

    private void loadSAPProcessChainProcesses(SAPConnection sAPConnection, SAPExecutableProcessChain sAPExecutableProcessChain) {
        String string = sAPExecutableProcessChain.getName();
        String string2 = sAPExecutableProcessChain.getLogID();
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionChainGetProcesses(sAPConnection);
            jCoFunction.getImportParameterList().setValue("I_CHAIN", string);
            jCoFunction.getImportParameterList().setValue("I_LOGID", string2);
            sAPConnection.executeMiddleFunction(jCoFunction);
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("E_T_PROCESSLIST");
            int n = jCoTable.getNumRows();
            for (int i = 0; i < n; ++i) {
                jCoTable.setRow(i);
                String string3 = jCoTable.getString("EVENTP_START");
                String string4 = jCoTable.getString("STATE");
                String string5 = jCoTable.getString("TYPE");
                String string6 = jCoTable.getString("VARIANTE");
                String string7 = jCoTable.getString("INSTANCE");
                String string8 = jCoTable.getString("JOB_COUNT");
                SAPProcessStatus sAPProcessStatus = SAPProcessStatus.persistanceCodeToEnum(string4);
                SAPProcess sAPProcess = new SAPProcess(string, string3, sAPProcessStatus, string5, string6, string7, string8);
                sAPExecutableProcessChain.addProcess(sAPProcess);
                logger.debug((Object)(sAPExecutableProcessChain.getName() + ": Added SAPProcess: " + sAPProcess));
            }
        }
        catch (JCoException jCoException) {
            logger.error((Object)("Error loading processes into Process Chain " + sAPExecutableProcessChain.getNameAndLogID()), (Throwable)jCoException);
        }
    }

    private void addABAPSteps(SAPConnection sAPConnection, SAPJob sAPJob, SAPABAPStepSet sAPABAPStepSet, PrintWriter printWriter, String string) throws JCoException {
        for (SAPABAPStep sAPABAPStep : sAPABAPStepSet.getStepList()) {
            Object object;
            Object object2;
            String string2 = "Adding Step: " + sAPABAPStep.getLineNumber() + "  ABAP Program: " + sAPABAPStep.getAbapProgramName();
            if (sAPABAPStep.getAbapProgramVariantName() != null && sAPABAPStep.getAbapProgramVariantName().length() > 0) {
                string2 = string2 + " Program Variant: " + sAPABAPStep.getAbapProgramVariantName();
            }
            logger.debug((Object)string2);
            this.writeToProcessMonitorLog(printWriter, string2);
            JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_ADD_ABAP_STEP");
            jCoFunction.getImportParameterList().setValue("JOBNAME", sAPJob.getJobName());
            jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPJob.getJobCount());
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
            jCoFunction.getImportParameterList().setValue("ABAP_PROGRAM_NAME", sAPABAPStep.getAbapProgramName());
            jCoFunction.getImportParameterList().setValue("ABAP_VARIANT_NAME", sAPABAPStep.getAbapProgramVariantName());
            jCoFunction.getImportParameterList().setValue("SAP_USER_NAME", sAPABAPStep.getSapUserName());
            jCoFunction.getImportParameterList().setValue("LANGUAGE", sAPABAPStep.getLanguageCode());
            string2 = "Language key on step set to " + sAPABAPStep.getLanguageCode();
            logger.debug((Object)string2);
            this.writeToProcessMonitorLog(printWriter, string2);
            if (sAPABAPStep.hasPrintParameters()) {
                logger.debug((Object)("*** The current step " + sAPABAPStep.getAbapProgramName() + " has print parameters."));
                try {
                    object2 = this.getSAPPrintParameters(sAPABAPStep.getPrintParametersID());
                    this.addPrintParametersToABAPStep(jCoFunction, (SAPAllPrintParameters)((Object)object2));
                    if (((SAPAllPrintParameters)((Object)object2)).isArchiving()) {
                        this.addArchiveParametersToABAPStep(jCoFunction, (SAPAllPrintParameters)((Object)object2));
                    }
                }
                catch (Exception exception) {
                    object = "Error adding print parameters to ABAP Step " + sAPABAPStep.getAbapProgramName();
                    logger.error((Object)((String)object + " for SAP job " + sAPJob.getNameAndCount()), (Throwable)exception);
                    throw new JCoException(126, (String)object, (Throwable)exception);
                }
            }
            sAPConnection.executeMiddleFunction(jCoFunction);
            object2 = jCoFunction.getExportParameterList().getString("STEP_NUMBER");
            logger.debug((Object)("abapStepNumber = " + (String)object2));
            object = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (!((SAPReturnMessage)object).isError()) continue;
            string2 = "Error adding ABAP Step " + sAPABAPStep.getAbapProgramName() + " with variant " + sAPABAPStep.getAbapProgramVariantName();
            logger.error((Object)string2);
            this.writeToProcessMonitorLog(printWriter, string2);
            string2 = "SAP Error: " + ((SAPReturnMessage)object).getFullReturnMessage();
            logger.error((Object)string2);
            this.writeToProcessMonitorLog(printWriter, string2);
            if (((SAPReturnMessage)object).getReturnID().equals("XM") && ((SAPReturnMessage)object).getReturnNumber() == 34) {
                string2 = "A parameter of the job has an illegal value. Open the system log on " + sAPConnection.getSapSystemDefinitionName() + " via transaction SM21 for " + "around the time the error occurred and locate BP_STEPLIST_EDITOR.";
                logger.error((Object)string2);
                this.writeToProcessMonitorLog(printWriter, string2);
            }
            logger.debug((Object)("bapiFunction.isAbapClassExceptionEnabled() = " + jCoFunction.isAbapClassExceptionEnabled()));
            SAPFunctionUtility.logExceptionDetails(jCoFunction, true);
            throw new JCoException(126, "Error adding ABAP Step " + sAPABAPStep.getAbapProgramName() + " to SAP job.");
        }
    }

    private void addPrintParametersToABAPStep(JCoFunction jCoFunction, SAPAllPrintParameters sAPAllPrintParameters) {
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("ALLPRIPAR");
        SAPAllPrintParameters.PrintParameterField printParameterField = SAPAllPrintParameters.PrintParameterField.PDEST;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRCOP;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        if (!sAPAllPrintParameters.getBooleanField(SAPAllPrintParameters.PrintParameterField.PRIMM)) {
            printParameterField = SAPAllPrintParameters.PrintParameterField.PLIST;
            jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
            this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        }
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRTXT;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRIMM;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getBooleanFieldAsString(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRREL;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getBooleanFieldAsString(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRNEW;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getBooleanFieldAsString(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PEXPI;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.LINCT;
        String string = (String)sAPAllPrintParameters.getField(printParameterField);
        if (string.length() > 0 && Integer.parseInt(string) != 0) {
            jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
            this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        }
        printParameterField = SAPAllPrintParameters.PrintParameterField.LINSZ;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PAART;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRBIG;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getBooleanFieldAsString(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRSAP;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRREC;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRABT;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRBER;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRDSN;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PTYPE;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.ARMOD;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRIOT;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.PRUNX;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getBooleanFieldAsString(printParameterField));
        this.logStructureValueSetting(jCoStructure, "ALLPRIPAR", printParameterField);
    }

    private void addArchiveParametersToABAPStep(JCoFunction jCoFunction, SAPAllPrintParameters sAPAllPrintParameters) {
        String string = "ALLARCPAR";
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure(string);
        SAPAllPrintParameters.PrintParameterField printParameterField = SAPAllPrintParameters.PrintParameterField.SAP_OBJECT;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, string, printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.AR_OBJECT;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, string, printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.INFO;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, string, printParameterField);
        printParameterField = SAPAllPrintParameters.PrintParameterField.ARCTEXT;
        jCoStructure.setValue(printParameterField.name(), sAPAllPrintParameters.getField(printParameterField));
        this.logStructureValueSetting(jCoStructure, string, printParameterField);
    }

    private void logStructureValueSetting(JCoStructure jCoStructure, String string, SAPField sAPField) {
        logger.debug((Object)(string + " field " + sAPField + " set to " + jCoStructure.getValue(sAPField.getName())));
    }

    @Override
    public void terminateCommand(long l) {
        logger.debug((Object)("Received notification to terminate the process for Automate Schedule event " + l));
        this.requestsToTerminateAL.add(l);
    }

    private SAPAllPrintParameters getSAPPrintParameters(long l) throws ResourceUnavailableException {
        try {
            return this.getSAPPrintParametersDM().get(l);
        }
        catch (BadDataException badDataException) {
            String string = this.constructBadDataDetails(badDataException.getErrorList());
            String string2 = MessageUtil.formatMsg((String)"Unable to construct SAPPrintParameters for ID {0} due to corrupt data.{1}", (Object[])new Object[]{l, string});
            throw new IllegalStateException(string2, badDataException);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining SAPPrintParameters for ID " + l, (Throwable)exception);
        }
    }

    private SAPPrintParametersDM getSAPPrintParametersDM() {
        if (this.sapPrintParametersDM == null) {
            this.sapPrintParametersDM = (SAPPrintParametersDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.SAPPrintParametersDM");
        }
        return this.sapPrintParametersDM;
    }

    private String constructBadDataDetails(ErrorList errorList) {
        String string = "";
        if (errorList != null) {
            string = string + " Details:";
            while (errorList.nextError()) {
                string = string + " " + errorList.getErrorText();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void xmiAuditLevelChange(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        logger.debug((Object)("Received notification XMI Audit Level is now " + sAPXMIAuditLevel + " for SAP System Definition ID " + l));
        HashMap<Long, SAPXMIAuditLevel> hashMap = xmiAuditLevelHM;
        synchronized (hashMap) {
            xmiAuditLevelHM.put(l, sAPXMIAuditLevel);
        }
    }

    private SAPConnection getSAPConnection(SAPExecutable sAPExecutable) throws ResourceUnavailableException {
        SAPSystemEnvironment sAPSystemEnvironment;
        SAPSystemDefinition sAPSystemDefinition;
        try {
            sAPSystemDefinition = sAPExecutable.getSapSystemDefinition();
            sAPSystemEnvironment = sAPExecutable.getSapSystemEnvironment();
            logger.debug((Object)("SAP System Definition(" + sAPSystemDefinition.getName() + ") Environment(" + sAPSystemEnvironment.getName() + ")  XBP Version(" + sAPSystemDefinition.getXbpVersion().persistanceCode() + ")"));
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining connection from SAP System Definition ID " + sAPExecutable.getSapSystemDefinitionID(), (Throwable)exception);
        }
        SAPSystem sAPSystem = new SAPSystem(sAPSystemDefinition, sAPSystemEnvironment);
        JCoDestination jCoDestination = this.getDestination(sAPSystem);
        SAPConnection sAPConnection = null;
        try {
            sAPConnection = new SAPConnection(jCoDestination, sAPSystem);
        }
        catch (JCoException jCoException) {
            String string = "Error connecting to SAP System " + sAPExecutable.getSAPSystemName();
            logger.error((Object)string, (Throwable)jCoException);
            throw new ResourceUnavailableException(string, (Throwable)jCoException);
        }
        return sAPConnection;
    }
}

