/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.sap.SAPConnectionType;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemEnvironment;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemDefinitionsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemEnvironmentsDM;
import com.helpsystems.enterprise.core.enums.AndOrSelection;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.filter.SAPSystemDefinitionReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPSystemDefinitionReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SAPSystemDefinitionReport
extends AbstractJasperReport
implements Serializable {
    private static final long serialVersionUID = -2691110603161712126L;
    public static final String REPORT_NAME = "SAPSystemDefinitionReport";
    public static final String HEADER_DATE = "HEADER_DATE";
    public static final String FIELD_GROUPING = "GROUPING";
    public static final String NAMEFIELD = "NAMEFIELD";
    public static final String VALUEFIELD = "VALUEFIELD";
    public static final String END_OF_REPORT = "END_OF_REPORT";
    public static final String NO_DATA_EXISTS = "NO_DATA_EXISTS";
    public static final String ONELINEFIELD = "ONELINEFIELD";
    private static final Logger logger = Logger.getLogger(SAPSystemDefinitionReport.class);
    private SAPSystemDefinitionReportFilter filter = new SAPSystemDefinitionReportFilter();
    private Long[] sapSystemDefListToShow;
    private SAPSystemDefinitionsDM sapSystemDefinitionsDM;
    private SAPSystemEnvironmentsDM sapSystemEnvironmentsDM;
    final Map<String, Object> parentParams = new HashMap<String, Object>();

    public SAPSystemDefinitionReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.sapSystemDefinitionsDM = (SAPSystemDefinitionsDM)ManagerRegistry.getManager((String)"ENTERPRISE.SAPSystemDefinitionsDM");
        this.sapSystemEnvironmentsDM = (SAPSystemEnvironmentsDM)ManagerRegistry.getManager((String)"ENTERPRISE.SAPSystemEnvironmentsDM");
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
    }

    @Override
    public int getReportID() {
        return 0;
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    JasperReportData buildReportData() throws ReportException {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SAPSystemDefinitionReport.createReportDataBuilder();
        String[] stringArray = this.filter.getDefinitionNameList();
        String[] stringArray2 = this.filter.getTags();
        boolean bl = this.filter.isSelectedAllUntaggedSSD();
        AndOrSelection andOrSelection = this.filter.getObjectsAndOrSelection();
        this.sapSystemDefListToShow = this.reportDM.getSAPSystemDefinitionIdList(stringArray, stringArray2, bl, andOrSelection);
        this.parentParams.put(HEADER_DATE, ReportHelper.getFormatedDate(new Date()));
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.parentParams.put("REPORT_NAME", REPORT_NAME);
        try {
            this.buildTableOfContentData(reportDataBuilder);
            this.buildParameterReport(this.parentParams);
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
        if (this.sapSystemDefListToShow.length == 0) {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue(NO_DATA_EXISTS, "No SAP NetWeaver\u00ae System Definition  records.");
        } else {
            for (int i = 0; i < this.sapSystemDefListToShow.length; ++i) {
                this.buildData(reportDataBuilder, this.sapSystemDefListToShow[i]);
            }
            reportDataBuilder.setFieldValue(END_OF_REPORT, "*** End of Report ***");
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"SAP System Definition Report has been built.");
        return jasperReportData;
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (this.isEqualToKey(string) || string.equals("-") || !string.startsWith("-")) continue;
            String string2 = string.replaceAll("-", "val_");
            objectArray[i] = string2;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return false;
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        SAPSystemDefinitionReportFilterParser sAPSystemDefinitionReportFilterParser = new SAPSystemDefinitionReportFilterParser();
        sAPSystemDefinitionReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SAPSystemDefinitionReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    private void buildTableOfContentData(AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap hashMap = new HashMap();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPSystemDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        for (int i = 0; i < this.sapSystemDefListToShow.length; ++i) {
            try {
                SAPSystemDefinition sAPSystemDefinition = this.sapSystemDefinitionsDM.get(this.sapSystemDefListToShow[i]);
                String string = sAPSystemDefinition.getName();
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, string);
                continue;
            }
            catch (NoDataException noDataException) {
                // empty catch block
            }
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.TABLE_OF_CONTENT.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The Table of Content data has been built.");
    }

    private void buildGeneralData(SAPSystemDefinition sAPSystemDefinition, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPSystemDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.GENERAL.name());
        reportDataBuilder.setFieldValue("SAP_SYSTEM_DEFINITION_NAME", sAPSystemDefinition.getName());
        hashMap.put("HEADER_NAME", sAPSystemDefinition.getName());
        hashMap.put("JLR_SUB_TITLE", "General");
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Name:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getName());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Description:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getDescription());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Tags:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, this.reportDM.getTagsBySapSystemDefinitionID(sAPSystemDefinition.getOID()));
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Connection Type:");
        if (sAPSystemDefinition.getConnectionType() == SAPConnectionType.CUSTOM_APPLICATION_SERVER.persistanceCode().intValue()) {
            reportDataBuilder2.setFieldValue(VALUEFIELD, "Custom Application Server");
        } else {
            reportDataBuilder2.setFieldValue(VALUEFIELD, "Group/Server Selection");
        }
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Message Server:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getMessageServer());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Group/Server");
        reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getGroupOrServer());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Application Server:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getAshost());
        reportDataBuilder2.nextRow();
        String string = sAPSystemDefinition.getSystemNumber();
        if (string == null) {
            string = "00";
        }
        while (string.length() < 2) {
            string = "0" + string;
        }
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Instance Number:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, string);
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "System ID:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getR3name());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Router(s):");
        reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getRouter());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The general report data has been built.");
    }

    private void buildInterceptedJobSettingsData(SAPSystemDefinition sAPSystemDefinition, AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPSystemDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.INTERCEPTED_JOB_SETTINGS.name());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(ONELINEFIELD, "Poll System for Intercepted Jobs");
        hashMap.put("JLR_SUB_TITLE", "Intercepted Job Settings");
        boolean bl = sAPSystemDefinition.isPollInterceptedJobs();
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Enabled:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, bl);
        if (bl) {
            int n = sAPSystemDefinition.getPollInterceptIntervalSeconds();
            int n2 = n / 3600;
            int n3 = n / 60 % 60;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Hours:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, n2);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Minutes:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, n3);
        }
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Agent Environment has been built.");
    }

    private void buildPolledJobsSettingsData(SAPSystemDefinition sAPSystemDefinition, AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPSystemDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.POLLED_JOBS_SETTINGS.name());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(ONELINEFIELD, "Poll System for Jobs");
        hashMap.put("JLR_SUB_TITLE", "Polled Jobs Settings");
        boolean bl = sAPSystemDefinition.isPollJobs();
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Enabled:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, bl);
        if (bl) {
            int n = sAPSystemDefinition.getPollJobIntervalSeconds();
            int n2 = n / 3600;
            int n3 = n / 60 % 60;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Hours:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, n2);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Minutes:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, n3);
        }
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Agent Environment has been built.");
    }

    private void buildXbpLevelData(SAPSystemDefinition sAPSystemDefinition, AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPSystemDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.XBP_LEVEL.name());
        reportDataBuilder2.nextRow();
        hashMap.put("JLR_SUB_TITLE", "XBP Level");
        reportDataBuilder2.setFieldValue(NAMEFIELD, "XBP Version:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getXbpVersion().persistanceCode());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Agent Environment has been built.");
    }

    private void buildXmiAuditLevelData(SAPSystemDefinition sAPSystemDefinition, AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPSystemDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.XMI_AUDIT_LEVEL.name());
        reportDataBuilder2.nextRow();
        hashMap.put("JLR_SUB_TITLE", "XMI Audit Level");
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Level:");
        String string = sAPSystemDefinition.getXMIAuditLevel().toString();
        switch (sAPSystemDefinition.getXMIAuditLevel()) {
            case CHANGE_0: {
                string = "0 - Records data write (change) operations";
                break;
            }
            case READ_ERRORS_1: {
                string = "1 - Records data read errors";
                break;
            }
            case READ_OPERATIONS_2: {
                string = "2 - Records data read operations";
                break;
            }
            case EXTERNAL_ACCESS_3: {
                string = "3 - Records external management system access";
            }
        }
        reportDataBuilder2.setFieldValue(VALUEFIELD, string);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of job Agent Environment has been built.");
    }

    private void buildSystemEnvironmentSettingsData(SAPSystemDefinition sAPSystemDefinition, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws NoDataException, BadDataException, ResourceUnavailableException {
        List<SAPSystemEnvironment> list = this.sapSystemEnvironmentsDM.getBySystemDefinition(sAPSystemDefinition.getOID());
        long l = sAPSystemDefinition.getDefaultEnvironmentID();
        SAPSystemEnvironment sAPSystemEnvironment = this.sapSystemEnvironmentsDM.get(l);
        ArrayList<SAPSystemEnvironment> arrayList = new ArrayList<SAPSystemEnvironment>();
        arrayList.add(sAPSystemEnvironment);
        for (SAPSystemEnvironment sAPSystemEnvironment2 : list) {
            if (sAPSystemEnvironment2.equals(sAPSystemEnvironment)) continue;
            arrayList.add(sAPSystemEnvironment2);
        }
        for (SAPSystemEnvironment sAPSystemEnvironment2 : arrayList) {
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPSystemDefinitionReport.createReportDataBuilder();
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.DEFAULT_SYSTEM_ENVIRONMENT_SETTINGS.name());
            reportDataBuilder2.nextRow();
            hashMap.put("JLR_SUB_TITLE", "System Environment:" + sAPSystemEnvironment2.getName());
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Name:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemEnvironment2.getName());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Description:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemEnvironment2.getDescription());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Tags:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, this.reportDM.getTagsBySAPSystemEnvironmentID(sAPSystemEnvironment2.getOID()));
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Client Code:");
            String string2 = sAPSystemEnvironment2.getClientCode();
            if (string2 == null) {
                string2 = "000";
            }
            while (string2.length() < 3) {
                string2 = "0" + string2;
            }
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemEnvironment2.getClientCode());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Language:");
            String string3 = string = sAPSystemEnvironment2.getLanguageCode();
            string3 = "EN".equals(string) ? "English" : "Deutsch";
            reportDataBuilder2.setFieldValue(VALUEFIELD, string3);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Username:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemEnvironment2.getSapUserName());
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        }
        logger.trace((Object)"The report data of SAP System Environment has been built.");
    }

    private void buildSLDRegistrationData(SAPSystemDefinition sAPSystemDefinition, AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPSystemDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.SLD_REGISTRATION.name());
        hashMap.put("JLR_SUB_TITLE", "SLD Registration Information");
        boolean bl = sAPSystemDefinition.getRegisteredWithSLDMS() != 0L;
        String string2 = string = sAPSystemDefinition.isSLDEnabled() && bl ? "Yes" : "No";
        if (bl) {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Register:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, string);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "SLD Registered:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, new Date(sAPSystemDefinition.getRegisteredWithSLDMS()));
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Local System Name:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getSLDLocalSystemName());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Computer name:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getSLDComputerName());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Host:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getSLDHost());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Port:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getSLDPort());
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Username:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, sAPSystemDefinition.getSLDUser());
        } else {
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, "Register:");
            reportDataBuilder2.setFieldValue(VALUEFIELD, string);
        }
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
    }

    private void buildData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, long l) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = reportDataBuilder;
        try {
            SAPSystemDefinition sAPSystemDefinition = this.sapSystemDefinitionsDM.get(l);
            this.buildGeneralData(sAPSystemDefinition, reportDataBuilder2);
            this.buildInterceptedJobSettingsData(sAPSystemDefinition, reportDataBuilder2);
            this.buildPolledJobsSettingsData(sAPSystemDefinition, reportDataBuilder2);
            this.buildXbpLevelData(sAPSystemDefinition, reportDataBuilder2);
            this.buildXmiAuditLevelData(sAPSystemDefinition, reportDataBuilder2);
            this.buildSLDRegistrationData(sAPSystemDefinition, reportDataBuilder2);
            this.buildSystemEnvironmentSettingsData(sAPSystemDefinition, reportDataBuilder2);
            logger.trace((Object)("SAP System Definition Report for SAP System Definition " + sAPSystemDefinition.getName() + " has been built."));
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
    }

    private static enum Groupings {
        TABLE_OF_CONTENT,
        GENERAL,
        SECURE_NETWORK_SETTINGS,
        INTERCEPTED_JOB_SETTINGS,
        POLLED_JOBS_SETTINGS,
        XBP_LEVEL,
        XMI_AUDIT_LEVEL,
        DEFAULT_SYSTEM_ENVIRONMENT_SETTINGS,
        SLD_REGISTRATION;

    }
}

