/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.LanguageCode;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStep;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStepSet;
import com.helpsystems.enterprise.core.busobj.sap.SAPLanguageKeys;
import com.helpsystems.enterprise.core.dm.LanguageCodesDM;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.sap.SAPABAPStepSetsDM;
import com.helpsystems.enterprise.core.enums.AndOrSelection;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.filter.SAPJobDefinitionReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPJobDefinitionReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.module.reports.jasper.SAPReportHelper;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SAPJobDefinitionReport
extends AbstractJasperReport
implements Serializable {
    private static final long serialVersionUID = -1279921928557717157L;
    public static final String HEADER_DATE = "HEADER_DATE";
    public static final String REPORT_NAME = "SAPJobDefinitionReport";
    public static final String FIELD_SHOW_COLUMN_BACK_COLOR = "SHOW_COLUMN_BACK_COLOR";
    private LanguageCodesDM languageCodesDM;
    private SAPABAPStepSetsDM sapAbapStepSetsDM;
    private static final Logger logger = Logger.getLogger(SAPJobDefinitionReport.class);
    private SAPJobDefinitionReportFilter filter = new SAPJobDefinitionReportFilter();
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    public static final String NAMEFIELD = "NAMEFIELD";
    public static final String VALUEFIELD = "VALUEFIELD";
    public static final String FIELD_GROUPING = "GROUPING";
    public static final String END_OF_REPORT = "END_OF_REPORT";
    public static final String ONELINEFIELD = "ONELINEFIELD";

    public SAPJobDefinitionReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
        this.languageCodesDM = (LanguageCodesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.LanguageCodesDM");
        this.sapAbapStepSetsDM = (SAPABAPStepSetsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPABAPStepSetsDM");
    }

    @Override
    public int getReportID() {
        return 0;
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    JasperReportData buildReportData() {
        JasperReportData jasperReportData = new JasperReportData();
        try {
            int n;
            AbstractJasperReport.ReportDataBuilder reportDataBuilder = SAPJobDefinitionReport.createReportDataBuilder();
            String[] stringArray = this.filter.getDefinitionNameList();
            String[] stringArray2 = this.filter.getAbapStepSetNameList();
            String[] stringArray3 = this.filter.getAbapProgramNameList();
            String[] stringArray4 = this.filter.getJobDefNameList();
            String[] stringArray5 = this.filter.getTags();
            boolean bl = this.filter.isSelectedAllUntaggedSJDs();
            AndOrSelection andOrSelection = this.filter.getObjectsAndOrSelection();
            SAPJobDefinitionReportFilter.Environment[] environmentArray = this.filter.getEnvironmentList();
            int n2 = environmentArray.length;
            String[] stringArray6 = new String[n2];
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < n2; ++n) {
                stringArray6[n] = environmentArray[n].getEnvName();
                hashSet.add(environmentArray[n].getDefName());
            }
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
            String[] stringArray7 = hashSet.toArray(new String[hashSet.size()]);
            this.parentParams.put("HEADER_REPORT_NAME", REPORT_NAME);
            this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
            this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
            this.parentParams.put("TITLE_SAP_JOB_DEFINITION_REPORT", "SAP NetWeaver\u00ae Job Definition Report");
            this.parentParams.put(HEADER_DATE, ReportHelper.getFormatedDate(new Date()));
            this.parentParams.put("REPORT_NAME", REPORT_NAME);
            this.buildParameterReport(this.parentParams);
            ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getSapJobDefinitionList(stringArray2, stringArray3, stringArray7, stringArray6, stringArray5, stringArray4, bl, andOrSelection);
            this.buildTableOfContentData(reportDataBuilder, arrayList);
            if (arrayList != null && !arrayList.isEmpty()) {
                this.parentParams.put("DATA_EXISTS", new Boolean(true));
                for (int i = 0; i < arrayList.size(); ++i) {
                    Map map = (Map)arrayList.get(i);
                    this.buildJLRData(reportDataBuilder, map);
                    this.log("The SAP job definition Data List has been built.");
                }
                reportDataBuilder.setFieldValue(END_OF_REPORT, "*** End of Report ***");
            } else {
                this.parentParams.put("DATA_EXISTS", new Boolean(false));
            }
            jasperReportData.setParameters(this.parentParams);
            jasperReportData.setData(reportDataBuilder.toJRDataSource());
            this.log("The SAP job definition Data List has been built");
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
        return jasperReportData;
    }

    private void buildTableOfContentData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, List<HashMap<String, Object>> list) throws DataException, ResourceUnavailableException {
        HashMap hashMap = new HashMap();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPJobDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        for (HashMap<String, Object> hashMap2 : list) {
            String string = "JOB_DEFINITION_NAME";
            String string2 = (String)hashMap2.get(string);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, string2);
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.TABLE_OF_CONTENT.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The Table of Content data has been built.");
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (this.isEqualToKey(string) || string.equals("-") || !string.startsWith("-")) continue;
            String string2 = string.replaceAll("-", "val_");
            objectArray[i] = string2;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return false;
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        SAPJobDefinitionReportFilterParser sAPJobDefinitionReportFilterParser = new SAPJobDefinitionReportFilterParser();
        sAPJobDefinitionReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SAPJobDefinitionReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    private void buildJLRData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, Map<String, Object> map) throws DataException, ResourceUnavailableException {
        this.buildGeneralJLRData(reportDataBuilder, map);
        this.buildStepsJLRData(reportDataBuilder, map);
    }

    private void buildGeneralJLRData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, Map<String, Object> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPJobDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        String string = "JOB_DEFINITION_NAME";
        String string2 = (String)map.get(string);
        reportDataBuilder.setFieldValue(string, string2);
        hashMap.put("HEADER_NAME", string2);
        hashMap.put("JLR_SUB_TITLE", "General");
        SAPReportHelper.addRowWithTwoColumns("Name:", string2, reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("Description:", (String)map.get("JOB_DEFINITION_DESC"), reportDataBuilder2);
        String string3 = this.reportDM.getTagsBySAPJobDefinitionID((Long)map.get("JOB_DEFINITION_ID"));
        SAPReportHelper.addRowWithTwoColumns("Tags:", string3, reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("System Definition:", (String)map.get("SYSTEM_DEFINITION_NAME"), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("System Environment:", (String)map.get("ENVIRONMENT_NAME"), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("Job Class:", (String)map.get("SAP_JOB_CLASS"), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("Exec. Target:", (String)map.get("SAP_EXEC_TARGET"), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("Recipient Type:", (String)map.get("RECIPIENT_TYPE"), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("Send Confirmation:", (String)map.get("SEND_CONFIRMATION"), reportDataBuilder2);
        String string4 = (String)map.get("SAP_SPOOL_LIST_RECP");
        SAPReportHelper.addRowWithTwoColumns("Spool List Recipient:", string4, reportDataBuilder2);
        String string5 = this.getRecipientAttributes((String)map.get("RECIPIENT_ATTRIBUTES"), (String)map.get("RECIPIENT_TYPE"));
        if (string5 != null && !string5.isEmpty()) {
            SAPReportHelper.addRowWithTwoColumns("Recipient Attributes:", string5, reportDataBuilder2);
        } else {
            SAPReportHelper.addRowWithTwoColumns("Recipient Attributes:", "", reportDataBuilder2);
        }
        SAPReportHelper.addRowWithTwoColumns("Start Immediately:", (String)map.get("START_IMMEDIATELY"), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("Wait For Child Jobs:", (String)map.get("WAIT_FOR_CHILD"), reportDataBuilder2);
        reportDataBuilder.setFieldValue(FIELD_GROUPING, (Object)Groupings.GENERAL);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
    }

    private void buildStepsJLRData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, Map<String, Object> map) throws DataException, ResourceUnavailableException {
        long l = (Long)map.get("ABAP_STEP_SET_ID");
        SAPABAPStepSet sAPABAPStepSet = this.sapAbapStepSetsDM.get(l, null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPJobDefinitionReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Steps");
        String string = "Shared Abap Step Set is not used";
        if (sAPABAPStepSet.getStepSetType() == SAPABAPStepSet.SAPABAPStepSetType.SHARED) {
            string = "Using Shared Abap Step Set - " + sAPABAPStepSet.getName();
        }
        SAPReportHelper.addOnelineField(string, reportDataBuilder2);
        ArrayList<SAPABAPStep> arrayList = sAPABAPStepSet.getStepList();
        int n = 0;
        for (SAPABAPStep sAPABAPStep : arrayList) {
            if (n != 0) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "");
                reportDataBuilder2.setFieldValue(FIELD_SHOW_COLUMN_BACK_COLOR, new Boolean(true));
            }
            String string2 = SAPLanguageKeys.getISOCodeForKey(sAPABAPStep.getLanguageCode());
            LanguageCode languageCode = this.languageCodesDM.getForCode(string2);
            SAPReportHelper.buildAbapStepSection(reportDataBuilder2, sAPABAPStep, languageCode);
            SAPReportHelper.buildPrintParamReportSection(reportDataBuilder2, this.reportDM, sAPABAPStep);
            ++n;
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.STEPS.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of sap abap step set steps has been built!");
    }

    private String getRecipientAttributes(String string, String string2) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "Copy");
        hashMap.put(2, "Express");
        hashMap.put(4, "Blind Copy");
        hashMap.put(6, "No Forwarding");
        String string3 = "";
        for (Map.Entry entry : hashMap.entrySet()) {
            int n = (Integer)entry.getKey();
            if (n == 6 && string2.equals("Email Address") || string.charAt(n) != '1') continue;
            string3 = string3 + (String)entry.getValue() + ", ";
        }
        if (string3 != "") {
            string3 = string3.substring(0, string3.length() - 2);
        }
        return string3;
    }

    private static enum Groupings {
        TABLE_OF_CONTENT,
        GENERAL,
        STEPS;

    }
}

