/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.JobMonitorHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.JobMonitorHistoryReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportBuilder;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobMonitorHistoryReport
extends AbstractJasperReport
implements Serializable {
    private JobMonitorHistoryReportFilter filter = new JobMonitorHistoryReportFilter();
    private static final long serialVersionUID = -871313742802236807L;
    private static final String ALL_JOBS = "All Jobs";
    public static final String REPORT_NAME = "JobMonitorHistoryReport";
    private static final Logger logger = Logger.getLogger(JobMonitorHistoryReport.class);
    private List<String> jobList = new ArrayList<String>();
    private List<String> agentList = new ArrayList<String>();
    private List<String> tagList = new ArrayList<String>();
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    private static final String AGENTS = "-agents";
    private static final String AGENT_GROUPS = "-agentGroups";
    private static final String TAGS = "-tags";
    private static final String USER_NAME = "-userName";
    private static final String DATE_RANGE = "-dateRange";
    private static final String END_DATE_DURATION = "-endDateDuration";
    private static final String START_DATE_DURATION = "-startDateDuration";
    private static final String MONITOR_TYPES = "-monitorTypes";
    private static final String JOB_NAMES = "-jobNames";
    private static final String JOB_IDS = "-jobIds";
    private static final String MONITOR_TYPES_IDS = "-monitorTypeIds";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    public JobMonitorHistoryReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
    }

    @Override
    JasperReportData buildReportData() {
        Object object;
        Long l = this.filter.getFromDate();
        Long l2 = this.filter.getToDate();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = JobMonitorHistoryReport.createReportDataBuilder();
        this.parentParams.put("HEADER_REPORT_NAME", REPORT_NAME);
        this.parentParams.put("HEADER_FROM_DATE", ReportHelper.getStartDate(l));
        this.parentParams.put("HEADER_TO_DATE", ReportHelper.getEndDate(l2));
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.jobList.add(ALL_JOBS);
        this.agentList.add(ALL_JOBS);
        this.tagList.add(ALL_JOBS);
        this.parentParams.put("TITLE_JOB_LIST", this.jobList);
        this.parentParams.put("TITLE_AGENT_LIST", this.agentList);
        this.parentParams.put("TITLE_TAG_LIST", this.tagList);
        try {
            this.buildParameterReport();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Could not build report parameters in title page", (Throwable)resourceUnavailableException);
        }
        catch (DataException dataException) {
            logger.error((Object)"Could not build report parameters in title page", (Throwable)dataException);
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("GROUPING", "HISTORY_LIST");
        ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getJobMonitorEventsData(this.filter);
        if (arrayList != null && !arrayList.isEmpty()) {
            this.parentParams.put("DATA_EXISTS", new Boolean(true));
            object = new ReportBuilder();
            ((ReportBuilder)object).buildJobMonitorHistoryTable(arrayList, false);
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", ((ReportBuilder)object).getParams());
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", ((ReportBuilder)object).getJRDataSource());
            this.log("The Job Monitor History Data List has been built.");
            reportDataBuilder.nextRow();
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        object = new JasperReportData();
        ((JasperReportData)object).setParameters(this.parentParams);
        ((JasperReportData)object).setData(reportDataBuilder.toJRDataSource());
        this.log("Job Monitor History Report data has been built.");
        return object;
    }

    private String buildParameterReport() throws DataException, ResourceUnavailableException {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = JobMonitorHistoryReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(this.parentParams, reportDataBuilder, this.filter);
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        JobMonitorHistoryReportFilterParser jobMonitorHistoryReportFilterParser = new JobMonitorHistoryReportFilterParser();
        this.replaceIfNotAKey(objectArray);
        jobMonitorHistoryReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals(DATE_RANGE) || string.equals(AGENTS) || string.equals(AGENT_GROUPS) || string.equals(TAGS) || string.equals(END_DATE_DURATION) || string.equals(START_DATE_DURATION) || string.equals(MONITOR_TYPES) || string.equals(USER_NAME) || string.equals(JOB_NAMES) || string.equals(JOB_IDS) || string.equals(MONITOR_TYPES_IDS) || string.equals("-f");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.JOB_MONITOR_HISTORY_REPORT.getReportID();
    }
}

