/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentStatusAM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.SchedulerStatusAM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.ReportRecordLimit;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.GoodMorningReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.GoodMorningReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportBuilder;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GoodMorningReport
extends AbstractJasperReport
implements Serializable {
    private static final long serialVersionUID = -434559359345989112L;
    public static final String REPORT_NAME = "GoodMorningReport";
    private static final Logger logger = Logger.getLogger(GoodMorningReport.class);
    private GoodMorningReportFilter filter = new GoodMorningReportFilter();
    private AgentDM agent;
    private JobHistoryDM jobHistory;
    private JobQueuesDM jobQueues;
    private AgentStatusAM agentStatusAM;
    private EnterpriseServerAM enterpriseServerAM;
    private SchedulerStatusAM schedulerStatusAM;
    private static final String TITLE_SCHEDULER_STATUS = "TITLE_SCHEDULER_STATUS";
    private static final String TITLE_COUNT_AGENT_QUEUES_LOCKED = "TITLE_COUNT_AGENT_QUEUES_LOCKED";
    private static final String TITLE_COUNT_OFFLINE_AGENTS = "TITLE_COUNT_OFFLINE_AGENTS";
    private static final String TITLE_COUNT_UNLICENSED_AGENTS = "TITLE_COUNT_UNLICENSED_AGENTS";
    private static final String TITLE_COUNT_HELD_JOB_QUEUES = "TITLE_COUNT_HELD_JOB_QUEUES";
    private static final String TITLE_COUNT_JOBS_ENDED_NORMALLY = "TITLE_COUNT_JOBS_ENDED_NORMALLY";
    private static final String TITLE_COUNT_JOBS_ENDED_ABNORMALLY = "TITLE_COUNT_JOBS_ENDED_ABNORMALLY";
    private static final String TITLE_COUNT_JOBS_MANAGED = "TITLE_COUNT_JOBS_MANAGED";
    private static final String TITLE_COUNT_JOBS_QUEUED = "TITLE_COUNT_JOBS_QUEUED";
    private static final String TITLE_COUNT_JOBS_SKIPPED = "TITLE_COUNT_JOBS_SKIPPED";
    private static final String TITLE_TOTAL_JOBS = "TITLE_TOTAL_JOBS";
    private static final String TITLE_COUNT_JOBS_LATE_START_EVENTS = "TITLE_COUNT_JOBS_LATE_START_EVENTS";
    private static final String TITLE_COUNT_JOBS_OVERRUN_EVENTS = "TITLE_COUNT_JOBS_OVERRUN_EVENTS";
    private static final String TITLE_COUNT_JOBS_UNDERRUN_EVENTS = "TITLE_COUNT_JOBS_UNDERRUN_EVENTS";
    private static final String TITLE_TOTAL_JOBS_EVENTS = "TITLE_TOTAL_JOBS_EVENTS";
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    private static final String USER_NAME = "-userName";
    private static final String DATE_RANGE = "-dateRange";
    private static final String END_DATE_DURATION = "-endDateDuration";
    private static final String START_DATE_DURATION = "-startDateDuration";
    private static final String JOB_IDS = "-jobIds";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    public GoodMorningReport() {
    }

    public GoodMorningReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
    }

    @Override
    JasperReportData buildReportData() {
        Long l = this.filter.getFromDate();
        Long l2 = this.filter.getToDate();
        this.agent = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        this.jobHistory = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        this.jobQueues = (JobQueuesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuesDM");
        this.enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseServerAM");
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
        this.agentStatusAM = (AgentStatusAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentStatusAM");
        this.schedulerStatusAM = (SchedulerStatusAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SchedulerStatusAM");
        String string = "Building report data for " + this.getReportName();
        logger.debug((Object)string);
        this.log(string);
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = GoodMorningReport.createReportDataBuilder();
        try {
            this.parentParams.put("HEADER_FROM_DATE", ReportHelper.getStartDate(l));
            this.parentParams.put("HEADER_TO_DATE", ReportHelper.getEndDate(l2));
            this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
            this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
            Object object = null;
            if (object instanceof AbstractJasperReport.ReportDataBuilder) {
                object.toString();
            }
            this.buildParameterReport(this.parentParams);
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("GROUPING", Groupings.SUMMARY_DATA.name());
            this.buildSummaryDataReport(reportDataBuilder);
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("GROUPING", Groupings.ABNORMAL_JOB_LIST.name());
            boolean bl = this.filter.isLimitedHistory();
            this.buildAbnormalJobListReportData(reportDataBuilder, l, l2, bl);
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("GROUPING", Groupings.JOB_MONITOR_EVENTS.name());
            this.buildJobMonitorEventsReportData(reportDataBuilder, l, l2);
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("GROUPING", Groupings.MANUALLY_MANAGED_JOBS.name());
            String string2 = this.buildManuallyManagedJobsReportData(reportDataBuilder, l, l2);
            logger.trace((Object)string2);
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("GROUPING", Groupings.OFFLINE_AGENT_LIST.name());
            String string3 = this.buildOfflineAgentsReportData(reportDataBuilder);
            logger.trace((Object)string3);
            JasperReportData jasperReportData = new JasperReportData();
            jasperReportData.setParameters(this.parentParams);
            jasperReportData.setData(reportDataBuilder.toJRDataSource());
            logger.trace((Object)"Good Morning Report data has been built.");
            return jasperReportData;
        }
        catch (Exception exception) {
            logger.error((Object)"An error occured creating the Good Morning Report.", (Throwable)exception);
            return null;
        }
    }

    private int getUnlicensedAgentsCount() throws DataException, ResourceUnavailableException {
        AgentProxy[] agentProxyArray;
        int n = 0;
        for (AgentProxy agentProxy : agentProxyArray = this.agentStatusAM.getStatus(this.agent.getList())) {
            if (agentProxy.getLicenseAllocated() || agentProxy.getLicenseStatus().getLicenseState() == 2) continue;
            ++n;
        }
        return n;
    }

    private void buildJobMonitorEventsReportData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, long l, long l2) {
        ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getJobMonitorEventsDataInPeriod(l, l2);
        if (arrayList.isEmpty()) {
            this.parentParams.put("JOB_MONITOR_EVENTS_DATA_EXISTS", new Boolean(false));
            this.log("No Job Monitor Events were found to build a list for in the time period specified.");
            return;
        }
        this.parentParams.put("JOB_MONITOR_EVENTS_DATA_EXISTS", new Boolean(true));
        ReportBuilder reportBuilder = new ReportBuilder();
        reportBuilder.buildJobMonitorHistoryTable(arrayList, true);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", reportBuilder.getParams());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportBuilder.getJRDataSource());
        logger.trace((Object)"The report data of job event monitor list has been built.");
    }

    private String buildManuallyManagedJobsReportData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, long l, long l2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = GoodMorningReport.createReportDataBuilder();
        boolean bl = true;
        this.parentParams.put("MANUALLY_MANAGED_JOBS_DATA_EXISTS", new Boolean(false));
        ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getByManuallyManagedJobsInPeriod(l, l2);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            HashMap<String, Object> hashMap2 = arrayList.get(i);
            if (bl) {
                this.parentParams.put("MANUALLY_MANAGED_JOBS_DATA_EXISTS", new Boolean(true));
                bl = false;
            }
            reportDataBuilder2.nextRow();
            int n2 = ReportRecordLimit.getReportRowLimit(Reports.ReportType.GOOD_MORNING_REPORT);
            if (i == n2) {
                object = ReportHelper.getRowLimitMessage(n2, n, "Manage Missed Jobs");
                reportDataBuilder2.setFieldValue("ONELINEFIELD", object);
                break;
            }
            hashMap.put("JOB_RUN_NUMBER", "Job Run Number");
            reportDataBuilder2.setFieldValue("JOB_RUN_NUMBER", hashMap2.get("JOB_RUN_NUMBER"));
            hashMap.put("JOB_NAME", "Job Name");
            reportDataBuilder2.setFieldValue("JOB_NAME", hashMap2.get("JOB_NAME"));
            hashMap.put("JOB_DESC", "Description");
            reportDataBuilder2.setFieldValue("JOB_DESC", hashMap2.get("JOB_DESC"));
            hashMap.put("AGENT", "Agent");
            reportDataBuilder2.setFieldValue("AGENT", hashMap2.get("AGENT"));
            hashMap.put("SERVER_START_TIME", "Server Start Time");
            object = new Date((Long)hashMap2.get("SERVER_START_TIME"));
            reportDataBuilder2.setFieldValue("SERVER_START_TIME", object);
            hashMap.put("SERVER_SCHEDULED_TIME", "Server Scheduled Time");
            Date date = new Date((Long)hashMap2.get("SERVER_SCHEDULED_TIME"));
            reportDataBuilder2.setFieldValue("SERVER_SCHEDULED_TIME", date);
        }
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        String string = "The report data of manually managed job list has been built.";
        return string;
    }

    private void buildAbnormalJobListReportData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, long l, long l2, boolean bl) {
        ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getAbnormalJobsByStatusInPeriod(l, l2);
        if (!arrayList.isEmpty()) {
            this.parentParams.put("ABNORMAL_JOB_LIST_DATA_EXISTS", new Boolean(true));
            ReportBuilder reportBuilder = new ReportBuilder();
            reportBuilder.buildJobHistoryTable(arrayList, bl);
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", reportBuilder.getParams());
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportBuilder.getJRDataSource());
            logger.trace((Object)"The report data of abnormal job list has been built.");
        } else {
            this.parentParams.put("ABNORMAL_JOB_LIST_DATA_EXISTS", new Boolean(false));
            logger.trace((Object)"No abnormal jobs have been found to build a list for.");
        }
    }

    private String buildOfflineAgentsReportData(AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = GoodMorningReport.createReportDataBuilder();
        boolean bl = true;
        this.parentParams.put("OFF_LINE_AGENTS_DATA_EXISTS", new Boolean(false));
        ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getOfflineAgentsSortedByName();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string;
            HashMap<String, Object> hashMap2 = arrayList.get(i);
            if (bl) {
                this.parentParams.put("OFF_LINE_AGENTS_DATA_EXISTS", new Boolean(true));
                bl = false;
            }
            reportDataBuilder2.nextRow();
            hashMap.put("AGENT", "Agent");
            reportDataBuilder2.setFieldValue("AGENT", hashMap2.get("AGENT"));
            hashMap.put("AGENT_DESC", "Agent Description");
            reportDataBuilder2.setFieldValue("AGENT_DESC", hashMap2.get("AGENT_DESC"));
            hashMap.put("AGENT_STATUS", "Agent Status");
            int n2 = ((Long)hashMap2.get("AGENT_STATUS")).intValue();
            switch (n2) {
                case 1: {
                    string = "Active";
                    break;
                }
                case 2: {
                    string = "Inactive";
                    break;
                }
                case 3: {
                    string = "Failed";
                    break;
                }
                case 0: {
                    string = "Unknown";
                    break;
                }
                default: {
                    string = "Unknown status";
                }
            }
            reportDataBuilder2.setFieldValue("AGENT_STATUS", string);
        }
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        String string = "The report data of offline agents list has been built.";
        return string;
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = GoodMorningReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    private String buildSummaryDataReport(AbstractJasperReport.ReportDataBuilder reportDataBuilder) {
        Long l = this.filter.getFromDate();
        Long l2 = this.filter.getToDate();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = GoodMorningReport.createReportDataBuilder();
        try {
            reportDataBuilder2.nextRow();
            hashMap.put(TITLE_SCHEDULER_STATUS, this.schedulerStatusAM.getSchedulerStatus());
            ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getOfflineAgentsSortedByName();
            int n = arrayList.size();
            hashMap.put(TITLE_COUNT_OFFLINE_AGENTS, n);
            int n2 = this.agent.getByLicenseAllocation(false).length;
            hashMap.put(TITLE_COUNT_UNLICENSED_AGENTS, n2);
            int n3 = this.agent.getLockedAgentIDs().size();
            hashMap.put(TITLE_COUNT_AGENT_QUEUES_LOCKED, n3);
            int n4 = this.jobQueues.getByHoldStatus(true).length;
            hashMap.put(TITLE_COUNT_HELD_JOB_QUEUES, n4);
            int n5 = this.jobHistory.getCountByStatusCodeInPeriod(JobStatusCode.COMPLETED.persistanceCode(), l, l2);
            hashMap.put(TITLE_COUNT_JOBS_ENDED_NORMALLY, n5);
            int n6 = this.jobHistory.getCountByStatusCodeInPeriod(JobStatusCode.ERROR.persistanceCode(), l, l2);
            int n7 = this.jobHistory.getCountByStatusCodeInPeriod(JobStatusCode.FAILED.persistanceCode(), l, l2);
            int n8 = this.jobHistory.getCountByStatusCodeInPeriod(JobStatusCode.CANCELED.persistanceCode(), l, l2);
            int n9 = n7 + n8 + n6;
            hashMap.put(TITLE_COUNT_JOBS_ENDED_ABNORMALLY, n9);
            int n10 = this.jobHistory.getCountByManagedinPeriod(l, l2);
            hashMap.put(TITLE_COUNT_JOBS_MANAGED, n10);
            int n11 = this.enterpriseServerAM.getTotalJobsQueued();
            hashMap.put(TITLE_COUNT_JOBS_QUEUED, n11);
            int n12 = this.jobHistory.getCountByStatusCodeInPeriod(JobStatusCode.SKIPPED.persistanceCode(), l, l2);
            hashMap.put(TITLE_COUNT_JOBS_SKIPPED, n12);
            int n13 = n11 + n10 + n9 + n12 + n5;
            hashMap.put(TITLE_TOTAL_JOBS, n13);
            logger.trace((Object)"Counted job report data is complete.");
            int n14 = this.reportDM.getCountJobMonitorEventsDataInPeriod(3, l, l2);
            int n15 = this.reportDM.getCountJobMonitorEventsDataInPeriod(2, l, l2);
            int n16 = this.reportDM.getCountJobMonitorEventsDataInPeriod(1, l, l2);
            hashMap.put(TITLE_COUNT_JOBS_LATE_START_EVENTS, n14);
            hashMap.put(TITLE_COUNT_JOBS_OVERRUN_EVENTS, n15);
            hashMap.put(TITLE_COUNT_JOBS_UNDERRUN_EVENTS, n16);
            int n17 = n14 + n16 + n15;
            hashMap.put(TITLE_TOTAL_JOBS_EVENTS, n17);
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
            String string = "The report summary data of GMR has been built.";
            return string;
        }
        catch (Exception exception) {
            logger.error((Object)"An error occured creating the Good Morning Report.", (Throwable)exception);
            return null;
        }
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        GoodMorningReportFilterParser goodMorningReportFilterParser = new GoodMorningReportFilterParser();
        this.replaceIfNotAKey(objectArray);
        goodMorningReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals(DATE_RANGE) || string.equals(END_DATE_DURATION) || string.equals(START_DATE_DURATION) || string.equals(USER_NAME) || string.equals(JOB_IDS) || string.equals("-f");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.GOOD_MORNING_REPORT.getReportID();
    }

    private static enum Groupings {
        SUMMARY_DATA,
        ABNORMAL_JOB_LIST,
        JOB_MONITOR_EVENTS,
        MANUALLY_MANAGED_JOBS,
        OFFLINE_AGENT_LIST;

    }
}

