/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.ForecastJobRunsReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.ForecastJobRunsReportFilterParser;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ForecastJobRunsReport
extends AbstractJasperReport
implements Serializable {
    public static final String REPORT_NAME = "ForecastedJobRunsReport";
    public static final int REPORT_ID = Reports.ReportType.FORECAST_JOB_RUNS_REPORT.getReportID();
    private static final Logger logger = Logger.getLogger(ForecastJobRunsReport.class);
    private long forecastID;
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    private ForecastJobRunsReportFilter filter = new ForecastJobRunsReportFilter();
    private static final String USER_NAME = "-userName";
    private static final String OUTPUT_TYPE = "-outputType";
    private static final String FORECAST_MODEL = "-forecastModel";
    private static final String LAST_GEN = "-lastGen";
    private static final String JOB_IDS = "-jobIds";
    private static final String DATE_PARM = "-date";
    private static final String TIME_PARM = "-time";

    public ForecastJobRunsReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
    }

    @Override
    public int getReportID() {
        return REPORT_ID;
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    JasperReportData buildReportData() throws ReportException {
        Object object;
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = ForecastJobRunsReport.createReportDataBuilder();
        this.forecastID = this.reportDM.getForecastRunIdByModelName(this.filter.getForecastModel(), this.filter.isLastGeneration(), this.filter.getGenerationDate());
        Map<String, Object> map = this.reportDM.getForecastModelData(this.forecastID);
        if (map.size() == 0) {
            String string = "Invalid forecast model - " + this.filter.getForecastModel() + " or there is no data for this forecast model";
            throw new ReportException(string);
        }
        this.parentParams.put("HEADER_REPORT_NAME", "Forecasted Job Runs");
        this.parentParams.put("FORECAST_DEF", map.get("FORECAST_DEF"));
        String string = ReportHelper.getFormatedDate(new Date((Long)map.get("GEN_TIME")));
        this.parentParams.put("GEN_TIME", "at " + string);
        this.parentParams.put("REPORT_OUTPUT_TYPE", this.getOutputType().name());
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        List<Map<String, Object>> list = this.reportDM.getForecastJobRunsData(this.forecastID);
        if (!list.isEmpty()) {
            if (this.getOutputType().persistanceCode() == 3) {
                this.parentParams.put("REPORT_COLUMN_NAMES", "Job Name,Agent,Start Time,End Time,Total Duration,Initiation Code,Held/Skipped");
                this.parentParams.put("DATA_EXISTS", new Boolean(true));
            } else {
                this.parentParams.put("JOB_NAME", "Job Name");
                this.parentParams.put("AGENT", "Agent");
                this.parentParams.put("START_TIME", "Start Time");
                this.parentParams.put("END_TIME", "End Time");
                this.parentParams.put("TOTAL_DURATION", "Total Duration");
                this.parentParams.put("INIT_CODE", "Initiation Code");
                this.parentParams.put("HOLD_STATUS", "Held/Skipped");
                this.parentParams.put("DATA_EXISTS", new Boolean(true));
            }
            object = new ArrayList();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Boolean bl = (Boolean)list.get(i).get("MEMBER_SKIPPED_PER_SPECIAL_INSTANCE");
                String string2 = (String)list.get(i).get("JOB_NAME");
                String string3 = (String)list.get(i).get("AGENT");
                Date date = new Date((Long)list.get(i).get("START_TIME"));
                Date date2 = new Date((Long)list.get(i).get("END_TIME"));
                long l = (Long)list.get(i).get("TOTAL_DURATION");
                String string4 = ReportHelper.getForecastInitCode((Integer)list.get(i).get("INIT_CODE"));
                String string5 = (String)list.get(i).get("HOLD_STATUS");
                if (this.getOutputType().persistanceCode() == 3) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (string2 != null) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append(",");
                    if (string3 != null) {
                        stringBuilder.append(string3);
                    }
                    stringBuilder.append(",").append(date).append(",").append(date2).append(",").append(this.getFormttedTimeByMillSec(l));
                    stringBuilder.append(",").append(string4).append(",").append(string5);
                    ((ArrayList)object).add(stringBuilder);
                    continue;
                }
                if (bl.booleanValue()) continue;
                reportDataBuilder.nextRow();
                reportDataBuilder.setFieldValue("JOB_NAME", string2);
                reportDataBuilder.setFieldValue("AGENT", string3);
                reportDataBuilder.setFieldValue("START_TIME", date);
                reportDataBuilder.setFieldValue("END_TIME", date2);
                reportDataBuilder.setFieldValue("TOTAL_DURATION", this.getFormttedTimeByMillSec(l));
                reportDataBuilder.setFieldValue("INIT_CODE", string4);
                reportDataBuilder.setFieldValue("HOLD_STATUS", string5);
            }
            this.parentParams.put("ROW_DATA", object);
            logger.trace((Object)"The Forecast Job Runs has been built.");
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        object = new JasperReportData();
        ((JasperReportData)object).setParameters(this.parentParams);
        ((JasperReportData)object).setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"Forecasted Job Runs Report data has been built.");
        return object;
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        ForecastJobRunsReportFilterParser forecastJobRunsReportFilterParser = new ForecastJobRunsReportFilterParser();
        this.replaceIfNotAKey(objectArray);
        forecastJobRunsReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals(OUTPUT_TYPE) || string.equals(FORECAST_MODEL) || string.equals(LAST_GEN) || string.equals(USER_NAME) || string.equals(JOB_IDS) || string.equals(DATE_PARM) || string.equals(TIME_PARM) || string.equals("-f");
    }

    private String getFormttedTimeByMillSec(long l) {
        if (l < 1000L) {
            return "0:00:00";
        }
        long l2 = l / 1000L;
        if (l2 < 60L) {
            return "0:00:" + (l2 < 10L ? "0" + l2 : Long.valueOf(l2));
        }
        long l3 = l2 / 60L;
        l2 %= 60L;
        if (l3 < 60L) {
            return "0:" + (l3 < 10L ? "0" + l3 : Long.valueOf(l3)) + ":" + (l2 < 10L ? "0" + l2 : Long.valueOf(l2));
        }
        long l4 = l3 / 60L;
        return "" + l4 + ":" + ((l3 %= 60L) < 10L ? "0" + l3 : Long.valueOf(l3)) + ":" + (l2 < 10L ? "0" + l2 : Long.valueOf(l2));
    }
}

