/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.SNMPTrapMonitorDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.enums.AndOrSelection;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.filter.AgentEventHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.BaseDateFilter;
import com.helpsystems.enterprise.core.reports.filter.JobHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.JobMonitorHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.JobSetupReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPAbapStepSetReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPInterceptedJobHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPJobDefinitionReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SAPSystemDefinitionReportFilter;
import com.helpsystems.enterprise.core.reports.filter.SNMPTrapMonitorHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.ServerHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.AgentEventMonitorFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.AgentEventTypeFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.AgentFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.AllUntaggedJobsFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.AllUntaggedSASSFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.AllUntaggedSJDFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.AllUntaggedSSDFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.DateFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.FilterDeclaration;
import com.helpsystems.enterprise.core.reports.filter.declaration.JobFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.JobMonitorTypeFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.JobStatusFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.LimitedHistoryFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.ObjectsAndOrFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.SAPAbapStepSetFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.SAPJobDefinitionFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.SAPRunInterceptedJobsFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.SAPSystemDefinitionFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.SNMPTrapMonitorFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.SecurityFilter;
import com.helpsystems.enterprise.core.reports.filter.declaration.TagFilter;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JobSetupReportHelper;
import com.helpsystems.enterprise.module.reports.jasper.ReportParamStrComparator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ReportTitleHelper {
    private static final Logger logger = Logger.getLogger(ReportTitleHelper.class);
    private static ReportTitleHelper inctance = null;
    private Map<String, Object> dmMap = new HashMap<String, Object>();

    private ReportTitleHelper() {
    }

    public static ReportTitleHelper getInstance() {
        if (inctance == null) {
            inctance = new ReportTitleHelper();
        }
        return inctance;
    }

    public String buildReportParameter(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, FilterDeclaration filterDeclaration) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("HEADER_PARAM_NAME", "Parameters");
        if (filterDeclaration instanceof DateFilter) {
            this.buildDateFilterParserParameterReport(hashMap, reportDataBuilder, (DateFilter)filterDeclaration, 0);
        }
        if (filterDeclaration instanceof AgentEventMonitorFilter) {
            try {
                this.buildAgentEventMonitorFilterParserParameterReport(hashMap, reportDataBuilder, (AgentEventMonitorFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof AgentEventTypeFilter) {
            try {
                this.buildAgentEventTypeFilterParserParameterReport(hashMap, reportDataBuilder, (AgentEventTypeFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof AgentFilter) {
            this.buildAgentFilterParserParameterReport(hashMap, reportDataBuilder, (AgentFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof JobFilter) {
            this.buildJobFilterParserParameterReport(hashMap, reportDataBuilder, (JobFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof JobMonitorTypeFilter) {
            try {
                this.buildJobMonitorTypeFilterParserParameterReport(hashMap, reportDataBuilder, (JobMonitorTypeFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof JobStatusFilter) {
            this.buildJobStatusFilterParserParameterReport(hashMap, reportDataBuilder, (JobStatusFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof SNMPTrapMonitorFilter) {
            try {
                this.buildSNMPTrapMonitorFilterParserParameterReport(hashMap, reportDataBuilder, (SNMPTrapMonitorFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof SAPSystemDefinitionFilter) {
            try {
                this.buildSAPFilterParserParameterReport(hashMap, reportDataBuilder, (SAPSystemDefinitionFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof SAPJobDefinitionFilter) {
            try {
                this.buildSAPJobFilterParserParameterReport(hashMap, reportDataBuilder, (SAPJobDefinitionFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof SAPAbapStepSetFilter) {
            try {
                this.buildSAPAbapStepSetFilterParserParameterReport(hashMap, reportDataBuilder, (SAPAbapStepSetFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof SAPRunInterceptedJobsFilter) {
            try {
                this.buildSAPRunInterceptedJobsFilterParserParameterReport(hashMap, reportDataBuilder, (SAPRunInterceptedJobsFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof SAPInterceptedJobHistoryReportFilter) {
            try {
                this.buildSAPInterceptedJobHistoryReportFilterParserParameterReport(hashMap, reportDataBuilder, (SAPInterceptedJobHistoryReportFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof SecurityFilter) {
            try {
                this.buildSecurityFilterParserParameterReport(hashMap, reportDataBuilder, (SecurityFilter)filterDeclaration);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException);
            }
            catch (DataException dataException) {
                logger.error((Object)dataException);
            }
        }
        if (filterDeclaration instanceof TagFilter) {
            this.buildTagFilterParserParameterReport(hashMap, reportDataBuilder, (TagFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof JobHistoryReportFilter) {
            this.buildServerTimeZoneParserParameterReport(hashMap, reportDataBuilder, (JobHistoryReportFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof AllUntaggedJobsFilter) {
            this.buildAllUntagJobsParserParameterReport(hashMap, reportDataBuilder, (AllUntaggedJobsFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof AllUntaggedSSDFilter) {
            this.buildAllUntagSSDParserParameterReport(hashMap, reportDataBuilder, (AllUntaggedSSDFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof AllUntaggedSASSFilter) {
            this.buildAllUntaggedSASSParserParameterReport(hashMap, reportDataBuilder, (AllUntaggedSASSFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof AllUntaggedSJDFilter) {
            this.buildAllUntaggedSJDParserParameterReport(hashMap, reportDataBuilder, (AllUntaggedSJDFilter)filterDeclaration);
        }
        if (filterDeclaration instanceof ObjectsAndOrFilter) {
            this.buildObjectsAndOrFilterParserParameterReport(hashMap, reportDataBuilder, (ObjectsAndOrFilter)filterDeclaration, this.getReportNameFromFilter(filterDeclaration));
        }
        if (filterDeclaration instanceof LimitedHistoryFilter) {
            this.buildLimitedHistoryFilterParserParameterReport(hashMap, reportDataBuilder, (LimitedHistoryFilter)filterDeclaration);
        }
        map.put("GROUP_SUBREPORT_PARAMS", hashMap);
        map.put("GROUP_SUBREPORT_DATA", reportDataBuilder.toJRDataSource());
        String string = "The report parameters of Agent Event History has been built.";
        return string;
    }

    private String getReportNameFromFilter(FilterDeclaration filterDeclaration) {
        String string = "Unknown";
        if (filterDeclaration instanceof JobSetupReportFilter) {
            string = "Jobs";
        }
        if (filterDeclaration instanceof ServerHistoryReportFilter) {
            string = "Server History";
        }
        if (filterDeclaration instanceof JobHistoryReportFilter) {
            string = "Job History";
        }
        if (filterDeclaration instanceof AgentEventHistoryReportFilter) {
            string = "Agent Event History";
        }
        if (filterDeclaration instanceof JobMonitorHistoryReportFilter) {
            string = "Job Monitor History";
        }
        if (filterDeclaration instanceof SNMPTrapMonitorHistoryReportFilter) {
            string = "SNMP Trap Monitor History";
        }
        if (filterDeclaration instanceof SAPSystemDefinitionReportFilter) {
            string = "System Definitions";
        }
        if (filterDeclaration instanceof SAPJobDefinitionReportFilter) {
            string = "Job Definitions";
        }
        if (filterDeclaration instanceof SAPAbapStepSetReportFilter) {
            string = "ABAP Step Sets";
        }
        if (filterDeclaration instanceof SAPInterceptedJobHistoryReportFilter) {
            string = "Intercepted Job History";
        }
        return string;
    }

    public void buildAgentEventMonitorFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, AgentEventMonitorFilter agentEventMonitorFilter) throws ResourceUnavailableException, DataException {
        long[] lArray = agentEventMonitorFilter.getAgentEventMonitorIds();
        String[] stringArray = null;
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = agentEventMonitorFilter.getAgentEventMonitorNames();
        if (lArray != null) {
            stringArray = new String[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                stringArray[i] = ((AgentEventMonitorDM)this.getDM("ENTERPRISE.AgentEventMonitorDM")).get(lArray[i], null).getName();
            }
            stringArray2 = stringArray;
        }
        if (stringArray3 != null) {
            stringArray2 = stringArray3;
        }
        if (lArray != null && stringArray3 != null) {
            stringArray2 = ReportHelper.concatArrays(stringArray, stringArray3);
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Agent Event Monitor List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray2));
    }

    public void buildAgentEventTypeFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, AgentEventTypeFilter agentEventTypeFilter) throws ResourceUnavailableException, DataException {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Agent Event Type List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(agentEventTypeFilter.getEventTypeNames()));
    }

    public void buildAgentFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, AgentFilter agentFilter) {
        String[] stringArray = agentFilter.getAgentNames();
        reportDataBuilder.nextRow();
        Arrays.sort(stringArray, new ReportParamStrComparator());
        reportDataBuilder.setFieldValue("NAMEFIELD", "Agent Names");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray));
        String[] stringArray2 = agentFilter.getAgentGroupNames();
        reportDataBuilder.nextRow();
        Arrays.sort(stringArray2, new ReportParamStrComparator());
        reportDataBuilder.setFieldValue("NAMEFIELD", "Agent Group Names");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray2));
    }

    public void buildDateFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, DateFilter dateFilter, int n) {
        ReportTitleHelper.generateReportDateInTitlePage(reportDataBuilder, dateFilter.getDateDayFromRelative(), dateFilter.getDateHourFromRelative(), dateFilter.getDateDayToRelative(), dateFilter.getDateHourToRelative(), dateFilter.getFromDate(), dateFilter.getToDate(), dateFilter.isToCurrentDate(), n);
    }

    private static void generateReportDateInTitlePage(AbstractJasperReport.ReportDataBuilder reportDataBuilder, Integer n, Integer n2, Integer n3, Integer n4, Long l, Long l2, boolean bl, int n5) {
        String string;
        String string2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm");
        if (n != null || n2 != null) {
            string2 = "Start Date and Time";
            string = "Days: " + (n != null ? String.valueOf(n) : "0");
            string = string + " , Hours: " + (n2 != null ? String.valueOf(n2) : "0");
            string = string + " (prior to End Date and Time)";
        } else {
            string2 = "Start Date and Time";
            string = "Date: " + simpleDateFormat.format(new Date(l));
            string = string + " , Time: " + simpleDateFormat2.format(new Date(l));
        }
        reportDataBuilder.nextRow();
        if (2 == n5) {
            string2 = "Planned " + string2;
        } else if (1 == n5) {
            string2 = "Scheduled Release " + string2;
        }
        reportDataBuilder.setFieldValue("NAMEFIELD", string2);
        reportDataBuilder.setFieldValue("VALUEFIELD", string);
        if (bl) {
            string2 = "End Date and Time";
            string = "Date: " + simpleDateFormat.format(new Date(l2));
            string = string + " , Time: " + simpleDateFormat2.format(new Date(l2));
        } else if (n3 != null && n4 != null) {
            string2 = "End Date and Time ";
            string = "Days: " + (n3 != null ? String.valueOf(n3) : "0");
            string = string + " , Hours: " + (n4 != null ? String.valueOf(n4) : "0");
            string = string + " (after Begin Date and Time)";
        } else {
            string2 = "End Date and Time";
            string = "Date: " + simpleDateFormat.format(new Date(l2));
            string = string + " , Time: " + simpleDateFormat2.format(new Date(l2));
        }
        reportDataBuilder.nextRow();
        if (2 == n5) {
            string2 = "Planned " + string2;
        } else if (1 == n5) {
            string2 = "Scheduled Release " + string2;
        }
        reportDataBuilder.setFieldValue("NAMEFIELD", string2);
        reportDataBuilder.setFieldValue("VALUEFIELD", string);
    }

    public void buildJobFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, JobFilter jobFilter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jobFilter.getJobIds().length; ++i) {
            try {
                ScheduleJob scheduleJob = this.getJobOrSuite(jobFilter.getJobIds()[i]);
                arrayList.add(scheduleJob.getName());
                continue;
            }
            catch (NoDataException noDataException) {
                continue;
            }
            catch (DataException dataException) {
                logger.error((Object)dataException.getMessage(), (Throwable)dataException);
                continue;
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
            }
        }
        String[] stringArray = JobSetupReportHelper.getMergedJobNames(arrayList, jobFilter.getJobNames());
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Job List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray));
    }

    public void buildJobMonitorTypeFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, JobMonitorTypeFilter jobMonitorTypeFilter) throws ResourceUnavailableException, DataException {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Job Monitor Type List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(jobMonitorTypeFilter.getMonitorNames()));
    }

    public void buildJobStatusFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, JobStatusFilter jobStatusFilter) {
        String string = JobSetupReportHelper.getOneLineString(jobStatusFilter.getJobStatusCodeNameList());
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Job Status List");
        reportDataBuilder.setFieldValue("VALUEFIELD", string);
    }

    public void buildServerTimeZoneParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, JobHistoryReportFilter jobHistoryReportFilter) {
        String string = TimeZone.getDefault().getDisplayName();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Time Zone");
        reportDataBuilder.setFieldValue("VALUEFIELD", string);
    }

    public void buildSNMPTrapMonitorFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, SNMPTrapMonitorFilter sNMPTrapMonitorFilter) throws ResourceUnavailableException, DataException {
        long[] lArray = sNMPTrapMonitorFilter.getSnmpTrapMonitors();
        String[] stringArray = null;
        String[] stringArray2 = sNMPTrapMonitorFilter.getSnmpTrapMonitorNames();
        String[] stringArray3 = new String[]{};
        if (lArray != null) {
            int n = lArray.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((SNMPTrapMonitorDM)this.getDM("ENTERPRISE.SNMPTrapMonitorDM")).get(sNMPTrapMonitorFilter.getSnmpTrapMonitors()[i], null).getName();
            }
            stringArray3 = stringArray;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            stringArray3 = stringArray2;
        }
        if (stringArray != null && stringArray2 != null) {
            stringArray3 = ReportHelper.concatArrays(stringArray, stringArray2);
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "SNMP Trap Monitor List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray3));
    }

    public void buildTagFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, TagFilter tagFilter) {
        reportDataBuilder.nextRow();
        Arrays.sort(tagFilter.getTags(), new ReportParamStrComparator());
        reportDataBuilder.setFieldValue("NAMEFIELD", "Tag List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(tagFilter.getTags()));
    }

    public void buildLimitedHistoryFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, LimitedHistoryFilter limitedHistoryFilter) {
        if (!limitedHistoryFilter.isLimitedHistory()) {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("NAMEFIELD", "Limited History");
            reportDataBuilder.setFieldValue("VALUEFIELD", "False");
        }
    }

    public void buildAllUntagJobsParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, AllUntaggedJobsFilter allUntaggedJobsFilter) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Include all untagged jobs in report ");
        reportDataBuilder.setFieldValue("VALUEFIELD", allUntaggedJobsFilter.isSelectedAllUntaggedJobs());
    }

    public void buildObjectsAndOrFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, ObjectsAndOrFilter objectsAndOrFilter, String string) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Restrict report to " + string + " matching all lists ");
        reportDataBuilder.setFieldValue("VALUEFIELD", ReportTitleHelper.getYesNo(objectsAndOrFilter.getObjectsAndOrSelection()));
    }

    private void buildAllUntagSSDParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, AllUntaggedSSDFilter allUntaggedSSDFilter) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Include all untagged System Definitions in report ");
        reportDataBuilder.setFieldValue("VALUEFIELD", allUntaggedSSDFilter.isSelectedAllUntaggedSSD());
    }

    private void buildAllUntaggedSASSParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, AllUntaggedSASSFilter allUntaggedSASSFilter) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Include all untagged ABAP Step Sets in report ");
        reportDataBuilder.setFieldValue("VALUEFIELD", allUntaggedSASSFilter.isSelectedAllUntaggedSASSs());
    }

    private void buildAllUntaggedSJDParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, AllUntaggedSJDFilter allUntaggedSJDFilter) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Include all untagged Job Definitions in report ");
        reportDataBuilder.setFieldValue("VALUEFIELD", allUntaggedSJDFilter.isSelectedAllUntaggedSJDs());
    }

    private Object getDM(String string) {
        Object object = null;
        if (this.dmMap.containsKey(string)) {
            object = this.dmMap.get(string);
        } else {
            object = ManagerRegistry.getManagerOrFail((String)string);
            this.dmMap.put(string, object);
        }
        return object;
    }

    public ScheduleJob getJobOrSuite(long l) throws ResourceUnavailableException, DataException {
        ScheduleJobDM scheduleJobDM = (ScheduleJobDM)this.getDM("ENTERPRISE.ScheduleJobDM");
        ScheduleJobProxy scheduleJobProxy = scheduleJobDM.getScheduleJobProxy(l);
        ScheduleJob scheduleJob = null;
        switch (scheduleJobProxy.getJobType()) {
            case JOB: {
                scheduleJob = scheduleJobDM.get(l);
                break;
            }
            case SUITE: {
                scheduleJob = scheduleJobDM.getSuite(l);
                break;
            }
            case SUITE_MEMBER: {
                scheduleJob = scheduleJobDM.get(l);
                break;
            }
            default: {
                String string = "Invalid Job Type: " + scheduleJobProxy.getJobType();
                logger.error((Object)string);
                throw new IllegalStateException(string);
            }
        }
        return scheduleJob;
    }

    public void buildSAPFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, SAPSystemDefinitionFilter sAPSystemDefinitionFilter) throws ResourceUnavailableException, DataException {
        String[] stringArray = sAPSystemDefinitionFilter.getDefinitionNameList();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "System Definition List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray));
    }

    public void buildSAPJobFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, SAPJobDefinitionFilter sAPJobDefinitionFilter) throws ResourceUnavailableException, DataException {
        String[] stringArray = sAPJobDefinitionFilter.getDefinitionNameList();
        SAPJobDefinitionReportFilter.Environment[] environmentArray = sAPJobDefinitionFilter.getEnvironmentList();
        String[] stringArray2 = sAPJobDefinitionFilter.getAbapStepSetNameList();
        String[] stringArray3 = sAPJobDefinitionFilter.getAbapProgramNameList();
        String[] stringArray4 = sAPJobDefinitionFilter.getJobDefNameList();
        String[] stringArray5 = new String[environmentArray.length];
        for (int i = 0; i < environmentArray.length; ++i) {
            stringArray5[i] = environmentArray[i].getEnvName() + "(" + environmentArray[i].getDefName() + ")";
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Job Definitions");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray4));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "System Definition List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "System Environment List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray5));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "ABAP Step Set List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray2));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "ABAP Program List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray3));
    }

    public void buildSAPAbapStepSetFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, SAPAbapStepSetFilter sAPAbapStepSetFilter) throws ResourceUnavailableException, DataException {
        String[] stringArray = sAPAbapStepSetFilter.getSapSystemDefList();
        String[] stringArray2 = sAPAbapStepSetFilter.getAbapStepSetNameList();
        String[] stringArray3 = sAPAbapStepSetFilter.getAbapProgramNameList();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "ABAP Step Set List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray2));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "System Definition List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "ABAP Program List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray3));
    }

    public void buildSAPRunInterceptedJobsFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, SAPRunInterceptedJobsFilter sAPRunInterceptedJobsFilter) throws ResourceUnavailableException, DataException {
        String[] stringArray = sAPRunInterceptedJobsFilter.getAbapStepSetNameList();
        String[] stringArray2 = sAPRunInterceptedJobsFilter.getAbapProgramNameList();
        String[] stringArray3 = sAPRunInterceptedJobsFilter.getSAPJobList();
        String[] stringArray4 = sAPRunInterceptedJobsFilter.getSAPSystemDefinitionList();
        String[] stringArray5 = sAPRunInterceptedJobsFilter.getSAPSystemEnvironmentList();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "SAP ABAP Step Set Names");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "SAP ABAP Program Names");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray2));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "SAP Jobs");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray3));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "SAP System Definitions");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray4));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "SAP System Environments");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray5));
    }

    public void buildSAPInterceptedJobHistoryReportFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, SAPInterceptedJobHistoryReportFilter sAPInterceptedJobHistoryReportFilter) throws ResourceUnavailableException, DataException {
        String[] stringArray = sAPInterceptedJobHistoryReportFilter.getSapSystemDefinitions();
        String[] stringArray2 = sAPInterceptedJobHistoryReportFilter.getSapJobNames();
        String[] stringArray3 = sAPInterceptedJobHistoryReportFilter.getSapJobOwners();
        String[] stringArray4 = sAPInterceptedJobHistoryReportFilter.getSapClients();
        String[] stringArray5 = sAPInterceptedJobHistoryReportFilter.getSkybotJobs();
        String[] stringArray6 = sAPInterceptedJobHistoryReportFilter.getSkybotAgents();
        BaseDateFilter baseDateFilter = sAPInterceptedJobHistoryReportFilter.getSapPlannedDateFilter();
        BaseDateFilter baseDateFilter2 = sAPInterceptedJobHistoryReportFilter.getScheduledReleaseDateFilter();
        if (baseDateFilter.getFromDate() != null || baseDateFilter.getToDate() != null) {
            this.buildDateFilterParserParameterReport(map, reportDataBuilder, baseDateFilter, 2);
        }
        if (baseDateFilter2.getFromDate() != null || baseDateFilter2.getToDate() != null) {
            this.buildDateFilterParserParameterReport(map, reportDataBuilder, baseDateFilter2, 1);
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "System Definition List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Automate Schedule Job List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray5));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Automate Schedule Agent List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray6));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Job Name List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray2));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Job Owner List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray3));
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Client List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray4));
    }

    public void buildSecurityFilterParserParameterReport(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, SecurityFilter securityFilter) throws ResourceUnavailableException, DataException {
        String[] stringArray = securityFilter.getRolesNameList();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Role List");
        reportDataBuilder.setFieldValue("VALUEFIELD", JobSetupReportHelper.getOneLineString(stringArray));
    }

    public static String getYesNo(AndOrSelection andOrSelection) {
        switch (andOrSelection) {
            case AND: {
                return "Yes";
            }
            case OR: {
                return "No";
            }
        }
        return null;
    }
}

