/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportRecordLimit;
import com.helpsystems.enterprise.core.reports.ReportRowsLimitException;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;

public class ReportBuilder {
    private Map<String, Object> params = new HashMap<String, Object>();
    private AbstractJasperReport.ReportDataBuilder dataBuilder = new AbstractJasperReport.ReportDataBuilder();

    public Map<String, Object> getParams() {
        return this.params;
    }

    public AbstractJasperReport.ReportDataBuilder getReportDataBuilder() {
        return this.dataBuilder;
    }

    public void nextRow() {
        this.dataBuilder.nextRow();
    }

    public void put(String string, String string2, Object object) {
        this.params.put(string, string2);
        this.put(string, object);
    }

    public void put(String string, Object object) {
        this.dataBuilder.setFieldValue(string, object);
    }

    public void buildJobHistoryTable(ArrayList<HashMap<String, Object>> arrayList, boolean bl) {
        String string = null;
        int n = arrayList.size();
        int n2 = ReportRecordLimit.getReportRowLimit(Reports.ReportType.JOB_HISTORY_REPORT);
        if (!bl && n > n2) {
            Object[] objectArray = new String[]{"job history report", "" + (n2 + 1)};
            String string2 = RosettaMsg.getMsgText(RosettaMsg.REPORT_ROWS_LIMIT, objectArray);
            throw new ReportRowsLimitException(string2);
        }
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap = arrayList.get(i);
            this.nextRow();
            int n3 = ReportRecordLimit.getReportRowLimit(Reports.ReportType.GOOD_MORNING_REPORT);
            if (bl && i == n3) {
                string = "ONELINEFIELD";
                this.put(string, "", ReportHelper.getRowLimitMessage(n3, n, "Job History"));
                break;
            }
            string = "JOB_RUN_NUMBER";
            this.put(string, "Job Run Number", hashMap.get(string));
            string = "JOB_NAME";
            this.put(string, "Job Name", hashMap.get(string));
            string = "INIT_CODE";
            Integer n4 = (Integer)hashMap.get(string);
            int n5 = 0;
            if (n4 != null) {
                n5 = n4;
            }
            this.put(string, "Initiation Code", ReportHelper.getInitiationCode(n5));
            string = "AGENT";
            this.put(string, "Agent", hashMap.get(string));
            string = "SCHEDULED_DATE";
            this.put(string, "Scheduled Time", new Date((Long)hashMap.get(string)));
            string = "INITIATED_DATE";
            this.put(string, "Server Initiated Time", new Date((Long)hashMap.get(string)));
            string = "SERVER_END_TIME";
            Long l = (Long)hashMap.get(string);
            if (l != 0L) {
                this.put(string, "Server End Time", new Date(l));
            }
            string = "TOTAL_DURATION";
            this.put(string, "Total Duration", hashMap.get(string));
            string = "JOB_STATUS";
            String string3 = "JOB_ENDED_REASON_CODE";
            this.put(string, "Job Status", ReportHelper.getJobFullSatusString((String)hashMap.get(string), (String)hashMap.get(string3)));
            string = "AGENT_GROUP";
            this.put(string, "Agent Group", hashMap.get(string));
        }
    }

    public void buildSapInterceptedJobHistoryTable(ArrayList<HashMap<String, Object>> arrayList, boolean bl) {
        String string = null;
        int n = arrayList.size();
        int n2 = ReportRecordLimit.getReportRowLimit(Reports.ReportType.SAP_INTERCEPTED_JOB_HISTORY_REPORT);
        if (!bl && n > n2) {
            Object[] objectArray = new String[]{"SAP Intercepted Job History report", "" + (n2 + 1)};
            String string2 = RosettaMsg.getMsgText(RosettaMsg.REPORT_ROWS_LIMIT, objectArray);
            throw new ReportRowsLimitException(string2);
        }
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap = arrayList.get(i);
            this.nextRow();
            int n3 = ReportRecordLimit.getReportRowLimit(Reports.ReportType.GOOD_MORNING_REPORT);
            if (bl && i == n3) {
                string = "ONELINEFIELD";
                String string3 = ReportHelper.getRowLimitMessage(n3, n, "SAP Intercepted Job History");
                this.put(string, string3);
                break;
            }
            string = "SAP_SYSTEM_DEFINITION";
            this.put(string, hashMap.get(string));
            string = "SAP_JOB_NAME";
            this.put(string, hashMap.get(string));
            string = "SAP_JOB_OWNER";
            this.put(string, hashMap.get(string));
            string = "SAP_CLIENT";
            this.put(string, hashMap.get(string));
            string = "SAP_JOB_COUNT";
            this.put(string, hashMap.get(string));
            string = "SAP_PLANNED_START";
            this.put(string, new Date((Long)hashMap.get(string)));
            string = "SKYBOT_JOB_NAME";
            this.put(string, hashMap.get(string));
            string = "SKYBOT_AGENT";
            this.put(string, hashMap.get(string));
            string = "SKYBOT_SCHEDULED_RELEASE";
            long l = (Long)hashMap.get(string);
            if (l != 0L) {
                this.put(string, new Date(l));
            } else {
                this.put(string, null);
            }
            string = "JOB_HISTORY_ID";
            this.put(string, hashMap.get(string));
            string = "JOB_STATUS";
            this.put(string, ReportHelper.getJobFullSatusString((String)hashMap.get(string), (String)hashMap.get("JOB_ENDED_REASON_CODE")));
        }
    }

    public void buildJobMonitorHistoryTable(ArrayList<HashMap<String, Object>> arrayList, boolean bl) {
        String string = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap = arrayList.get(i);
            this.nextRow();
            int n2 = ReportRecordLimit.getReportRowLimit(Reports.ReportType.GOOD_MORNING_REPORT);
            if (bl && i == n2) {
                string = "ONELINEFIELD";
                this.put(string, "", ReportHelper.getRowLimitMessage(n2, n, "Job Monitor History"));
                break;
            }
            string = "JOB_RUN_NUMBER";
            this.put(string, "Job Run Number", hashMap.get(string));
            string = "JOB_NAME";
            this.put(string, "Job Name", hashMap.get(string));
            string = "AGENT";
            this.put(string, "Agent", hashMap.get(string));
            string = "SCHEDULED_DATE";
            this.put(string, "Scheduled Time", new Date((Long)hashMap.get(string)));
            string = "TIME_DETECTED";
            this.put(string, "Time Detected", new Date((Long)hashMap.get(string)));
            string = "EVENT_DATA";
            this.put(string, "Actions Performed", (String)hashMap.get(string));
            string = "JOB_MONITOR_TYPE";
            this.put(string, "Monitor Type", JobMonitorEvent.getTypeDescription((Integer)hashMap.get(string)));
            string = "AGENT_GROUP";
            this.put(string, "Agent Group", (String)hashMap.get(string));
            string = "JOB_SUITE_NAME";
            this.put(string, "Suite Name", (String)hashMap.get(string));
        }
    }

    public JRDataSource getJRDataSource() {
        return this.getReportDataBuilder().toJRDataSource();
    }
}

