/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.module.exec.Platform;
import com.helpsystems.enterprise.module.exec.ProcessCommand;
import com.helpsystems.enterprise.module.exec.ProcessMonitor;
import com.helpsystems.enterprise.module.exec.ProcessUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class UNIXPlatform
implements Platform {
    private static final String CMD_EXTENSION = ".sh";

    @Override
    public String getName() {
        return "UNIX Default";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getProcessShellCommand(int n, String string, boolean bl) throws ActionFailedException {
        boolean bl2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = ProcessUtil.findInLibraryPath("robotterm");
        if (string2 == null) {
            throw new ActionFailedException("Unable to find 'robotterm' for this platform.");
        }
        if (n == 4) {
            String string3 = ProcessUtil.findInLibraryPath("nopwd");
            if (string3 == null) {
                throw new ActionFailedException("Unable to find 'nopwd' for this platform");
            }
            arrayList.add(string3);
            arrayList.add(string);
        }
        arrayList.add(string2);
        arrayList.add("-n");
        boolean bl3 = bl2 = n == 2 || n == 4;
        if (bl2 && (string == null || string.length() == 0)) {
            throw new ActionFailedException("The job-user is empty");
        }
        if (n == 2) {
            String[] stringArray = this.getSwapUserCommand(string, bl);
            if (stringArray == null || stringArray.length <= 0) throw new ActionFailedException("Unable to compose 'su' command for " + string);
            arrayList.addAll(Arrays.asList(stringArray));
        } else if (n == 4 || n == 3) {
            if (bl) {
                String string4 = System.getProperty("user.dir") + "/" + "dologin.sh";
                File file = new File(string4);
                if (!file.exists()) {
                    throw new ActionFailedException("Unable to find " + file.getAbsolutePath());
                }
                arrayList.add(file.getAbsolutePath());
            } else {
                arrayList.add("/bin/sh");
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    @Override
    public String getExitCodeCommand(String string) {
        if (this.isCSHShell(string)) {
            return "echo {0}$status";
        }
        return "echo {0}$?";
    }

    @Override
    public boolean isUsable() {
        String string = System.getProperty("os.name");
        if (string == null) {
            return false;
        }
        return string.startsWith("Linux") || string.startsWith("SunOS") || string.startsWith("AIX") || string.startsWith("HP-UX") || string.startsWith("Mac ");
    }

    @Override
    public String getExitCommand() {
        return "exit";
    }

    @Override
    public String[] getEnvCommands(Map<String, String> map, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = new String[map.size()];
        map.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            String string2 = map.get(object);
            if (string2 == null || !ProcessMonitor.divideLongCommands || this.isCSHShell(string) || string2.length() <= 250) {
                string2 = this.sanitizeCmdLineArgument(string2);
            }
            if (this.isCSHShell(string)) {
                arrayList.add("setenv " + (String)object + " " + string2);
                continue;
            }
            arrayList.add((String)object + "=" + string2);
            arrayList.add("export " + (String)object);
        }
        Object[] objectArray2 = new String[arrayList.size()];
        arrayList.toArray(objectArray2);
        return objectArray2;
    }

    private String quoteIfNeeded(String string) {
        char c;
        if (string == null) {
            return string;
        }
        if (string.indexOf(" ") == -1) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 == (c = string.charAt(string.length() - 1)) && (c2 == '\'' || c2 == '\"' || c2 == '`')) {
            return string;
        }
        return '\"' + string + '\"';
    }

    @Override
    public String quoteString(String string) {
        return this.quoteIfNeeded(string);
    }

    @Override
    public String[] getSwapUserCommand(String string, boolean bl) {
        if (bl) {
            return new String[]{"su", "-", string};
        }
        return new String[]{"su", string};
    }

    @Override
    public String fixPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string;
        if (string.indexOf(" ") > -1) {
            string2 = string.replaceAll(" ", "\\ ");
        }
        return string2;
    }

    @Override
    public boolean echoesCommands() {
        return true;
    }

    @Override
    public String makeRemarkCommand(String string, String string2) {
        if (this.isCSHShell(string2)) {
            return ": " + string;
        }
        return "# " + string;
    }

    @Override
    public boolean sendUserPassword() {
        return !"root".equals(System.getProperty("user.name"));
    }

    @Override
    public void interpretBIFS(ArrayList<ProcessCommand> arrayList, String string, String string2) {
        ProcessUtil.convertBIFS(this, arrayList, string, string2);
    }

    @Override
    public String getCommandExtension() {
        return CMD_EXTENSION;
    }

    @Override
    public boolean isCommentCommand(String string) {
        return string != null && string.toUpperCase().trim().startsWith("#");
    }

    @Override
    public String getSetEnvironment(String string, String string2, String string3) {
        if (this.isCSHShell(string3)) {
            if (string != null && string.trim().length() > 0) {
                if (string2 != null) {
                    String[] stringArray;
                    String string4 = "";
                    String string5 = string2;
                    if (string5.startsWith("'") && string5.endsWith("'")) {
                        string5 = string5.substring(1, string5.length() - 1);
                    }
                    if ((stringArray = this.splitFixedLenString(100, string5)) == null || stringArray.length == 0) {
                        string4 = "setenv " + string + " " + string2;
                    } else {
                        for (int i = 0; i < stringArray.length; ++i) {
                            string4 = i == 0 ? "setenv " + string + " \"" + stringArray[i] + "\"" : string4 + "\n" + "setenv " + string + " \"${" + string + "}" + stringArray[i] + "\"";
                        }
                    }
                    return string4;
                }
                return "setenv " + string + " ";
            }
        } else if (string != null && string.trim().length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("=");
            if (string2 != null) {
                stringBuffer.append(UNIXPlatform.sliceIntoChunks(string2, 100));
                stringBuffer.append(";");
                stringBuffer.append(" export ");
                stringBuffer.append(string);
                stringBuffer.append(";");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private String[] splitFixedLenString(int n, String string) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid length: " + n);
        }
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            arrayList.add("");
        } else {
            while (string2.length() > 0) {
                if (string2.length() > n) {
                    arrayList.add(string2.substring(0, n));
                    string2 = string2.substring(n);
                    continue;
                }
                arrayList.add(string2);
                string2 = "";
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static String sliceIntoChunks(String string, int n) {
        if (string == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (string.length() > n) {
            stringBuilder.append(string.substring(0, n));
            stringBuilder.append("\\\r");
            string = string.substring(n);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public String sanitizeCmdLineArgument(String string) {
        String string2 = string;
        if (string2 != null) {
            char[] cArray = string2.toCharArray();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = "'";
            String string4 = "\\";
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == string3.charAt(0)) {
                    if (bl) {
                        stringBuilder.append(string3);
                        bl = false;
                    }
                    stringBuilder.append(string4 + string3);
                    continue;
                }
                if (!bl) {
                    stringBuilder.append(string3);
                    bl = true;
                }
                stringBuilder.append(cArray[i]);
            }
            if (bl) {
                stringBuilder.append(string3);
                bl = false;
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    @Override
    public String quoteEnvVarValue(String string, String string2) {
        if (string == null) {
            return string;
        }
        if (this.isCSHShell(string2)) {
            if (string.startsWith("'") && string.endsWith("'")) {
                return string;
            }
            return "'" + string + "'";
        }
        return string;
    }

    @Override
    public boolean isCSHShell(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().indexOf("csh") > -1;
    }
}

