/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileTransferAM;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import com.helpsystems.enterprise.core.util.FileHandler;
import com.helpsystems.enterprise.module.exec.RemoteFileCopier;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.io.File;
import org.apache.log4j.Logger;

public class StandbyBackupFileTransferAMImpl
extends AbstractManager
implements StandbyBackupFileTransferAM {
    private final AgentPeer agentPeer;
    private static final Logger logger = Logger.getLogger(StandbyBackupFileTransferAMImpl.class);

    public StandbyBackupFileTransferAMImpl(AgentPeer agentPeer) {
        this.agentPeer = agentPeer;
        this.setName("ENTERPRISE.StandbyBackupFileTransferAM");
    }

    @Override
    public boolean transferStandbyBackupFile(StandbyBackupFile standbyBackupFile) {
        Object object;
        Object object2;
        boolean bl = false;
        String string = standbyBackupFile.getFullFileName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting to process file transfer from master to standby: " + string));
        }
        RemoteFileCopier remoteFileCopier = new RemoteFileCopier(this.agentPeer.getConnectedAgentServer(), string);
        remoteFileCopier.setDeleteWhenFinished(false);
        String string2 = null;
        String string3 = standbyBackupFile.getServerDirName();
        if (string3 != null && string3.length() > 0) {
            object2 = new File(string3);
            if (!((File)object2).exists() || !((File)object2).isDirectory()) {
                ((File)object2).mkdirs();
            }
            if (!((File)object2).exists() || !((File)object2).isDirectory()) {
                object = "Unable to copy the file to the Standby, the directory " + string3 + " does not exist.";
                logger.debug(object);
            }
        }
        object2 = standbyBackupFile.getServerFileName();
        remoteFileCopier.setServerFilename((String)object2);
        bl = remoteFileCopier.run(true);
        object = remoteFileCopier.getServerWriteError();
        if (object != null) {
            logger.debug((Object)("Unable transfer the file " + string2 + " from master to standby server"), (Throwable)object);
        }
        if (bl) {
            logger.debug((Object)("Standby Backup File '" + standbyBackupFile.getFullFileName() + "' successfully sent to Standby"));
        } else {
            logger.debug((Object)("Standby Backup File '" + standbyBackupFile.getFullFileName() + "' can't send to Standby server"));
        }
        return bl;
    }

    @Override
    public boolean purgeStandbyBackupFile(StandbyBackupFile standbyBackupFile) {
        String string = null;
        boolean bl = false;
        String string2 = standbyBackupFile.getServerFileName();
        String string3 = standbyBackupFile.getDeleteUntilDirectory();
        try {
            File file = new File(string2);
            if (file.exists()) {
                FileHandler.deleteFilesUntilGivenFolder(string2, string3);
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to delete the standby backup file " + string2), (Throwable)exception);
        }
        if (bl) {
            string = "Succesfully deleted Standby Backup File '" + string2;
            logger.debug((Object)string);
        }
        return bl;
    }
}

