/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.enterprise.module.exec.LogFileWrapper;
import org.apache.log4j.Logger;

public class LogUtils {
    private Logger logger;
    private LogFileWrapper logFileWrapper;
    private String prefix = null;
    private static final String SPACE = " ";
    private static final String EMPTY = "";

    public LogUtils(LogFileWrapper logFileWrapper, Class clazz) {
        this.logFileWrapper = logFileWrapper;
        this.logger = Logger.getLogger((Class)clazz);
    }

    public LogUtils(LogFileWrapper logFileWrapper, Class clazz, String string) {
        this(logFileWrapper, clazz);
        this.prefix = string;
    }

    public void logTrace(Exception exception, Object ... objectArray) {
        String string = this.concatStringParams(objectArray);
        this.logger.trace((Object)string, (Throwable)exception);
        System.out.println(string + SPACE + exception.getMessage());
        this.logFileWrapper.write(string);
    }

    public void logTrace(Object ... objectArray) {
        String string = this.concatStringParams(objectArray);
        this.logger.trace((Object)string);
        System.out.println(string);
        this.logFileWrapper.write(string);
    }

    public void logDebug(String ... stringArray) {
        String string = this.concatStringParams(stringArray);
        this.logger.debug((Object)string);
        System.out.println(string);
        this.logFileWrapper.write(string);
    }

    public void logDebug(Exception exception, String ... stringArray) {
        String string = this.concatStringParams(stringArray);
        this.logger.debug((Object)string, (Throwable)exception);
        System.out.println(string + SPACE + exception.getMessage());
        this.logFileWrapper.write(string);
    }

    public void logError(Object ... objectArray) {
        String string = this.concatStringParams(objectArray);
        this.logger.error((Object)string);
        System.err.println(string);
        this.logFileWrapper.write(string);
    }

    public void logError(Exception exception, Object ... objectArray) {
        String string = this.concatStringParams(objectArray);
        this.logger.error((Object)string, (Throwable)exception);
        System.err.println(string + SPACE + exception.getMessage());
        this.logFileWrapper.write(string);
    }

    private String concatStringParams(Object ... objectArray) {
        StringBuilder stringBuilder = null;
        if (objectArray != null) {
            stringBuilder = new StringBuilder();
            if (this.prefix != null) {
                stringBuilder.append(this.prefix);
                stringBuilder.append(SPACE);
            }
            for (Object object : objectArray) {
                stringBuilder.append(object.toString());
                stringBuilder.append(SPACE);
            }
        }
        if (stringBuilder == null) {
            return EMPTY;
        }
        return stringBuilder.toString();
    }
}

