/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.server.busobj.BasicProcessInfo;
import com.helpsystems.common.server.dm.ActiveProcessAM;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentEventProcess;
import com.helpsystems.enterprise.core.busobj.ProcessEvent;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.module.AgentEventMonitorAMImpl;
import com.helpsystems.enterprise.module.AgentEventMonitorExecutor;
import java.util.HashMap;
import org.apache.log4j.Logger;

class ProcessEventMonitorExecutor
extends AgentEventMonitorExecutor {
    private static final Logger logger = Logger.getLogger(ProcessEventMonitorExecutor.class);
    private HashMap<String, ProcessTracker> lastInfoMap = new HashMap();

    ProcessEventMonitorExecutor(AgentEventMonitor agentEventMonitor, AgentEventMonitorAMImpl agentEventMonitorAMImpl, long l, JobExecDM jobExecDM) {
        super(agentEventMonitor, agentEventMonitorAMImpl, l, jobExecDM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runPoll() {
        ActiveProcessAM activeProcessAM = this.getProcessAM();
        BasicProcessInfo[] basicProcessInfoArray = null;
        DataSet dataSet = null;
        try {
            dataSet = activeProcessAM.getDataSet(null, null, null);
            basicProcessInfoArray = dataSet.size() == 0 ? new BasicProcessInfo[]{} : (BasicProcessInfo[])ArrayDataSet.toArray((DataSet)dataSet, (boolean)false);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to evaluate Agent Process Monitor " + this.aem.getName()), (Throwable)exception);
            return;
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.firstPoll) {
            this.firstPoll = false;
            this.purgeAndFillMap(basicProcessInfoArray);
            return;
        }
        ProcessEvent processEvent = (ProcessEvent)this.aem;
        AgentEventProcess agentEventProcess = processEvent.getAgentEventProcess();
        HashMap<String, ProcessTracker> hashMap = new HashMap<String, ProcessTracker>();
        hashMap.putAll(this.lastInfoMap);
        for (BasicProcessInfo basicProcessInfo : basicProcessInfoArray) {
            ProcessTracker processTracker = (ProcessTracker)hashMap.remove(basicProcessInfo.getPid());
            if (processTracker != null) {
                if (!processTracker.timeToFire()) continue;
                String string = "Process Started and has run " + processTracker.minutesToDelay + " minutes";
                if (processTracker.minutesToDelay == 1) {
                    string = "Process Started and has run one minute";
                }
                this.fireEvent(AgentEventHistoryInfo.encodeEventData(basicProcessInfo), string);
                continue;
            }
            if (processEvent.getType() != 301 || !this.matchesUserCriteria(basicProcessInfo.getUser(), agentEventProcess) || !this.matchesCommandCriteria(basicProcessInfo.getCommand(), agentEventProcess)) continue;
            int n = agentEventProcess.getProcessTime();
            this.lastInfoMap.put(basicProcessInfo.getPid(), new ProcessTracker(basicProcessInfo, n));
            if (n != 0) continue;
            this.fireEvent(AgentEventHistoryInfo.encodeEventData(basicProcessInfo), "Process Started");
        }
        if (processEvent.getType() == 302) {
            for (ProcessTracker processTracker : hashMap.values()) {
                BasicProcessInfo basicProcessInfo = processTracker.info;
                if (!this.matchesUserCriteria(basicProcessInfo.getUser(), agentEventProcess) || !this.matchesCommandCriteria(basicProcessInfo.getCommand(), agentEventProcess)) continue;
                this.fireEvent(AgentEventHistoryInfo.encodeEventData(basicProcessInfo), "Process Ended");
            }
        }
        this.purgeAndFillMap(basicProcessInfoArray);
    }

    private boolean matchesUserCriteria(String string, AgentEventProcess agentEventProcess) {
        String string2 = agentEventProcess.getUserName();
        if (string2 == null) {
            return true;
        }
        if ((string2 = string2.trim().toLowerCase()).length() == 0) {
            return true;
        }
        String string3 = string;
        if (string == null) {
            return false;
        }
        if ((string3 = string3.trim().toLowerCase()).length() == 0) {
            return false;
        }
        int n = agentEventProcess.getUserCompareValue();
        if (n == 0) {
            return string3.startsWith(string2);
        }
        if (n == 1) {
            return string3.contains(string2);
        }
        if (n == 2) {
            return string3.equals(string2);
        }
        if (n == 3) {
            return !string3.equals(string2);
        }
        return false;
    }

    private boolean matchesCommandCriteria(String string, AgentEventProcess agentEventProcess) {
        String string2 = agentEventProcess.getProcessName();
        if (string2 == null) {
            return true;
        }
        if ((string2 = string2.trim().toLowerCase()).length() == 0) {
            return true;
        }
        String string3 = string;
        if (string == null) {
            return false;
        }
        if ((string3 = string3.trim().toLowerCase()).length() == 0) {
            return false;
        }
        int n = agentEventProcess.getProcessCompareValue();
        if (n == 0) {
            return string3.startsWith(string2);
        }
        if (n == 1) {
            return string3.contains(string2);
        }
        if (n == 2) {
            return string3.endsWith(string2);
        }
        return false;
    }

    private void purgeAndFillMap(BasicProcessInfo[] basicProcessInfoArray) {
        HashMap<String, ProcessTracker> hashMap = new HashMap<String, ProcessTracker>();
        hashMap.putAll(this.lastInfoMap);
        this.lastInfoMap.clear();
        for (BasicProcessInfo basicProcessInfo : basicProcessInfoArray) {
            ProcessTracker processTracker = (ProcessTracker)hashMap.get(basicProcessInfo.getPid());
            if (processTracker != null) {
                this.lastInfoMap.put(basicProcessInfo.getPid(), processTracker);
                continue;
            }
            this.lastInfoMap.put(basicProcessInfo.getPid(), new ProcessTracker(basicProcessInfo, 0));
        }
    }

    class ProcessTracker {
        BasicProcessInfo info;
        long whenToFire;
        int minutesToDelay;

        ProcessTracker(BasicProcessInfo basicProcessInfo, int n) {
            this.info = basicProcessInfo;
            this.minutesToDelay = n;
            if (n > 0) {
                this.whenToFire = System.currentTimeMillis() + (long)(n * 60 * 1000);
            }
        }

        boolean timeToFire() {
            if (this.whenToFire == 0L) {
                return false;
            }
            long l = System.currentTimeMillis();
            if (l >= this.whenToFire) {
                this.whenToFire = 0L;
                return true;
            }
            return false;
        }
    }
}

