/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.enterprise.module.windows.GenerateConsoleCtrlEvent;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.LocalAgentAM;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class InteractiveCommandProcessor {
    private static Logger logger = Logger.getLogger(InteractiveCommandProcessor.class);
    private static final String name = "Interactive Command Processor";
    public static final String CMD_SHUTDOWN = "shutdown";
    public static final String CMD_SHUTDOWN_NOW = "shutdown now";
    public static final String CMD_SHUTDOWN_RESTART = "shutdown restart";
    public static final String CMD_SHUTDOWN_RESTART_NOW = "shutdown restart now";
    public static final String SET_LOGGING = "LOGGING";
    public static final String LOGGING_INFO = "INFO";
    public static final String LOGGING_DEBUG = "DEBUG";
    public static final String LOGGING_TRACE = "TRACE";
    public static final String CMD_JVMDUMP = "dump";
    public static boolean useDaemonThread = true;
    public static final String CMD_EXIT = "exit";
    private AgentPeer agentPeer = null;
    private boolean endProcessor = false;

    public static void startProcessor(final AgentPeer agentPeer) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    InteractiveCommandProcessor interactiveCommandProcessor = new InteractiveCommandProcessor(agentPeer);
                    interactiveCommandProcessor.processor();
                }
                catch (Throwable throwable) {
                    logger.warn((Object)("Interactive Command Processor Error: " + throwable.getLocalizedMessage()), throwable);
                }
                finally {
                    if (!useDaemonThread) {
                        System.exit(0);
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        if (useDaemonThread) {
            thread.setDaemon(true);
            thread.setName("Interactive Command Processor Daemon");
        } else {
            thread.setDaemon(false);
            thread.setName("Interactive Command Processor Thread - Does not support restart");
        }
        thread.start();
    }

    private InteractiveCommandProcessor(AgentPeer agentPeer) {
        this.agentPeer = agentPeer;
    }

    private void processor() {
        logger.trace((Object)"Starting Interactive Command Processor.");
        InputStream inputStream = System.in;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            while (true) {
                if (inputStream.available() > 0) {
                    String string = bufferedReader.readLine();
                    this.processCommand(string);
                    if (!this.endProcessor) continue;
                    break;
                }
                try {
                    Thread.yield();
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        logger.trace((Object)"Ending Interactive Command Processor.");
    }

    private void processCommand(String string) {
        String string2 = this.generateTag();
        if (string == null) {
            this.sendError(string2, "Null command.");
            return;
        }
        logger.trace((Object)(string2 + "Processing Command: " + string));
        try {
            String string3 = string.toLowerCase().trim();
            if (string3.length() == 0) {
                this.sendError(string2, "Blank command: " + string);
            } else if (string3.startsWith(CMD_SHUTDOWN)) {
                this.process_Shutdown(string2, string);
            } else if (string3.startsWith(CMD_JVMDUMP)) {
                this.process_Dump(string2, string);
            } else if (string3.startsWith(CMD_EXIT)) {
                this.process_Exit(string2, string);
            } else if (string3.startsWith(SET_LOGGING.toLowerCase())) {
                this.process_set_logging(string2, string);
            } else {
                this.sendError(string2, "Unknown command: " + string);
            }
        }
        catch (Throwable throwable) {
            String string4 = throwable.getLocalizedMessage();
            logger.error((Object)string4, throwable);
            this.sendError(string2, string4);
        }
    }

    private void process_set_logging(String string, String string2) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(string + "Processing set logging Command: " + string2));
        }
        String string3 = string2.toUpperCase();
        int n = 20000;
        if (string3.contains(LOGGING_DEBUG)) {
            n = 10000;
        } else if (string3.contains(LOGGING_TRACE)) {
            n = 5000;
        }
        try {
            IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManager((String)"PEER.PeerInfoManager");
            iPeerInfoManager.setLoggingLevel(n);
            this.sendFinished(string, string2);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to change logging level.", (Throwable)exception);
            this.sendError(string, string2);
        }
    }

    private void process_Exit(String string, String string2) {
        logger.trace((Object)(string + "Processing Exit Command: " + string2));
        this.endProcessor = true;
        this.sendFinished(string, string2);
    }

    private void process_Shutdown(String string, String string2) {
        logger.trace((Object)(string + "Processing Shutdown Command: " + string2));
        if (this.agentPeer != null) {
            boolean bl = string2.toLowerCase().contains(" now");
            boolean bl2 = string2.toLowerCase().contains(" restart");
            LocalAgentAM localAgentAM = (LocalAgentAM)ManagerRegistry.getManager((String)"ENTERPRISE.LocalAgentAM");
            try {
                localAgentAM.shutdown(!bl, bl2, this.agentPeer.getShutdownCommand());
            }
            catch (Exception exception) {
                String string3 = "Unable to send shutdown command";
                logger.warn((Object)(string + string3), (Throwable)exception);
                this.sendError(string, string3);
            }
        } else {
            String string4 = "Shutdown failed.  Agent Peer is not set.";
            logger.error((Object)(string + string4));
            this.sendError(string, string4);
            return;
        }
    }

    private void process_Dump(String string, String string2) {
        logger.trace((Object)(string + "Processing Dump: " + string2));
        GenerateConsoleCtrlEvent generateConsoleCtrlEvent = new GenerateConsoleCtrlEvent();
        generateConsoleCtrlEvent.generateThreadDump(0);
        this.sendFinished(string, string2);
    }

    private void sendError(String string, String string2) {
        System.out.println(string + "Command error: " + string2);
    }

    private void sendFinished(String string, String string2) {
        System.out.println(string + "Command completed: " + string2);
    }

    private String generateTag() {
        return String.valueOf(System.currentTimeMillis()) + ": ";
    }

    public static void main(String[] stringArray) {
        PropertyConfigurator.configureAndWatch((String)"log4j.properties", (long)5000L);
        useDaemonThread = false;
        InteractiveCommandProcessor.startProcessor(null);
    }
}

