/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.enterprise.core.busobj.AgentEventFile;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.DirectoryEvent;
import com.helpsystems.enterprise.core.busobj.FileEvent;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.module.AgentEventMonitorAMImpl;
import com.helpsystems.enterprise.module.AgentEventMonitorExecutor;
import com.helpsystems.enterprise.module.exec.WildcardEvaluator;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

class FileEventMonitorExecutor
extends AgentEventMonitorExecutor {
    private static final Logger logger = Logger.getLogger(FileEventMonitorExecutor.class);
    private Map<String, SimpleFileInfo> fileInfoMap;
    private byte[] requiredEOFBytes;

    FileEventMonitorExecutor(AgentEventMonitor agentEventMonitor, AgentEventMonitorAMImpl agentEventMonitorAMImpl, long l, JobExecDM jobExecDM) {
        super(agentEventMonitor, agentEventMonitorAMImpl, l, jobExecDM);
        String string;
        this.firstPoll = true;
        this.fileInfoMap = new HashMap<String, SimpleFileInfo>();
        FileEvent fileEvent = (FileEvent)agentEventMonitor;
        AgentEventFile agentEventFile = fileEvent.getAgentEventFile();
        if (agentEventFile.getEofTest() == 2 && (string = agentEventFile.getEofHexMarker()) != null) {
            this.requiredEOFBytes = Convert.hexToBytes((String)string);
        }
        if (agentEventFile.getEofTest() == 1) {
            try {
                this.requiredEOFBytes = agentEventFile.getEofTextMarker().getBytes(agentEventFile.getEofTextEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)("Error decoding EOF Text '" + agentEventFile.getEofTextMarker() + "' with encoding " + agentEventFile.getEofTextEncoding() + "."));
            }
        }
    }

    @Override
    public void runPoll() {
        FileEvent fileEvent = (FileEvent)this.aem;
        this.monitorFileEvents(fileEvent);
        this.firstPoll = false;
    }

    private void purgeAndFillMap(RemoteFile[] remoteFileArray) {
        HashMap<String, SimpleFileInfo> hashMap = new HashMap<String, SimpleFileInfo>();
        hashMap.putAll(this.fileInfoMap);
        this.fileInfoMap.clear();
        for (RemoteFile remoteFile : remoteFileArray) {
            String string = remoteFile.getAbsolutePath();
            SimpleFileInfo simpleFileInfo = (SimpleFileInfo)hashMap.get(string);
            if (simpleFileInfo == null) {
                simpleFileInfo = new SimpleFileInfo();
                if (!this.firstPoll) {
                    simpleFileInfo.isNew = true;
                }
            }
            simpleFileInfo.date = remoteFile.lastModified();
            simpleFileInfo.whenLastChanged = remoteFile.lastModified();
            if (remoteFile.isFile()) {
                if (simpleFileInfo.size != remoteFile.length()) {
                    simpleFileInfo.whenLastChanged = System.currentTimeMillis();
                }
                simpleFileInfo.size = remoteFile.length();
            } else if (remoteFile.isDirectory()) {
                int n = this.getSubFileCount(remoteFile);
                long l = this.getSize(remoteFile);
                if (simpleFileInfo.size != l || simpleFileInfo.subFileCount != n) {
                    simpleFileInfo.size = l;
                    simpleFileInfo.subFileCount = n;
                    simpleFileInfo.whenLastChanged = System.currentTimeMillis();
                }
            }
            this.fileInfoMap.put(string, simpleFileInfo);
        }
    }

    private long getSize(RemoteFile remoteFile) {
        if (remoteFile.isFile()) {
            return remoteFile.length();
        }
        File file = new File(remoteFile.getAbsolutePath());
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        long l = 0L;
        for (File file2 : fileArray) {
            if (!file2.isFile()) continue;
            l += file2.length();
        }
        return l;
    }

    private int getSubFileCount(RemoteFile remoteFile) {
        if (remoteFile.isFile()) {
            return 0;
        }
        File file = new File(remoteFile.getAbsolutePath());
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0;
        }
        return fileArray.length;
    }

    private void monitorFileEvents(FileEvent fileEvent) {
        AgentEventFile agentEventFile = fileEvent.getAgentEventFile();
        try {
            int n = 0;
            if (fileEvent instanceof DirectoryEvent) {
                n = 1;
            }
            RemoteFile[] remoteFileArray = WildcardEvaluator.evaluateWildcards(this.getLocalFileAM(), agentEventFile.getFilePath(), n);
            if (this.firstPoll) {
                this.purgeAndFillMap(remoteFileArray);
                return;
            }
            int n2 = fileEvent.getType();
            switch (n2) {
                case 101: 
                case 201: {
                    this.checkFilesAdded(remoteFileArray);
                    break;
                }
                case 102: 
                case 202: {
                    this.checkFilesDeleted(remoteFileArray);
                    break;
                }
                case 103: 
                case 203: {
                    this.checkFilesChanged(remoteFileArray);
                    break;
                }
                case 104: 
                case 204: {
                    this.checkFilesThreshold(remoteFileArray);
                    break;
                }
                default: {
                    logger.info((Object)("Don't know how to process agent event type " + n2));
                    this.removeSelf();
                    return;
                }
            }
            this.purgeAndFillMap(remoteFileArray);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to evaluate monitor " + this.aem.getName()), (Throwable)exception);
        }
    }

    private void checkFilesAdded(RemoteFile[] remoteFileArray) {
        FileEvent fileEvent = (FileEvent)this.aem;
        AgentEventFile agentEventFile = fileEvent.getAgentEventFile();
        for (RemoteFile remoteFile : remoteFileArray) {
            long l;
            SimpleFileInfo simpleFileInfo = this.fileInfoMap.get(remoteFile.getAbsolutePath());
            int n = agentEventFile.getRecheckSeconds();
            if (simpleFileInfo == null && n == 0) {
                if (!this.fileEOFValid(remoteFile)) continue;
                this.fireEvent(remoteFile.getAbsolutePath(), "File added, wait time = 0");
                simpleFileInfo = new SimpleFileInfo();
                this.fileInfoMap.put(remoteFile.getAbsolutePath(), simpleFileInfo);
            }
            if (simpleFileInfo == null || !simpleFileInfo.isNew || (l = System.currentTimeMillis() - simpleFileInfo.whenLastChanged) < (long)(n * 1000) || !this.fileEOFValid(remoteFile)) continue;
            simpleFileInfo.isNew = false;
            this.fireEvent(remoteFile.getAbsolutePath(), "File added and has finished growing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fileEOFValid(RemoteFile remoteFile) {
        if (this.requiredEOFBytes == null || this.requiredEOFBytes.length == 0) {
            return true;
        }
        if (remoteFile.length() < (long)this.requiredEOFBytes.length) {
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(remoteFile.getAbsolutePath(), "r");
            randomAccessFile.seek(randomAccessFile.length() - (long)this.requiredEOFBytes.length);
            byte[] byArray = new byte[this.requiredEOFBytes.length];
            randomAccessFile.read(byArray);
            boolean bl = Arrays.equals(this.requiredEOFBytes, byArray);
            return bl;
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to read EOF chars from file: " + remoteFile.getAbsolutePath()), (Throwable)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void checkFilesDeleted(RemoteFile[] remoteFileArray) {
        for (RemoteFile remoteFile : remoteFileArray) {
            this.fileInfoMap.remove(remoteFile.getAbsolutePath());
        }
        for (String string : this.fileInfoMap.keySet()) {
            this.fireEvent(string, "File deleted");
        }
    }

    private void checkFilesChanged(RemoteFile[] remoteFileArray) {
        FileEvent fileEvent = (FileEvent)this.aem;
        AgentEventFile agentEventFile = fileEvent.getAgentEventFile();
        for (RemoteFile remoteFile : remoteFileArray) {
            SimpleFileInfo simpleFileInfo = this.fileInfoMap.get(remoteFile.getAbsolutePath());
            if (simpleFileInfo == null) continue;
            if (agentEventFile.isChangeDateFlag() && simpleFileInfo.date != remoteFile.lastModified()) {
                this.fireEvent(remoteFile.getAbsolutePath(), "File date changed");
                continue;
            }
            long l = this.getSize(remoteFile);
            long l2 = simpleFileInfo.size;
            int n = simpleFileInfo.subFileCount;
            int n2 = this.getSubFileCount(remoteFile);
            if (agentEventFile.isIncreasedFlag() && (l > l2 || n2 > n)) {
                this.fireEvent(remoteFile.getAbsolutePath(), "File increased");
            }
            if (!agentEventFile.isDecreasedFlag() || l >= l2 && n2 >= n) continue;
            this.fireEvent(remoteFile.getAbsolutePath(), "File decreased");
        }
    }

    private void checkFilesThreshold(RemoteFile[] remoteFileArray) {
        FileEvent fileEvent = (FileEvent)this.aem;
        AgentEventFile agentEventFile = fileEvent.getAgentEventFile();
        for (RemoteFile remoteFile : remoteFileArray) {
            int n;
            long l = 0L;
            SimpleFileInfo simpleFileInfo = this.fileInfoMap.get(remoteFile.getAbsolutePath());
            if (simpleFileInfo != null) {
                l = simpleFileInfo.size;
            }
            long l2 = this.getSize(remoteFile);
            double d = fileEvent.getIncreaseSizeThreshold();
            double d2 = fileEvent.getDecreaseSizeThreshold();
            if (agentEventFile.isGreaterThanFlag() && (double)l2 >= d) {
                n = agentEventFile.getFireWhenIncreasing();
                if (n == 0) {
                    if (!((double)l < d)) continue;
                    this.fireEvent(remoteFile.getAbsolutePath(), "File exceeded threshold, first time");
                    continue;
                }
                if (n == 2) {
                    if (l >= l2) continue;
                    this.fireEvent(remoteFile.getAbsolutePath(), "File over threshold and still increasing");
                    continue;
                }
                if (n == 1) {
                    this.fireEvent(remoteFile.getAbsolutePath(), "File still over threshold");
                    continue;
                }
            }
            if (!agentEventFile.isLessThanFlag() || !((double)l2 <= d2)) continue;
            n = agentEventFile.getFireWhenDecreasing();
            if (n == 0) {
                if (!((double)l > d2) && (l != 0L || simpleFileInfo != null || !((double)l2 < d2))) continue;
                this.fireEvent(remoteFile.getAbsolutePath(), "File below threshold, first time");
                continue;
            }
            if (n == 2) {
                if (l <= l2) continue;
                this.fireEvent(remoteFile.getAbsolutePath(), "File below threshold and still decreasing");
                continue;
            }
            if (n != 1) continue;
            this.fireEvent(remoteFile.getAbsolutePath(), "File still under threshold");
        }
    }

    private class SimpleFileInfo {
        long size;
        long date;
        long whenLastChanged;
        boolean isNew;
        int subFileCount;

        private SimpleFileInfo() {
        }
    }
}

