/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.MailSentEvent;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.util.FileHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Logger;

public class EnterpriseEmailAMImpl
extends AbstractManager
implements EnterpriseEmailAM {
    private static Logger logger = Logger.getLogger(EnterpriseEmailAMImpl.class);
    private BlockingQueue<QueuedMessage> queue;
    private SystemSetupDM systemSetupDM;
    private static final String EMAIL_EOL = "<br>";
    private static final String ENCODING = "UTF-8";
    private List<SimpleEventListener> eventListenerList = new ArrayList<SimpleEventListener>();
    private static final Message.RecipientType RECIPIENT_TYPE = Message.RecipientType.BCC;

    public EnterpriseEmailAMImpl(SystemSetupDM systemSetupDM) {
        ValidationHelper.checkForNull((String)"SystemSetupDM", (Object)systemSetupDM);
        this.systemSetupDM = systemSetupDM;
        this.setName("ENTERPRISE.EnterpriseEmailAM");
        this.queue = new LinkedBlockingQueue<QueuedMessage>();
        Thread thread = new Thread(new EmailQueueRunner());
        thread.setName("EmailQueueRunner");
        thread.start();
    }

    @Override
    public void sendMessage(String string, String string2, String string3) throws ResourceUnavailableException, ActionFailedException {
        String[] stringArray = new String[]{string};
        this.sendMessage(stringArray, string2, string3);
    }

    @Override
    public void sendMessage(String[] stringArray, String string, String string2) throws ResourceUnavailableException, ActionFailedException {
        this.sendMessage(stringArray, string, string2, null);
    }

    @Override
    public void sendMessage(String[] stringArray, String string, String string2, String[] stringArray2) throws ResourceUnavailableException, ActionFailedException {
        ValidationHelper.checkForNullAndBlank((String)"subjectString", (String)string);
        SystemSetup systemSetup = null;
        try {
            systemSetup = this.systemSetupDM.get();
        }
        catch (Exception exception) {
            logger.error((Object)"Error retrieving System Setup.", (Throwable)exception);
            return;
        }
        if (systemSetup != null && systemSetup.getEmailServerAddress() != null && systemSetup.getEmailServerAddress().trim().length() > 0) {
            QueuedMessage queuedMessage = new QueuedMessage();
            queuedMessage.setSystemSetup(systemSetup);
            queuedMessage.setRecipients(stringArray);
            queuedMessage.setSubject(string);
            queuedMessage.setContent(string2);
            this.loadQueuedMessageFooter(queuedMessage);
            queuedMessage.setAttachments(stringArray2);
            this.queue.offer(queuedMessage);
        }
    }

    private void loadQueuedMessageFooter(QueuedMessage queuedMessage) {
        String string = this.getSystemName();
        queuedMessage.loadFooter(string, System.currentTimeMillis());
    }

    private String getSystemName() {
        String string = null;
        try {
            string = System.getenv("COMPUTERNAME");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || string.trim().length() == 0) {
            try {
                InetAddress inetAddress = null;
                inetAddress = InetAddress.getLocalHost();
                string = inetAddress.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (string == null || string.trim().length() == 0) {
            return "unavailable";
        }
        return string;
    }

    @Override
    public void sendMessage(String[] stringArray, String string, String string2, String[] stringArray2, Object object) throws ResourceUnavailableException, ActionFailedException {
        ValidationHelper.checkForNullAndBlank((String)"subjectString", (String)string);
        SystemSetup systemSetup = null;
        try {
            systemSetup = this.systemSetupDM.get();
        }
        catch (Exception exception) {
            logger.error((Object)"Error retrieving System Setup.", (Throwable)exception);
            return;
        }
        if (systemSetup != null && systemSetup.getEmailServerAddress() != null && systemSetup.getEmailServerAddress().trim().length() > 0) {
            QueuedMessage queuedMessage = new QueuedMessage();
            queuedMessage.setSystemSetup(systemSetup);
            queuedMessage.setRecipients(stringArray);
            queuedMessage.setSubject(string);
            queuedMessage.setContent(string2);
            this.loadQueuedMessageFooter(queuedMessage);
            queuedMessage.setAttachments(stringArray2);
            queuedMessage.setObj(object);
            this.queue.offer(queuedMessage);
        }
    }

    @Override
    public void addEventListener(SimpleEventListener simpleEventListener) {
        this.eventListenerList.add(simpleEventListener);
    }

    @Override
    public void removeEventListener(SimpleEventListener simpleEventListener) {
        if (this.eventListenerList.contains(simpleEventListener)) {
            this.eventListenerList.remove(simpleEventListener);
        }
    }

    class QueuedMessage {
        private SystemSetup systemSetup;
        private String[] recipients;
        private String subject;
        private String content;
        private String footer = null;
        private String[] attachments;
        private Object obj;

        QueuedMessage() {
        }

        public SystemSetup getSystemSetup() {
            return this.systemSetup;
        }

        public void setSystemSetup(SystemSetup systemSetup) {
            this.systemSetup = systemSetup;
        }

        public String[] getRecipients() {
            return this.recipients;
        }

        public void setRecipients(String[] stringArray) {
            this.recipients = stringArray;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String string) {
            this.subject = string;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String string) {
            this.content = string;
        }

        public String getFooter() {
            if (this.footer == null) {
                return "";
            }
            return this.footer;
        }

        public void setFooter(String string) {
            this.footer = string;
        }

        public void loadFooter(String string, long l) {
            this.footer = "<br><br>Sent from Automate Schedule server: " + string + EnterpriseEmailAMImpl.EMAIL_EOL + "Sent date/time: " + ScheduleLogger.formatTimeStampSecs(l);
        }

        public String[] getAttachments() {
            return this.attachments;
        }

        public void setAttachments(String[] stringArray) {
            this.attachments = stringArray;
        }

        public Object getObj() {
            return this.obj;
        }

        public void setObj(Object object) {
            this.obj = object;
        }

        public MimeMessage getMineMessage(Session session) throws MessagingException {
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setSentDate(new Date(System.currentTimeMillis()));
            mimeMessage.setSubject(this.getSubject(), EnterpriseEmailAMImpl.ENCODING);
            InternetAddress internetAddress = new InternetAddress(this.systemSetup.getEmailSenderAddress());
            mimeMessage.setFrom((Address)internetAddress);
            int n = 0;
            for (int i = 0; i < this.recipients.length; ++i) {
                if (this.recipients[i] != null && this.recipients[i].trim().length() > 0) {
                    try {
                        InternetAddress internetAddress2 = new InternetAddress(this.recipients[i].trim());
                        mimeMessage.addRecipient(RECIPIENT_TYPE, (Address)internetAddress2);
                        ++n;
                    }
                    catch (MessagingException messagingException) {
                        logger.error((Object)("Error adding recipient " + this.recipients[i] + " to message: " + mimeMessage.getSubject()), (Throwable)messagingException);
                    }
                    continue;
                }
                logger.debug((Object)("Null or blank recipient found for message: " + mimeMessage.getSubject()));
            }
            if (n == 0) {
                throw new MessagingException("No valid recipients were added to message: " + mimeMessage.getSubject());
            }
            return mimeMessage;
        }

        public MimeBodyPart getMessageBody() throws MessagingException {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)(this.getContent() + this.getFooter()), "text/html; charset=UTF-8");
            return mimeBodyPart;
        }

        public MimeBodyPart[] getAttachmentList(String string) throws MessagingException {
            if (this.attachments == null || this.attachments.length < 1) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Preparing to send the following attachments for message '" + string + "':"));
                logger.debug((Object)"*** Start of Attachment List ***");
            }
            MimeBodyPart[] mimeBodyPartArray = new MimeBodyPart[this.attachments.length];
            for (int i = 0; i < this.attachments.length; ++i) {
                String string2;
                FileDataSource fileDataSource = new FileDataSource(this.attachments[i]){

                    public String getContentType() {
                        return "application/octet-stream";
                    }
                };
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                String string3 = string2 = FileHandler.getFileExactName(this.attachments[i]);
                try {
                    string3 = MimeUtility.encodeText((String)string2, (String)EnterpriseEmailAMImpl.ENCODING, (String)"B");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.warn((Object)unsupportedEncodingException);
                }
                mimeBodyPart.setFileName(string3);
                mimeBodyPartArray[i] = mimeBodyPart;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("    " + this.attachments[i]));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"*** End of Attachment List ***");
            }
            return mimeBodyPartArray;
        }
    }

    class EmailQueueRunner
    implements Runnable {
        EmailQueueRunner() {
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                while (true) {
                    this.dequeue();
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"The EmailQueueRunner has encoundered a severe error. No more email messages will be sent until the server is restarted.", throwable);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getProperties(SystemSetup systemSetup) {
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                String string = "email_client.properties";
                File file = new File(string);
                if (file.exists()) {
                    logger.debug((Object)("Loading email client properties: " + file.getAbsolutePath()));
                    inputStream = new FileInputStream(file);
                    if (inputStream != null) {
                        properties.load(inputStream);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Email client properties file was not found: " + file.getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                logger.warn((Object)"Error loading email client properties file: ", (Throwable)exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            int n = systemSetup.getEmailServerPort();
            int n2 = systemSetup.getEmailServerTimeout() * 1000;
            properties.put("mail.smtp.host", systemSetup.getEmailServerAddress());
            properties.put("mail.smtp.port", Integer.toString(n));
            properties.put("mail.smtp.connectiontimeout", Integer.toString(n2));
            properties.put("mail.smtp.timeout", Integer.toString(n2));
            properties.put("mail.smtp.quitwait", "false");
            if (systemSetup.isEmailServerRequiresAuthentication()) {
                properties.put("mail.smtp.auth", "true");
            }
            if (systemSetup.isEmailUseSSL()) {
                properties.put("mail.smtp.starttls.enable", "true");
                properties.put("mail.smtp.socketFactory.port", Integer.toString(n));
                properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.put("mail.smtp.socketFactory.fallback", "false");
            }
            if (logger.isTraceEnabled()) {
                try {
                    logger.trace((Object)("Loaded Properties: " + properties.size()));
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        logger.trace((Object)(" ==>  Key: " + entry.getKey() + " Value: " + entry.getValue()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return properties;
        }

        private Session getMailSession(final SystemSetup systemSetup) {
            Session session;
            Properties properties = this.getProperties(systemSetup);
            if (systemSetup.isEmailServerRequiresAuthentication()) {
                Authenticator authenticator = new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(systemSetup.getEmailServerLoginName(), systemSetup.getEmailServerLoginPassword());
                    }
                };
                session = Session.getInstance((Properties)properties, (Authenticator)authenticator);
            } else {
                session = Session.getInstance((Properties)properties);
            }
            if (logger.isTraceEnabled()) {
                session.setDebug(true);
            }
            return session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void dequeue() {
            QueuedMessage queuedMessage = null;
            try {
                queuedMessage = (QueuedMessage)EnterpriseEmailAMImpl.this.queue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (queuedMessage == null) {
                return;
            }
            SystemSetup systemSetup = queuedMessage.getSystemSetup();
            try {
                Object object;
                Session session = this.getMailSession(systemSetup);
                MimeMessage mimeMessage = queuedMessage.getMineMessage(session);
                MimeBodyPart mimeBodyPart = queuedMessage.getMessageBody();
                MimeBodyPart[] mimeBodyPartArray = queuedMessage.getAttachmentList(mimeMessage.getSubject());
                MimeMultipart mimeMultipart = new MimeMultipart();
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                if (mimeBodyPartArray != null) {
                    for (int i = 0; i < mimeBodyPartArray.length; ++i) {
                        mimeMultipart.addBodyPart((BodyPart)mimeBodyPartArray[i]);
                    }
                }
                mimeMessage.setContent((Multipart)mimeMultipart);
                Transport transport = session.getTransport("smtp");
                if (systemSetup.isEmailServerRequiresAuthentication()) {
                    transport.connect(systemSetup.getEmailServerAddress(), systemSetup.getEmailServerPort(), systemSetup.getEmailServerLoginName(), systemSetup.getEmailServerLoginPassword());
                } else {
                    transport.connect();
                }
                Address[] addressArray = mimeMessage.getRecipients(RECIPIENT_TYPE);
                int n = addressArray.length;
                ArrayList<Address> arrayList = new ArrayList<Address>();
                ArrayList<Address> arrayList2 = new ArrayList<Address>();
                if (logger.isDebugEnabled()) {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (n2 = 0; n2 < n; ++n2) {
                        if (n2 > 0) {
                            stringBuffer.append(", ");
                        }
                        if (addressArray[n2] == null) {
                            stringBuffer.append("<null_recipient>");
                            continue;
                        }
                        stringBuffer.append(addressArray[n2].toString());
                    }
                    n2 = 0;
                    if (mimeBodyPartArray != null) {
                        n2 = mimeBodyPartArray.length;
                    }
                    logger.debug((Object)("Sending message '" + mimeMessage.getSubject() + "' with " + n2 + " attachment(s) to recipients: " + stringBuffer.toString()));
                }
                for (int i = 0; i < n; ++i) {
                    Address address = addressArray[i];
                    if (address == null) {
                        logger.debug((Object)("Not sending email to null recipient index # " + i));
                        continue;
                    }
                    object = new Address[]{address};
                    try {
                        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])object);
                        transport.sendMessage((Message)mimeMessage, (Address[])object);
                        arrayList.add(address);
                        continue;
                    }
                    catch (Throwable throwable) {
                        logger.error((Object)("Error sending message '" + mimeMessage.getSubject() + "' to recipient: " + address.toString()), throwable);
                        arrayList2.add(address);
                        continue;
                    }
                    finally {
                        if (i == n - 1) {
                            transport.close();
                        }
                    }
                }
                if (logger.isDebugEnabled() && arrayList.size() > 0) {
                    this.sendDebugLog(arrayList, queuedMessage.getSubject(), systemSetup.getEmailSenderAddress(), true);
                }
                if (logger.isDebugEnabled() && arrayList2.size() > 0) {
                    this.sendDebugLog(arrayList2, queuedMessage.getSubject(), systemSetup.getEmailSenderAddress(), false);
                }
                for (SimpleEventListener simpleEventListener : EnterpriseEmailAMImpl.this.eventListenerList) {
                    void var18_31;
                    object = new ArrayList();
                    for (Address address : arrayList) {
                        ((ArrayList)object).add(address.toString());
                    }
                    if (arrayList2.isEmpty()) {
                        simpleEventListener.serviceEvent((GenericEvent)new MailSentEvent(queuedMessage.getObj(), MailSentEvent.MailSentStatus.SUCCESS_SENT_STATUS, (ArrayList<String>)object));
                        continue;
                    }
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    for (Address address : arrayList2) {
                        arrayList3.add(address.toString());
                    }
                    MailSentEvent.MailSentStatus mailSentStatus = MailSentEvent.MailSentStatus.MIXED_SENT_STATUS;
                    if (arrayList.isEmpty()) {
                        MailSentEvent.MailSentStatus mailSentStatus2 = MailSentEvent.MailSentStatus.FAILED_SENT_STATUS;
                    }
                    simpleEventListener.serviceEvent((GenericEvent)new MailSentEvent(queuedMessage.getObj(), (MailSentEvent.MailSentStatus)var18_31, (ArrayList<String>)object, arrayList3));
                }
            }
            catch (Exception exception) {
                for (SimpleEventListener simpleEventListener : EnterpriseEmailAMImpl.this.eventListenerList) {
                    simpleEventListener.serviceEvent((GenericEvent)new MailSentEvent(queuedMessage.getObj(), MailSentEvent.MailSentStatus.FAILED_SENT_STATUS));
                }
                logger.error((Object)("Error sending message '" + queuedMessage.getSubject() + "'"), (Throwable)exception);
            }
        }

        private void sendDebugLog(List<Address> list, String string, String string2, boolean bl) {
            String string3 = "Sent ";
            if (!bl) {
                string3 = "Failed to send ";
            }
            if (list.size() == 1) {
                logger.debug((Object)(string3 + "email " + string + " from " + string2 + " to " + list.get(0)));
            } else {
                logger.debug((Object)(string3 + "email " + string + " from " + string2 + " to the following recipients:"));
                for (Address address : list) {
                    logger.debug((Object)("    " + address));
                }
            }
        }
    }
}

