/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.dm.AgentConfigAM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.peer.AgentControl;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.File;
import org.apache.log4j.Logger;

public class AgentConfigAMImpl
extends AbstractManager
implements AgentConfigAM {
    private static final Logger logger = Logger.getLogger(AgentConfigAMImpl.class);
    private AgentPeer peer;

    public AgentConfigAMImpl(AgentPeer agentPeer) {
        this.peer = agentPeer;
        this.setName("ENTERPRISE.AgentConfigAM");
    }

    @Override
    public int getOfflineEventHandling() throws ActionFailedException {
        AgentPeerConfig agentPeerConfig = this.peer.getAgentConfig();
        return agentPeerConfig.getOfflineEventHandling();
    }

    @Override
    public void setOfflineEventHandling(int n) throws ActionFailedException {
        AgentPeerConfig agentPeerConfig = this.peer.getAgentConfig();
        agentPeerConfig.setOfflineEventHandling(n);
        try {
            this.peer.saveConfig();
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to save config changes", (Throwable)exception);
        }
    }

    @Override
    public void switchServer(String string, int n) throws ActionFailedException {
        try {
            IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManager((String)"PEER.PeerInfoManager");
            if (!iPeerInfoManager.testSocket(string, n)) {
                throw new ActionFailedException("The agent cannot establish a connection to the Enterprise Server " + string + ":" + n);
            }
        }
        catch (Exception exception) {
            throw new ActionFailedException("The agent is unable to connect to " + string + ":" + n, (Throwable)exception);
        }
        try {
            this.peer.switchServer(string, n, true);
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to switch to server", (Throwable)exception);
        }
    }

    @Override
    public void setStandby(PeerDescriptor peerDescriptor) throws ActionFailedException {
        AgentPeerConfig agentPeerConfig = this.peer.getAgentConfig();
        agentPeerConfig.setStandby(peerDescriptor);
        try {
            this.peer.saveConfig();
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to save config changes", (Throwable)exception);
        }
    }

    @Override
    public String deleteWebServiceFiles(Agent agent) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (AgentControl.isWindows()) {
            stringBuilder.append(DefaultConfigPath.getDefaultPath());
            stringBuilder.append(File.separator);
            stringBuilder.append("webservice");
        } else {
            object = System.getProperty("user.dir");
            stringBuilder.append((String)object);
            stringBuilder.append(File.separator);
            stringBuilder.append("webservice");
            stringBuilder.append(File.separator);
            stringBuilder.append("requests");
        }
        object = new File(stringBuilder.toString());
        logger.info((Object)("Deleting Web Service files from: " + ((File)object).getAbsolutePath()));
        int n = 0;
        long l = System.currentTimeMillis() - 86400000L;
        if (((File)object).exists() && ((File)object).isDirectory()) {
            for (File file : ((File)object).listFiles()) {
                if (!file.getName().startsWith(String.valueOf(agent.getOid())) || !file.isFile() || file.lastModified() >= l) continue;
                try {
                    if (!file.delete()) continue;
                    logger.debug((Object)("Serialized Web Service Request file was deleted: " + file.getAbsolutePath()));
                    ++n;
                }
                catch (Exception exception) {
                    logger.error((Object)"Error deleting Serialized Web Service Request file.", (Throwable)exception);
                }
            }
        }
        String string = n + " serialized Web Service Request files older than " + ScheduleLogger.formatTimeStamp(l) + " were deleted from '" + ((File)object).getAbsolutePath() + "' on agent " + agent.getName() + ".";
        logger.info((Object)string);
        return string;
    }

    @Override
    public PeerDescriptor getStandby() {
        AgentPeerConfig agentPeerConfig = this.peer.getAgentConfig();
        return agentPeerConfig.getStandby();
    }
}

