/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.webservices.test;

import com.helpsystems.enterprise.core.webservices.WebServiceExecutor_Apache;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestComposite;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestParameter;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestProperty;
import com.helpsystems.enterprise.core.webservices.WebServiceServer;
import com.helpsystems.enterprise.core.webservices.test.WebServiceTestHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.apache.http.client.ClientProtocolException;

public class WebServiceTest
extends WebServiceTestHelper {
    private static final String DELIMITER = "=================================================================";
    private static final String SKYADMIN = "admin";
    private static final String SKYADMIN_PWD = "Enterprise2";
    WebServiceServer wssHttpBin = new WebServiceServer("http://httpbin.org/");
    WebServiceServer wssHttpBinBasic = new WebServiceServer("http://httpbin.org/");
    WebServiceServer wssHttpSkybot = new WebServiceServer("http://skybot-robot:8008/");

    public static void main(String[] stringArray) {
        WebServiceTest webServiceTest = new WebServiceTest();
        try {
            webServiceTest.runTests();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (ClientProtocolException clientProtocolException) {
            clientProtocolException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    private void runTests() throws UnsupportedEncodingException, ClientProtocolException, IOException, URISyntaxException {
        String string = "testuser";
        String string2 = "testpwd";
        this.wssHttpBin.resetAuthority();
        super.setBasicAuthority(string, "popcorn", string2, this.wssHttpBinBasic);
        super.setBasicAuthority(SKYADMIN, "popcorn", SKYADMIN_PWD, this.wssHttpSkybot);
        String string3 = "simple_put";
        WebServiceRequestComposite webServiceRequestComposite = this.loadPutRequest(this.wssHttpBin);
        this.processRequest(webServiceRequestComposite, string3);
        string3 = "simple_post";
        webServiceRequestComposite = this.loadPostRequest(this.wssHttpBin);
        this.processRequest(webServiceRequestComposite, string3);
        string3 = "simple_get_file_output";
        webServiceRequestComposite = this.loadGetRequestWithFileOutput(this.wssHttpBin, string3);
        this.processRequest(webServiceRequestComposite, string3);
        string3 = "simple_delete";
        webServiceRequestComposite = this.loadDeleteRequest(this.wssHttpBin);
        this.processRequest(webServiceRequestComposite, string3);
        string3 = "basic_authority";
        webServiceRequestComposite = this.loadBasicAuthRequest(this.wssHttpBinBasic, string, string2);
        this.processRequest(webServiceRequestComposite, string3);
        string3 = "skybot_hold_job";
        webServiceRequestComposite = this.loadSkybotHoldJobRequest(this.wssHttpSkybot);
        this.processRequest(webServiceRequestComposite, string3);
        string3 = "skybot_delete_job";
        webServiceRequestComposite = this.loadDeleteSkybotJobRequest(this.wssHttpSkybot);
        this.processRequest(webServiceRequestComposite, string3);
        System.out.println(DELIMITER);
        System.out.println("Web Service Tests Finished!");
        System.exit(0);
    }

    private void processRequest(WebServiceRequestComposite webServiceRequestComposite, String string) throws UnsupportedEncodingException, ClientProtocolException, IOException, URISyntaxException {
        System.out.println(DELIMITER);
        System.out.println(" Web Service Request Test Name: " + string);
        System.out.println(DELIMITER);
        WebServiceRequestComposite webServiceRequestComposite2 = WebServiceTest.wsrTestSaveRestore(webServiceRequestComposite, string);
        WebServiceExecutor_Apache webServiceExecutor_Apache = new WebServiceExecutor_Apache();
        int n = webServiceExecutor_Apache.processRequest(webServiceRequestComposite2);
        System.out.println();
        System.out.println("Web Service Request Return Code: " + n);
        System.out.println();
    }

    private static WebServiceRequestComposite wsrTestSaveRestore(WebServiceRequestComposite webServiceRequestComposite, String string) {
        try {
            String string2 = string + ".config.xml";
            WebServiceRequestComposite.saveToDisk(webServiceRequestComposite, string2);
            return WebServiceRequestComposite.restoreFromDisk(string2);
        }
        catch (Exception exception) {
            System.out.println("Error saving/restoring web service request.");
            exception.printStackTrace();
            return null;
        }
    }

    private WebServiceRequestComposite loadGetRequestWithFileOutput(WebServiceServer webServiceServer, String string) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("get");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.setOutputType(1);
        webServiceRequest.setOutputFileName(string + ".response.xml");
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("message", "my put message!", 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm1", "value1", 2));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm2", "value2", 3));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadPutRequest(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("put");
        webServiceRequest.setRequestMethod(2);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("message", "my put message!", 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm1", "value1", 2));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm2", "value2", 3));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadPostRequest(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("post");
        webServiceRequest.setRequestMethod(1);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("message", "my posted message!", 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm1", "value1", 2));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm2", "value2", 3));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadDeleteRequest(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("delete");
        webServiceRequest.setRequestMethod(3);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("message", "my delete message!", 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm1", "value1", 2));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm2", "value2", 3));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadBasicAuthRequest(WebServiceServer webServiceServer, String string, String string2) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("basic-auth/" + string + "/" + string2);
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("message", "my authenticated message!", 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm1", "value1", 2));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm2", "value2", 3));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadSkybotHoldJobRequest(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("automate-schedule/ws/jobs/DEMO_RUNS_DAILY/hold");
        webServiceRequest.setRequestMethod(0);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm1", "value1", 1));
        webServiceRequest.addParameter(new WebServiceRequestParameter("parm2", "value2", 2));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }

    private WebServiceRequestComposite loadDeleteSkybotJobRequest(WebServiceServer webServiceServer) {
        WebServiceRequest webServiceRequest = new WebServiceRequest("automate-schedule/ws/jobs/DOES_NOT_EXIST");
        webServiceRequest.setRequestMethod(3);
        webServiceRequest.addProperty(new WebServiceRequestProperty("Accept-Charset", webServiceServer.getCharSet(), 1));
        return new WebServiceRequestComposite(webServiceRequest, webServiceServer);
    }
}

