/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.util.TestUtils;
import com.helpsystems.enterprise.core.util.UnicodeGenerator;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import junit.framework.TestCase;

public class UnicodeGeneratorTest
extends TestCase {
    static UnicodeGenerator ug;

    protected void setUp() throws Exception {
        super.setUp();
        ug = new UnicodeGenerator();
    }

    protected void tearDown() throws Exception {
        ug = null;
        super.tearDown();
    }

    public void testSliderChangesValue() {
        UnicodeGeneratorTest.assertNotNull((Object)ug);
        JSlider jSlider = (JSlider)TestUtils.getChildNamed(ug, "sliderBar");
        UnicodeGeneratorTest.assertNotNull((Object)jSlider);
        JTextField jTextField = (JTextField)TestUtils.getChildNamed(ug, "txtIndexValue");
        UnicodeGeneratorTest.assertNotNull((Object)jTextField);
        UnicodeGeneratorTest.assertEquals((String)"1", (String)jTextField.getText());
        jSlider.setValue(5432);
        UnicodeGeneratorTest.assertEquals((String)"5432", (String)jTextField.getText());
    }

    public void testJumpButtons() {
        UnicodeGeneratorTest.assertNotNull((Object)ug);
        JSlider jSlider = (JSlider)TestUtils.getChildNamed(ug, "sliderBar");
        UnicodeGeneratorTest.assertNotNull((Object)jSlider);
        JTextField jTextField = (JTextField)TestUtils.getChildNamed(ug, "txtIndexValue");
        UnicodeGeneratorTest.assertNotNull((Object)jTextField);
        UnicodeGeneratorTest.assertEquals((String)"1", (String)jTextField.getText());
        JButton jButton = (JButton)TestUtils.getChildNamed(ug, "btnIndexJumpUp");
        UnicodeGeneratorTest.assertNotNull((Object)jButton);
        JButton jButton2 = (JButton)TestUtils.getChildNamed(ug, "btnIndexJumpDown");
        UnicodeGeneratorTest.assertNotNull((Object)jButton2);
        JButton jButton3 = (JButton)TestUtils.getChildNamed(ug, "btnIndexJump");
        UnicodeGeneratorTest.assertNotNull((Object)jButton3);
        jButton.doClick();
        UnicodeGeneratorTest.assertEquals((String)"101", (String)jTextField.getText());
        UnicodeGeneratorTest.assertEquals((int)101, (int)jSlider.getValue());
        jButton2.doClick();
        UnicodeGeneratorTest.assertEquals((String)"1", (String)jTextField.getText());
        UnicodeGeneratorTest.assertEquals((int)1, (int)jSlider.getValue());
        jTextField.setText("1499");
        jTextField.postActionEvent();
        UnicodeGeneratorTest.assertEquals((String)"1499", (String)jTextField.getText());
        UnicodeGeneratorTest.assertEquals((int)1, (int)jSlider.getValue());
        jButton3.doClick();
        UnicodeGeneratorTest.assertEquals((int)1499, (int)jSlider.getValue());
        jButton2.doClick();
        jButton2.doClick();
        jButton2.doClick();
        UnicodeGeneratorTest.assertEquals((String)"1199", (String)jTextField.getText());
        UnicodeGeneratorTest.assertEquals((int)1199, (int)jSlider.getValue());
        jButton.doClick();
        jButton.doClick();
        UnicodeGeneratorTest.assertEquals((String)"1399", (String)jTextField.getText());
        UnicodeGeneratorTest.assertEquals((int)1399, (int)jSlider.getValue());
    }
}

