/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.util.SkybotTimeZone;
import com.helpsystems.enterprise.core.util.SkybotTimeZoneHelper;
import java.util.TimeZone;

public class SkybotTimeZoneHelperTest {
    private static final StringBuffer BLANKS = new StringBuffer();
    private static final StringBuffer sb = new StringBuffer();

    public static void main(String[] stringArray) {
        SkybotTimeZoneHelperTest.logTimeZoneSubset("indi");
        SkybotTimeZoneHelperTest.logTimeZoneSubset("america");
        SkybotTimeZoneHelperTest.logTimeZoneSubset("7");
        SkybotTimeZoneHelperTest.logTimeZoneSubset("-5");
        SkybotTimeZoneHelperTest.logTimeZoneSubset("central sta");
        SkybotTimeZoneHelperTest.logTimeZoneSubset("etc");
        System.out.println();
        System.out.println("Loading Timezones with Custom IDs...");
        System.out.println();
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT+01:23");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-01:23");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT+1123");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-1005");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-2");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-23");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-234");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-2345");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT+0000");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-0000");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-0002");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-0023");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-0234");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT+05:00");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-05:00");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-6");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT-06");
        SkybotTimeZoneHelperTest.testTimeZoneID("GMT+99:99");
        SkybotTimeZoneHelperTest.testTimeZoneID("FruitLoops");
    }

    private static void logTimeZoneSubset(String string) {
        System.out.println();
        System.out.println("Subsetting Time Zone Array: " + string);
        SkybotTimeZone[] skybotTimeZoneArray = SkybotTimeZoneHelper.getSkybotTimeZones(string);
        SkybotTimeZoneHelperTest.logSkybotTimeZoneArray(skybotTimeZoneArray);
    }

    private static void logSkybotTimeZoneArray(SkybotTimeZone[] skybotTimeZoneArray) {
        String string = "====================";
        SkybotTimeZoneHelperTest.log("ID", "getFullDescription()", "getDSTSavings()", "getRawOffset()", "GMT/DST Info");
        SkybotTimeZoneHelperTest.log(string, string, string, string, string);
        for (int i = 0; i < skybotTimeZoneArray.length; ++i) {
            SkybotTimeZoneHelperTest.logTimeZone(skybotTimeZoneArray[i]);
        }
    }

    private static TimeZone testTimeZoneID(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        SkybotTimeZone skybotTimeZone = new SkybotTimeZone(timeZone);
        SkybotTimeZoneHelperTest.logTimeZone(skybotTimeZone);
        return timeZone;
    }

    private static void logTimeZone(SkybotTimeZone skybotTimeZone) {
        SkybotTimeZoneHelperTest.log(skybotTimeZone.getId(), skybotTimeZone.getFullDescription(), String.valueOf(skybotTimeZone.getDstSavings()), String.valueOf(skybotTimeZone.getRawOffset()), skybotTimeZone.getGmtDstInfo());
    }

    private static void addColumn(StringBuffer stringBuffer, String string, int n) {
        stringBuffer.insert(n, string);
    }

    private static void log(String string, String string2, String string3, String string4, String string5) {
        sb.setLength(0);
        sb.append(BLANKS.toString());
        int n = 0;
        SkybotTimeZoneHelperTest.addColumn(sb, string, n);
        SkybotTimeZoneHelperTest.addColumn(sb, string2, n += 35);
        SkybotTimeZoneHelperTest.addColumn(sb, string3, n += 80);
        SkybotTimeZoneHelperTest.addColumn(sb, string4, n += 25);
        SkybotTimeZoneHelperTest.addColumn(sb, string5, n += 25);
        System.out.println(sb.toString().trim());
    }

    static {
        BLANKS.setLength(0);
        for (int i = 0; i < 200; ++i) {
            BLANKS.append(" ");
        }
    }
}

