/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.util.LongConverter;
import junit.framework.TestCase;

public class LongConverterTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testTooLargeThrowsException() {
        long l = 0x80000000L;
        try {
            LongConverter.intValue(l);
            LongConverterTest.fail((String)"LongConverter accepted a value that was TOO BIG");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTooSmallThrowsException() {
        long l = -2147483649L;
        try {
            LongConverter.intValue(l);
            LongConverterTest.fail((String)"LongConverter accepted a value that was TOO SMALL");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGoodValues() {
        LongConverterTest.assertEquals((int)0, (int)LongConverter.intValue(0L));
        LongConverterTest.assertEquals((int)1, (int)LongConverter.intValue(1L));
        LongConverterTest.assertEquals((int)123456789, (int)LongConverter.intValue(123456789L));
    }
}

