/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoTest;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DateList;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;

public class ScheduleInfo_DateListTest
extends ScheduleInfoTest {
    private ScheduleInfo_DateList info;
    private DateObject dateObject;
    private Runtimes_Basic runtimes;

    public ScheduleInfo_DateListTest(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.info = new ScheduleInfo_DateList();
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        this.info.setCalendarObject(this.calendar);
        this.info.setOmitDates(this.omitDates);
        this.dateObject = new DateObject();
        this.dateObject.setName("TestDateObject");
        this.dateObject.setDates(new int[]{20100315, 20100317, 20100319});
        this.info.setRunDates(this.dateObject);
        this.runtimes = new Runtimes_Basic(new LocalHHMM(0, 0));
        this.runtimes.addRuntime(new LocalHHMM(9, 0));
        this.runtimes.addRuntime(new LocalHHMM(11, 15));
        this.runtimes.addRuntime(new LocalHHMM(13, 30));
        this.runtimes.addRuntime(new LocalHHMM(15, 45));
        this.info.setRuntimes(this.runtimes);
    }

    @Override
    protected void tearDown() throws Exception {
        this.runtimes = null;
        this.dateObject = null;
        this.omitDates = null;
        super.tearDown();
    }

    public void testValidate() {
        this.info.validate();
    }

    public void testToString() {
        String string = "Schedule type: DATE_LIST|Timezone type: AGENT|Calendar: MyCalendar|Omit Date List: OmitDates|Run Date List: TestDateObject|Runtimes: [09:00, 11:15, 13:30, 15:45]";
        String string2 = this.info.toString();
        ScheduleInfo_DateListTest.assertEquals((String)string, (String)string2);
    }

    public void testGetScheduleType() {
        ScheduleInfo_DateListTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DATE_LIST, (Object)this.info.getScheduleType());
    }

    @Override
    public void testCreateScheduleInfoOfType() {
        super.testCreateScheduleInfoOfType();
        ScheduleInfo scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.DATE_LIST);
        ScheduleInfo_DateListTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DATE_LIST, (Object)scheduleInfo.getScheduleType());
    }

    @Override
    public void testCalcNST() {
        Calendar calendar = this.info.calcNST(MAR15_SERVER_TIME_ZONE, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DateListTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DateListTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DateListTest.assertEquals((int)15, (int)calendar.get(5));
        ScheduleInfo_DateListTest.assertEquals((int)11, (int)calendar.get(11));
        ScheduleInfo_DateListTest.assertEquals((int)15, (int)calendar.get(12));
        calendar = this.info.calcNST(calendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DateListTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DateListTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DateListTest.assertEquals((int)15, (int)calendar.get(5));
        ScheduleInfo_DateListTest.assertEquals((int)13, (int)calendar.get(11));
        ScheduleInfo_DateListTest.assertEquals((int)30, (int)calendar.get(12));
        calendar.set(11, 18);
        calendar = this.info.calcNST(calendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DateListTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DateListTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DateListTest.assertEquals((int)17, (int)calendar.get(5));
        ScheduleInfo_DateListTest.assertEquals((int)9, (int)calendar.get(11));
        ScheduleInfo_DateListTest.assertEquals((int)0, (int)calendar.get(12));
        calendar = this.info.calcNST(MAR15_AGENT_TIME_ZONE, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DateListTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DateListTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DateListTest.assertEquals((int)15, (int)calendar.get(5));
        ScheduleInfo_DateListTest.assertEquals((int)11, (int)calendar.get(11));
        ScheduleInfo_DateListTest.assertEquals((int)15, (int)calendar.get(12));
        calendar = this.info.calcNST(calendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DateListTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DateListTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DateListTest.assertEquals((int)15, (int)calendar.get(5));
        ScheduleInfo_DateListTest.assertEquals((int)13, (int)calendar.get(11));
        ScheduleInfo_DateListTest.assertEquals((int)30, (int)calendar.get(12));
        calendar.set(11, 18);
        calendar = this.info.calcNST(calendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DateListTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DateListTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DateListTest.assertEquals((int)17, (int)calendar.get(5));
        ScheduleInfo_DateListTest.assertEquals((int)9, (int)calendar.get(11));
        ScheduleInfo_DateListTest.assertEquals((int)0, (int)calendar.get(12));
    }

    public void testCalcNSTWithNoRuntimes() {
        this.info = new ScheduleInfo_DateList();
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        this.info.setCalendarObject(this.calendar);
        this.info.setOmitDates(this.omitDates);
        this.dateObject = new DateObject();
        this.dateObject.setName("TestDateObject");
        this.dateObject.setDates(new int[]{20100315, 20100317, 20100319});
        this.info.setRunDates(this.dateObject);
        this.runtimes = new Runtimes_Basic(new LocalHHMM(0, 0));
        this.info.setRuntimes(this.runtimes);
        try {
            this.info.calcNST(MAR15_SERVER_TIME_ZONE, this.jobInfo, SERVER_TIME_ZONE);
            ScheduleInfo_DateListTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void testGetOmitDates() {
        int[] nArray = this.info.getOmitDates().getDates();
        ScheduleInfo_DateListTest.assertEquals((int)2, (int)nArray.length);
        ScheduleInfo_DateListTest.assertEquals((int)20100316, (int)nArray[0]);
        ScheduleInfo_DateListTest.assertEquals((int)20100318, (int)nArray[1]);
    }

    @Override
    public void testSetLateStartJob() {
        this.info.setLateStartJob(false);
        ScheduleInfo_DateListTest.assertFalse((boolean)this.info.isLateStartJob());
        this.info.setLateStartJob(true);
        ScheduleInfo_DateListTest.assertTrue((boolean)this.info.isLateStartJob());
    }

    @Override
    public void testSetNonWorkdayOption() {
        this.info.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.DO_NOT_RUN);
        ScheduleInfo_DateListTest.assertEquals((Object)ScheduleInfo.NonWorkdayOption.DO_NOT_RUN, (Object)this.info.getNonWorkdayOption());
    }

    @Override
    public void testSetTargetID() {
        this.info.setTargetID(12345);
        ScheduleInfo_DateListTest.assertEquals((int)12345, (int)this.info.getTargetID());
    }

    @Override
    public void testSetTargetType() {
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        ScheduleInfo_DateListTest.assertEquals((Object)ScheduleInfo.TargetType.AGENT, (Object)this.info.getTargetType());
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT_GROUP);
        ScheduleInfo_DateListTest.assertEquals((Object)ScheduleInfo.TargetType.AGENT_GROUP, (Object)this.info.getTargetType());
    }

    @Override
    public void testSetTimeZoneToUse() {
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        ScheduleInfo_DateListTest.assertEquals((Object)ScheduleInfo.TimeZoneType.SERVER, (Object)this.info.getTimeZoneType());
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        ScheduleInfo_DateListTest.assertEquals((Object)ScheduleInfo.TimeZoneType.AGENT, (Object)this.info.getTimeZoneType());
    }

    @Override
    public void testSetUpdateCounter() {
        this.info.setUpdateCounter(33333);
        ScheduleInfo_DateListTest.assertEquals((int)33333, (int)this.info.getUpdateCounter());
    }
}

