/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoTest;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_CronExpression;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ScheduleInfo_CronExpressionTest
extends ScheduleInfoTest {
    private ScheduleInfo_CronExpression siCE;

    public ScheduleInfo_CronExpressionTest(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.siCE = new ScheduleInfo_CronExpression();
        this.siCE.setTargetID(1000);
        this.siCE.setTargetType(ScheduleInfo.TargetType.AGENT);
        this.siCE.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        this.siCE.setCalendarObject(new CalendarObject());
    }

    @Override
    protected void tearDown() throws Exception {
        this.siCE = null;
        super.tearDown();
    }

    public void testToString() {
        String string = "Schedule type: CRON_EXPRESSION|Timezone type: SERVER|Calendar: ";
        String string2 = this.siCE.toString();
        ScheduleInfo_CronExpressionTest.assertEquals((String)string, (String)string2);
    }

    public void testSetPersistent() {
    }

    @Override
    public void testCreateScheduleInfoOfType() {
        super.testCreateScheduleInfoOfType();
        ScheduleInfo scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.CRON_EXPRESSION);
        ScheduleInfo_CronExpressionTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.CRON_EXPRESSION, (Object)scheduleInfo.getScheduleType());
    }

    public void testGetConsideredAtDateTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
    }

    public void testGetConsideredScheduledTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
    }

    public void testGetNextScheduledTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
    }

    public void testSetMaintainedAtDateTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
    }

    public void testValidateShouldNotThrowException() {
        this.siCE.validate();
    }

    public void testIsRunDay() {
        JobInfo jobInfo = new JobInfo(1000, "TestJobName");
        Calendar calendar = Calendar.getInstance();
        String string = "* * * * * *";
        this.siCE.setCronExpressionString(string);
        ScheduleInfo_CronExpressionTest.assertTrue((boolean)this.siCE.isRunDay(calendar, jobInfo));
        Calendar calendar2 = Calendar.getInstance();
        string = "* * * * * 2099";
        this.siCE.setCronExpressionString(string);
        ScheduleInfo_CronExpressionTest.assertFalse((boolean)this.siCE.isRunDay(calendar2, jobInfo));
        Calendar calendar3 = Calendar.getInstance();
        string = "1 0 * * * *";
        this.siCE.setCronExpressionString(string);
        ScheduleInfo_CronExpressionTest.assertTrue((boolean)this.siCE.isRunDay(calendar3, jobInfo));
    }

    @Override
    public void testCalcNST() {
    }

    @Override
    public void testGetOmitDates() {
    }

    @Override
    public void testSetLateStartJob() {
    }

    @Override
    public void testSetNonWorkdayOption() {
    }

    @Override
    public void testSetTargetID() {
    }

    @Override
    public void testSetTargetType() {
    }

    @Override
    public void testSetTimeZoneToUse() {
    }

    @Override
    public void testSetUpdateCounter() {
    }
}

