/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.SkybotCronExpression;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ScheduleInfo_CronExpression
extends ScheduleInfo {
    private static final Logger logger = Logger.getLogger(ScheduleInfo_CronExpression.class);
    private Calendar consideredScheduledTime;
    private String cronExpressionString;
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public ScheduleInfo_CronExpression() {
        super(ScheduleJobProxy.ScheduleType.CRON_EXPRESSION);
    }

    @Override
    public Calendar calcNST(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        ValidationHelper.checkForNull((String)"CST", (Object)calendar);
        Calendar calendar2 = null;
        logger.trace((Object)("Raw cron = " + this.cronExpressionString));
        try {
            SkybotCronExpression skybotCronExpression = new SkybotCronExpression(this.cronExpressionString, timeZone);
            logger.trace((Object)("passed-in cst = " + ScheduleInfo_CronExpression.getDateTimeString(calendar.getTimeInMillis()) + " " + calendar.getTimeZone().getDisplayName()));
            logger.trace((Object)("passed-in timeZone = " + timeZone.getDisplayName()));
            calendar2 = skybotCronExpression.getNextScheduledTime(calendar);
            if (!this.isOmitDate(calendar2) && this.isFutureDate(calendar, calendar2)) {
                logger.trace((Object)("nst = " + ScheduleInfo_CronExpression.getDateTimeString(calendar2.getTimeInMillis()) + " " + calendar2.getTimeZone().getDisplayName()));
                return calendar2;
            }
            if (!this.isFutureDate(calendar, calendar2)) {
                calendar2 = this.getNextFutureNST(calendar, calendar2, skybotCronExpression);
            }
            Calendar calendar3 = (Calendar)calendar.clone();
            while (this.isOmitDate(calendar2)) {
                this.logThatJobWasOmitted(calendar2, jobInfo);
                calendar3 = calendar2;
                if (this.isFutureDate(calendar3, calendar2 = skybotCronExpression.getNextScheduledTime(calendar3))) continue;
                calendar2 = this.getNextFutureNST(calendar3, calendar2, skybotCronExpression);
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.trace((Object)"Unable to determine NST for job.  ", (Throwable)nullPointerException);
            throw new IllegalStateException("The job may not have a future run date or is scheduled further than 100 years out.");
        }
        logger.trace((Object)("nst = " + ScheduleInfo_CronExpression.getDateTimeString(calendar2.getTimeInMillis())));
        return calendar2;
    }

    private Calendar getNextFutureNST(Calendar calendar, Calendar calendar2, SkybotCronExpression skybotCronExpression) {
        Calendar calendar3 = (Calendar)calendar2.clone();
        Calendar calendar4 = (Calendar)calendar.clone();
        calendar4.set(13, 59);
        calendar4.set(12, 59);
        calendar4.set(11, 23);
        calendar3 = skybotCronExpression.getNextScheduledTime(calendar4);
        Calendar calendar5 = this.calculateMaximumTimeHorizon(calendar4);
        while (!this.isFutureDate(calendar4, calendar3) && !this.maxTimeHorizonExceeded(calendar4, calendar5)) {
            this.advanceOneDay(calendar4);
            calendar3 = skybotCronExpression.getNextScheduledTime(calendar4);
        }
        if (this.maxTimeHorizonExceeded(calendar4, calendar5)) {
            String string = this.maximumTimeHorizonExceededErrorText(calendar5);
            throw new IllegalStateException(string);
        }
        return calendar3;
    }

    private boolean isFutureDate(Calendar calendar, Calendar calendar2) {
        return calendar2.after(calendar);
    }

    private boolean maxTimeHorizonExceeded(Calendar calendar, Calendar calendar2) {
        return calendar.after(calendar2);
    }

    public static String getDateTimeString(long l) {
        String string = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        String string2 = "";
        String string3 = "";
        string2 = numberFormatter.format(calendar.get(12));
        string3 = numberFormatter.format(calendar.get(13));
        string = calendar.get(1) + "." + (calendar.get(2) + 1) + "." + calendar.get(5) + " at " + calendar.get(11) + ":" + string2 + ":" + string3;
        return string;
    }

    @Override
    protected boolean isRunDay(Calendar calendar, JobInfo jobInfo) {
        try {
            SkybotCronExpression skybotCronExpression = new SkybotCronExpression(this.cronExpressionString);
            return skybotCronExpression.isScheduledToday(calendar);
        }
        catch (Exception exception) {
            logger.error((Object)("Error determining if job '" + jobInfo.getJobName() + "(" + jobInfo.getJobID() + ") will run today."), (Throwable)exception);
            return false;
        }
    }

    public void setCronExpressionString(String string) {
        this.cronExpressionString = string;
    }

    public static void main(String[] stringArray) {
        Calendar calendar;
        Object object;
        Calendar calendar2;
        String string2;
        System.out.println("Running tests...");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("* * * * * *");
        arrayList.add("0 * * * * *");
        arrayList.add("0 0 * * * *");
        arrayList.add("* 0 * * * *");
        arrayList.add("0 0 1 * * *");
        arrayList.add("* 0 1 * * *");
        arrayList.add("* * 1 * * *");
        arrayList.add("0 0 1 1 * *");
        arrayList.add("0 0 1 1 1 *");
        arrayList.add("0-15 * * * * *");
        arrayList.add("0-15 7-15 1-15 1-4 * *");
        arrayList.add("0-15/3 * * * *");
        arrayList.add("0-15/3 0-15/3 * * * *");
        arrayList.add("0-15/3 0-15/3 1-15/3 * * *");
        arrayList.add("0-15/3 0-15/3 1-15/3 1-10/2 * *");
        arrayList.add("*/15 * * * * *");
        arrayList.add("* * 1-15,17,20-25 * * *");
        arrayList.add("*/3 */2 */3 * * *");
        arrayList.add("5-41/3 * * * * *");
        arrayList.add("1,2,44,53 * * * * *");
        arrayList.add("2-50 * * * * *");
        arrayList.add("* */3 * * * *");
        arrayList.add("* 6-12/2 * * * *");
        arrayList.add("* 6-15 * * * *");
        arrayList.add("* * */3 * * *");
        arrayList.add("* * 10-20/2 * * *");
        arrayList.add("* * 5,7,15,25 * * *");
        arrayList.add("* * L * * *");
        arrayList.add("* * L * ? *");
        arrayList.add("* * L-2 * * *");
        arrayList.add("* * L-2 * ? *");
        arrayList.add("* * 15W * * *");
        arrayList.add("* * 15W * ? *");
        arrayList.add("* * 5 * TUE *");
        arrayList.add("* * * JAN * *");
        arrayList.add("* * * JAN ? *");
        arrayList.add("* * * JAN-APR * *");
        arrayList.add("* * * JAN-APR ? *");
        arrayList.add("* * * JUN-DEC/2 * *");
        arrayList.add("* * * JUN-DEC/2 ? *");
        arrayList.add("* * * MAR-DEC/2 * *");
        arrayList.add("* * * MAR-DEC/2 ? *");
        arrayList.add("* * * */2 * *");
        arrayList.add("* * * */2 ? *");
        arrayList.add("* * * */3 * *");
        arrayList.add("* * * */3 ? *");
        arrayList.add("* * * * */2 *");
        arrayList.add("* * ? * */2 *");
        arrayList.add("* * * * */3 *");
        arrayList.add("* * ? * */3 *");
        arrayList.add("* * * * 2-6/2 *");
        arrayList.add("* * ? * 2-6/2 *");
        arrayList.add("* * * * 3-5 *");
        arrayList.add("* * ? * 3-5 *");
        arrayList.add("* * * * 4-6 *");
        arrayList.add("* * ? * 4-6 *");
        arrayList.add("* * * * L *");
        arrayList.add("* * ? * L *");
        arrayList.add("* * * * 5L *");
        arrayList.add("* * ? * 5L *");
        arrayList.add("* * * * 4#3 *");
        arrayList.add("* * ? * 4#3 *");
        arrayList.add("* * * * mon *");
        arrayList.add("* * ? * mon *");
        arrayList.add("* * * * MON *");
        arrayList.add("* * ? * MON *");
        arrayList.add("* * * * TUE *");
        arrayList.add("* * ? * TUE *");
        arrayList.add("* * * * THU *");
        arrayList.add("* * ? * THU *");
        arrayList.add("* * * * MON,TUE *");
        arrayList.add("* * ? * MON,TUE *");
        arrayList.add("* * * * MON-WED,FRI *");
        arrayList.add("* * ? * MON-WED,FRI *");
        arrayList.add("* * * * MON,FRI *");
        arrayList.add("* * ? * MON,FRI *");
        arrayList.add("* * * * 0 *");
        arrayList.add("* * ? * 0 *");
        arrayList.add("* * * * 1 *");
        arrayList.add("* * ? * 1 *");
        arrayList.add("* * * * 2 *");
        arrayList.add("* * ? * 2 *");
        arrayList.add("* * * * 3 *");
        arrayList.add("* * ? * 3 *");
        arrayList.add("* * * * 4 *");
        arrayList.add("* * ? * 4 *");
        arrayList.add("* * * * 5 *");
        arrayList.add("* * ? * 5 *");
        arrayList.add("* * * * 6 *");
        arrayList.add("* * ? * 6 *");
        arrayList.add("* * * * 7 *");
        arrayList.add("* * ? * 7 *");
        arrayList.add("* * * * 0-6 *");
        arrayList.add("* * ? * 0-6 *");
        arrayList.add("* * * * 6-7 *");
        arrayList.add("* * ? * 6-7 *");
        arrayList.add("45-15 * * * * *");
        arrayList.add("* 22-5 * * * *");
        arrayList.add("* * 25-5 * * *");
        arrayList.add("* * * 10-3 * *");
        arrayList.add("* * * * 5-2 *");
        arrayList.add("45-15/5 * * * * *");
        arrayList.add("* 22-5/3 * * * *");
        arrayList.add("* * 25-5/5 * * *");
        arrayList.add("* * * 10-3/3 * *");
        arrayList.add("* * * * 5-3/2 *");
        arrayList.add("45-15/5,30 * * * * *");
        arrayList.add("* 22-5/3,11 * * * *");
        arrayList.add("* * 25-5/5,15 * * *");
        arrayList.add("* * * 10-3/3,5 * *");
        arrayList.add("* * * * 5-1/2,3 *");
        arrayList.add("* * * * * 2111");
        arrayList.add("59 23 31 12 * 2111");
        arrayList.add("* * * * * 2112");
        arrayList.add("* * * * * 2112");
        arrayList.add("* * * * * 2113");
        arrayList.add("* * L-12 * * *");
        arrayList.add("00 8 L-12 * * *");
        arrayList.add("52 7 L-12 * * *");
        arrayList.add("52 7 L-12,4 * * *");
        for (String string2 : arrayList) {
            System.out.println("cron = " + string2);
            calendar2 = Calendar.getInstance();
            System.out.println("now = " + ScheduleInfo_CronExpression.getDateTimeString(calendar2.getTimeInMillis()));
            try {
                object = new SkybotCronExpression(string2);
                calendar = ((SkybotCronExpression)object).getNextScheduledTime(calendar2);
                System.out.println("Quartz nst = " + ScheduleInfo_CronExpression.getDateTimeString(calendar.getTimeInMillis()));
            }
            catch (Exception exception) {
                System.out.println("Quartz choked. " + exception.getMessage());
            }
            System.out.println("-----------------------------------");
        }
        System.out.println("Start of TimeZone tests...");
        string2 = "0 19 * 6 * *";
        System.out.println("cron = " + string2);
        calendar2 = Calendar.getInstance();
        System.out.println("now = " + ScheduleInfo_CronExpression.getDateTimeString(calendar2.getTimeInMillis()) + " " + calendar2.getTimeZone().getDisplayName());
        try {
            object = new SkybotCronExpression(string2);
            calendar = ((SkybotCronExpression)object).getNextScheduledTime(calendar2);
            System.out.println("Quartz nst = " + ScheduleInfo_CronExpression.getDateTimeString(calendar.getTimeInMillis()) + " " + calendar.getTimeZone().getDisplayName());
        }
        catch (Exception exception) {
            System.out.println("Quartz choked. " + exception.getMessage());
        }
        System.out.println("-----------------------------------");
        object = TimeZone.getTimeZone("GMT-04:00");
        calendar = new GregorianCalendar((TimeZone)object);
        calendar.setTimeInMillis(new Date().getTime());
        System.out.println("estCal " + calendar.getTimeZone().getDisplayName() + " hour of day = " + calendar.get(11));
        TimeZone timeZone = TimeZone.getTimeZone("GMT-05:00");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(new Date().getTime());
        System.out.println("localCst " + ((Calendar)gregorianCalendar).getTimeZone().getDisplayName() + " hour of day = " + gregorianCalendar.get(11));
        System.out.println("About to create skybotCE with timezone " + TimeZone.getTimeZone("America/New_York").getDisplayName());
        SkybotCronExpression skybotCronExpression = new SkybotCronExpression(string2, TimeZone.getTimeZone("America/New_York"));
        Calendar calendar3 = skybotCronExpression.getNextScheduledTime(calendar2);
        System.out.println("Quartz nst = " + ScheduleInfo_CronExpression.getDateTimeString(calendar3.getTimeInMillis()) + " " + calendar3.getTimeZone().getDisplayName());
        System.out.println("-----------------------------------");
        string2 = "0 8 * 6 * *";
        System.out.println("cron = " + string2);
        System.out.println("About to create skybotCE with timezone " + TimeZone.getTimeZone("America/New_York").getDisplayName());
        skybotCronExpression = new SkybotCronExpression(string2, TimeZone.getTimeZone("America/New_York"));
        calendar3 = skybotCronExpression.getNextScheduledTime(calendar2);
        System.out.println("Quartz nst = " + ScheduleInfo_CronExpression.getDateTimeString(calendar3.getTimeInMillis()) + " " + calendar3.getTimeZone().getDisplayName());
        System.out.println("-----------------------------------");
        System.out.println("About to set skybotCE timezone to " + TimeZone.getTimeZone("Europe/Oslo").getDisplayName());
        skybotCronExpression.setTimeZone(TimeZone.getTimeZone("Europe/Oslo"));
        calendar3 = skybotCronExpression.getNextScheduledTime(calendar2);
        System.out.println("Quartz nst = " + ScheduleInfo_CronExpression.getDateTimeString(calendar3.getTimeInMillis()) + " " + calendar3.getTimeZone().getDisplayName());
        System.out.println("-----------------------------------");
        try {
            System.out.println("About to set skybotCE timezone to 'BillyBob'");
            skybotCronExpression.setTimeZone(TimeZone.getTimeZone("BillyBob"));
            System.out.println("skybotCE timezone is now " + skybotCronExpression.getTimeZone().getDisplayName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("End of Running tests.");
    }

    public void setConsideredScheduledTime(Calendar calendar) {
        this.consideredScheduledTime = calendar;
    }

    public Calendar getConsideredScheduledTime() {
        return this.consideredScheduledTime;
    }

    static {
        numberFormatter.setMinimumIntegerDigits(2);
    }
}

