/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.DSTHelper;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;

public class Runtimes_Basic
implements Runtimes {
    private int[] runtimes = new int[10];
    private int size;
    private int dayStart;
    private boolean runtimesAreSorted;
    private static ThreadLocal<Boolean> suppressScheduleLogEntry = new ThreadLocal();

    public static void setSuppressScheduleLogEntry(boolean bl) {
        suppressScheduleLogEntry.set(bl);
    }

    public Runtimes_Basic(LocalHHMM localHHMM) {
        ValidationHelper.checkForNull((String)"Day Start", (Object)((Object)localHHMM));
        this.dayStart = localHHMM.toInt();
    }

    public void addRuntime(LocalHHMM localHHMM) {
        ValidationHelper.checkForNull((String)"Runtime", (Object)((Object)localHHMM));
        this.ensureCapacityForAdd();
        this.runtimes[this.size++] = localHHMM.toInt();
    }

    @Override
    public Calendar firstRuntimeOfDay(Calendar calendar, JobInfo jobInfo) {
        int n;
        ValidationHelper.checkForNull((String)"Considered Scheduled Time", (Object)calendar);
        if (this.isEmpty()) {
            return null;
        }
        if (calendar instanceof MovedInvalidDateTime) {
            LocalHHMM object = ((MovedInvalidDateTime)calendar).getOriginalTimeHHMM();
            n = object.toInt();
            calendar = ((MovedInvalidDateTime)calendar).toCalendar();
        } else {
            n = this.toHHMM(calendar);
        }
        this.ensureRuntimesAreSorted();
        for (int n2 : this.runtimes) {
            if (n2 < this.dayStart) continue;
            if (n >= this.dayStart) {
                return this.replaceTime(calendar, n2, jobInfo);
            }
            return this.replaceTimeAndSubtractADay(calendar, n2, jobInfo);
        }
        if (n < this.dayStart) {
            return this.replaceTime(calendar, this.runtimes[0], jobInfo);
        }
        return this.replaceTimeAndAddADay(calendar, this.runtimes[0], jobInfo);
    }

    @Override
    public Calendar nextRuntimeSameDay(Calendar calendar, JobInfo jobInfo) {
        int n;
        ValidationHelper.checkForNull((String)"Considered Scheduled Time", (Object)calendar);
        if (this.isEmpty()) {
            return null;
        }
        if (calendar instanceof MovedInvalidDateTime) {
            LocalHHMM object = ((MovedInvalidDateTime)calendar).getOriginalTimeHHMM();
            n = object.toInt();
            calendar = ((MovedInvalidDateTime)calendar).toCalendar();
        } else {
            n = this.toHHMM(calendar);
        }
        this.ensureRuntimesAreSorted();
        if (n < this.dayStart) {
            for (int n2 : this.runtimes) {
                if (n2 <= n || n2 >= this.dayStart) continue;
                return this.replaceTime(calendar, n2, jobInfo);
            }
            return null;
        }
        for (int n3 : this.runtimes) {
            if (n3 <= n) continue;
            return this.replaceTime(calendar, n3, jobInfo);
        }
        for (int n3 : this.runtimes) {
            if (n3 >= this.dayStart) continue;
            return this.replaceTimeAndAddADay(calendar, n3, jobInfo);
        }
        return null;
    }

    public LocalHHMM[] getRuntimes() {
        this.sortRuntimes();
        LocalHHMM[] localHHMMArray = new LocalHHMM[this.size];
        for (int i = 0; i < this.size; ++i) {
            localHHMMArray[i] = this.toLocalHHMM(this.runtimes[i]);
        }
        return localHHMMArray;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public String toString() {
        String string = Arrays.toString((Object[])this.getRuntimes());
        if (this.dayStart != 0) {
            string = string + " (Day start: " + (Object)((Object)this.toLocalHHMM(this.dayStart)) + ")";
        }
        return string;
    }

    private void ensureCapacityForAdd() {
        if (this.size == this.runtimes.length) {
            int[] nArray = this.runtimes;
            int n = this.size * 3 / 2 + 1;
            this.runtimes = new int[n];
            System.arraycopy(nArray, 0, this.runtimes, 0, this.size);
        }
    }

    private void ensureRuntimesAreSorted() {
        if (!this.runtimesAreSorted) {
            this.sortRuntimes();
            this.runtimesAreSorted = true;
        }
    }

    private void sortRuntimes() {
        Arrays.sort(this.runtimes, 0, this.size);
    }

    private int toHHMM(Calendar calendar) {
        return calendar.get(11) * 100 + calendar.get(12);
    }

    private LocalHHMM toLocalHHMM(int n) {
        int n2 = n / 100;
        int n3 = n - n2 * 100;
        return new LocalHHMM(n2, n3);
    }

    private Calendar replaceTime(Calendar calendar, int n, JobInfo jobInfo) {
        try {
            return DSTHelper.replaceTime(calendar, this.toLocalHHMM(n));
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            MovedInvalidDateTime movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
            String string = movedInvalidDateTime.getOriginalTimeHHMM().toString();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat2.setTimeZone(movedInvalidDateTime.getTimeZone());
            String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime()), string, simpleDateFormat2.format(movedInvalidDateTime.getTime())};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.NST_CALC_RUNTIME_ADJUSTED_DUE_TO_INVALID_DATETIME_DST.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
            if (!this.isSuppressScheduleLogEntry()) {
                ScheduleLogger.write(scheduleLogEntry);
            }
            return movedInvalidDateTime;
        }
    }

    private Calendar replaceTimeAndAddADay(Calendar calendar, int n, JobInfo jobInfo) {
        Calendar calendar2 = (Calendar)calendar.clone();
        try {
            DSTHelper.addDays(calendar2, 1);
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            calendar2 = invalidDateTimeException.getMovedInvalidDateTime();
        }
        return this.replaceTime(calendar2, n, jobInfo);
    }

    private Calendar replaceTimeAndSubtractADay(Calendar calendar, int n, JobInfo jobInfo) {
        Calendar calendar2 = (Calendar)calendar.clone();
        try {
            DSTHelper.addDays(calendar2, -1);
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            calendar2 = invalidDateTimeException.getMovedInvalidDateTime();
        }
        return this.replaceTime(calendar2, n, jobInfo);
    }

    private boolean isSuppressScheduleLogEntry() {
        Boolean bl = suppressScheduleLogEntry.get();
        return bl != null && bl == Boolean.TRUE;
    }
}

