/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.scheduler.Prereq;
import com.helpsystems.enterprise.core.scheduler.PrereqStatus;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import junit.framework.TestCase;

public class PrereqTest
extends TestCase {
    private Prereq prereq;

    protected void setUp() throws Exception {
        super.setUp();
        this.prereq = new Prereq();
    }

    protected void tearDown() throws Exception {
        this.prereq = null;
        super.tearDown();
    }

    public void testToString() {
        this.prereq.setID(123456L);
        this.prereq.setDepJobID(678678L);
        this.prereq.setPrereqObjectID(135135L);
        this.prereq.setPrereqObjectFile(ParentType.JOBS);
        this.prereq.setType(PrereqEventType.AGENT_EVENT);
        this.prereq.setReactToStatus(PrereqStatusType.COMPLETED);
        this.prereq.setSequenceNumber(54321);
        this.prereq.setConjunction("AND");
        String string = "DEPID(123456).DEP_JOB(678678).PR_OBJECT(135135).PR_FILE(JOBS).PR_TYPE(AGENT_EVENT).CONJUNCTION(AND).SEQ(54321).REACTSTS(COMPLETED)";
        String string2 = this.prereq.toString();
        PrereqTest.assertEquals((String)string, (String)string2);
    }

    public void testSetID() {
        this.prereq.setID(123456L);
        PrereqTest.assertEquals((long)123456L, (long)this.prereq.getID());
    }

    public void testSetDepJobID() {
        this.prereq.setDepJobID(678678L);
        PrereqTest.assertEquals((long)678678L, (long)this.prereq.getDepJobID());
    }

    public void testSetPrereqObjectID() {
        this.prereq.setPrereqObjectID(135135L);
        PrereqTest.assertEquals((long)135135L, (long)this.prereq.getPrereqObjectID());
    }

    public void testSetPrereqObjectFile() {
        ParentType parentType = ParentType.JOBS;
        this.prereq.setPrereqObjectFile(parentType);
        PrereqTest.assertEquals((Object)ParentType.JOBS, (Object)this.prereq.getPrereqObjectFile());
    }

    public void testSetType() {
        this.prereq.setType(PrereqEventType.AGENT_EVENT);
        PrereqTest.assertEquals((Object)PrereqEventType.AGENT_EVENT, (Object)this.prereq.getType());
    }

    public void testSetReactToStatus() {
        this.prereq.setReactToStatus(PrereqStatusType.COMPLETED);
        PrereqTest.assertEquals((Object)PrereqStatusType.COMPLETED, (Object)this.prereq.getReactToStatus());
    }

    public void testSetSequenceNumber() {
        this.prereq.setSequenceNumber(54321);
        PrereqTest.assertEquals((int)54321, (int)this.prereq.getSequenceNumber());
    }

    public void testSetConjunction() {
        this.prereq.setConjunction("AND");
        PrereqTest.assertEquals((String)"AND", (String)this.prereq.getConjunction());
    }

    public void testSetPrereqStatus() {
        PrereqStatus prereqStatus = new PrereqStatus();
        this.prereq.setPrereqStatus(prereqStatus);
        PrereqTest.assertEquals((Object)prereqStatus, (Object)this.prereq.getPrereqStatus());
    }

    public void testIsSatisfied() {
        this.prereq.setReactToStatus(PrereqStatusType.ENDED);
        PrereqTest.assertFalse((boolean)this.prereq.isSatisfied());
        PrereqStatus prereqStatus = new PrereqStatus();
        this.prereq.setPrereqStatus(prereqStatus);
        prereqStatus.setCurrentStatus(PrereqStatusType.COMPLETED);
        PrereqTest.assertTrue((boolean)this.prereq.isSatisfied());
        prereqStatus.setCurrentStatus(PrereqStatusType.FAILED);
        PrereqTest.assertTrue((boolean)this.prereq.isSatisfied());
        prereqStatus.setCurrentStatus(PrereqStatusType.CANCELED);
        PrereqTest.assertTrue((boolean)this.prereq.isSatisfied());
        prereqStatus.setCurrentStatus(PrereqStatusType.OCCURRED);
        PrereqTest.assertFalse((boolean)this.prereq.isSatisfied());
        this.prereq.setReactToStatus(PrereqStatusType.OCCURRED);
        PrereqTest.assertTrue((boolean)this.prereq.isSatisfied());
    }

    public void testValidate() {
        this.prereq.validate();
    }

    public void testGetHistoryCode() {
        this.prereq.setType(PrereqEventType.AGENT_EVENT);
        this.prereq.setID(12345L);
        this.prereq.setPrereqObjectID(34567L);
        PrereqStatus prereqStatus = new PrereqStatus();
        this.prereq.setReactToStatus(PrereqStatusType.ENDED);
        this.prereq.setPrereqStatus(prereqStatus);
        prereqStatus.setHistoryID(234234L);
        prereqStatus.setPrereqAgentID(24680L);
        String string = "PR_EVTMON:12345:34567:24680:234234:D";
        String string2 = this.prereq.getHistoryCode();
        PrereqTest.assertEquals((String)string, (String)string2);
        this.prereq.setType(PrereqEventType.JOB_MONITOR_EVENT);
        string = "PR_JOBMON:12345:34567:24680:234234:D";
        string2 = this.prereq.getHistoryCode();
        PrereqTest.assertEquals((String)string, (String)string2);
        this.prereq.setType(PrereqEventType.JOB_STATUS_CHANGE);
        string = "PR_JOBSTS:12345:34567:24680:234234:D";
        string2 = this.prereq.getHistoryCode();
        PrereqTest.assertEquals((String)string, (String)string2);
        this.prereq.setType(PrereqEventType.SNMP_TRAP_EVENT);
        string = "PR_SNMP:12345:34567:234234:D";
        string2 = this.prereq.getHistoryCode();
        PrereqTest.assertEquals((String)string, (String)string2);
    }

    public void testGetPrereqText() {
        this.prereq.setType(PrereqEventType.AGENT_EVENT);
        this.prereq.setID(12345L);
        this.prereq.setPrereqObjectID(34567L);
        PrereqStatus prereqStatus = new PrereqStatus();
        this.prereq.setReactToStatus(PrereqStatusType.ENDED);
        this.prereq.setPrereqStatus(prereqStatus);
        prereqStatus.setCurrentStatus(PrereqStatusType.BLANK);
        prereqStatus.setHistoryID(43234L);
        PrereqTest.assertFalse((boolean)this.prereq.isSatisfied());
        String string = "Prereq 12345 for Agent Event 34567 on agent 56789 has BLANK instead of ENDED status.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
        prereqStatus.setCurrentStatus(PrereqStatusType.COMPLETED);
        PrereqTest.assertTrue((boolean)this.prereq.isSatisfied());
        string = "Prereq 12345 for Agent Event 34567 on agent 56789 has COMPLETED status from event history 43234.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
        this.prereq.setType(PrereqEventType.JOB_STATUS_CHANGE);
        this.prereq.setReactToStatus(PrereqStatusType.ENDED);
        this.prereq.setPrereqStatus(prereqStatus);
        prereqStatus.setCurrentStatus(PrereqStatusType.BLANK);
        PrereqTest.assertFalse((boolean)this.prereq.isSatisfied());
        string = "Prereq 12345 for Job 34567 on agent 56789 has BLANK instead of ENDED status.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
        prereqStatus.setCurrentStatus(PrereqStatusType.COMPLETED);
        PrereqTest.assertTrue((boolean)this.prereq.isSatisfied());
        string = "Prereq 12345 for Job 34567 on agent 56789 has COMPLETED status from job history 43234.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
        this.prereq.setType(PrereqEventType.SNMP_TRAP_EVENT);
        this.prereq.setReactToStatus(PrereqStatusType.ENDED);
        this.prereq.setPrereqStatus(prereqStatus);
        prereqStatus.setCurrentStatus(PrereqStatusType.BLANK);
        PrereqTest.assertFalse((boolean)this.prereq.isSatisfied());
        string = "Prereq 12345 for SNMP Trap 34567 has BLANK instead of ENDED status.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
        prereqStatus.setCurrentStatus(PrereqStatusType.COMPLETED);
        PrereqTest.assertTrue((boolean)this.prereq.isSatisfied());
        string = "Prereq 12345 for SNMP Trap 34567 has COMPLETED status from SNMP history 43234.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
        this.prereq.setType(PrereqEventType.JOB_MONITOR_EVENT);
        this.prereq.setReactToStatus(PrereqStatusType.ENDED);
        this.prereq.setPrereqStatus(prereqStatus);
        prereqStatus.setCurrentStatus(PrereqStatusType.BLANK);
        PrereqTest.assertFalse((boolean)this.prereq.isSatisfied());
        string = "Prereq 12345 for Job Monitor 34567 on agent 56789 has BLANK instead of ENDED status.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
        prereqStatus.setCurrentStatus(PrereqStatusType.COMPLETED);
        PrereqTest.assertTrue((boolean)this.prereq.isSatisfied());
        string = "Prereq 12345 for Job Monitor 34567 on agent 56789 has COMPLETED status from job monitor history 43234.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
        this.prereq.setPrereqStatus(null);
        PrereqTest.assertFalse((boolean)this.prereq.isSatisfied());
        string = "Prereq 12345 for Job Monitor 34567 on agent 56789 has No Status instead of ENDED status.";
        PrereqTest.assertEquals((String)string, (String)this.prereq.getPrereqText());
    }
}

