/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;

public class LocalHHMM
extends EnterpriseVersionedObject
implements XMLSerializable {
    private static final long serialVersionUID = -3878725634661025614L;
    public static final int MIN_HOUR = 0;
    public static final int MAX_HOUR = 23;
    public static final int MIN_MINUTE = 0;
    public static final int MAX_MINUTE = 59;
    private int hourOfDay;
    private int minuteOfHour;

    public LocalHHMM() {
        this(0, 0);
    }

    public LocalHHMM(int n, int n2) {
        this.setHourOfDay(n);
        this.setMinuteOfHour(n2);
    }

    public int getHourOfDay() {
        return this.hourOfDay;
    }

    public int getMinuteOfHour() {
        return this.minuteOfHour;
    }

    public void setHourOfDay(int n) {
        ValidationHelper.validateBounds((String)"Hour of day", (long)0L, (long)23L, (long)n);
        this.hourOfDay = n;
    }

    public void setMinuteOfHour(int n) {
        ValidationHelper.validateBounds((String)"Minute of hour", (long)0L, (long)59L, (long)n);
        this.minuteOfHour = n;
    }

    public int toInt() {
        return this.hourOfDay * 100 + this.minuteOfHour;
    }

    public String toString() {
        return LocalHHMM.formatHHMM(this.hourOfDay, this.minuteOfHour);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        LocalHHMM localHHMM = (LocalHHMM)((Object)object);
        return localHHMM.hourOfDay == this.hourOfDay && localHHMM.minuteOfHour == this.minuteOfHour;
    }

    public int hashCode() {
        return this.hourOfDay + this.minuteOfHour;
    }

    public int compareTo(Object object) {
        LocalHHMM localHHMM = (LocalHHMM)((Object)object);
        if (this.hourOfDay < localHHMM.hourOfDay) {
            return -1;
        }
        if (this.hourOfDay > localHHMM.hourOfDay) {
            return 1;
        }
        if (this.minuteOfHour < localHHMM.minuteOfHour) {
            return -1;
        }
        if (this.minuteOfHour > localHHMM.minuteOfHour) {
            return 1;
        }
        return 0;
    }

    public boolean isZero() {
        return this.hourOfDay == 0 && this.minuteOfHour == 0;
    }

    public static String formatHHMM(int n, int n2) {
        String string;
        String string2 = Integer.toString(n);
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toString(n2)).length() == 1) {
            string = "0" + string;
        }
        return string2 + ":" + string;
    }
}

