/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateRange;
import com.helpsystems.enterprise.core.scheduler.FiscalYear;
import junit.framework.TestCase;

public class FiscalYearTest
extends TestCase {
    private FiscalYear fiscalYear;

    public FiscalYearTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.fiscalYear = null;
        super.tearDown();
    }

    public void testConstructQuarters() {
        this.loadFiscalYear();
        DateRange[] dateRangeArray = this.fiscalYear.getQuarters();
        FiscalYearTest.assertEquals((int)20100103, (int)dateRangeArray[0].getBegin());
        FiscalYearTest.assertEquals((int)20100403, (int)dateRangeArray[0].getEnd());
        FiscalYearTest.assertEquals((int)20100404, (int)dateRangeArray[1].getBegin());
        FiscalYearTest.assertEquals((int)20100703, (int)dateRangeArray[1].getEnd());
        FiscalYearTest.assertEquals((int)20100704, (int)dateRangeArray[2].getBegin());
        FiscalYearTest.assertEquals((int)20101002, (int)dateRangeArray[2].getEnd());
        FiscalYearTest.assertEquals((int)20101003, (int)dateRangeArray[3].getBegin());
        FiscalYearTest.assertEquals((int)20110101, (int)dateRangeArray[3].getEnd());
    }

    public void testConstructHalfYears() {
        this.loadFiscalYear();
        DateRange[] dateRangeArray = this.fiscalYear.getHalfYears();
        FiscalYearTest.assertEquals((int)20100103, (int)dateRangeArray[0].getBegin());
        FiscalYearTest.assertEquals((int)20100703, (int)dateRangeArray[0].getEnd());
        FiscalYearTest.assertEquals((int)20100704, (int)dateRangeArray[1].getBegin());
        FiscalYearTest.assertEquals((int)20110101, (int)dateRangeArray[1].getEnd());
    }

    public void testSetYear() {
        this.fiscalYear = new FiscalYear(20100101, 20101231);
        this.fiscalYear.setYear(2010);
        FiscalYearTest.assertEquals((int)2010, (int)this.fiscalYear.getYear());
    }

    public void testSetMonths() {
        this.fiscalYear = new FiscalYear(20100101, 20101231);
        this.fiscalYear.setYear(2010);
        DateRange dateRange = new DateRange(20100101, 20100130);
        DateRange dateRange2 = new DateRange(20100201, 20100228);
        DateRange dateRange3 = new DateRange(20100301, 20100331);
        DateRange dateRange4 = new DateRange(20100401, 20100430);
        DateRange dateRange5 = new DateRange(20100501, 20100531);
        DateRange dateRange6 = new DateRange(20100601, 20100630);
        DateRange dateRange7 = new DateRange(20100701, 20100731);
        DateRange dateRange8 = new DateRange(20100801, 20100831);
        DateRange dateRange9 = new DateRange(20100901, 20100930);
        DateRange dateRange10 = new DateRange(20101001, 20101031);
        DateRange dateRange11 = new DateRange(20101101, 20101130);
        DateRange dateRange12 = new DateRange(20101201, 20101231);
        this.fiscalYear.setMonths(new DateRange[]{dateRange, dateRange2, dateRange3, dateRange4, dateRange5, dateRange6, dateRange7, dateRange8, dateRange9, dateRange10, dateRange11, dateRange12});
        DateRange[] dateRangeArray = this.fiscalYear.getMonths();
        FiscalYearTest.assertEquals((int)12, (int)dateRangeArray.length);
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange2, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange3, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange4, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange5, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange6, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange7, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange8, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange9, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange10, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange11, dateRangeArray));
        FiscalYearTest.assertTrue((boolean)this.arrayContains(dateRange12, dateRangeArray));
    }

    public void testPeriodContaining_Normal() {
        this.loadFiscalYear();
        DateRange dateRange = this.fiscalYear.periodContaining(20100404, CalendarObject.PeriodType.MONTH);
        FiscalYearTest.assertEquals((int)20100404, (int)dateRange.getBegin());
        FiscalYearTest.assertEquals((int)20100501, (int)dateRange.getEnd());
        DateRange dateRange2 = this.fiscalYear.periodContaining(20101002, CalendarObject.PeriodType.QUARTER);
        FiscalYearTest.assertEquals((int)20100704, (int)dateRange2.getBegin());
        FiscalYearTest.assertEquals((int)20101002, (int)dateRange2.getEnd());
        DateRange dateRange3 = this.fiscalYear.periodContaining(20100828, CalendarObject.PeriodType.HALF_YEAR);
        FiscalYearTest.assertEquals((int)20100704, (int)dateRange3.getBegin());
        FiscalYearTest.assertEquals((int)20110101, (int)dateRange3.getEnd());
        DateRange dateRange4 = this.fiscalYear.periodContaining(20100112, CalendarObject.PeriodType.YEAR);
        FiscalYearTest.assertEquals((int)20100103, (int)dateRange4.getBegin());
        FiscalYearTest.assertEquals((int)20110101, (int)dateRange4.getEnd());
    }

    public void testPeriodContaining_OutsideRange() {
        this.loadFiscalYear();
        try {
            this.fiscalYear.periodContaining(20090101, CalendarObject.PeriodType.MONTH);
            FiscalYearTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.fiscalYear.periodContaining(20090101, CalendarObject.PeriodType.QUARTER);
            FiscalYearTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.fiscalYear.periodContaining(20090101, CalendarObject.PeriodType.HALF_YEAR);
            FiscalYearTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.fiscalYear.periodContaining(20090101, CalendarObject.PeriodType.YEAR);
            FiscalYearTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPeriodContaining_Date_Last_Period() {
        this.loadFiscalYear();
        DateRange dateRange = new DateRange(20101003, 20110101);
        DateRange dateRange2 = new DateRange(20100704, 20110101);
        DateRange dateRange3 = new DateRange(20101128, 20110101);
        FiscalYearTest.assertEquals((Object)dateRange3, (Object)this.fiscalYear.periodContaining(20101215, CalendarObject.PeriodType.MONTH));
        FiscalYearTest.assertEquals((Object)dateRange, (Object)this.fiscalYear.periodContaining(20101111, CalendarObject.PeriodType.QUARTER));
        FiscalYearTest.assertEquals((Object)dateRange2, (Object)this.fiscalYear.periodContaining(20100811, CalendarObject.PeriodType.HALF_YEAR));
        FiscalYearTest.assertEquals((Object)this.fiscalYear, (Object)this.fiscalYear.periodContaining(20100527, CalendarObject.PeriodType.YEAR));
    }

    public void testPeriodContaining_Date_Not_Included_In_Either_Range() {
        this.loadFiscalYearWithHoles();
        try {
            this.fiscalYear.periodContaining(20100403, CalendarObject.PeriodType.QUARTER);
            FiscalYearTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPeriodContaining_No_Data() {
        this.fiscalYear = new FiscalYear(20100103, 20110101);
        try {
            this.fiscalYear.periodContaining(20100103, CalendarObject.PeriodType.MONTH);
            FiscalYearTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPeriodContaining_Thirteen_Periods() {
        this.loadFiscalYearWith13Periods();
        DateRange dateRange = new DateRange(20100910, 20101231);
        DateRange dateRange2 = new DateRange(20100618, 20101231);
        FiscalYearTest.assertEquals((Object)dateRange, (Object)this.fiscalYear.periodContaining(20101101, CalendarObject.PeriodType.QUARTER));
        FiscalYearTest.assertEquals((Object)dateRange2, (Object)this.fiscalYear.periodContaining(20101101, CalendarObject.PeriodType.HALF_YEAR));
    }

    public void testEquals() {
        FiscalYear fiscalYear = new FiscalYear(20100101, 20101231);
        FiscalYear fiscalYear2 = new FiscalYear(20100101, 20101231);
        FiscalYear fiscalYear3 = new FiscalYear(20100102, 20101231);
        FiscalYear fiscalYear4 = new FiscalYear(20100101, 20101230);
        FiscalYearTest.assertFalse((boolean)fiscalYear.equals(null));
        FiscalYearTest.assertFalse((boolean)fiscalYear.equals(new Object()));
        FiscalYearTest.assertTrue((boolean)fiscalYear.equals(fiscalYear));
        FiscalYearTest.assertTrue((boolean)fiscalYear.equals(fiscalYear2));
        FiscalYearTest.assertTrue((boolean)fiscalYear2.equals(fiscalYear));
        FiscalYearTest.assertFalse((boolean)fiscalYear.equals(fiscalYear3));
        FiscalYearTest.assertFalse((boolean)fiscalYear.equals(fiscalYear4));
    }

    public void testHashCode() {
        FiscalYear fiscalYear = new FiscalYear(20100101, 20101231);
        FiscalYear fiscalYear2 = new FiscalYear(20100101, 20101231);
        FiscalYearTest.assertEquals((int)fiscalYear.hashCode(), (int)fiscalYear2.hashCode());
        int n = fiscalYear.hashCode();
        for (int i = 0; i < 20; ++i) {
            FiscalYearTest.assertEquals((int)n, (int)fiscalYear.hashCode());
        }
    }

    private void loadFiscalYearWith13Periods() {
        this.fiscalYear = new FiscalYear(20100101, 20101231);
        this.fiscalYear.setYear(2010);
        DateRange dateRange = new DateRange(20100101, 20100128);
        DateRange dateRange2 = new DateRange(20100129, 20100225);
        DateRange dateRange3 = new DateRange(20100226, 20100325);
        DateRange dateRange4 = new DateRange(20100326, 20100422);
        DateRange dateRange5 = new DateRange(20100423, 20100520);
        DateRange dateRange6 = new DateRange(20100521, 20100617);
        DateRange dateRange7 = new DateRange(20100618, 20100715);
        DateRange dateRange8 = new DateRange(20100716, 20100812);
        DateRange dateRange9 = new DateRange(20100813, 20100909);
        DateRange dateRange10 = new DateRange(20100910, 20101007);
        DateRange dateRange11 = new DateRange(20101008, 20101104);
        DateRange dateRange12 = new DateRange(20101105, 20101202);
        DateRange dateRange13 = new DateRange(20101203, 20101231);
        this.fiscalYear.setMonths(new DateRange[]{dateRange, dateRange2, dateRange3, dateRange4, dateRange5, dateRange6, dateRange7, dateRange8, dateRange9, dateRange10, dateRange11, dateRange12, dateRange13});
    }

    private void loadFiscalYearWithHoles() {
        this.fiscalYear = new FiscalYear(20100103, 20110101);
        this.fiscalYear.setYear(2010);
        DateRange dateRange = new DateRange(20100103, 20100129);
        DateRange dateRange2 = new DateRange(20100131, 20100226);
        DateRange dateRange3 = new DateRange(20100228, 20100402);
        DateRange dateRange4 = new DateRange(20100404, 20100430);
        DateRange dateRange5 = new DateRange(20100502, 20100528);
        DateRange dateRange6 = new DateRange(20100530, 20100702);
        DateRange dateRange7 = new DateRange(20100704, 20100730);
        DateRange dateRange8 = new DateRange(20100801, 20100827);
        DateRange dateRange9 = new DateRange(20100829, 20101001);
        DateRange dateRange10 = new DateRange(20101003, 20101029);
        DateRange dateRange11 = new DateRange(20101031, 20101126);
        DateRange dateRange12 = new DateRange(20101128, 20101231);
        this.fiscalYear.setMonths(new DateRange[]{dateRange, dateRange2, dateRange3, dateRange4, dateRange5, dateRange6, dateRange7, dateRange8, dateRange9, dateRange10, dateRange11, dateRange12});
    }

    private void loadFiscalYear() {
        this.fiscalYear = new FiscalYear(20100103, 20110101);
        this.fiscalYear.setYear(2010);
        DateRange dateRange = new DateRange(20100103, 20100130);
        DateRange dateRange2 = new DateRange(20100131, 20100227);
        DateRange dateRange3 = new DateRange(20100228, 20100403);
        DateRange dateRange4 = new DateRange(20100404, 20100501);
        DateRange dateRange5 = new DateRange(20100502, 20100529);
        DateRange dateRange6 = new DateRange(20100530, 20100703);
        DateRange dateRange7 = new DateRange(20100704, 20100731);
        DateRange dateRange8 = new DateRange(20100801, 20100828);
        DateRange dateRange9 = new DateRange(20100829, 20101002);
        DateRange dateRange10 = new DateRange(20101003, 20101030);
        DateRange dateRange11 = new DateRange(20101031, 20101127);
        DateRange dateRange12 = new DateRange(20101128, 20110101);
        this.fiscalYear.setMonths(new DateRange[]{dateRange, dateRange2, dateRange3, dateRange4, dateRange5, dateRange6, dateRange7, dateRange8, dateRange9, dateRange10, dateRange11, dateRange12});
    }

    private boolean arrayContains(DateRange dateRange, DateRange[] dateRangeArray) {
        for (DateRange dateRange2 : dateRangeArray) {
            if (!dateRange2.equals(dateRange)) continue;
            return true;
        }
        return false;
    }
}

