/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.DateRange;
import com.helpsystems.enterprise.core.scheduler.FiscalCalendar;
import com.helpsystems.enterprise.core.scheduler.FiscalYear;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class FiscalCalendarTest
extends TestCase {
    private FiscalCalendar fiscalCalendar;

    public FiscalCalendarTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fiscalCalendar = new FiscalCalendar();
        this.fiscalCalendar.setName("Fiscal");
        this.fiscalCalendar.setID(123456L);
    }

    protected void tearDown() throws Exception {
        this.fiscalCalendar = null;
        super.tearDown();
    }

    public void testWeekOfMonth() {
        this.loadFiscalCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2010, 10, 12);
        FiscalCalendarTest.assertEquals((int)2, (int)this.fiscalCalendar.weekOfMonth(gregorianCalendar));
    }

    public void testWeekOfMonth_OutsideRange() {
        this.loadFiscalCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2011, 4, 31);
        try {
            this.fiscalCalendar.weekOfMonth(gregorianCalendar);
            FiscalCalendarTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testIsLastWeekOfMonth() {
        this.loadFiscalCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2010, 10, 21);
        FiscalCalendarTest.assertEquals((boolean)true, (boolean)this.fiscalCalendar.isLastWeekOfMonth(gregorianCalendar));
        gregorianCalendar.clear();
        gregorianCalendar.set(2010, 11, 25);
        FiscalCalendarTest.assertEquals((boolean)false, (boolean)this.fiscalCalendar.isLastWeekOfMonth(gregorianCalendar));
    }

    public void testIsLastWeekOfMonth_OutsideRange() {
        this.loadFiscalCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2011, 4, 31);
        try {
            this.fiscalCalendar.isLastWeekOfMonth(gregorianCalendar);
            FiscalCalendarTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testIsNonWorkday() {
        this.fiscalCalendar.setHolidays(new int[]{20101225});
        FiscalCalendarTest.assertTrue((boolean)this.fiscalCalendar.isNonWorkday(20101225));
        FiscalCalendarTest.assertFalse((boolean)this.fiscalCalendar.isNonWorkday(20101226));
    }

    public void testIsNonWorkday_OutsideRange() {
        this.loadFiscalCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2011, 4, 31);
        try {
            this.fiscalCalendar.isNonWorkday(gregorianCalendar);
            FiscalCalendarTest.fail((String)"Should throw a CalendarObjectRangeException.");
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            // empty catch block
        }
    }

    public void testPeriodContaining_Normal() {
        this.loadFiscalCalendar();
        DateRange dateRange = this.fiscalCalendar.periodContaining(20100404, CalendarObject.PeriodType.MONTH);
        FiscalCalendarTest.assertEquals((int)20100404, (int)dateRange.getBegin());
        FiscalCalendarTest.assertEquals((int)20100501, (int)dateRange.getEnd());
        DateRange dateRange2 = this.fiscalCalendar.periodContaining(20101002, CalendarObject.PeriodType.QUARTER);
        FiscalCalendarTest.assertEquals((int)20100704, (int)dateRange2.getBegin());
        FiscalCalendarTest.assertEquals((int)20101002, (int)dateRange2.getEnd());
        DateRange dateRange3 = this.fiscalCalendar.periodContaining(20100828, CalendarObject.PeriodType.HALF_YEAR);
        FiscalCalendarTest.assertEquals((int)20100704, (int)dateRange3.getBegin());
        FiscalCalendarTest.assertEquals((int)20110101, (int)dateRange3.getEnd());
        DateRange dateRange4 = this.fiscalCalendar.periodContaining(20100112, CalendarObject.PeriodType.YEAR);
        FiscalCalendarTest.assertEquals((int)20100103, (int)dateRange4.getBegin());
        FiscalCalendarTest.assertEquals((int)20110101, (int)dateRange4.getEnd());
        this.loadFiscalCalendarWithHoles();
        try {
            this.fiscalCalendar.periodContaining(20100403, CalendarObject.PeriodType.QUARTER);
            FiscalCalendarTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddDays_NotEnoughNonWorkdaysDefined() throws InvalidDateTimeException {
        this.loadFiscalCalendar();
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, -3);
        int n = this.fiscalCalendar.yyyymmdd_AdjustedForVirtualDay(calendar2);
        this.fiscalCalendar.setHolidays(new int[]{n});
        Calendar calendar3 = (Calendar)calendar.clone();
        calendar3.add(5, 4);
        int n2 = this.fiscalCalendar.yyyymmdd_AdjustedForVirtualDay(calendar3);
        Calendar calendar4 = (Calendar)calendar.clone();
        calendar4.add(5, 7);
        int n3 = this.fiscalCalendar.yyyymmdd_AdjustedForVirtualDay(calendar4);
        this.fiscalCalendar.setOtherNonWorkdates(new int[]{n2, n3});
        try {
            this.fiscalCalendar.addDays(3, CalendarObject.DayType.NON_WORKDAYS, calendar);
            FiscalCalendarTest.fail((String)"Should throw a CalendarObjectRangeException.");
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            // empty catch block
        }
    }

    public void testAddDays_NotEnoughWorkdaysDefined() throws InvalidDateTimeException {
        Calendar calendar = Calendar.getInstance();
        try {
            this.fiscalCalendar.addDays(400, CalendarObject.DayType.WORKDAYS, calendar);
            FiscalCalendarTest.fail((String)"Should throw a CalendarObjectRangeException.");
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            // empty catch block
        }
        this.loadFiscalCalendar();
        try {
            this.fiscalCalendar.addDays(400, CalendarObject.DayType.WORKDAYS, calendar);
            FiscalCalendarTest.fail((String)"Should throw a CalendarObjectRangeException.");
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            // empty catch block
        }
    }

    public void testValidate() throws Exception {
        this.fiscalCalendar.validate();
    }

    private void loadFiscalCalendarWithHoles() {
        FiscalYear fiscalYear = new FiscalYear(20100103, 20110101);
        fiscalYear.setYear(2010);
        DateRange dateRange = new DateRange(20100103, 20100130);
        DateRange dateRange2 = new DateRange(20100201, 20100227);
        DateRange dateRange3 = new DateRange(20100301, 20100402);
        DateRange dateRange4 = new DateRange(20100404, 20100430);
        DateRange dateRange5 = new DateRange(20100502, 20100528);
        DateRange dateRange6 = new DateRange(20100530, 20100702);
        DateRange dateRange7 = new DateRange(20100704, 20100730);
        DateRange dateRange8 = new DateRange(20100801, 20100827);
        DateRange dateRange9 = new DateRange(20100829, 20101001);
        DateRange dateRange10 = new DateRange(20101003, 20101029);
        DateRange dateRange11 = new DateRange(20101031, 20101126);
        DateRange dateRange12 = new DateRange(20101128, 20110101);
        fiscalYear.setMonths(new DateRange[]{dateRange, dateRange2, dateRange3, dateRange4, dateRange5, dateRange6, dateRange7, dateRange8, dateRange9, dateRange10, dateRange11, dateRange12});
        this.fiscalCalendar.setYears(new FiscalYear[]{fiscalYear});
    }

    private void loadFiscalCalendar() {
        FiscalYear fiscalYear = new FiscalYear(20100103, 20110101);
        fiscalYear.setYear(2010);
        DateRange dateRange = new DateRange(20100103, 20100130);
        DateRange dateRange2 = new DateRange(20100131, 20100227);
        DateRange dateRange3 = new DateRange(20100228, 20100403);
        DateRange dateRange4 = new DateRange(20100404, 20100501);
        DateRange dateRange5 = new DateRange(20100502, 20100529);
        DateRange dateRange6 = new DateRange(20100530, 20100703);
        DateRange dateRange7 = new DateRange(20100704, 20100731);
        DateRange dateRange8 = new DateRange(20100801, 20100828);
        DateRange dateRange9 = new DateRange(20100829, 20101002);
        DateRange dateRange10 = new DateRange(20101003, 20101030);
        DateRange dateRange11 = new DateRange(20101031, 20101127);
        DateRange dateRange12 = new DateRange(20101128, 20110101);
        fiscalYear.setMonths(new DateRange[]{dateRange, dateRange2, dateRange3, dateRange4, dateRange5, dateRange6, dateRange7, dateRange8, dateRange9, dateRange10, dateRange11, dateRange12});
        this.fiscalCalendar.setYears(new FiscalYear[]{fiscalYear});
    }
}

