/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;

public class DateRange {
    private int begin;
    private int end;

    public DateRange(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Trying to create a DateRange where the begin date {0} is greater than the end date {1}.", (Object[])new Object[]{n, n2}));
        }
        this.begin = n;
        this.end = n2;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean contains(int n) {
        return n >= this.begin && n <= this.end;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        DateRange dateRange = (DateRange)object;
        return dateRange.begin == this.begin && dateRange.end == this.end;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    public String toString() {
        return MessageUtil.formatMsg((String)"{0} - {1}", (Object[])new Object[]{this.begin, this.end});
    }
}

