/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import junit.framework.TestCase;

public class AbstractBusinessObjectTest
extends TestCase {
    AbstractBusinessObject obj;

    public AbstractBusinessObjectTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.obj = new AbstractBusinessObject(){};
    }

    protected void tearDown() throws Exception {
        this.obj = null;
        super.tearDown();
    }

    public void testSetUpdateCounter() {
        this.obj.setUpdateCounter(12345);
        AbstractBusinessObjectTest.assertEquals((int)12345, (int)this.obj.getUpdateCounter());
    }

    public void testSetPersistent() {
        this.obj.setPersistent(false);
        AbstractBusinessObjectTest.assertFalse((boolean)this.obj.isPersistent());
        this.obj.setPersistent(true);
        AbstractBusinessObjectTest.assertTrue((boolean)this.obj.isPersistent());
    }

    public void testNextUpdateCounter() {
        this.obj.setUpdateCounter(12345);
        AbstractBusinessObjectTest.assertEquals((int)12346, (int)this.obj.nextUpdateCounter());
    }

    public void testNextUpdateCounterWraps() {
        this.obj.setUpdateCounter(Integer.MAX_VALUE);
        AbstractBusinessObjectTest.assertEquals((int)0, (int)this.obj.nextUpdateCounter());
    }

    public void testValidateProductIID() {
        this.obj.validateProductIID();
        this.obj.setIdentifier(null);
        try {
            this.obj.validateProductIID();
            AbstractBusinessObjectTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

